/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;

public class NullIfFunction
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        if (expr == null) {
            Class cls = Integer.class;
            int clsLevel = 0;
            for (int i = 0; i < args.size(); ++i) {
                SQLExpression argExpr = (SQLExpression)args.get(i);
                Class argType = argExpr.getJavaTypeMapping().getJavaType();
                if (clsLevel < 5 && (argType == Double.TYPE || argType == Double.class)) {
                    cls = Double.class;
                    clsLevel = 5;
                    continue;
                }
                if (clsLevel < 4 && (argType == Float.TYPE || argType == Float.class)) {
                    cls = Float.class;
                    clsLevel = 4;
                    continue;
                }
                if (clsLevel < 3 && argType == BigDecimal.class) {
                    cls = BigDecimal.class;
                    clsLevel = 3;
                    continue;
                }
                if (clsLevel < 2 && argType == BigInteger.class) {
                    cls = BigInteger.class;
                    clsLevel = 2;
                    continue;
                }
                if (clsLevel >= 1 || argType != Long.TYPE && argType != Long.class) continue;
                cls = Long.class;
                clsLevel = 1;
            }
            return new NumericExpression(this.getMappingForClass(cls), "NULLIF", args);
        }
        throw new NucleusException(LOCALISER.msg("060002", (Object)"NULLIF", (Object)expr));
    }
}

