/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

public class HBaseConfiguration
extends Configuration {
    public HBaseConfiguration() {
        this.addHbaseResources();
    }

    public HBaseConfiguration(Configuration c) {
        this();
        for (Map.Entry e : c) {
            this.set((String)e.getKey(), (String)e.getValue());
        }
    }

    private void addHbaseResources() {
        this.addResource("hbase-default.xml");
        this.addResource("hbase-site.xml");
    }

    public int hashCode() {
        int hash = 0;
        Iterator propertyIterator = this.iterator();
        while (propertyIterator.hasNext()) {
            hash ^= ((Object)((Map.Entry)propertyIterator.next())).hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HBaseConfiguration)) {
            return false;
        }
        HBaseConfiguration otherConf = (HBaseConfiguration)((Object)obj);
        if (this.size() != otherConf.size()) {
            return false;
        }
        Iterator propertyIterator = this.iterator();
        while (propertyIterator.hasNext()) {
            Map.Entry entry = (Map.Entry)propertyIterator.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value.equals(otherConf.getRaw(key))) continue;
            return false;
        }
        return true;
    }
}

