/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.util.ReflectionUtils;

public class LocalHBaseCluster
implements HConstants {
    static final Log LOG = LogFactory.getLog(LocalHBaseCluster.class);
    private final HMaster master;
    private final List<RegionServerThread> regionThreads;
    private static final int DEFAULT_NO = 1;
    public static final String LOCAL = "local";
    public static final String LOCAL_COLON = "local:";
    private final HBaseConfiguration conf;
    private final Class<? extends HRegionServer> regionServerClass;

    public LocalHBaseCluster(HBaseConfiguration conf) throws IOException {
        this(conf, 1);
    }

    public LocalHBaseCluster(HBaseConfiguration conf, int noRegionServers) throws IOException {
        this.conf = conf;
        this.master = new HMaster(conf);
        conf.set("hbase.regionserver.port", "0");
        this.regionThreads = new ArrayList<RegionServerThread>();
        this.regionServerClass = conf.getClass("hbase.regionserver.impl", HRegionServer.class);
        for (int i = 0; i < noRegionServers; ++i) {
            this.addRegionServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionServerThread addRegionServer() throws IOException {
        List<RegionServerThread> list = this.regionThreads;
        synchronized (list) {
            HRegionServer server;
            try {
                server = this.regionServerClass.getConstructor(HBaseConfiguration.class).newInstance(new Object[]{this.conf});
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
            RegionServerThread t = new RegionServerThread(server, this.regionThreads.size());
            this.regionThreads.add(t);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HRegionServer getRegionServer(int serverNumber) {
        List<RegionServerThread> list = this.regionThreads;
        synchronized (list) {
            return this.regionThreads.get(serverNumber).getRegionServer();
        }
    }

    public HMaster getMaster() {
        return this.master;
    }

    public List<RegionServerThread> getRegionServers() {
        return Collections.unmodifiableList(this.regionThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String waitOnRegionServer(int serverNumber) {
        RegionServerThread regionServerThread;
        List<RegionServerThread> list = this.regionThreads;
        synchronized (list) {
            regionServerThread = this.regionThreads.remove(serverNumber);
        }
        while (regionServerThread.isAlive()) {
            try {
                LOG.info((Object)("Waiting on " + regionServerThread.getRegionServer().getHServerInfo().toString()));
                regionServerThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return regionServerThread.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        if (this.regionThreads != null) {
            List<RegionServerThread> list = this.regionThreads;
            synchronized (list) {
                for (RegionServerThread t : this.regionThreads) {
                    if (!t.isAlive()) continue;
                    try {
                        t.join();
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
        if (this.master != null && this.master.isAlive()) {
            try {
                this.master.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String startup() {
        this.master.start();
        List<RegionServerThread> list = this.regionThreads;
        synchronized (list) {
            for (RegionServerThread t : this.regionThreads) {
                t.start();
            }
        }
        return this.master.getMasterAddress().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        LOG.debug((Object)"Shutting down HBase Cluster");
        Thread shutdownThread = null;
        List<RegionServerThread> list = this.regionThreads;
        synchronized (list) {
            for (RegionServerThread t : this.regionThreads) {
                Thread tt = t.getRegionServer().setHDFSShutdownThreadOnExit(null);
                if (shutdownThread != null || tt == null) continue;
                shutdownThread = tt;
            }
        }
        if (this.master != null) {
            this.master.shutdown();
        }
        list = this.regionThreads;
        synchronized (list) {
            for (RegionServerThread t : this.regionThreads) {
                if (!t.isAlive()) continue;
                try {
                    t.join();
                }
                catch (InterruptedException e) {}
            }
        }
        if (this.master != null) {
            while (this.master.isAlive()) {
                try {
                    this.threadDumpingJoin(this.master);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        Threads.shutdown(shutdownThread);
        LOG.info((Object)("Shutdown " + (this.regionThreads != null ? this.master.getName() : "0 masters") + " " + this.regionThreads.size() + " region server(s)"));
    }

    public void threadDumpingJoin(Thread t) throws InterruptedException {
        if (t == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        while (t.isAlive()) {
            Thread.sleep(1000L);
            if (System.currentTimeMillis() - startTime <= 60000L) continue;
            startTime = System.currentTimeMillis();
            ReflectionUtils.printThreadInfo((PrintWriter)new PrintWriter(System.out), (String)("Automatic Stack Trace every 60 seconds waiting on " + t.getName()));
        }
    }

    public static boolean isLocal(Configuration c) {
        String mode = c.get("hbase.cluster.distributed");
        return mode == null || mode.equals("false");
    }

    public static void main(String[] args) throws IOException {
        HBaseConfiguration conf = new HBaseConfiguration();
        LocalHBaseCluster cluster = new LocalHBaseCluster(conf);
        cluster.startup();
        HBaseAdmin admin = new HBaseAdmin(conf);
        HTableDescriptor htd = new HTableDescriptor(Bytes.toBytes(cluster.getClass().getName()));
        admin.createTable(htd);
        cluster.shutdown();
    }

    public static class RegionServerThread
    extends Thread {
        private final HRegionServer regionServer;

        RegionServerThread(HRegionServer r, int index) {
            super((Runnable)r, "RegionServer:" + index);
            this.regionServer = r;
        }

        public HRegionServer getRegionServer() {
            return this.regionServer;
        }

        public void waitForServerOnline() {
            while (!this.regionServer.isOnline()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

