/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Hash;
import org.apache.hadoop.hbase.util.MurmurHash;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.lib.reduce.LongSumReducer;
import org.apache.hadoop.util.LineReader;

public class PerformanceEvaluation
implements HConstants {
    protected static final Log LOG = LogFactory.getLog((String)PerformanceEvaluation.class.getName());
    private static final int ROW_LENGTH = 1000;
    private static final int ONE_GB = 1048576000;
    private static final int ROWS_PER_GB = 0x100000;
    public static final byte[] FAMILY_NAME = Bytes.toBytes("info");
    public static final byte[] QUALIFIER_NAME = Bytes.toBytes("data");
    protected static final HTableDescriptor TABLE_DESCRIPTOR = new HTableDescriptor("TestTable");
    private static final String RANDOM_READ = "randomRead";
    private static final String RANDOM_SEEK_SCAN = "randomSeekScan";
    private static final String RANDOM_READ_MEM = "randomReadMem";
    private static final String RANDOM_WRITE = "randomWrite";
    private static final String SEQUENTIAL_READ = "sequentialRead";
    private static final String SEQUENTIAL_WRITE = "sequentialWrite";
    private static final String SCAN = "scan";
    private static final List<String> COMMANDS;
    volatile HBaseConfiguration conf;
    private boolean miniCluster = false;
    private boolean nomapred = false;
    private int N = 1;
    private int R = 0x100000;
    private static final Path PERF_EVAL_DIR;
    public static final Pattern LINE_PATTERN;

    public PerformanceEvaluation(HBaseConfiguration c) {
        this.conf = c;
    }

    private boolean checkTable(HBaseAdmin admin) throws IOException {
        boolean tableExists = admin.tableExists(TABLE_DESCRIPTOR.getName());
        if (!tableExists) {
            admin.createTable(TABLE_DESCRIPTOR);
            LOG.info((Object)("Table " + TABLE_DESCRIPTOR + " created"));
        }
        return !tableExists;
    }

    private void runNIsMoreThanOne(String cmd) throws IOException, InterruptedException, ClassNotFoundException {
        this.checkTable(new HBaseAdmin(this.conf));
        if (this.nomapred) {
            this.doMultipleClients(cmd);
        } else {
            this.doMapReduce(cmd);
        }
    }

    private void doMultipleClients(final String cmd) throws IOException {
        ArrayList<Thread> threads = new ArrayList<Thread>(this.N);
        final int perClientRows = this.R / this.N;
        for (int i = 0; i < this.N; ++i) {
            Thread t = new Thread(Integer.toString(i)){

                @Override
                public void run() {
                    super.run();
                    PerformanceEvaluation pe = new PerformanceEvaluation(PerformanceEvaluation.this.conf);
                    int index = Integer.parseInt(this.getName());
                    try {
                        long elapsedTime = pe.runOneClient(cmd, index * perClientRows, perClientRows, PerformanceEvaluation.this.R, new Status(){

                            @Override
                            public void setStatus(String msg) throws IOException {
                                LOG.info((Object)("client-" + this.getName() + " " + msg));
                            }
                        });
                        LOG.info((Object)("Finished " + this.getName() + " in " + elapsedTime + "ms writing " + perClientRows + " rows"));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            threads.add(t);
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            while (t.isAlive()) {
                try {
                    t.join();
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)("Interrupted, continuing" + e.toString()));
                }
            }
        }
    }

    private void doMapReduce(String cmd) throws IOException, InterruptedException, ClassNotFoundException {
        Path inputDir = this.writeInputFile(this.conf);
        this.conf.set("EvaluationMapTask.command", cmd);
        Job job = new Job((Configuration)this.conf);
        job.setJarByClass(PerformanceEvaluation.class);
        job.setJobName("HBase Performance Evaluation");
        job.setInputFormatClass(PeInputFormat.class);
        PeInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputDir});
        job.setOutputKeyClass(LongWritable.class);
        job.setOutputValueClass(LongWritable.class);
        job.setMapperClass(EvaluationMapTask.class);
        job.setReducerClass(LongSumReducer.class);
        job.setNumReduceTasks(1);
        job.setOutputFormatClass(TextOutputFormat.class);
        TextOutputFormat.setOutputPath((Job)job, (Path)new Path(inputDir, "outputs"));
        job.waitForCompletion(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path writeInputFile(Configuration c) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)c);
        if (!fs.exists(PERF_EVAL_DIR)) {
            fs.mkdirs(PERF_EVAL_DIR);
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        Path subdir = new Path(PERF_EVAL_DIR, formatter.format(new Date()));
        fs.mkdirs(subdir);
        Path inputFile = new Path(subdir, "input.txt");
        PrintStream out = new PrintStream((OutputStream)fs.create(inputFile));
        TreeMap<Integer, String> m = new TreeMap<Integer, String>();
        Hash h = MurmurHash.getInstance();
        int perClientRows = this.R / this.N;
        try {
            for (int i = 0; i < 10; ++i) {
                for (int j = 0; j < this.N; ++j) {
                    String s = "startRow=" + (j * perClientRows + i * (perClientRows / 10)) + ", perClientRunRows=" + perClientRows / 10 + ", totalRows=" + this.R + ", clients=" + this.N;
                    int hash = h.hash(Bytes.toBytes(s));
                    m.put(hash, s);
                }
            }
            for (Map.Entry e : m.entrySet()) {
                out.println((String)e.getValue());
            }
        }
        finally {
            out.close();
        }
        return subdir;
    }

    public static byte[] format(int number) {
        byte[] b = new byte[10];
        int d = Math.abs(number);
        for (int i = b.length - 1; i >= 0; --i) {
            b[i] = (byte)(d % 10 + 48);
            d /= 10;
        }
        return b;
    }

    public static byte[] generateValue(Random r) {
        byte[] b = new byte[1000];
        r.nextBytes(b);
        return b;
    }

    static byte[] getRandomRow(Random random, int totalRows) {
        return PerformanceEvaluation.format(random.nextInt(Integer.MAX_VALUE) % totalRows);
    }

    long runOneClient(String cmd, int startRow, int perClientRunRows, int totalRows, Status status) throws IOException {
        status.setStatus("Start " + cmd + " at offset " + startRow + " for " + perClientRunRows + " rows");
        long totalElapsedTime = 0L;
        if (cmd.equals(RANDOM_READ)) {
            RandomReadTest t = new RandomReadTest(this.conf, startRow, perClientRunRows, totalRows, status);
            totalElapsedTime = t.test();
        } else {
            if (cmd.equals(RANDOM_READ_MEM)) {
                throw new UnsupportedOperationException("Not yet implemented");
            }
            if (cmd.equals(RANDOM_WRITE)) {
                RandomWriteTest t = new RandomWriteTest(this.conf, startRow, perClientRunRows, totalRows, status);
                totalElapsedTime = t.test();
            } else if (cmd.equals(SCAN)) {
                ScanTest t = new ScanTest(this.conf, startRow, perClientRunRows, totalRows, status);
                totalElapsedTime = t.test();
            } else if (cmd.equals(SEQUENTIAL_READ)) {
                SequentialReadTest t = new SequentialReadTest(this.conf, startRow, perClientRunRows, totalRows, status);
                totalElapsedTime = t.test();
            } else if (cmd.equals(SEQUENTIAL_WRITE)) {
                SequentialWriteTest t = new SequentialWriteTest(this.conf, startRow, perClientRunRows, totalRows, status);
                totalElapsedTime = t.test();
            } else if (cmd.equals(RANDOM_SEEK_SCAN)) {
                RandomSeekScanTest t = new RandomSeekScanTest(this.conf, startRow, perClientRunRows, totalRows, status);
                totalElapsedTime = t.test();
            } else {
                throw new IllegalArgumentException("Invalid command value: " + cmd);
            }
        }
        status.setStatus("Finished " + cmd + " in " + totalElapsedTime + "ms at offset " + startRow + " for " + perClientRunRows + " rows");
        return totalElapsedTime;
    }

    private void runNIsOne(String cmd) {
        Status status = new Status(){

            @Override
            public void setStatus(String msg) throws IOException {
                LOG.info((Object)msg);
            }
        };
        HBaseAdmin admin = null;
        try {
            admin = new HBaseAdmin(this.conf);
            this.checkTable(admin);
            this.runOneClient(cmd, 0, this.R, this.R, status);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(String cmd) throws IOException, InterruptedException, ClassNotFoundException {
        if (cmd.equals(RANDOM_READ_MEM)) {
            this.R = this.R / 10 * this.N;
        }
        MiniHBaseCluster hbaseMiniCluster = null;
        MiniDFSCluster dfsCluster = null;
        if (this.miniCluster) {
            dfsCluster = new MiniDFSCluster((Configuration)this.conf, 2, true, (String[])null);
            FileSystem fs = dfsCluster.getFileSystem();
            this.conf.set("fs.default.name", fs.getUri().toString());
            Path parentdir = fs.getHomeDirectory();
            this.conf.set("hbase.rootdir", parentdir.toString());
            fs.mkdirs(parentdir);
            FSUtils.setVersion(fs, parentdir);
            hbaseMiniCluster = new MiniHBaseCluster(this.conf, this.N);
        }
        try {
            if (this.N == 1) {
                this.runNIsOne(cmd);
            } else {
                this.runNIsMoreThanOne(cmd);
            }
        }
        finally {
            if (this.miniCluster && hbaseMiniCluster != null) {
                hbaseMiniCluster.shutdown();
                HBaseTestCase.shutdownDfs(dfsCluster);
            }
        }
    }

    private void printUsage() {
        this.printUsage(null);
    }

    private void printUsage(String message) {
        if (message != null && message.length() > 0) {
            System.err.println(message);
        }
        System.err.println("Usage: java " + this.getClass().getName() + " [--miniCluster]");
        System.err.println("  [--nomapred] [--rows=ROWS] <command> <nclients>");
        System.err.println();
        System.err.println("Options:");
        System.err.println(" miniCluster     Run the test on an HBaseMiniCluster");
        System.err.println(" nomapred        Run multiple clients using threads (rather than use mapreduce)");
        System.err.println(" rows            Rows each client runs. Default: One million");
        System.err.println();
        System.err.println("Command:");
        System.err.println(" randomRead      Run random read test");
        System.err.println(" randomReadMem   Run random read test where table is in memory");
        System.err.println(" randomSeekScan  Run random seek and scan 100 test");
        System.err.println(" randomWrite     Run random write test");
        System.err.println(" sequentialRead  Run sequential read test");
        System.err.println(" sequentialWrite Run sequential write test");
        System.err.println(" scan            Run scan test");
        System.err.println();
        System.err.println("Args:");
        System.err.println(" nclients        Integer. Required. Total number of clients (and HRegionServers)");
        System.err.println("                 running: 1 <= value <= 500");
        System.err.println("Examples:");
        System.err.println(" To run a single evaluation client:");
        System.err.println(" $ bin/hbase org.apache.hadoop.hbase.PerformanceEvaluation sequentialWrite 1");
    }

    private void getArgs(int start, String[] args) {
        if (start + 1 > args.length) {
            throw new IllegalArgumentException("must supply the number of clients");
        }
        this.N = Integer.parseInt(args[start]);
        if (this.N < 1) {
            throw new IllegalArgumentException("Number of clients must be > 1");
        }
        this.R *= this.N;
    }

    private int doCommandLine(String[] args) {
        int errCode = -1;
        if (args.length < 1) {
            this.printUsage();
            return errCode;
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                String cmd = args[i];
                if (cmd.equals("-h") || cmd.startsWith("--h")) {
                    this.printUsage();
                    errCode = 0;
                } else {
                    String miniClusterArgKey = "--miniCluster";
                    if (cmd.startsWith("--miniCluster")) {
                        this.miniCluster = true;
                        continue;
                    }
                    String nmr = "--nomapred";
                    if (cmd.startsWith("--nomapred")) {
                        this.nomapred = true;
                        continue;
                    }
                    String rows = "--rows=";
                    if (cmd.startsWith("--rows=")) {
                        this.R = Integer.parseInt(cmd.substring("--rows=".length()));
                        continue;
                    }
                    if (COMMANDS.contains(cmd)) {
                        this.getArgs(i + 1, args);
                        this.runTest(cmd);
                        errCode = 0;
                    } else {
                        this.printUsage();
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errCode;
    }

    public static void main(String[] args) {
        HBaseConfiguration c = new HBaseConfiguration();
        System.exit(new PerformanceEvaluation(c).doCommandLine(args));
    }

    static {
        TABLE_DESCRIPTOR.addFamily(new HColumnDescriptor(FAMILY_NAME));
        COMMANDS = Arrays.asList(RANDOM_READ, RANDOM_SEEK_SCAN, RANDOM_READ_MEM, RANDOM_WRITE, SEQUENTIAL_READ, SEQUENTIAL_WRITE, SCAN);
        PERF_EVAL_DIR = new Path("performance_evaluation");
        LINE_PATTERN = Pattern.compile("startRow=(\\d+),\\s+perClientRunRows=(\\d+),\\s+totalRows=(\\d+),\\s+clients=(\\d+)");
    }

    class SequentialWriteTest
    extends Test {
        SequentialWriteTest(HBaseConfiguration conf, int startRow, int perClientRunRows, int totalRows, Status status) {
            super(conf, startRow, perClientRunRows, totalRows, status);
        }

        @Override
        void testRow(int i) throws IOException {
            Put put = new Put(PerformanceEvaluation.format(i));
            put.add(FAMILY_NAME, QUALIFIER_NAME, PerformanceEvaluation.generateValue(this.rand));
            this.table.put(put);
        }

        @Override
        String getTestName() {
            return PerformanceEvaluation.SEQUENTIAL_WRITE;
        }
    }

    class SequentialReadTest
    extends Test {
        SequentialReadTest(HBaseConfiguration conf, int startRow, int perClientRunRows, int totalRows, Status status) {
            super(conf, startRow, perClientRunRows, totalRows, status);
        }

        @Override
        void testRow(int i) throws IOException {
            Get get2 = new Get(PerformanceEvaluation.format(i));
            get2.addColumn(FAMILY_NAME, QUALIFIER_NAME);
            this.table.get(get2);
        }

        @Override
        String getTestName() {
            return PerformanceEvaluation.SEQUENTIAL_READ;
        }
    }

    class ScanTest
    extends Test {
        private ResultScanner testScanner;

        ScanTest(HBaseConfiguration conf, int startRow, int perClientRunRows, int totalRows, Status status) {
            super(conf, startRow, perClientRunRows, totalRows, status);
        }

        @Override
        void testSetup() throws IOException {
            super.testSetup();
            Scan scan = new Scan(PerformanceEvaluation.format(this.startRow));
            scan.addColumn(FAMILY_NAME, QUALIFIER_NAME);
            this.testScanner = this.table.getScanner(scan);
        }

        @Override
        void testTakedown() throws IOException {
            if (this.testScanner != null) {
                this.testScanner.close();
            }
            super.testTakedown();
        }

        @Override
        void testRow(int i) throws IOException {
            this.testScanner.next();
        }

        @Override
        String getTestName() {
            return PerformanceEvaluation.SCAN;
        }
    }

    class RandomWriteTest
    extends Test {
        RandomWriteTest(HBaseConfiguration conf, int startRow, int perClientRunRows, int totalRows, Status status) {
            super(conf, startRow, perClientRunRows, totalRows, status);
        }

        @Override
        void testRow(int i) throws IOException {
            byte[] row = PerformanceEvaluation.getRandomRow(this.rand, this.totalRows);
            Put put = new Put(row);
            put.add(FAMILY_NAME, QUALIFIER_NAME, PerformanceEvaluation.generateValue(this.rand));
            this.table.put(put);
        }

        @Override
        String getTestName() {
            return PerformanceEvaluation.RANDOM_WRITE;
        }
    }

    class RandomReadTest
    extends Test {
        RandomReadTest(HBaseConfiguration conf, int startRow, int perClientRunRows, int totalRows, Status status) {
            super(conf, startRow, perClientRunRows, totalRows, status);
        }

        @Override
        void testRow(int i) throws IOException {
            Get get2 = new Get(PerformanceEvaluation.getRandomRow(this.rand, this.totalRows));
            get2.addColumn(FAMILY_NAME, QUALIFIER_NAME);
            this.table.get(get2);
        }

        @Override
        protected int getReportingPeriod() {
            return this.perClientRunRows / 100;
        }

        @Override
        String getTestName() {
            return PerformanceEvaluation.RANDOM_READ;
        }
    }

    class RandomSeekScanTest
    extends Test {
        RandomSeekScanTest(HBaseConfiguration conf, int startRow, int perClientRunRows, int totalRows, Status status) {
            super(conf, startRow, perClientRunRows, totalRows, status);
        }

        @Override
        void testRow(int i) throws IOException {
            Scan scan = new Scan(PerformanceEvaluation.getRandomRow(this.rand, this.totalRows));
            scan.addColumn(FAMILY_NAME, QUALIFIER_NAME);
            scan.setFilter(new WhileMatchFilter(new PageFilter(120L)));
            ResultScanner s = this.table.getScanner(scan);
            Result rr = null;
            while ((rr = s.next()) != null) {
            }
            s.close();
        }

        @Override
        protected int getReportingPeriod() {
            return this.perClientRunRows / 100;
        }

        @Override
        String getTestName() {
            return "randomSeekScanTest";
        }
    }

    static abstract class Test {
        protected final Random rand = new Random(System.currentTimeMillis());
        protected final int startRow;
        protected final int perClientRunRows;
        protected final int totalRows;
        private final Status status;
        protected HBaseAdmin admin;
        protected HTable table;
        protected volatile HBaseConfiguration conf;

        Test(HBaseConfiguration conf, int startRow, int perClientRunRows, int totalRows, Status status) {
            this.startRow = startRow;
            this.perClientRunRows = perClientRunRows;
            this.totalRows = totalRows;
            this.status = status;
            this.table = null;
            this.conf = conf;
        }

        private String generateStatus(int sr, int i, int lr) {
            return sr + "/" + i + "/" + lr;
        }

        protected int getReportingPeriod() {
            return this.perClientRunRows / 10;
        }

        void testSetup() throws IOException {
            this.admin = new HBaseAdmin(this.conf);
            this.table = new HTable(this.conf, TABLE_DESCRIPTOR.getName());
            this.table.setAutoFlush(false);
            this.table.setWriteBufferSize(0xC00000L);
            this.table.setScannerCaching(30);
        }

        void testTakedown() throws IOException {
            this.table.flushCommits();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long test() throws IOException {
            long elapsedTime;
            this.testSetup();
            long startTime = System.currentTimeMillis();
            try {
                int lastRow = this.startRow + this.perClientRunRows;
                for (int i = this.startRow; i < lastRow; ++i) {
                    this.testRow(i);
                    if (this.status == null || i <= 0 || i % this.getReportingPeriod() != 0) continue;
                    this.status.setStatus(this.generateStatus(this.startRow, i, lastRow));
                }
                elapsedTime = System.currentTimeMillis() - startTime;
            }
            finally {
                this.testTakedown();
            }
            return elapsedTime;
        }

        abstract void testRow(int var1) throws IOException;

        abstract String getTestName();
    }

    public static class EvaluationMapTask
    extends Mapper<NullWritable, PeInputSplit, LongWritable, LongWritable> {
        public static final String CMD_KEY = "EvaluationMapTask.command";
        private String cmd;
        private PerformanceEvaluation pe;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.cmd = context.getConfiguration().get(CMD_KEY);
            this.pe = new PerformanceEvaluation(new HBaseConfiguration(context.getConfiguration()));
        }

        protected void map(NullWritable key, PeInputSplit value, final Mapper.Context context) throws IOException, InterruptedException {
            Status status = new Status(){

                @Override
                public void setStatus(String msg) {
                    context.setStatus(msg);
                }
            };
            long elapsedTime = this.pe.runOneClient(this.cmd, value.getStartRow(), value.getRows(), value.getTotalRows(), status);
            context.getCounter((Enum)Counter.ELAPSED_TIME).increment(elapsedTime);
            context.getCounter((Enum)Counter.ROWS).increment((long)value.rows);
            context.write((Object)new LongWritable((long)value.startRow), (Object)new LongWritable(elapsedTime));
            context.progress();
        }
    }

    public static class PeInputFormat
    extends FileInputFormat<NullWritable, PeInputSplit> {
        public List<InputSplit> getSplits(JobContext job) throws IOException {
            ArrayList<InputSplit> splitList = new ArrayList<InputSplit>();
            for (FileStatus file : this.listStatus(job)) {
                Text lineText;
                Path path = file.getPath();
                FileSystem fs = path.getFileSystem(job.getConfiguration());
                FSDataInputStream fileIn = fs.open(path);
                LineReader in = new LineReader((InputStream)fileIn, job.getConfiguration());
                int lineLen = 0;
                while ((lineLen = in.readLine(lineText = new Text())) > 0) {
                    Matcher m = LINE_PATTERN.matcher(lineText.toString());
                    if (m == null || !m.matches()) continue;
                    int startRow = Integer.parseInt(m.group(1));
                    int rows = Integer.parseInt(m.group(2));
                    int totalRows = Integer.parseInt(m.group(3));
                    int clients = Integer.parseInt(m.group(4));
                    LOG.debug((Object)("split[" + splitList.size() + "] " + " startRow=" + startRow + " rows=" + rows + " totalRows=" + totalRows + " clients=" + clients));
                    PeInputSplit newSplit = new PeInputSplit(startRow, rows, totalRows, clients);
                    splitList.add(newSplit);
                }
                in.close();
            }
            LOG.info((Object)("Total # of splits: " + splitList.size()));
            return splitList;
        }

        public RecordReader<NullWritable, PeInputSplit> createRecordReader(InputSplit split, TaskAttemptContext context) {
            return new PeRecordReader();
        }

        public static class PeRecordReader
        extends RecordReader<NullWritable, PeInputSplit> {
            private boolean readOver = false;
            private PeInputSplit split = null;
            private NullWritable key = null;
            private PeInputSplit value = null;

            public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
                this.readOver = false;
                this.split = (PeInputSplit)split;
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                if (this.readOver) {
                    return false;
                }
                this.key = NullWritable.get();
                this.value = this.split;
                this.readOver = true;
                return true;
            }

            public NullWritable getCurrentKey() throws IOException, InterruptedException {
                return this.key;
            }

            public PeInputSplit getCurrentValue() throws IOException, InterruptedException {
                return this.value;
            }

            public float getProgress() throws IOException, InterruptedException {
                if (this.readOver) {
                    return 1.0f;
                }
                return 0.0f;
            }

            public void close() throws IOException {
            }
        }
    }

    public static class PeInputSplit
    extends InputSplit
    implements Writable {
        private int startRow = 0;
        private int rows = 0;
        private int totalRows = 0;
        private int clients = 0;

        public PeInputSplit() {
            this.startRow = 0;
            this.rows = 0;
            this.totalRows = 0;
            this.clients = 0;
        }

        public PeInputSplit(int startRow, int rows, int totalRows, int clients) {
            this.startRow = startRow;
            this.rows = rows;
            this.totalRows = totalRows;
            this.clients = clients;
        }

        public void readFields(DataInput in) throws IOException {
            this.startRow = in.readInt();
            this.rows = in.readInt();
            this.totalRows = in.readInt();
            this.clients = in.readInt();
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.startRow);
            out.writeInt(this.rows);
            out.writeInt(this.totalRows);
            out.writeInt(this.clients);
        }

        public long getLength() throws IOException, InterruptedException {
            return 0L;
        }

        public String[] getLocations() throws IOException, InterruptedException {
            return new String[0];
        }

        public int getStartRow() {
            return this.startRow;
        }

        public int getRows() {
            return this.rows;
        }

        public int getTotalRows() {
            return this.totalRows;
        }

        public int getClients() {
            return this.clients;
        }
    }

    static interface Status {
        public void setStatus(String var1) throws IOException;
    }

    protected static enum Counter {
        ELAPSED_TIME,
        ROWS;

    }
}

