/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;

public class TestEmptyMetaInfo
extends HBaseClusterTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmptyMetaInfo() throws IOException {
        HTable t = new HTable(this.conf, HConstants.META_TABLE_NAME);
        int COUNT = 5;
        byte[] tableName = Bytes.toBytes(this.getName());
        for (int i = 0; i < 5; ++i) {
            byte[] regionName = HRegionInfo.createRegionName(tableName, Bytes.toBytes(i == 0 ? "" : Integer.toString(i)), Long.toString(System.currentTimeMillis()));
            Put put = new Put(regionName);
            put.add(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes("localhost:1234"));
            t.put(put);
        }
        long sleepTime = this.conf.getLong("hbase.master.meta.thread.rescanfrequency", 10000L);
        int tries = this.conf.getInt("hbase.client.retries.number", 5);
        int count = 0;
        do {
            --tries;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Scan scan = new Scan();
            scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
            scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
            scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER);
            scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER);
            scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER);
            ResultScanner scanner = t.getScanner(scan);
            try {
                Result r;
                count = 0;
                while ((r = scanner.next()) != null) {
                    if (r.isEmpty()) continue;
                    ++count;
                }
            }
            finally {
                scanner.close();
            }
        } while (count != 0 && tries >= 0);
        TestEmptyMetaInfo.assertTrue((tries >= 0 ? 1 : 0) != 0);
        TestEmptyMetaInfo.assertEquals((int)0, (int)count);
    }
}

