/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;

public class TestScanMultipleVersions
extends HBaseClusterTestCase {
    private final byte[] TABLE_NAME = Bytes.toBytes("TestScanMultipleVersions");
    private final HRegionInfo[] INFOS = new HRegionInfo[2];
    private final HRegion[] REGIONS = new HRegion[2];
    private final byte[][] ROWS = new byte[][]{Bytes.toBytes("row_0200"), Bytes.toBytes("row_0800")};
    private final long[] TIMESTAMPS = new long[]{100L, 1000L};
    private HTableDescriptor desc = null;

    @Override
    protected void preHBaseClusterSetup() throws Exception {
        this.testDir = new Path(this.conf.get("hbase.rootdir"));
        this.desc = new HTableDescriptor(this.TABLE_NAME);
        this.desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.INFOS[0] = new HRegionInfo(this.desc, HConstants.EMPTY_START_ROW, Bytes.toBytes("row_0500"));
        this.INFOS[1] = new HRegionInfo(this.desc, Bytes.toBytes("row_0500"), HConstants.EMPTY_END_ROW);
        this.createRootAndMetaRegions();
        for (int i = 0; i < this.REGIONS.length; ++i) {
            this.REGIONS[i] = HRegion.createHRegion(this.INFOS[i], this.testDir, this.conf);
            for (int j = 0; j < this.TIMESTAMPS.length; ++j) {
                Put put = new Put(this.ROWS[i]);
                put.setTimeStamp(this.TIMESTAMPS[j]);
                put.add(HConstants.CATALOG_FAMILY, null, this.TIMESTAMPS[j], Bytes.toBytes(this.TIMESTAMPS[j]));
                this.REGIONS[i].put(put);
            }
            HRegion.addRegionToMETA(this.meta, this.REGIONS[i]);
            this.REGIONS[i].close();
            this.REGIONS[i].getLog().closeAndDelete();
        }
        this.closeRootAndMeta();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScanMultipleVersions() throws Exception {
        HTable t = new HTable(this.conf, this.TABLE_NAME);
        for (int i = 0; i < this.ROWS.length; ++i) {
            for (int j = 0; j < this.TIMESTAMPS.length; ++j) {
                Get get2 = new Get(this.ROWS[i]);
                get2.addFamily(HConstants.CATALOG_FAMILY);
                get2.setTimeStamp(this.TIMESTAMPS[j]);
                Result result = t.get(get2);
                int cellCount = 0;
                for (KeyValue kv : result.sorted()) {
                    ++cellCount;
                }
                TestScanMultipleVersions.assertTrue((cellCount == 1 ? 1 : 0) != 0);
            }
        }
        int count = 0;
        Scan scan = new Scan();
        scan.addFamily(HConstants.CATALOG_FAMILY);
        ResultScanner s = t.getScanner(scan);
        try {
            Result rr = null;
            while ((rr = s.next()) != null) {
                System.out.println(rr.toString());
                ++count;
            }
            TestScanMultipleVersions.assertEquals((String)"Number of rows should be 2", (int)2, (int)count);
        }
        finally {
            s.close();
        }
        count = 0;
        scan = new Scan();
        scan.setTimeRange(1000L, Long.MAX_VALUE);
        scan.addFamily(HConstants.CATALOG_FAMILY);
        s = t.getScanner(scan);
        try {
            while (s.next() != null) {
                ++count;
            }
            TestScanMultipleVersions.assertEquals((String)"Number of rows should be 2", (int)2, (int)count);
        }
        finally {
            s.close();
        }
        count = 0;
        scan = new Scan();
        scan.setTimeStamp(1000L);
        scan.addFamily(HConstants.CATALOG_FAMILY);
        s = t.getScanner(scan);
        try {
            while (s.next() != null) {
                ++count;
            }
            TestScanMultipleVersions.assertEquals((String)"Number of rows should be 2", (int)2, (int)count);
        }
        finally {
            s.close();
        }
        count = 0;
        scan = new Scan();
        scan.setTimeRange(100L, 1000L);
        scan.addFamily(HConstants.CATALOG_FAMILY);
        s = t.getScanner(scan);
        try {
            while (s.next() != null) {
                ++count;
            }
            TestScanMultipleVersions.assertEquals((String)"Number of rows should be 2", (int)2, (int)count);
        }
        finally {
            s.close();
        }
        count = 0;
        scan = new Scan();
        scan.setTimeStamp(100L);
        scan.addFamily(HConstants.CATALOG_FAMILY);
        s = t.getScanner(scan);
        try {
            while (s.next() != null) {
                ++count;
            }
            TestScanMultipleVersions.assertEquals((String)"Number of rows should be 2", (int)2, (int)count);
        }
        finally {
            s.close();
        }
    }
}

