/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.Cell;
import org.apache.hadoop.hbase.util.Bytes;

public class TimestampTestBase
extends HBaseTestCase {
    private static final long T0 = 10L;
    private static final long T1 = 100L;
    private static final long T2 = 200L;
    private static final String COLUMN_NAME = "colfamily1:contents";
    private static final byte[] COLUMN = Bytes.toBytes("colfamily1:contents");
    private static final byte[][] COLUMNS = new byte[][]{Bytes.toBytes("colfamily1")};
    private static final byte[] ROW = Bytes.toBytes("row");

    public static void doTestDelete(HBaseTestCase.Incommon incommon, HBaseTestCase.FlushCache flusher) throws IOException {
        TimestampTestBase.put(incommon, 10L);
        TimestampTestBase.put(incommon, 100L);
        TimestampTestBase.put(incommon, 200L);
        TimestampTestBase.put(incommon);
        TimestampTestBase.assertVersions(incommon, new long[]{Long.MAX_VALUE, 200L, 100L});
        TimestampTestBase.delete(incommon);
        TimestampTestBase.assertVersions(incommon, new long[]{200L, 100L, 10L});
        flusher.flushcache();
        TimestampTestBase.assertVersions(incommon, new long[]{200L, 100L, 10L});
        TimestampTestBase.put(incommon);
        TimestampTestBase.assertVersions(incommon, new long[]{Long.MAX_VALUE, 200L, 100L});
        TimestampTestBase.delete(incommon, 200L);
        TimestampTestBase.assertVersions(incommon, new long[]{Long.MAX_VALUE, 100L, 10L});
        flusher.flushcache();
        TimestampTestBase.assertVersions(incommon, new long[]{Long.MAX_VALUE, 100L, 10L});
        TimestampTestBase.put(incommon, 200L);
        TimestampTestBase.delete(incommon, 100L);
        TimestampTestBase.put(incommon, 100L);
        Delete delete = new Delete(ROW);
        byte[][] famAndQf = KeyValue.parseColumn(COLUMN);
        if (famAndQf[1].length == 0) {
            delete.deleteFamily(famAndQf[0], 200L);
        } else {
            delete.deleteColumns(famAndQf[0], famAndQf[1], 200L);
        }
        incommon.delete(delete, null, true);
        TimestampTestBase.assertOnlyLatest(incommon, Long.MAX_VALUE);
        flusher.flushcache();
        TimestampTestBase.assertOnlyLatest(incommon, Long.MAX_VALUE);
    }

    private static void assertOnlyLatest(HBaseTestCase.Incommon incommon, long currentTime) throws IOException {
        Get get2 = null;
        byte[][] famAndQf = null;
        get2 = new Get(ROW);
        famAndQf = KeyValue.parseColumn(COLUMN);
        get2.addColumn(famAndQf[0], famAndQf[1]);
        get2.setMaxVersions(3);
        Result result = incommon.get(get2);
        TimestampTestBase.assertEquals((int)1, (int)result.size());
        long time = Bytes.toLong(result.sorted()[0].getValue());
        TimestampTestBase.assertEquals((long)time, (long)currentTime);
    }

    public static void assertVersions(HBaseTestCase.Incommon incommon, long[] tss) throws IOException {
        Get get2 = null;
        byte[][] famAndQf = null;
        get2 = new Get(ROW);
        famAndQf = KeyValue.parseColumn(COLUMN);
        get2.addColumn(famAndQf[0], famAndQf[1]);
        Result r = incommon.get(get2);
        byte[] bytes = r.getValue(famAndQf[0], famAndQf[1]);
        long t = Bytes.toLong(bytes);
        TimestampTestBase.assertEquals((long)tss[0], (long)t);
        get2 = new Get(ROW);
        famAndQf = KeyValue.parseColumn(COLUMN);
        get2.addColumn(famAndQf[0], famAndQf[1]);
        get2.setMaxVersions(tss.length);
        Result result = incommon.get(get2);
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (KeyValue kv : result.sorted()) {
            cells.add(new Cell(kv.getValue(), kv.getTimestamp()));
        }
        TimestampTestBase.assertEquals((int)tss.length, (int)cells.size());
        for (int i = 0; i < cells.size(); ++i) {
            long ts = Bytes.toLong(((Cell)cells.get(i)).getValue());
            TimestampTestBase.assertEquals((long)ts, (long)tss[i]);
        }
        get2 = new Get(ROW);
        famAndQf = KeyValue.parseColumn(COLUMN);
        get2.addColumn(famAndQf[0], famAndQf[1]);
        get2.setTimeStamp(tss[0]);
        get2.setMaxVersions(cells.size() - 1);
        result = incommon.get(get2);
        cells = new ArrayList();
        for (KeyValue kv : result.sorted()) {
            cells.add(new Cell(kv.getValue(), kv.getTimestamp()));
        }
        for (int i = 1; i < cells.size(); ++i) {
            long ts = Bytes.toLong(((Cell)cells.get(i)).getValue());
            TimestampTestBase.assertEquals((long)ts, (long)tss[i]);
        }
        TimestampTestBase.assertScanContentTimestamp(incommon, tss[0]);
    }

    public static void doTestTimestampScanning(HBaseTestCase.Incommon incommon, HBaseTestCase.FlushCache flusher) throws IOException {
        TimestampTestBase.put(incommon, 10L);
        TimestampTestBase.put(incommon, 100L);
        TimestampTestBase.put(incommon, Long.MAX_VALUE);
        int count = TimestampTestBase.assertScanContentTimestamp(incommon, Long.MAX_VALUE);
        TimestampTestBase.assertEquals((int)count, (int)TimestampTestBase.assertScanContentTimestamp(incommon, 10L));
        TimestampTestBase.assertEquals((int)count, (int)TimestampTestBase.assertScanContentTimestamp(incommon, 100L));
        flusher.flushcache();
        TimestampTestBase.assertEquals((int)count, (int)TimestampTestBase.assertScanContentTimestamp(incommon, 10L));
        TimestampTestBase.assertEquals((int)count, (int)TimestampTestBase.assertScanContentTimestamp(incommon, 100L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int assertScanContentTimestamp(HBaseTestCase.Incommon in, long ts) throws IOException {
        HBaseTestCase.ScannerIncommon scanner = in.getScanner(COLUMNS, HConstants.EMPTY_START_ROW, ts);
        int count = 0;
        scanner.close();
        return count;
    }

    public static void put(HBaseTestCase.Incommon loader, long ts) throws IOException {
        TimestampTestBase.put(loader, Bytes.toBytes(ts), ts);
    }

    public static void put(HBaseTestCase.Incommon loader) throws IOException {
        long ts = Long.MAX_VALUE;
        TimestampTestBase.put(loader, Bytes.toBytes(ts), ts);
    }

    public static void put(HBaseTestCase.Incommon loader, byte[] bytes, long ts) throws IOException {
        Put put = new Put(ROW);
        if (ts != Long.MAX_VALUE) {
            put.setTimeStamp(ts);
        }
        byte[][] famAndQf = KeyValue.parseColumn(COLUMN);
        put.add(famAndQf[0], famAndQf[1], bytes);
        loader.put(put);
    }

    public static void delete(HBaseTestCase.Incommon loader) throws IOException {
        TimestampTestBase.delete(loader, null);
    }

    public static void delete(HBaseTestCase.Incommon loader, byte[] column) throws IOException {
        TimestampTestBase.delete(loader, column, Long.MAX_VALUE);
    }

    public static void delete(HBaseTestCase.Incommon loader, long ts) throws IOException {
        TimestampTestBase.delete(loader, null, ts);
    }

    public static void delete(HBaseTestCase.Incommon loader, byte[] column, long ts) throws IOException {
        Delete delete = ts == Long.MAX_VALUE ? new Delete(ROW) : new Delete(ROW, ts, null);
        byte[][] famAndQf = KeyValue.parseColumn(column == null ? COLUMN : column);
        if (famAndQf[1].length == 0) {
            delete.deleteFamily(famAndQf[0], ts);
        } else {
            delete.deleteColumn(famAndQf[0], famAndQf[1], ts);
        }
        loader.delete(delete, null, true);
    }

    public static Result get(HBaseTestCase.Incommon loader) throws IOException {
        return loader.get(new Get(ROW));
    }
}

