/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class TestClient
extends HBaseClusterTestCase {
    final Log LOG = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static byte[] ROW = Bytes.toBytes("testRow");
    private static byte[] FAMILY = Bytes.toBytes("testFamily");
    private static byte[] QUALIFIER = Bytes.toBytes("testQualifier");
    private static byte[] VALUE = Bytes.toBytes("testValue");
    private static byte[] EMPTY = new byte[0];

    public void testWeirdCacheBehaviour() throws Exception {
        byte[] TABLE = Bytes.toBytes("testWeirdCacheBehaviour");
        byte[][] FAMILIES = new byte[][]{Bytes.toBytes("trans-blob"), Bytes.toBytes("trans-type"), Bytes.toBytes("trans-date"), Bytes.toBytes("trans-tags"), Bytes.toBytes("trans-group")};
        HTable ht = this.createTable(TABLE, FAMILIES);
        String value = "this is the value";
        String value2 = "this is some other value";
        String keyPrefix1 = UUID.randomUUID().toString();
        String keyPrefix2 = UUID.randomUUID().toString();
        String keyPrefix3 = UUID.randomUUID().toString();
        this.putRows(ht, 3, value, keyPrefix1);
        this.putRows(ht, 3, value, keyPrefix2);
        this.putRows(ht, 3, value, keyPrefix3);
        ht.flushCommits();
        this.putRows(ht, 3, value2, keyPrefix1);
        this.putRows(ht, 3, value2, keyPrefix2);
        this.putRows(ht, 3, value2, keyPrefix3);
        HTable table = new HTable(this.conf, Bytes.toBytes("testWeirdCacheBehaviour"));
        System.out.println("Checking values for key: " + keyPrefix1);
        TestClient.assertEquals((String)"Got back incorrect number of rows from scan", (int)3, (int)this.getNumberOfRows(keyPrefix1, value2, table));
        System.out.println("Checking values for key: " + keyPrefix2);
        TestClient.assertEquals((String)"Got back incorrect number of rows from scan", (int)3, (int)this.getNumberOfRows(keyPrefix2, value2, table));
        System.out.println("Checking values for key: " + keyPrefix3);
        TestClient.assertEquals((String)"Got back incorrect number of rows from scan", (int)3, (int)this.getNumberOfRows(keyPrefix3, value2, table));
        this.deleteColumns(ht, value2, keyPrefix1);
        this.deleteColumns(ht, value2, keyPrefix2);
        this.deleteColumns(ht, value2, keyPrefix3);
        System.out.println("Starting important checks.....");
        TestClient.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix1), (int)0, (int)this.getNumberOfRows(keyPrefix1, value2, table));
        TestClient.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix2), (int)0, (int)this.getNumberOfRows(keyPrefix2, value2, table));
        TestClient.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix3), (int)0, (int)this.getNumberOfRows(keyPrefix3, value2, table));
        ht.setScannerCaching(0);
        TestClient.assertEquals((String)"Got back incorrect number of rows from scan", (int)0, (int)this.getNumberOfRows(keyPrefix1, value2, table));
        ht.setScannerCaching(100);
        TestClient.assertEquals((String)"Got back incorrect number of rows from scan", (int)0, (int)this.getNumberOfRows(keyPrefix2, value2, table));
    }

    private void deleteColumns(HTable ht, String value, String keyPrefix) throws IOException {
        ResultScanner scanner = this.buildScanner(keyPrefix, value, ht);
        Iterator it = scanner.iterator();
        int count = 0;
        while (it.hasNext()) {
            Result result = (Result)it.next();
            Delete delete = new Delete(result.getRow());
            delete.deleteColumn(Bytes.toBytes("trans-tags"), Bytes.toBytes("qual2"));
            ht.delete(delete);
            ++count;
        }
        TestClient.assertEquals((String)"Did not perform correct number of deletes", (int)3, (int)count);
    }

    private int getNumberOfRows(String keyPrefix, String value, HTable ht) throws Exception {
        ResultScanner resultScanner = this.buildScanner(keyPrefix, value, ht);
        Iterator scanner = resultScanner.iterator();
        int numberOfResults = 0;
        while (scanner.hasNext()) {
            Result result = (Result)scanner.next();
            System.out.println("Got back key: " + Bytes.toString(result.getRow()));
            for (KeyValue kv : result.raw()) {
                System.out.println("kv=" + kv.toString() + ", " + Bytes.toString(kv.getValue()));
            }
            ++numberOfResults;
        }
        return numberOfResults;
    }

    private ResultScanner buildScanner(String keyPrefix, String value, HTable ht) throws IOException {
        FilterList allFilters = new FilterList();
        allFilters.addFilter(new PrefixFilter(Bytes.toBytes(keyPrefix)));
        SingleColumnValueFilter filter = new SingleColumnValueFilter(Bytes.toBytes("trans-tags"), Bytes.toBytes("qual2"), CompareFilter.CompareOp.EQUAL, Bytes.toBytes(value));
        filter.setFilterIfMissing(true);
        allFilters.addFilter(filter);
        Scan scan = new Scan();
        scan.addFamily(Bytes.toBytes("trans-blob"));
        scan.addFamily(Bytes.toBytes("trans-type"));
        scan.addFamily(Bytes.toBytes("trans-date"));
        scan.addFamily(Bytes.toBytes("trans-tags"));
        scan.addFamily(Bytes.toBytes("trans-group"));
        scan.setFilter(allFilters);
        return ht.getScanner(scan);
    }

    private void putRows(HTable ht, int numRows, String value, String key) throws IOException {
        for (int i = 0; i < numRows; ++i) {
            String row = key + "_" + UUID.randomUUID().toString();
            System.out.println(String.format("Saving row: %s, with value %s", row, value));
            Put put = new Put(Bytes.toBytes(row));
            put.add(Bytes.toBytes("trans-blob"), null, Bytes.toBytes("value for blob"));
            put.add(Bytes.toBytes("trans-type"), null, Bytes.toBytes("statement"));
            put.add(Bytes.toBytes("trans-date"), null, Bytes.toBytes("20090921010101999"));
            put.add(Bytes.toBytes("trans-tags"), Bytes.toBytes("qual2"), Bytes.toBytes(value));
            put.add(Bytes.toBytes("trans-group"), null, Bytes.toBytes("adhocTransactionGroupId"));
            ht.put(put);
        }
    }

    public void testFilterAcrossMutlipleRegions() throws IOException {
        byte[] name = Bytes.toBytes(this.getName());
        HTable t = this.createTable(name, FAMILY);
        int rowCount = this.loadTable(t);
        this.assertRowCount(t, rowCount);
        Map<HRegionInfo, HServerAddress> regions = this.splitTable(t);
        this.assertRowCount(t, rowCount);
        byte[] endKey = regions.keySet().iterator().next().getEndKey();
        int endKeyCount = this.countRows(t, this.createScanWithRowFilter(endKey));
        TestClient.assertTrue((endKeyCount < rowCount ? 1 : 0) != 0);
        byte[] key = new byte[]{endKey[0], endKey[1], (byte)(endKey[2] + 1)};
        int plusOneCount = this.countRows(t, this.createScanWithRowFilter(key));
        TestClient.assertEquals((int)(endKeyCount + 1), (int)plusOneCount);
        key = new byte[]{endKey[0], endKey[1], (byte)(endKey[2] + 2)};
        int plusTwoCount = this.countRows(t, this.createScanWithRowFilter(key));
        TestClient.assertEquals((int)(endKeyCount + 2), (int)plusTwoCount);
        key = new byte[]{endKey[0], endKey[1], (byte)(endKey[2] - 1)};
        int minusOneCount = this.countRows(t, this.createScanWithRowFilter(key));
        TestClient.assertEquals((int)(endKeyCount - 1), (int)minusOneCount);
        key = new byte[]{97, 97, 97};
        int countBBB = this.countRows(t, this.createScanWithRowFilter(key, null, CompareFilter.CompareOp.EQUAL));
        TestClient.assertEquals((int)1, (int)countBBB);
        int countGreater = this.countRows(t, this.createScanWithRowFilter(endKey, null, CompareFilter.CompareOp.GREATER_OR_EQUAL));
        TestClient.assertEquals((int)0, (int)countGreater);
        countGreater = this.countRows(t, this.createScanWithRowFilter(endKey, endKey, CompareFilter.CompareOp.GREATER_OR_EQUAL));
        TestClient.assertEquals((int)(rowCount - endKeyCount), (int)countGreater);
    }

    private int loadTable(HTable t) throws IOException {
        byte[] k = new byte[3];
        int rowCount = 0;
        for (int b1 = 97; b1 < 122; b1 = (int)((byte)(b1 + 1))) {
            for (int b2 = 97; b2 < 122; b2 = (int)((byte)(b2 + 1))) {
                for (int b3 = 97; b3 < 122; b3 = (int)((byte)(b3 + 1))) {
                    k[0] = b1;
                    k[1] = b2;
                    k[2] = b3;
                    Put put = new Put(k);
                    put.add(FAMILY, new byte[0], k);
                    t.put(put);
                    ++rowCount;
                }
            }
        }
        return rowCount;
    }

    private Scan createScanWithRowFilter(byte[] key) {
        return this.createScanWithRowFilter(key, null, CompareFilter.CompareOp.LESS);
    }

    private Scan createScanWithRowFilter(byte[] key, byte[] startRow, CompareFilter.CompareOp op) {
        TestClient.assertTrue((key != null && key.length > 0 && Bytes.BYTES_COMPARATOR.compare(key, new byte[]{97, 97, 97}) >= 0 ? 1 : 0) != 0);
        this.LOG.info((Object)("Key=" + Bytes.toString(key)));
        Scan s = startRow == null ? new Scan() : new Scan(startRow);
        Filter f = new RowFilter(op, new BinaryComparator(key));
        f = new WhileMatchFilter(f);
        s.setFilter(f);
        return s;
    }

    private int countRows(HTable t, Scan s) throws IOException {
        ResultScanner scanner = t.getScanner(s);
        int count = 0;
        for (Result result : scanner) {
            ++count;
            TestClient.assertTrue((result.size() > 0 ? 1 : 0) != 0);
        }
        return count;
    }

    private void assertRowCount(HTable t, int expected) throws IOException {
        TestClient.assertEquals((int)expected, (int)this.countRows(t, new Scan()));
    }

    private Map<HRegionInfo, HServerAddress> splitTable(HTable t) throws IOException {
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        admin.split(t.getTableName());
        Map<HRegionInfo, HServerAddress> regions = this.waitOnSplit(t);
        TestClient.assertTrue((regions.size() > 1 ? 1 : 0) != 0);
        return regions;
    }

    private Map<HRegionInfo, HServerAddress> waitOnSplit(HTable t) throws IOException {
        Map<HRegionInfo, HServerAddress> regions = t.getRegionsInfo();
        int originalCount = regions.size();
        for (int i = 0; i < this.conf.getInt("hbase.test.retries", 30); ++i) {
            Thread.currentThread();
            try {
                Thread.sleep(this.conf.getInt("hbase.server.thread.wakefrequency", 1000));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            regions = t.getRegionsInfo();
            if (regions.size() > originalCount) break;
        }
        return regions;
    }

    public void testSuperSimple() throws Exception {
        byte[] TABLE = Bytes.toBytes(this.getName());
        HTable ht = this.createTable(TABLE, FAMILY);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        Scan scan = new Scan();
        scan.addColumn(FAMILY, TABLE);
        ResultScanner scanner = ht.getScanner(scan);
        Result result = scanner.next();
        TestClient.assertTrue((String)"Expected null result", (result == null ? 1 : 0) != 0);
        scanner.close();
        System.out.println("Done.");
    }

    public void testFilters() throws Exception {
        byte[] TABLE = Bytes.toBytes("testFilters");
        HTable ht = this.createTable(TABLE, FAMILY);
        byte[][] ROWS = this.makeN(ROW, 10);
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes("col0-<d2v1>-<d3v2>"), Bytes.toBytes("col1-<d2v1>-<d3v2>"), Bytes.toBytes("col2-<d2v1>-<d3v2>"), Bytes.toBytes("col3-<d2v1>-<d3v2>"), Bytes.toBytes("col4-<d2v1>-<d3v2>"), Bytes.toBytes("col5-<d2v1>-<d3v2>"), Bytes.toBytes("col6-<d2v1>-<d3v2>"), Bytes.toBytes("col7-<d2v1>-<d3v2>"), Bytes.toBytes("col8-<d2v1>-<d3v2>"), Bytes.toBytes("col9-<d2v1>-<d3v2>")};
        for (int i = 0; i < 10; ++i) {
            Put put = new Put(ROWS[i]);
            put.add(FAMILY, QUALIFIERS[i], VALUE);
            ht.put(put);
        }
        Scan scan = new Scan();
        scan.addFamily(FAMILY);
        QualifierFilter filter = new QualifierFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator("col[1-5]"));
        scan.setFilter(filter);
        ResultScanner scanner = ht.getScanner(scan);
        int expectedIndex = 1;
        for (Result result : ht.getScanner(scan)) {
            TestClient.assertEquals((int)result.size(), (int)1);
            TestClient.assertTrue((boolean)Bytes.equals(result.raw()[0].getRow(), ROWS[expectedIndex]));
            TestClient.assertTrue((boolean)Bytes.equals(result.raw()[0].getQualifier(), QUALIFIERS[expectedIndex]));
            ++expectedIndex;
        }
        TestClient.assertEquals((int)expectedIndex, (int)6);
        scanner.close();
    }

    public void testSimpleMissing() throws Exception {
        byte[] TABLE = Bytes.toBytes("testSimpleMissing");
        HTable ht = this.createTable(TABLE, FAMILY);
        byte[][] ROWS = this.makeN(ROW, 4);
        Get get2 = new Get(ROWS[0]);
        Result result = ht.get(get2);
        this.assertEmptyResult(result);
        get2 = new Get(ROWS[0]);
        get2.addFamily(FAMILY);
        result = ht.get(get2);
        this.assertEmptyResult(result);
        get2 = new Get(ROWS[0]);
        get2.addColumn(FAMILY, QUALIFIER);
        result = ht.get(get2);
        this.assertEmptyResult(result);
        Scan scan = new Scan();
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(ROWS[0]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(ROWS[0], ROWS[1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addFamily(FAMILY);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addColumn(FAMILY, QUALIFIER);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        Put put = new Put(ROWS[2]);
        put.add(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        get2 = new Get(ROWS[1]);
        result = ht.get(get2);
        this.assertEmptyResult(result);
        get2 = new Get(ROWS[0]);
        get2.addFamily(FAMILY);
        result = ht.get(get2);
        this.assertEmptyResult(result);
        get2 = new Get(ROWS[3]);
        get2.addColumn(FAMILY, QUALIFIER);
        result = ht.get(get2);
        this.assertEmptyResult(result);
        scan = new Scan(ROWS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(ROWS[0], ROWS[2]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        get2 = new Get(ROWS[2]);
        result = ht.get(get2);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        get2 = new Get(ROWS[2]);
        get2.addFamily(FAMILY);
        result = ht.get(get2);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        get2 = new Get(ROWS[2]);
        get2.addColumn(FAMILY, QUALIFIER);
        result = ht.get(get2);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        scan = new Scan();
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        scan = new Scan(ROWS[0], ROWS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        scan = new Scan(ROWS[2], ROWS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
    }

    public void testSingleRowMultipleFamily() throws Exception {
        byte[] TABLE = Bytes.toBytes("testSingleRowMultipleFamily");
        byte[][] ROWS = this.makeN(ROW, 3);
        byte[][] FAMILIES = this.makeN(FAMILY, 10);
        byte[][] QUALIFIERS = this.makeN(QUALIFIER, 10);
        byte[][] VALUES = this.makeN(VALUE, 10);
        HTable ht = this.createTable(TABLE, FAMILIES);
        Put put = new Put(ROWS[0]);
        put.add(FAMILIES[4], QUALIFIERS[0], VALUES[0]);
        ht.put(put);
        this.getVerifySingleColumn(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0, VALUES, 0);
        this.scanVerifySingleColumn(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0, VALUES, 0);
        this.getVerifySingleEmpty(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0);
        this.scanVerifySingleEmpty(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0);
        this.flushMemStore(TABLE);
        this.getVerifySingleColumn(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0, VALUES, 0);
        this.scanVerifySingleColumn(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0, VALUES, 0);
        this.getVerifySingleEmpty(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0);
        this.scanVerifySingleEmpty(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0);
        put = new Put(ROWS[0]);
        put.add(FAMILIES[2], QUALIFIERS[2], VALUES[2]);
        put.add(FAMILIES[2], QUALIFIERS[4], VALUES[4]);
        put.add(FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        put.add(FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        put.add(FAMILIES[6], QUALIFIERS[7], VALUES[7]);
        put.add(FAMILIES[7], QUALIFIERS[7], VALUES[7]);
        put.add(FAMILIES[9], QUALIFIERS[0], VALUES[0]);
        ht.put(put);
        this.singleRowGetTest(ht, ROWS, FAMILIES, QUALIFIERS, VALUES);
        this.singleRowScanTest(ht, ROWS, FAMILIES, QUALIFIERS, VALUES);
        this.flushMemStore(TABLE);
        this.singleRowGetTest(ht, ROWS, FAMILIES, QUALIFIERS, VALUES);
        this.singleRowScanTest(ht, ROWS, FAMILIES, QUALIFIERS, VALUES);
        put = new Put(ROWS[0]);
        put.add(FAMILIES[6], QUALIFIERS[5], VALUES[5]);
        put.add(FAMILIES[6], QUALIFIERS[8], VALUES[8]);
        put.add(FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        put.add(FAMILIES[4], QUALIFIERS[3], VALUES[3]);
        ht.put(put);
        Delete delete = new Delete(ROWS[0]);
        delete.deleteColumns(FAMILIES[6], QUALIFIERS[7]);
        ht.delete(delete);
        Get get2 = new Get(ROWS[0]);
        get2.addColumn(FAMILIES[6], QUALIFIERS[7]);
        Result result = ht.get(get2);
        this.assertEmptyResult(result);
        Scan scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[7]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        get2 = new Get(ROWS[0]);
        get2.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = ht.get(get2);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        get2 = new Get(ROWS[0]);
        get2.addColumn(FAMILIES[6], QUALIFIERS[8]);
        result = ht.get(get2);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[8], VALUES[8]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[8]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[8], VALUES[8]);
        delete = new Delete(ROWS[0]);
        delete.deleteColumns(FAMILIES[6], QUALIFIERS[8]);
        ht.delete(delete);
        get2 = new Get(ROWS[0]);
        get2.addColumn(FAMILIES[6], QUALIFIERS[8]);
        result = ht.get(get2);
        this.assertEmptyResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[8]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        get2 = new Get(ROWS[0]);
        get2.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = ht.get(get2);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        get2 = new Get(ROWS[0]);
        get2.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = ht.get(get2);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        delete = new Delete(ROWS[0]);
        delete.deleteFamily(FAMILIES[4]);
        ht.delete(delete);
        get2 = new Get(ROWS[0]);
        get2.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = ht.get(get2);
        this.assertEmptyResult(result);
        get2 = new Get(ROWS[0]);
        get2.addColumn(FAMILIES[4], QUALIFIERS[3]);
        result = ht.get(get2);
        this.assertEmptyResult(result);
        get2 = new Get(ROWS[0]);
        get2.addFamily(FAMILIES[4]);
        result = ht.get(get2);
        this.assertEmptyResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addFamily(FAMILIES[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        get2 = new Get(ROWS[0]);
        get2.addColumn(FAMILIES[2], QUALIFIERS[2]);
        result = ht.get(get2);
        this.assertSingleResult(result, ROWS[0], FAMILIES[2], QUALIFIERS[2], VALUES[2]);
        get2 = new Get(ROWS[0]);
        get2.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = ht.get(get2);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        this.flushMemStore(TABLE);
        get2 = new Get(ROWS[0]);
        get2.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = ht.get(get2);
        this.assertEmptyResult(result);
        get2 = new Get(ROWS[0]);
        get2.addColumn(FAMILIES[4], QUALIFIERS[3]);
        result = ht.get(get2);
        this.assertEmptyResult(result);
        get2 = new Get(ROWS[0]);
        get2.addFamily(FAMILIES[4]);
        result = ht.get(get2);
        this.assertEmptyResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addFamily(FAMILIES[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        get2 = new Get(ROWS[0]);
        get2.addColumn(FAMILIES[2], QUALIFIERS[2]);
        result = ht.get(get2);
        this.assertSingleResult(result, ROWS[0], FAMILIES[2], QUALIFIERS[2], VALUES[2]);
        get2 = new Get(ROWS[0]);
        get2.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = ht.get(get2);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
    }

    public void testNull() throws Exception {
        Put put;
        Result result;
        Get get2;
        Put put2;
        HTable htFail;
        byte[] TABLE = Bytes.toBytes("testNull");
        try {
            htFail = this.createTable(null, FAMILY);
            TestClient.assertTrue((String)"Creating a table with null name passed, should have failed", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            htFail = this.createTable(TABLE, (byte[])null);
            TestClient.assertTrue((String)"Creating a table with a null family passed, should fail", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        HTable ht = this.createTable(TABLE, FAMILY);
        try {
            put2 = new Put((byte[])null);
            put2.add(FAMILY, QUALIFIER, VALUE);
            ht.put(put2);
            TestClient.assertTrue((String)"Inserting a null row worked, should throw exception", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            put2 = new Put(ROW);
            put2.add(FAMILY, null, VALUE);
            ht.put(put2);
            this.getTestNull(ht, ROW, FAMILY, VALUE);
            this.scanTestNull(ht, ROW, FAMILY, VALUE);
            Delete delete = new Delete(ROW);
            delete.deleteColumns(FAMILY, null);
            ht.delete(delete);
            get2 = new Get(ROW);
            result = ht.get(get2);
            this.assertEmptyResult(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestClient.assertTrue((String)"Using a row with null qualifier threw exception, should pass", (boolean)false);
        }
        byte[] TABLE2 = Bytes.toBytes("testNull2");
        ht = this.createTable(TABLE2, FAMILY);
        try {
            put = new Put(ROW);
            put.add(FAMILY, EMPTY, VALUE);
            ht.put(put);
            this.getTestNull(ht, ROW, FAMILY, VALUE);
            this.scanTestNull(ht, ROW, FAMILY, VALUE);
            this.flushMemStore(TABLE2);
            this.getTestNull(ht, ROW, FAMILY, VALUE);
            this.scanTestNull(ht, ROW, FAMILY, VALUE);
            Delete delete = new Delete(ROW);
            delete.deleteColumns(FAMILY, EMPTY);
            ht.delete(delete);
            Get get3 = new Get(ROW);
            Result result2 = ht.get(get3);
            this.assertEmptyResult(result2);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestClient.assertTrue((String)"Using a row with null qualifier threw exception, should pass", (boolean)false);
        }
        try {
            put = new Put(ROW);
            put.add(FAMILY, QUALIFIER, null);
            ht.put(put);
            get2 = new Get(ROW);
            get2.addColumn(FAMILY, QUALIFIER);
            result = ht.get(get2);
            this.assertSingleResult(result, ROW, FAMILY, QUALIFIER, null);
            Scan scan = new Scan();
            scan.addColumn(FAMILY, QUALIFIER);
            result = this.getSingleScanResult(ht, scan);
            this.assertSingleResult(result, ROW, FAMILY, QUALIFIER, null);
            Delete delete = new Delete(ROW);
            delete.deleteColumns(FAMILY, QUALIFIER);
            ht.delete(delete);
            get2 = new Get(ROW);
            result = ht.get(get2);
            this.assertEmptyResult(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestClient.assertTrue((String)"Null values should be allowed, but threw exception", (boolean)false);
        }
    }

    public void testVersions() throws Exception {
        byte[] TABLE = Bytes.toBytes("testSimpleVersions");
        long[] STAMPS = this.makeStamps(20);
        byte[][] VALUES = this.makeNAscii(VALUE, 20);
        HTable ht = this.createTable(TABLE, FAMILY, 10);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        put.add(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        ht.put(put);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        Get get2 = new Get(ROW);
        get2.addColumn(FAMILY, QUALIFIER);
        get2.setMaxVersions(2);
        Result result = ht.get(get2);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        Scan scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(2);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        this.flushMemStore(TABLE);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        get2 = new Get(ROW);
        get2.addColumn(FAMILY, QUALIFIER);
        get2.setMaxVersions(2);
        result = ht.get(get2);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(2);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
        put.add(FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        put.add(FAMILY, QUALIFIER, STAMPS[8], VALUES[8]);
        ht.put(put);
        get2 = new Get(ROW);
        get2.addColumn(FAMILY, QUALIFIER);
        get2.setMaxVersions();
        result = ht.get(get2);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 7);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions();
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 7);
        get2 = new Get(ROW);
        get2.setMaxVersions();
        result = ht.get(get2);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 7);
        scan = new Scan(ROW);
        scan.setMaxVersions();
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 7);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[9]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[9]);
        this.flushMemStore(TABLE);
        put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[9], VALUES[9]);
        put.add(FAMILY, QUALIFIER, STAMPS[11], VALUES[11]);
        put.add(FAMILY, QUALIFIER, STAMPS[13], VALUES[13]);
        put.add(FAMILY, QUALIFIER, STAMPS[15], VALUES[15]);
        ht.put(put);
        get2 = new Get(ROW);
        get2.addColumn(FAMILY, QUALIFIER);
        get2.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get2);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8], STAMPS[9], STAMPS[11], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8], VALUES[9], VALUES[11], VALUES[13], VALUES[15]}, 0, 9);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8], STAMPS[9], STAMPS[11], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8], VALUES[9], VALUES[11], VALUES[13], VALUES[15]}, 0, 9);
        Delete delete = new Delete(ROW);
        delete.deleteColumn(FAMILY, QUALIFIER, STAMPS[11]);
        delete.deleteColumn(FAMILY, QUALIFIER, STAMPS[7]);
        ht.delete(delete);
        get2 = new Get(ROW);
        get2.addColumn(FAMILY, QUALIFIER);
        get2.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get2);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[8], STAMPS[9], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[8], VALUES[9], VALUES[13], VALUES[15]}, 0, 9);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[8], STAMPS[9], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[8], VALUES[9], VALUES[13], VALUES[15]}, 0, 9);
    }

    public void testVersionLimits() throws Exception {
        byte[] TABLE = Bytes.toBytes("testVersionLimits");
        byte[][] FAMILIES = this.makeNAscii(FAMILY, 3);
        int[] LIMITS = new int[]{1, 3, 5};
        long[] STAMPS = this.makeStamps(10);
        byte[][] VALUES = this.makeNAscii(VALUE, 10);
        HTable ht = this.createTable(TABLE, FAMILIES, LIMITS);
        Put put = new Put(ROW);
        put.add(FAMILIES[0], QUALIFIER, STAMPS[0], VALUES[0]);
        put.add(FAMILIES[0], QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILIES[1], QUALIFIER, STAMPS[0], VALUES[0]);
        put.add(FAMILIES[1], QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILIES[1], QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILIES[1], QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILIES[2], QUALIFIER, STAMPS[0], VALUES[0]);
        put.add(FAMILIES[2], QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILIES[2], QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILIES[2], QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILIES[2], QUALIFIER, STAMPS[4], VALUES[4]);
        put.add(FAMILIES[2], QUALIFIER, STAMPS[5], VALUES[5]);
        put.add(FAMILIES[2], QUALIFIER, STAMPS[6], VALUES[6]);
        ht.put(put);
        Get get2 = new Get(ROW);
        get2.addColumn(FAMILIES[0], QUALIFIER);
        get2.setMaxVersions(Integer.MAX_VALUE);
        Result result = ht.get(get2);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{STAMPS[1]}, new byte[][]{VALUES[1]}, 0, 0);
        get2 = new Get(ROW);
        get2.addFamily(FAMILIES[0]);
        get2.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get2);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{STAMPS[1]}, new byte[][]{VALUES[1]}, 0, 0);
        Scan scan = new Scan(ROW);
        scan.addColumn(FAMILIES[0], QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{STAMPS[1]}, new byte[][]{VALUES[1]}, 0, 0);
        scan = new Scan(ROW);
        scan.addFamily(FAMILIES[0]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{STAMPS[1]}, new byte[][]{VALUES[1]}, 0, 0);
        get2 = new Get(ROW);
        get2.addColumn(FAMILIES[1], QUALIFIER);
        get2.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get2);
        this.assertNResult(result, ROW, FAMILIES[1], QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        get2 = new Get(ROW);
        get2.addFamily(FAMILIES[1]);
        get2.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get2);
        this.assertNResult(result, ROW, FAMILIES[1], QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        scan = new Scan(ROW);
        scan.addColumn(FAMILIES[1], QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[1], QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        scan = new Scan(ROW);
        scan.addFamily(FAMILIES[1]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[1], QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        get2 = new Get(ROW);
        get2.addColumn(FAMILIES[2], QUALIFIER);
        get2.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get2);
        this.assertNResult(result, ROW, FAMILIES[2], QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6]}, new byte[][]{VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6]}, 0, 4);
        get2 = new Get(ROW);
        get2.addFamily(FAMILIES[2]);
        get2.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get2);
        this.assertNResult(result, ROW, FAMILIES[2], QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6]}, new byte[][]{VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6]}, 0, 4);
        scan = new Scan(ROW);
        scan.addColumn(FAMILIES[2], QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[2], QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6]}, new byte[][]{VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6]}, 0, 4);
        scan = new Scan(ROW);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[2], QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6]}, new byte[][]{VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6]}, 0, 4);
        get2 = new Get(ROW);
        get2.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get2);
        TestClient.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
        get2 = new Get(ROW);
        get2.addFamily(FAMILIES[0]);
        get2.addFamily(FAMILIES[1]);
        get2.addFamily(FAMILIES[2]);
        get2.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get2);
        TestClient.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
        get2 = new Get(ROW);
        get2.addColumn(FAMILIES[0], QUALIFIER);
        get2.addColumn(FAMILIES[1], QUALIFIER);
        get2.addColumn(FAMILIES[2], QUALIFIER);
        get2.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get2);
        TestClient.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
        scan = new Scan(ROW);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        TestClient.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
        scan = new Scan(ROW);
        scan.setMaxVersions(Integer.MAX_VALUE);
        scan.addFamily(FAMILIES[0]);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        result = this.getSingleScanResult(ht, scan);
        TestClient.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
        scan = new Scan(ROW);
        scan.setMaxVersions(Integer.MAX_VALUE);
        scan.addColumn(FAMILIES[0], QUALIFIER);
        scan.addColumn(FAMILIES[1], QUALIFIER);
        scan.addColumn(FAMILIES[2], QUALIFIER);
        result = this.getSingleScanResult(ht, scan);
        TestClient.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
    }

    public void testDeletes() throws Exception {
        byte[] bytes;
        int i;
        byte[] bytes2;
        int i2;
        byte[] TABLE = Bytes.toBytes("testDeletes");
        byte[][] ROWS = this.makeNAscii(ROW, 6);
        byte[][] FAMILIES = this.makeN(FAMILY, 3);
        byte[][] VALUES = this.makeN(VALUE, 5);
        long[] ts = new long[]{1000L, 2000L, 3000L, 4000L, 5000L};
        HTable ht = this.createTable(TABLE, FAMILIES);
        Put put = new Put(ROW);
        put.add(FAMILIES[0], QUALIFIER, ts[0], VALUES[0]);
        put.add(FAMILIES[0], QUALIFIER, ts[1], VALUES[1]);
        ht.put(put);
        Delete delete = new Delete(ROW);
        delete.deleteFamily(FAMILIES[0], ts[0]);
        ht.delete(delete);
        Get get2 = new Get(ROW);
        get2.addFamily(FAMILIES[0]);
        get2.setMaxVersions(Integer.MAX_VALUE);
        Result result = ht.get(get2);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUES[1]}, 0, 0);
        Scan scan = new Scan(ROW);
        scan.addFamily(FAMILIES[0]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUES[1]}, 0, 0);
        put = new Put(ROW);
        put.add(FAMILIES[0], QUALIFIER, ts[4], VALUES[4]);
        put.add(FAMILIES[0], QUALIFIER, ts[2], VALUES[2]);
        put.add(FAMILIES[0], QUALIFIER, ts[3], VALUES[3]);
        put.add(FAMILIES[0], null, ts[4], VALUES[4]);
        put.add(FAMILIES[0], null, ts[2], VALUES[2]);
        put.add(FAMILIES[0], null, ts[3], VALUES[3]);
        ht.put(put);
        delete = new Delete(ROW);
        delete.deleteColumn(FAMILIES[0], QUALIFIER);
        ht.delete(delete);
        get2 = new Get(ROW);
        get2.addColumn(FAMILIES[0], QUALIFIER);
        get2.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get2);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        scan = new Scan(ROW);
        scan.addColumn(FAMILIES[0], QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        delete = new Delete(ROW);
        delete.deleteColumn(FAMILIES[0], null);
        ht.delete(delete);
        delete = new Delete(ROW);
        delete.deleteColumns(FAMILIES[0], null);
        ht.delete(delete);
        put = new Put(ROW);
        put.add(FAMILIES[0], QUALIFIER, ts[0], VALUES[0]);
        put.add(FAMILIES[0], QUALIFIER, ts[4], VALUES[4]);
        ht.put(put);
        get2 = new Get(ROW);
        get2.addFamily(FAMILIES[0]);
        get2.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get2);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[2], ts[3], ts[4]}, new byte[][]{VALUES[2], VALUES[3], VALUES[4]}, 0, 2);
        scan = new Scan(ROW);
        scan.addFamily(FAMILIES[0]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        put = new Put(ROWS[0]);
        put.add(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
        put.add(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
        put.add(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
        put.add(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
        ht.put(put);
        put = new Put(ROWS[1]);
        put.add(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
        put.add(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
        put.add(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
        put.add(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
        ht.put(put);
        put = new Put(ROWS[2]);
        put.add(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
        put.add(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
        put.add(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
        put.add(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
        ht.put(put);
        delete = new Delete(ROWS[0]);
        delete.deleteFamily(FAMILIES[2]);
        ht.delete(delete);
        delete = new Delete(ROWS[1]);
        delete.deleteColumns(FAMILIES[1], QUALIFIER);
        ht.delete(delete);
        delete = new Delete(ROWS[2]);
        delete.deleteColumn(FAMILIES[1], QUALIFIER);
        delete.deleteColumn(FAMILIES[1], QUALIFIER);
        delete.deleteColumn(FAMILIES[2], QUALIFIER);
        ht.delete(delete);
        get2 = new Get(ROWS[0]);
        get2.addFamily(FAMILIES[1]);
        get2.addFamily(FAMILIES[2]);
        get2.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get2);
        TestClient.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        this.assertNResult(result, ROWS[0], FAMILIES[1], QUALIFIER, new long[]{ts[0], ts[1]}, new byte[][]{VALUES[0], VALUES[1]}, 0, 1);
        scan = new Scan(ROWS[0]);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        TestClient.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        this.assertNResult(result, ROWS[0], FAMILIES[1], QUALIFIER, new long[]{ts[0], ts[1]}, new byte[][]{VALUES[0], VALUES[1]}, 0, 1);
        get2 = new Get(ROWS[1]);
        get2.addFamily(FAMILIES[1]);
        get2.addFamily(FAMILIES[2]);
        get2.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get2);
        TestClient.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        scan = new Scan(ROWS[1]);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        TestClient.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        get2 = new Get(ROWS[2]);
        get2.addFamily(FAMILIES[1]);
        get2.addFamily(FAMILIES[2]);
        get2.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get2);
        TestClient.assertTrue((String)("Expected 1 key but received " + result.size()), (result.size() == 1 ? 1 : 0) != 0);
        this.assertNResult(result, ROWS[2], FAMILIES[2], QUALIFIER, new long[]{ts[2]}, new byte[][]{VALUES[2]}, 0, 0);
        scan = new Scan(ROWS[2]);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        TestClient.assertTrue((String)("Expected 1 key but received " + result.size()), (result.size() == 1 ? 1 : 0) != 0);
        this.assertNResult(result, ROWS[2], FAMILIES[2], QUALIFIER, new long[]{ts[2]}, new byte[][]{VALUES[2]}, 0, 0);
        delete = new Delete(ROWS[3]);
        delete.deleteFamily(FAMILIES[1]);
        ht.delete(delete);
        put = new Put(ROWS[3]);
        put.add(FAMILIES[2], QUALIFIER, VALUES[0]);
        ht.put(put);
        put = new Put(ROWS[4]);
        put.add(FAMILIES[1], QUALIFIER, VALUES[1]);
        put.add(FAMILIES[2], QUALIFIER, VALUES[2]);
        ht.put(put);
        get2 = new Get(ROWS[3]);
        get2.addFamily(FAMILIES[1]);
        get2.addFamily(FAMILIES[2]);
        get2.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get2);
        TestClient.assertTrue((String)("Expected 1 key but received " + result.size()), (result.size() == 1 ? 1 : 0) != 0);
        get2 = new Get(ROWS[4]);
        get2.addFamily(FAMILIES[1]);
        get2.addFamily(FAMILIES[2]);
        get2.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get2);
        TestClient.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        scan = new Scan(ROWS[3]);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        ResultScanner scanner = ht.getScanner(scan);
        result = scanner.next();
        TestClient.assertTrue((String)("Expected 1 key but received " + result.size()), (result.size() == 1 ? 1 : 0) != 0);
        TestClient.assertTrue((boolean)Bytes.equals(result.sorted()[0].getRow(), ROWS[3]));
        TestClient.assertTrue((boolean)Bytes.equals(result.sorted()[0].getValue(), VALUES[0]));
        result = scanner.next();
        TestClient.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        TestClient.assertTrue((boolean)Bytes.equals(result.sorted()[0].getRow(), ROWS[4]));
        TestClient.assertTrue((boolean)Bytes.equals(result.sorted()[1].getRow(), ROWS[4]));
        TestClient.assertTrue((boolean)Bytes.equals(result.sorted()[0].getValue(), VALUES[1]));
        TestClient.assertTrue((boolean)Bytes.equals(result.sorted()[1].getValue(), VALUES[2]));
        scanner.close();
        for (i2 = 0; i2 < 10; ++i2) {
            bytes2 = Bytes.toBytes(i2);
            put = new Put(bytes2);
            put.add(FAMILIES[0], QUALIFIER, bytes2);
            ht.put(put);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            bytes2 = Bytes.toBytes(i2);
            get2 = new Get(bytes2);
            get2.addFamily(FAMILIES[0]);
            result = ht.get(get2);
            TestClient.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        }
        ArrayList<Delete> deletes = new ArrayList<Delete>();
        for (i = 0; i < 10; ++i) {
            bytes = Bytes.toBytes(i);
            delete = new Delete(bytes);
            delete.deleteFamily(FAMILIES[0]);
            deletes.add(delete);
        }
        ht.delete(deletes);
        for (i = 0; i < 10; ++i) {
            bytes = Bytes.toBytes(i);
            get2 = new Get(bytes);
            get2.addFamily(FAMILIES[0]);
            result = ht.get(get2);
            TestClient.assertTrue((result.size() == 0 ? 1 : 0) != 0);
        }
    }

    public void XtestMillions() throws Exception {
    }

    public void XtestMultipleRegionsAndBatchPuts() throws Exception {
    }

    public void XtestMultipleRowMultipleFamily() throws Exception {
    }

    public void testJIRAs() throws Exception {
        this.jiraTest867();
        this.jiraTest861();
        this.jiraTest33();
        this.jiraTest1014();
        this.jiraTest1182();
        this.jiraTest52();
    }

    private void jiraTest867() throws Exception {
        int i;
        int numRows = 10;
        int numColsPerRow = 2000;
        byte[] TABLE = Bytes.toBytes("jiraTest867");
        byte[][] ROWS = this.makeN(ROW, numRows);
        byte[][] QUALIFIERS = this.makeN(QUALIFIER, numColsPerRow);
        HTable ht = this.createTable(TABLE, FAMILY);
        for (int i2 = 0; i2 < numRows; ++i2) {
            Put put = new Put(ROWS[i2]);
            for (int j = 0; j < numColsPerRow; ++j) {
                put.add(FAMILY, QUALIFIERS[j], QUALIFIERS[j]);
            }
            TestClient.assertTrue((String)("Put expected to contain " + numColsPerRow + " columns but " + "only contains " + put.size()), (put.size() == numColsPerRow ? 1 : 0) != 0);
            ht.put(put);
        }
        Get get2 = new Get(ROWS[numRows - 1]);
        Result result = ht.get(get2);
        this.assertNumKeys(result, numColsPerRow);
        KeyValue[] keys = result.sorted();
        for (int i3 = 0; i3 < result.size(); ++i3) {
            this.assertKey(keys[i3], ROWS[numRows - 1], FAMILY, QUALIFIERS[i3], QUALIFIERS[i3]);
        }
        Scan scan = new Scan();
        ResultScanner scanner = ht.getScanner(scan);
        int rowCount = 0;
        while ((result = scanner.next()) != null) {
            this.assertNumKeys(result, numColsPerRow);
            KeyValue[] kvs = result.sorted();
            for (i = 0; i < numColsPerRow; ++i) {
                this.assertKey(kvs[i], ROWS[rowCount], FAMILY, QUALIFIERS[i], QUALIFIERS[i]);
            }
            ++rowCount;
        }
        scanner.close();
        TestClient.assertTrue((String)("Expected to scan " + numRows + " rows but actually scanned " + rowCount + " rows"), (rowCount == numRows ? 1 : 0) != 0);
        this.flushMemStore(TABLE);
        get2 = new Get(ROWS[numRows - 1]);
        result = ht.get(get2);
        this.assertNumKeys(result, numColsPerRow);
        keys = result.sorted();
        for (int i4 = 0; i4 < result.size(); ++i4) {
            this.assertKey(keys[i4], ROWS[numRows - 1], FAMILY, QUALIFIERS[i4], QUALIFIERS[i4]);
        }
        scan = new Scan();
        scanner = ht.getScanner(scan);
        rowCount = 0;
        while ((result = scanner.next()) != null) {
            this.assertNumKeys(result, numColsPerRow);
            KeyValue[] kvs = result.sorted();
            for (i = 0; i < numColsPerRow; ++i) {
                this.assertKey(kvs[i], ROWS[rowCount], FAMILY, QUALIFIERS[i], QUALIFIERS[i]);
            }
            ++rowCount;
        }
        scanner.close();
        TestClient.assertTrue((String)("Expected to scan " + numRows + " rows but actually scanned " + rowCount + " rows"), (rowCount == numRows ? 1 : 0) != 0);
    }

    private void jiraTest861() throws Exception {
        byte[] TABLE = Bytes.toBytes("jiraTest861");
        byte[][] VALUES = this.makeNAscii(VALUE, 7);
        long[] STAMPS = this.makeStamps(7);
        HTable ht = this.createTable(TABLE, FAMILY, 10);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        ht.put(put);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[1]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[5]);
        this.flushMemStore(TABLE);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[1]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[5]);
        put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        put.add(FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
        ht.put(put);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[5]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
        this.flushMemStore(TABLE);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[5]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
    }

    private void jiraTest33() throws Exception {
        byte[] TABLE = Bytes.toBytes("jiraTest33");
        byte[][] VALUES = this.makeNAscii(VALUE, 7);
        long[] STAMPS = this.makeStamps(7);
        HTable ht = this.createTable(TABLE, FAMILY, 10);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        put.add(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        put.add(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        ht.put(put);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 2);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 3);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 2);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 3);
        this.flushMemStore(TABLE);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 2);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 3);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 2);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 3);
    }

    private void jiraTest1014() throws Exception {
        byte[] TABLE = Bytes.toBytes("jiraTest1014");
        HTable ht = this.createTable(TABLE, FAMILY, 10);
        long manualStamp = 12345L;
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, manualStamp, VALUE);
        ht.put(put);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, manualStamp, VALUE);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, manualStamp - 1L);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, manualStamp + 1L);
    }

    private void jiraTest1182() throws Exception {
        byte[] TABLE = Bytes.toBytes("jiraTest1182");
        byte[][] VALUES = this.makeNAscii(VALUE, 7);
        long[] STAMPS = this.makeStamps(7);
        HTable ht = this.createTable(TABLE, FAMILY, 10);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        put.add(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        put.add(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        ht.put(put);
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 5);
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.flushMemStore(TABLE);
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 5);
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
    }

    private void jiraTest52() throws Exception {
        byte[] TABLE = Bytes.toBytes("jiraTest52");
        byte[][] VALUES = this.makeNAscii(VALUE, 7);
        long[] STAMPS = this.makeStamps(7);
        HTable ht = this.createTable(TABLE, FAMILY, 10);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        put.add(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        put.add(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        ht.put(put);
        this.getAllVersionsAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanAllVersionsAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.flushMemStore(TABLE);
        this.getAllVersionsAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanAllVersionsAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
    }

    private void getVersionRangeAndVerifyGreaterThan(HTable ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Get get2 = new Get(row);
        get2.addColumn(family, qualifier);
        get2.setMaxVersions(Integer.MAX_VALUE);
        get2.setTimeRange(stamps[start + 1], Long.MAX_VALUE);
        Result result = ht.get(get2);
        this.assertNResult(result, row, family, qualifier, stamps, values, start + 1, end);
    }

    private void getVersionRangeAndVerify(HTable ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Get get2 = new Get(row);
        get2.addColumn(family, qualifier);
        get2.setMaxVersions(Integer.MAX_VALUE);
        get2.setTimeRange(stamps[start], stamps[end] + 1L);
        Result result = ht.get(get2);
        this.assertNResult(result, row, family, qualifier, stamps, values, start, end);
    }

    private void getAllVersionsAndVerify(HTable ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Get get2 = new Get(row);
        get2.addColumn(family, qualifier);
        get2.setMaxVersions(Integer.MAX_VALUE);
        Result result = ht.get(get2);
        this.assertNResult(result, row, family, qualifier, stamps, values, start, end);
    }

    private void scanVersionRangeAndVerifyGreaterThan(HTable ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Scan scan = new Scan(row);
        scan.addColumn(family, qualifier);
        scan.setMaxVersions(Integer.MAX_VALUE);
        scan.setTimeRange(stamps[start + 1], Long.MAX_VALUE);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, row, family, qualifier, stamps, values, start + 1, end);
    }

    private void scanVersionRangeAndVerify(HTable ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Scan scan = new Scan(row);
        scan.addColumn(family, qualifier);
        scan.setMaxVersions(Integer.MAX_VALUE);
        scan.setTimeRange(stamps[start], stamps[end] + 1L);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, row, family, qualifier, stamps, values, start, end);
    }

    private void scanAllVersionsAndVerify(HTable ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Scan scan = new Scan(row);
        scan.addColumn(family, qualifier);
        scan.setMaxVersions(Integer.MAX_VALUE);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, row, family, qualifier, stamps, values, start, end);
    }

    private void getVersionAndVerify(HTable ht, byte[] row, byte[] family, byte[] qualifier, long stamp, byte[] value) throws Exception {
        Get get2 = new Get(row);
        get2.addColumn(family, qualifier);
        get2.setTimeStamp(stamp);
        get2.setMaxVersions(Integer.MAX_VALUE);
        Result result = ht.get(get2);
        this.assertSingleResult(result, row, family, qualifier, stamp, value);
    }

    private void getVersionAndVerifyMissing(HTable ht, byte[] row, byte[] family, byte[] qualifier, long stamp) throws Exception {
        Get get2 = new Get(row);
        get2.addColumn(family, qualifier);
        get2.setTimeStamp(stamp);
        get2.setMaxVersions(Integer.MAX_VALUE);
        Result result = ht.get(get2);
        this.assertEmptyResult(result);
    }

    private void scanVersionAndVerify(HTable ht, byte[] row, byte[] family, byte[] qualifier, long stamp, byte[] value) throws Exception {
        Scan scan = new Scan(row);
        scan.addColumn(family, qualifier);
        scan.setTimeStamp(stamp);
        scan.setMaxVersions(Integer.MAX_VALUE);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, qualifier, stamp, value);
    }

    private void scanVersionAndVerifyMissing(HTable ht, byte[] row, byte[] family, byte[] qualifier, long stamp) throws Exception {
        Scan scan = new Scan(row);
        scan.addColumn(family, qualifier);
        scan.setTimeStamp(stamp);
        scan.setMaxVersions(Integer.MAX_VALUE);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
    }

    private void getTestNull(HTable ht, byte[] row, byte[] family, byte[] value) throws Exception {
        Get get2 = new Get(row);
        get2.addColumn(family, null);
        Result result = ht.get(get2);
        this.assertSingleResult(result, row, family, null, value);
        get2 = new Get(row);
        get2.addColumn(family, EMPTY);
        result = ht.get(get2);
        this.assertSingleResult(result, row, family, EMPTY, value);
        get2 = new Get(row);
        get2.addFamily(family);
        result = ht.get(get2);
        this.assertSingleResult(result, row, family, EMPTY, value);
        get2 = new Get(row);
        result = ht.get(get2);
        this.assertSingleResult(result, row, family, EMPTY, value);
    }

    private void scanTestNull(HTable ht, byte[] row, byte[] family, byte[] value) throws Exception {
        Scan scan = new Scan();
        scan.addColumn(family, null);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, EMPTY, value);
        scan = new Scan();
        scan.addColumn(family, EMPTY);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, EMPTY, value);
        scan = new Scan();
        scan.addFamily(family);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, EMPTY, value);
        scan = new Scan();
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, EMPTY, value);
    }

    private void singleRowGetTest(HTable ht, byte[][] ROWS, byte[][] FAMILIES, byte[][] QUALIFIERS, byte[][] VALUES) throws Exception {
        Get get2 = new Get(ROWS[0]);
        get2.addColumn(FAMILIES[4], QUALIFIERS[0]);
        Result result = ht.get(get2);
        this.assertSingleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0]);
        get2 = new Get(ROWS[0]);
        get2.addColumn(FAMILIES[2], QUALIFIERS[2]);
        result = ht.get(get2);
        this.assertSingleResult(result, ROWS[0], FAMILIES[2], QUALIFIERS[2], VALUES[2]);
        get2 = new Get(ROWS[0]);
        get2.addFamily(FAMILIES[7]);
        result = ht.get(get2);
        this.assertSingleResult(result, ROWS[0], FAMILIES[7], QUALIFIERS[7], VALUES[7]);
        get2 = new Get(ROWS[0]);
        get2.addFamily(FAMILIES[4]);
        result = ht.get(get2);
        this.assertDoubleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0], FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        get2 = new Get(ROWS[0]);
        get2.addColumn(FAMILIES[4], QUALIFIERS[0]);
        get2.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = ht.get(get2);
        this.assertDoubleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0], FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        get2 = new Get(ROWS[0]);
        get2.addFamily(FAMILIES[4]);
        get2.addFamily(FAMILIES[7]);
        result = ht.get(get2);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{4, 0, 0}, {4, 4, 4}, {7, 7, 7}});
        get2 = new Get(ROWS[0]);
        get2.addFamily(FAMILIES[2]);
        get2.addFamily(FAMILIES[4]);
        get2.addFamily(FAMILIES[6]);
        get2.addFamily(FAMILIES[7]);
        result = ht.get(get2);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}});
        get2 = new Get(ROWS[0]);
        get2.addColumn(FAMILIES[2], QUALIFIERS[2]);
        get2.addColumn(FAMILIES[2], QUALIFIERS[4]);
        get2.addColumn(FAMILIES[4], QUALIFIERS[0]);
        get2.addColumn(FAMILIES[4], QUALIFIERS[4]);
        get2.addColumn(FAMILIES[6], QUALIFIERS[6]);
        get2.addColumn(FAMILIES[6], QUALIFIERS[7]);
        get2.addColumn(FAMILIES[7], QUALIFIERS[7]);
        get2.addColumn(FAMILIES[7], QUALIFIERS[8]);
        result = ht.get(get2);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}});
        get2 = new Get(ROWS[0]);
        result = ht.get(get2);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}, {9, 0, 0}});
        get2 = new Get(ROWS[1]);
        result = ht.get(get2);
        this.assertEmptyResult(result);
        get2 = new Get(ROWS[0]);
        get2.addColumn(FAMILIES[4], QUALIFIERS[3]);
        get2.addColumn(FAMILIES[2], QUALIFIERS[3]);
        result = ht.get(get2);
        this.assertEmptyResult(result);
    }

    private void singleRowScanTest(HTable ht, byte[][] ROWS, byte[][] FAMILIES, byte[][] QUALIFIERS, byte[][] VALUES) throws Exception {
        Scan scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[0]);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0]);
        scan = new Scan();
        scan.addColumn(FAMILIES[2], QUALIFIERS[2]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[2], QUALIFIERS[2], VALUES[2]);
        scan = new Scan();
        scan.addFamily(FAMILIES[7]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[7], QUALIFIERS[7], VALUES[7]);
        scan = new Scan();
        scan.addFamily(FAMILIES[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertDoubleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0], FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[0]);
        scan.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertDoubleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0], FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        scan = new Scan();
        scan.addFamily(FAMILIES[4]);
        scan.addFamily(FAMILIES[7]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{4, 0, 0}, {4, 4, 4}, {7, 7, 7}});
        scan = new Scan();
        scan.addFamily(FAMILIES[2]);
        scan.addFamily(FAMILIES[4]);
        scan.addFamily(FAMILIES[6]);
        scan.addFamily(FAMILIES[7]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}});
        scan = new Scan();
        scan.addColumn(FAMILIES[2], QUALIFIERS[2]);
        scan.addColumn(FAMILIES[2], QUALIFIERS[4]);
        scan.addColumn(FAMILIES[4], QUALIFIERS[0]);
        scan.addColumn(FAMILIES[4], QUALIFIERS[4]);
        scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
        scan.addColumn(FAMILIES[6], QUALIFIERS[7]);
        scan.addColumn(FAMILIES[7], QUALIFIERS[7]);
        scan.addColumn(FAMILIES[7], QUALIFIERS[8]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}});
        scan = new Scan();
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}, {9, 0, 0}});
        scan = new Scan(ROWS[1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[3]);
        scan.addColumn(FAMILIES[2], QUALIFIERS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
    }

    private void getVerifySingleColumn(HTable ht, byte[][] ROWS, int ROWIDX, byte[][] FAMILIES, int FAMILYIDX, byte[][] QUALIFIERS, int QUALIFIERIDX, byte[][] VALUES, int VALUEIDX) throws Exception {
        Get get2 = new Get(ROWS[ROWIDX]);
        Result result = ht.get(get2);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get2 = new Get(ROWS[ROWIDX]);
        get2.addFamily(FAMILIES[FAMILYIDX]);
        result = ht.get(get2);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get2 = new Get(ROWS[ROWIDX]);
        get2.addFamily(FAMILIES[FAMILYIDX - 2]);
        get2.addFamily(FAMILIES[FAMILYIDX]);
        get2.addFamily(FAMILIES[FAMILYIDX + 2]);
        result = ht.get(get2);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get2 = new Get(ROWS[ROWIDX]);
        get2.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[0]);
        result = ht.get(get2);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get2 = new Get(ROWS[ROWIDX]);
        get2.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[1]);
        get2.addFamily(FAMILIES[FAMILYIDX]);
        result = ht.get(get2);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get2 = new Get(ROWS[ROWIDX]);
        get2.addFamily(FAMILIES[FAMILYIDX]);
        get2.addColumn(FAMILIES[FAMILYIDX + 1], QUALIFIERS[1]);
        get2.addColumn(FAMILIES[FAMILYIDX - 2], QUALIFIERS[1]);
        get2.addFamily(FAMILIES[FAMILYIDX - 1]);
        get2.addFamily(FAMILIES[FAMILYIDX + 2]);
        result = ht.get(get2);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
    }

    private void scanVerifySingleColumn(HTable ht, byte[][] ROWS, int ROWIDX, byte[][] FAMILIES, int FAMILYIDX, byte[][] QUALIFIERS, int QUALIFIERIDX, byte[][] VALUES, int VALUEIDX) throws Exception {
        Scan scan = new Scan();
        Result result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan(ROWS[ROWIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan(ROWS[ROWIDX], ROWS[ROWIDX + 1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan(HConstants.EMPTY_START_ROW, ROWS[ROWIDX + 1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan();
        scan.addFamily(FAMILIES[FAMILYIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan();
        scan.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan();
        scan.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX + 1]);
        scan.addFamily(FAMILIES[FAMILYIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan();
        scan.addColumn(FAMILIES[FAMILYIDX - 1], QUALIFIERS[QUALIFIERIDX + 1]);
        scan.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX]);
        scan.addFamily(FAMILIES[FAMILYIDX + 1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
    }

    private void getVerifySingleEmpty(HTable ht, byte[][] ROWS, int ROWIDX, byte[][] FAMILIES, int FAMILYIDX, byte[][] QUALIFIERS, int QUALIFIERIDX) throws Exception {
        Get get2 = new Get(ROWS[ROWIDX]);
        get2.addFamily(FAMILIES[4]);
        get2.addColumn(FAMILIES[4], QUALIFIERS[1]);
        Result result = ht.get(get2);
        this.assertEmptyResult(result);
        get2 = new Get(ROWS[ROWIDX]);
        get2.addFamily(FAMILIES[4]);
        get2.addColumn(FAMILIES[4], QUALIFIERS[2]);
        result = ht.get(get2);
        this.assertEmptyResult(result);
        get2 = new Get(ROWS[ROWIDX]);
        get2.addFamily(FAMILIES[3]);
        get2.addColumn(FAMILIES[4], QUALIFIERS[2]);
        get2.addFamily(FAMILIES[5]);
        result = ht.get(get2);
        this.assertEmptyResult(result);
        get2 = new Get(ROWS[ROWIDX + 1]);
        result = ht.get(get2);
        this.assertEmptyResult(result);
    }

    private void scanVerifySingleEmpty(HTable ht, byte[][] ROWS, int ROWIDX, byte[][] FAMILIES, int FAMILYIDX, byte[][] QUALIFIERS, int QUALIFIERIDX) throws Exception {
        Scan scan = new Scan(ROWS[ROWIDX + 1]);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(ROWS[ROWIDX + 1], ROWS[ROWIDX + 2]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(HConstants.EMPTY_START_ROW, ROWS[ROWIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX + 1]);
        scan.addFamily(FAMILIES[FAMILYIDX - 1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
    }

    private void assertKey(KeyValue key, byte[] row, byte[] family, byte[] qualifier, byte[] value) throws Exception {
        TestClient.assertTrue((String)("Expected row [" + Bytes.toString(row) + "] " + "Got row [" + Bytes.toString(key.getRow()) + "]"), (boolean)this.equals(row, key.getRow()));
        TestClient.assertTrue((String)("Expected family [" + Bytes.toString(family) + "] " + "Got family [" + Bytes.toString(key.getFamily()) + "]"), (boolean)this.equals(family, key.getFamily()));
        TestClient.assertTrue((String)("Expected qualifier [" + Bytes.toString(qualifier) + "] " + "Got qualifier [" + Bytes.toString(key.getQualifier()) + "]"), (boolean)this.equals(qualifier, key.getQualifier()));
        TestClient.assertTrue((String)("Expected value [" + Bytes.toString(value) + "] " + "Got value [" + Bytes.toString(key.getValue()) + "]"), (boolean)this.equals(value, key.getValue()));
    }

    private void assertNumKeys(Result result, int n) throws Exception {
        TestClient.assertTrue((String)("Expected " + n + " keys but got " + result.size()), (result.size() == n ? 1 : 0) != 0);
    }

    private void assertNResult(Result result, byte[] row, byte[][] families, byte[][] qualifiers, byte[][] values, int[][] idxs) throws Exception {
        TestClient.assertTrue((String)("Expected row [" + Bytes.toString(row) + "] " + "Got row [" + Bytes.toString(result.getRow()) + "]"), (boolean)this.equals(row, result.getRow()));
        TestClient.assertTrue((String)("Expected " + idxs.length + " keys but result contains " + result.size()), (result.size() == idxs.length ? 1 : 0) != 0);
        KeyValue[] keys = result.sorted();
        for (int i = 0; i < keys.length; ++i) {
            byte[] family = families[idxs[i][0]];
            byte[] qualifier = qualifiers[idxs[i][1]];
            byte[] value = values[idxs[i][2]];
            KeyValue key = keys[i];
            TestClient.assertTrue((String)("(" + i + ") Expected family [" + Bytes.toString(family) + "] " + "Got family [" + Bytes.toString(key.getFamily()) + "]"), (boolean)this.equals(family, key.getFamily()));
            TestClient.assertTrue((String)("(" + i + ") Expected qualifier [" + Bytes.toString(qualifier) + "] " + "Got qualifier [" + Bytes.toString(key.getQualifier()) + "]"), (boolean)this.equals(qualifier, key.getQualifier()));
            TestClient.assertTrue((String)("(" + i + ") Expected value [" + Bytes.toString(value) + "] " + "Got value [" + Bytes.toString(key.getValue()) + "]"), (boolean)this.equals(value, key.getValue()));
        }
    }

    private void assertNResult(Result result, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        TestClient.assertTrue((String)("Expected row [" + Bytes.toString(row) + "] " + "Got row [" + Bytes.toString(result.getRow()) + "]"), (boolean)this.equals(row, result.getRow()));
        int expectedResults = end - start + 1;
        TestClient.assertTrue((String)("Expected " + expectedResults + " keys but result contains " + result.size()), (result.size() == expectedResults ? 1 : 0) != 0);
        KeyValue[] keys = result.sorted();
        for (int i = 0; i < keys.length; ++i) {
            byte[] value = values[end - i];
            long ts = stamps[end - i];
            KeyValue key = keys[i];
            TestClient.assertTrue((String)("(" + i + ") Expected family [" + Bytes.toString(family) + "] " + "Got family [" + Bytes.toString(key.getFamily()) + "]"), (boolean)this.equals(family, key.getFamily()));
            TestClient.assertTrue((String)("(" + i + ") Expected qualifier [" + Bytes.toString(qualifier) + "] " + "Got qualifier [" + Bytes.toString(key.getQualifier()) + "]"), (boolean)this.equals(qualifier, key.getQualifier()));
            TestClient.assertTrue((String)("Expected ts [" + ts + "] " + "Got ts [" + key.getTimestamp() + "]"), (ts == key.getTimestamp() ? 1 : 0) != 0);
            TestClient.assertTrue((String)("(" + i + ") Expected value [" + Bytes.toString(value) + "] " + "Got value [" + Bytes.toString(key.getValue()) + "]"), (boolean)this.equals(value, key.getValue()));
        }
    }

    private void assertDoubleResult(Result result, byte[] row, byte[] familyA, byte[] qualifierA, byte[] valueA, byte[] familyB, byte[] qualifierB, byte[] valueB) throws Exception {
        TestClient.assertTrue((String)("Expected row [" + Bytes.toString(row) + "] " + "Got row [" + Bytes.toString(result.getRow()) + "]"), (boolean)this.equals(row, result.getRow()));
        TestClient.assertTrue((String)("Expected two keys but result contains " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        KeyValue[] kv = result.sorted();
        KeyValue kvA = kv[0];
        TestClient.assertTrue((String)("(A) Expected family [" + Bytes.toString(familyA) + "] " + "Got family [" + Bytes.toString(kvA.getFamily()) + "]"), (boolean)this.equals(familyA, kvA.getFamily()));
        TestClient.assertTrue((String)("(A) Expected qualifier [" + Bytes.toString(qualifierA) + "] " + "Got qualifier [" + Bytes.toString(kvA.getQualifier()) + "]"), (boolean)this.equals(qualifierA, kvA.getQualifier()));
        TestClient.assertTrue((String)("(A) Expected value [" + Bytes.toString(valueA) + "] " + "Got value [" + Bytes.toString(kvA.getValue()) + "]"), (boolean)this.equals(valueA, kvA.getValue()));
        KeyValue kvB = kv[1];
        TestClient.assertTrue((String)("(B) Expected family [" + Bytes.toString(familyB) + "] " + "Got family [" + Bytes.toString(kvB.getFamily()) + "]"), (boolean)this.equals(familyB, kvB.getFamily()));
        TestClient.assertTrue((String)("(B) Expected qualifier [" + Bytes.toString(qualifierB) + "] " + "Got qualifier [" + Bytes.toString(kvB.getQualifier()) + "]"), (boolean)this.equals(qualifierB, kvB.getQualifier()));
        TestClient.assertTrue((String)("(B) Expected value [" + Bytes.toString(valueB) + "] " + "Got value [" + Bytes.toString(kvB.getValue()) + "]"), (boolean)this.equals(valueB, kvB.getValue()));
    }

    private void assertSingleResult(Result result, byte[] row, byte[] family, byte[] qualifier, byte[] value) throws Exception {
        TestClient.assertTrue((String)("Expected row [" + Bytes.toString(row) + "] " + "Got row [" + Bytes.toString(result.getRow()) + "]"), (boolean)this.equals(row, result.getRow()));
        TestClient.assertTrue((String)("Expected a single key but result contains " + result.size()), (result.size() == 1 ? 1 : 0) != 0);
        KeyValue kv = result.sorted()[0];
        TestClient.assertTrue((String)("Expected family [" + Bytes.toString(family) + "] " + "Got family [" + Bytes.toString(kv.getFamily()) + "]"), (boolean)this.equals(family, kv.getFamily()));
        TestClient.assertTrue((String)("Expected qualifier [" + Bytes.toString(qualifier) + "] " + "Got qualifier [" + Bytes.toString(kv.getQualifier()) + "]"), (boolean)this.equals(qualifier, kv.getQualifier()));
        TestClient.assertTrue((String)("Expected value [" + Bytes.toString(value) + "] " + "Got value [" + Bytes.toString(kv.getValue()) + "]"), (boolean)this.equals(value, kv.getValue()));
    }

    private void assertSingleResult(Result result, byte[] row, byte[] family, byte[] qualifier, long ts, byte[] value) throws Exception {
        TestClient.assertTrue((String)("Expected row [" + Bytes.toString(row) + "] " + "Got row [" + Bytes.toString(result.getRow()) + "]"), (boolean)this.equals(row, result.getRow()));
        TestClient.assertTrue((String)("Expected a single key but result contains " + result.size()), (result.size() == 1 ? 1 : 0) != 0);
        KeyValue kv = result.sorted()[0];
        TestClient.assertTrue((String)("Expected family [" + Bytes.toString(family) + "] " + "Got family [" + Bytes.toString(kv.getFamily()) + "]"), (boolean)this.equals(family, kv.getFamily()));
        TestClient.assertTrue((String)("Expected qualifier [" + Bytes.toString(qualifier) + "] " + "Got qualifier [" + Bytes.toString(kv.getQualifier()) + "]"), (boolean)this.equals(qualifier, kv.getQualifier()));
        TestClient.assertTrue((String)("Expected ts [" + ts + "] " + "Got ts [" + kv.getTimestamp() + "]"), (ts == kv.getTimestamp() ? 1 : 0) != 0);
        TestClient.assertTrue((String)("Expected value [" + Bytes.toString(value) + "] " + "Got value [" + Bytes.toString(kv.getValue()) + "]"), (boolean)this.equals(value, kv.getValue()));
    }

    private void assertEmptyResult(Result result) throws Exception {
        TestClient.assertTrue((String)("expected an empty result but result contains " + result.size() + " keys"), (boolean)result.isEmpty());
    }

    private void assertNullResult(Result result) throws Exception {
        TestClient.assertTrue((String)"expected null result but received a non-null result", (result == null ? 1 : 0) != 0);
    }

    private void flushMemStore(byte[] tableName) throws Exception {
        System.out.println("\n\nFlushing table [" + Bytes.toString(tableName) + "]...\n");
        this.cluster.flushcache();
        System.out.println("\nTable flushed.\n\n");
    }

    private Result getSingleScanResult(HTable ht, Scan scan) throws IOException {
        ResultScanner scanner = ht.getScanner(scan);
        Result result = scanner.next();
        scanner.close();
        return result;
    }

    private byte[][] makeNAscii(byte[] base, int n) {
        if (n > 256) {
            return this.makeNBig(base, n);
        }
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            byte[] tail = Bytes.toBytes(new Integer(i).toString());
            ret[i] = Bytes.add(base, tail);
        }
        return ret;
    }

    private byte[][] makeN(byte[] base, int n) {
        if (n > 256) {
            return this.makeNBig(base, n);
        }
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            ret[i] = Bytes.add(base, new byte[]{(byte)i});
        }
        return ret;
    }

    private byte[][] makeNBig(byte[] base, int n) {
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            int byteA = i % 256;
            int byteB = i >> 8;
            ret[i] = Bytes.add(base, new byte[]{(byte)byteB, (byte)byteA});
        }
        return ret;
    }

    private long[] makeStamps(int n) {
        long[] stamps = new long[n];
        for (int i = 0; i < n; ++i) {
            stamps[i] = i + 1;
        }
        return stamps;
    }

    private HTable createTable(byte[] tableName, byte[] family) throws IOException {
        return this.createTable(tableName, new byte[][]{family});
    }

    private HTable createTable(byte[] tableName, byte[][] families) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            desc.addFamily(new HColumnDescriptor(family));
        }
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        admin.createTable(desc);
        return new HTable(this.conf, tableName);
    }

    private HTable createTable(byte[] tableName, byte[] family, int numVersions) throws IOException {
        return this.createTable(tableName, (byte[][])new byte[][]{family}, numVersions);
    }

    private HTable createTable(byte[] tableName, byte[][] families, int numVersions) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family, numVersions, HColumnDescriptor.DEFAULT_COMPRESSION, false, true, Integer.MAX_VALUE, Integer.MAX_VALUE, false);
            desc.addFamily(hcd);
        }
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        admin.createTable(desc);
        return new HTable(this.conf, tableName);
    }

    private HTable createTable(byte[] tableName, byte[][] families, int[] numVersions) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        int i = 0;
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family, numVersions[i], HColumnDescriptor.DEFAULT_COMPRESSION, false, true, Integer.MAX_VALUE, Integer.MAX_VALUE, false);
            desc.addFamily(hcd);
            ++i;
        }
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        admin.createTable(desc);
        return new HTable(this.conf, tableName);
    }

    private boolean equals(byte[] left, byte[] right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null && right.length == 0) {
            return true;
        }
        if (right == null && left.length == 0) {
            return true;
        }
        return Bytes.equals(left, right);
    }

    public void XtestDuplicateVersions() throws Exception {
        byte[] TABLE = Bytes.toBytes("testDuplicateVersions");
        long[] STAMPS = this.makeStamps(20);
        byte[][] VALUES = this.makeNAscii(VALUE, 20);
        HTable ht = this.createTable(TABLE, FAMILY, 10);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        put.add(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        ht.put(put);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        Get get2 = new Get(ROW);
        get2.addColumn(FAMILY, QUALIFIER);
        get2.setMaxVersions(2);
        Result result = ht.get(get2);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        Scan scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(2);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        this.flushMemStore(TABLE);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        get2 = new Get(ROW);
        get2.addColumn(FAMILY, QUALIFIER);
        get2.setMaxVersions(2);
        result = ht.get(get2);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(2);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILY, QUALIFIER, STAMPS[4], VALUES[14]);
        put.add(FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
        put.add(FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        put.add(FAMILY, QUALIFIER, STAMPS[8], VALUES[8]);
        ht.put(put);
        get2 = new Get(ROW);
        get2.addColumn(FAMILY, QUALIFIER);
        get2.setMaxVersions(7);
        result = ht.get(get2);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 6);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(7);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 6);
        get2 = new Get(ROW);
        get2.setMaxVersions(7);
        result = ht.get(get2);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 6);
        scan = new Scan(ROW);
        scan.setMaxVersions(7);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 6);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[14]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[14]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[9]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[9]);
        this.flushMemStore(TABLE);
        put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[9], VALUES[9]);
        put.add(FAMILY, QUALIFIER, STAMPS[11], VALUES[11]);
        put.add(FAMILY, QUALIFIER, STAMPS[13], VALUES[13]);
        put.add(FAMILY, QUALIFIER, STAMPS[15], VALUES[15]);
        ht.put(put);
        get2 = new Get(ROW);
        get2.addColumn(FAMILY, QUALIFIER);
        get2.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get2);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8], STAMPS[9], STAMPS[11], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8], VALUES[9], VALUES[11], VALUES[13], VALUES[15]}, 0, 9);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8], STAMPS[9], STAMPS[11], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8], VALUES[9], VALUES[11], VALUES[13], VALUES[15]}, 0, 9);
        Delete delete = new Delete(ROW);
        delete.deleteColumn(FAMILY, QUALIFIER, STAMPS[11]);
        delete.deleteColumn(FAMILY, QUALIFIER, STAMPS[7]);
        ht.delete(delete);
        get2 = new Get(ROW);
        get2.addColumn(FAMILY, QUALIFIER);
        get2.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get2);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[8], STAMPS[9], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[8], VALUES[9], VALUES[13], VALUES[15]}, 0, 7);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[8], STAMPS[9], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[8], VALUES[9], VALUES[13], VALUES[15]}, 0, 7);
    }
}

