/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;

public class TestForceSplit
extends HBaseClusterTestCase {
    static final Log LOG = LogFactory.getLog(TestForceSplit.class);
    private static final byte[] tableName = Bytes.toBytes("test");
    private static final byte[] columnName = Bytes.toBytes("a:");

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.conf.setInt("hbase.io.index.interval", 32);
    }

    public void testForceSplit() throws Exception {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(columnName));
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        admin.createTable(htd);
        final HTable table = new HTable(this.conf, tableName);
        byte[] k = new byte[3];
        int rowCount = 0;
        for (int b1 = 97; b1 < 122; b1 = (int)((byte)(b1 + 1))) {
            for (int b2 = 97; b2 < 122; b2 = (int)((byte)(b2 + 1))) {
                for (int b3 = 97; b3 < 122; b3 = (int)((byte)(b3 + 1))) {
                    k[0] = b1;
                    k[1] = b2;
                    k[2] = b3;
                    Put put = new Put(k);
                    byte[][] famAndQf = KeyValue.parseColumn(columnName);
                    put.add(famAndQf[0], famAndQf[1], k);
                    table.put(put);
                    ++rowCount;
                }
            }
        }
        Map<HRegionInfo, HServerAddress> m = table.getRegionsInfo();
        System.out.println("Initial regions (" + m.size() + "): " + m);
        TestForceSplit.assertTrue((m.size() == 1 ? 1 : 0) != 0);
        Scan scan = new Scan();
        ResultScanner scanner = table.getScanner(scan);
        int rows = 0;
        for (Result result : scanner) {
            ++rows;
        }
        scanner.close();
        TestForceSplit.assertEquals((int)rowCount, (int)rows);
        scan = new Scan();
        scanner = table.getScanner(scan);
        scanner.next();
        final AtomicInteger count = new AtomicInteger(0);
        Thread t = new Thread("CheckForSplit"){

            @Override
            public void run() {
                for (int i = 0; i < 20; ++i) {
                    try {
                        1.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    Map<HRegionInfo, HServerAddress> regions = null;
                    try {
                        regions = table.getRegionsInfo();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (regions == null) continue;
                    count.set(regions.size());
                    if (count.get() >= 2) break;
                    LOG.debug((Object)"Cycle waiting on split");
                }
            }
        };
        t.start();
        admin.split(Bytes.toString(tableName));
        t.join();
        rows = 1;
        for (Result result : scanner) {
            if (++rows <= rowCount) continue;
            scanner.close();
            TestForceSplit.assertTrue((String)("Scanned more than expected (" + rowCount + ")"), (boolean)false);
        }
        scanner.close();
        TestForceSplit.assertEquals((int)rowCount, (int)rows);
    }
}

