/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.HashSet;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;

public class TestListTables
extends HBaseClusterTestCase {
    HBaseAdmin admin = null;
    private static final HTableDescriptor[] TABLES = new HTableDescriptor[]{new HTableDescriptor("table1"), new HTableDescriptor("table2"), new HTableDescriptor("table3")};

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.admin = new HBaseAdmin(this.conf);
        HColumnDescriptor family = new HColumnDescriptor(HConstants.CATALOG_FAMILY);
        for (int i = 0; i < TABLES.length; ++i) {
            TABLES[i].addFamily(family);
            this.admin.createTable(TABLES[i]);
        }
    }

    public void testListTables() throws IOException {
        HTableDescriptor[] ts = this.admin.listTables();
        HashSet<HTableDescriptor> result = new HashSet<HTableDescriptor>(ts.length);
        for (int i = 0; i < ts.length; ++i) {
            result.add(ts[i]);
        }
        int size = result.size();
        TestListTables.assertEquals((int)TABLES.length, (int)size);
        for (int i = 0; i < TABLES.length && i < size; ++i) {
            TestListTables.assertTrue((boolean)result.contains(TABLES[i]));
        }
    }
}

