/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;

public class TestPut
extends HBaseClusterTestCase {
    private static final byte[] CONTENTS_FAMILY = Bytes.toBytes("contents");
    private static final byte[] SMALL_FAMILY = Bytes.toBytes("smallfam");
    private static final byte[] row1 = Bytes.toBytes("row1");
    private static final byte[] row2 = Bytes.toBytes("row2");
    private static final int SMALL_LENGTH = 1;
    private static final int NB_BATCH_ROWS = 10;
    private byte[] value = Bytes.toBytes("abcd");
    private byte[] smallValue = Bytes.toBytes("a");
    private HTableDescriptor desc = null;
    private HTable table = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.desc = new HTableDescriptor("test");
        this.desc.addFamily(new HColumnDescriptor(CONTENTS_FAMILY));
        this.desc.addFamily(new HColumnDescriptor(SMALL_FAMILY, 3, HColumnDescriptor.DEFAULT_COMPRESSION, false, true, 1, Integer.MAX_VALUE, false));
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        admin.createTable(this.desc);
        this.table = new HTable(this.conf, this.desc.getName());
    }

    public void testPut() throws IOException {
        Put put = new Put(row1);
        put.add(CONTENTS_FAMILY, null, this.value);
        this.table.put(put);
        put = new Put(row2);
        put.add(CONTENTS_FAMILY, null, this.value);
        TestPut.assertEquals((int)put.size(), (int)1);
        TestPut.assertEquals((int)put.getFamilyMap().get(CONTENTS_FAMILY).size(), (int)1);
        KeyValue kv = put.getFamilyMap().get(CONTENTS_FAMILY).get(0);
        TestPut.assertTrue((boolean)Bytes.equals(kv.getFamily(), CONTENTS_FAMILY));
        TestPut.assertTrue((boolean)Bytes.equals(kv.getQualifier(), new byte[0]));
        TestPut.assertTrue((boolean)Bytes.equals(kv.getValue(), this.value));
        this.table.put(put);
        Scan scan = new Scan();
        scan.addColumn(CONTENTS_FAMILY, null);
        ResultScanner scanner = this.table.getScanner(scan);
        for (Result r : scanner) {
            for (KeyValue key : r.sorted()) {
                System.out.println(Bytes.toString(r.getRow()) + ": " + key.toString());
            }
        }
    }

    public void testRowsPut() {
        ArrayList<Put> rowsUpdate = new ArrayList<Put>();
        for (int i = 0; i < 10; ++i) {
            byte[] row = Bytes.toBytes("row" + i);
            Put put = new Put(row);
            put.add(CONTENTS_FAMILY, null, this.value);
            rowsUpdate.add(put);
        }
        try {
            this.table.put(rowsUpdate);
            Scan scan = new Scan();
            scan.addFamily(CONTENTS_FAMILY);
            ResultScanner scanner = this.table.getScanner(scan);
            int nbRows = 0;
            for (Result row : scanner) {
                ++nbRows;
            }
            TestPut.assertEquals((int)10, (int)nbRows);
        }
        catch (IOException e) {
            TestPut.fail((String)("This is unexpected : " + e));
        }
    }

    public void testRowsPutBufferedOneFlush() {
        this.table.setAutoFlush(false);
        ArrayList<Put> rowsUpdate = new ArrayList<Put>();
        for (int i = 0; i < 100; ++i) {
            byte[] row = Bytes.toBytes("row" + i);
            Put put = new Put(row);
            put.add(CONTENTS_FAMILY, null, this.value);
            rowsUpdate.add(put);
        }
        try {
            this.table.put(rowsUpdate);
            Scan scan = new Scan();
            scan.addFamily(CONTENTS_FAMILY);
            ResultScanner scanner = this.table.getScanner(scan);
            int nbRows = 0;
            for (Result row : scanner) {
                ++nbRows;
            }
            TestPut.assertEquals((int)0, (int)nbRows);
            scanner.close();
            this.table.flushCommits();
            scan = new Scan();
            scan.addFamily(CONTENTS_FAMILY);
            scanner = this.table.getScanner(scan);
            nbRows = 0;
            for (Result row : scanner) {
                ++nbRows;
            }
            TestPut.assertEquals((int)100, (int)nbRows);
        }
        catch (IOException e) {
            TestPut.fail((String)("This is unexpected : " + e));
        }
    }

    public void testRowsPutBufferedManyManyFlushes() throws IOException {
        this.table.setAutoFlush(false);
        this.table.setWriteBufferSize(10L);
        ArrayList<Put> rowsUpdate = new ArrayList<Put>();
        for (int i = 0; i < 100; ++i) {
            byte[] row = Bytes.toBytes("row" + i);
            Put put = new Put(row);
            put.add(CONTENTS_FAMILY, null, this.value);
            rowsUpdate.add(put);
        }
        try {
            this.table.put(rowsUpdate);
            this.table.flushCommits();
            Scan scan = new Scan();
            scan.addFamily(CONTENTS_FAMILY);
            ResultScanner scanner = this.table.getScanner(scan);
            int nbRows = 0;
            for (Result row : scanner) {
                ++nbRows;
            }
            TestPut.assertEquals((int)100, (int)nbRows);
        }
        catch (IOException e) {
            TestPut.fail((String)("This is unexpected : " + e));
        }
    }

    public void testAddKeyValue() throws IOException {
        byte[] qualifier = Bytes.toBytes("qf1");
        Put put = new Put(row1);
        KeyValue kv = new KeyValue(row1, CONTENTS_FAMILY, qualifier, this.value);
        boolean ok = true;
        try {
            put.add(kv);
        }
        catch (IOException e) {
            ok = false;
        }
        TestPut.assertEquals((boolean)true, (boolean)ok);
        kv = new KeyValue(row2, CONTENTS_FAMILY, qualifier, this.value);
        ok = false;
        try {
            put.add(kv);
        }
        catch (IOException e) {
            ok = true;
        }
        TestPut.assertEquals((boolean)true, (boolean)ok);
    }
}

