/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.SortedMap;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.RowFilterInterface;
import org.apache.hadoop.hbase.io.Cell;
import org.apache.hadoop.hbase.util.Bytes;

public class PrefixRowFilter
implements RowFilterInterface {
    protected byte[] prefix;

    public PrefixRowFilter(byte[] prefix) {
        this.prefix = prefix;
    }

    public PrefixRowFilter() {
    }

    @Override
    public void reset() {
    }

    @Override
    public void rowProcessed(boolean filtered, byte[] key) {
        this.rowProcessed(filtered, key, 0, key.length);
    }

    @Override
    public void rowProcessed(boolean filtered, byte[] key, int offset, int length) {
    }

    @Override
    public boolean processAlways() {
        return false;
    }

    @Override
    public boolean filterAllRemaining() {
        return false;
    }

    @Override
    public boolean filterRowKey(byte[] rowKey) {
        return this.filterRowKey(rowKey, 0, rowKey.length);
    }

    @Override
    public boolean filterRowKey(byte[] rowKey, int offset, int length) {
        if (rowKey == null) {
            return true;
        }
        if (length < this.prefix.length) {
            return true;
        }
        for (int i = 0; i < this.prefix.length; ++i) {
            if (this.prefix[i] == rowKey[i + offset]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean filterColumn(byte[] rowKey, byte[] colunmName, byte[] columnValue) {
        return false;
    }

    @Override
    public boolean filterColumn(byte[] rowKey, int roffset, int rlength, byte[] colunmName, int coffset, int clength, byte[] columnValue, int voffset, int vlength) {
        return false;
    }

    @Override
    public boolean filterRow(SortedMap<byte[], Cell> columns) {
        return false;
    }

    @Override
    public boolean filterRow(List<KeyValue> results) {
        return false;
    }

    @Override
    public void validate(byte[][] columns) {
    }

    public void readFields(DataInput in) throws IOException {
        this.prefix = Bytes.readByteArray(in);
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.prefix);
    }
}

