/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.SortedMap;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.RowFilterInterface;
import org.apache.hadoop.hbase.io.Cell;
import org.apache.hadoop.hbase.util.Bytes;

public class StopRowFilter
implements RowFilterInterface {
    private byte[] stopRowKey;

    public StopRowFilter() {
    }

    public StopRowFilter(byte[] stopRowKey) {
        this.stopRowKey = stopRowKey;
    }

    public byte[] getStopRowKey() {
        return this.stopRowKey;
    }

    @Override
    public void validate(byte[][] columns) {
    }

    @Override
    public void reset() {
    }

    @Override
    public void rowProcessed(boolean filtered, byte[] rowKey) {
    }

    @Override
    public void rowProcessed(boolean filtered, byte[] key, int offset, int length) {
    }

    @Override
    public boolean processAlways() {
        return false;
    }

    @Override
    public boolean filterAllRemaining() {
        return false;
    }

    @Override
    public boolean filterRowKey(byte[] rowKey) {
        return this.filterRowKey(rowKey, 0, rowKey.length);
    }

    @Override
    public boolean filterRowKey(byte[] rowKey, int offset, int length) {
        if (rowKey == null) {
            return this.stopRowKey == null;
        }
        return Bytes.compareTo(this.stopRowKey, 0, this.stopRowKey.length, rowKey, offset, length) <= 0;
    }

    @Override
    public boolean filterColumn(byte[] rowKey, byte[] colKey, byte[] data) {
        return this.filterRowKey(rowKey);
    }

    @Override
    public boolean filterColumn(byte[] rowKey, int roffset, int rlength, byte[] colunmName, int coffset, int clength, byte[] columnValue, int voffset, int vlength) {
        return this.filterRowKey(rowKey, roffset, rlength);
    }

    @Override
    public boolean filterRow(SortedMap<byte[], Cell> columns) {
        return this.filterAllRemaining();
    }

    @Override
    public boolean filterRow(List<KeyValue> results) {
        return this.filterAllRemaining();
    }

    public void readFields(DataInput in) throws IOException {
        this.stopRowKey = Bytes.readByteArray(in);
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.stopRowKey);
    }
}

