/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.util.Bytes;

public class HalfHFileReader
extends HFile.Reader {
    final Log LOG = LogFactory.getLog(HalfHFileReader.class);
    final boolean top;
    protected final byte[] splitkey;

    public HalfHFileReader(FileSystem fs, Path p, BlockCache c, Reference r) throws IOException {
        super(fs, p, c, false);
        this.splitkey = r.getSplitKey();
        this.top = Reference.isTopFileRegion(r.getFileRegion());
    }

    protected boolean isTop() {
        return this.top;
    }

    @Override
    public HFileScanner getScanner() {
        return this.getScanner(true);
    }

    @Override
    public HFileScanner getScanner(boolean cacheBlocks) {
        final HFileScanner s = super.getScanner(cacheBlocks);
        return new HFileScanner(){
            final HFileScanner delegate;
            public boolean atEnd;
            {
                this.delegate = s;
                this.atEnd = false;
            }

            @Override
            public ByteBuffer getKey() {
                if (this.atEnd) {
                    return null;
                }
                return this.delegate.getKey();
            }

            @Override
            public String getKeyString() {
                if (this.atEnd) {
                    return null;
                }
                return this.delegate.getKeyString();
            }

            @Override
            public ByteBuffer getValue() {
                if (this.atEnd) {
                    return null;
                }
                return this.delegate.getValue();
            }

            @Override
            public String getValueString() {
                if (this.atEnd) {
                    return null;
                }
                return this.delegate.getValueString();
            }

            @Override
            public KeyValue getKeyValue() {
                if (this.atEnd) {
                    return null;
                }
                return this.delegate.getKeyValue();
            }

            @Override
            public boolean next() throws IOException {
                if (this.atEnd) {
                    return false;
                }
                boolean b = this.delegate.next();
                if (!b) {
                    return b;
                }
                if (!HalfHFileReader.this.top) {
                    ByteBuffer bb = this.getKey();
                    if (HalfHFileReader.this.getComparator().compare(bb.array(), bb.arrayOffset(), bb.limit(), HalfHFileReader.this.splitkey, 0, HalfHFileReader.this.splitkey.length) >= 0) {
                        this.atEnd = true;
                        return false;
                    }
                }
                return true;
            }

            @Override
            public boolean seekBefore(byte[] key) throws IOException {
                return this.seekBefore(key, 0, key.length);
            }

            @Override
            public boolean seekBefore(byte[] key, int offset, int length) throws IOException {
                if (HalfHFileReader.this.top) {
                    if (HalfHFileReader.this.getComparator().compare(key, offset, length, HalfHFileReader.this.splitkey, 0, HalfHFileReader.this.splitkey.length) < 0) {
                        return false;
                    }
                } else if (HalfHFileReader.this.getComparator().compare(key, offset, length, HalfHFileReader.this.splitkey, 0, HalfHFileReader.this.splitkey.length) >= 0) {
                    return this.seekBefore(HalfHFileReader.this.splitkey, 0, HalfHFileReader.this.splitkey.length);
                }
                return this.delegate.seekBefore(key, offset, length);
            }

            @Override
            public boolean seekTo() throws IOException {
                if (HalfHFileReader.this.top) {
                    int r = this.delegate.seekTo(HalfHFileReader.this.splitkey);
                    if (r < 0) {
                        return this.delegate.seekTo();
                    }
                    if (r > 0) {
                        return this.delegate.next();
                    }
                    return true;
                }
                boolean b = this.delegate.seekTo();
                if (!b) {
                    return b;
                }
                ByteBuffer k = this.delegate.getKey();
                return this.delegate.getReader().getComparator().compare(k.array(), k.arrayOffset(), k.limit(), HalfHFileReader.this.splitkey, 0, HalfHFileReader.this.splitkey.length) < 0;
            }

            @Override
            public int seekTo(byte[] key) throws IOException {
                return this.seekTo(key, 0, key.length);
            }

            @Override
            public int seekTo(byte[] key, int offset, int length) throws IOException {
                if (HalfHFileReader.this.top) {
                    if (HalfHFileReader.this.getComparator().compare(key, offset, length, HalfHFileReader.this.splitkey, 0, HalfHFileReader.this.splitkey.length) < 0) {
                        return -1;
                    }
                } else if (HalfHFileReader.this.getComparator().compare(key, offset, length, HalfHFileReader.this.splitkey, 0, HalfHFileReader.this.splitkey.length) >= 0) {
                    boolean res = this.delegate.seekBefore(HalfHFileReader.this.splitkey, 0, HalfHFileReader.this.splitkey.length);
                    if (!res) {
                        throw new IOException("Seeking for a key in bottom of file, but key exists in top of file, failed on seekBefore(midkey)");
                    }
                    return 1;
                }
                return this.delegate.seekTo(key, offset, length);
            }

            @Override
            public HFile.Reader getReader() {
                return this.delegate.getReader();
            }

            @Override
            public boolean isSeeked() {
                return this.delegate.isSeeked();
            }
        };
    }

    @Override
    public byte[] getLastKey() {
        if (this.top) {
            return super.getLastKey();
        }
        HFileScanner scanner = this.getScanner();
        try {
            if (scanner.seekBefore(this.splitkey)) {
                return Bytes.toBytes(scanner.getKey());
            }
        }
        catch (IOException e) {
            this.LOG.warn((Object)("Failed seekBefore " + Bytes.toString(this.splitkey)), (Throwable)e);
        }
        return null;
    }

    @Override
    public byte[] midkey() throws IOException {
        return null;
    }
}

