/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HMsg;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.RowFilterInterface;
import org.apache.hadoop.hbase.filter.RowFilterSet;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.io.HbaseMapWritable;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;

public class HbaseObjectWritable
implements Writable,
Configurable {
    protected static final Log LOG;
    static final Map<Byte, Class<?>> CODE_TO_CLASS;
    static final Map<Class<?>, Byte> CLASS_TO_CODE;
    private static final byte NOT_ENCODED = 0;
    private Class<?> declaredClass;
    private Object instance;
    private Configuration conf;

    public HbaseObjectWritable() {
    }

    public HbaseObjectWritable(Object instance) {
        this.set(instance);
    }

    public HbaseObjectWritable(Class<?> declaredClass, Object instance) {
        this.declaredClass = declaredClass;
        this.instance = instance;
    }

    public Object get() {
        return this.instance;
    }

    public Class<?> getDeclaredClass() {
        return this.declaredClass;
    }

    public void set(Object instance) {
        this.declaredClass = instance.getClass();
        this.instance = instance;
    }

    public String toString() {
        return "OW[class=" + this.declaredClass + ",value=" + this.instance + "]";
    }

    public void readFields(DataInput in) throws IOException {
        HbaseObjectWritable.readObject(in, this, this.conf);
    }

    public void write(DataOutput out) throws IOException {
        HbaseObjectWritable.writeObject(out, this.instance, this.declaredClass, this.conf);
    }

    static void writeClassCode(DataOutput out, Class<?> c) throws IOException {
        Byte code = CLASS_TO_CODE.get(c);
        if (code == null) {
            StackTraceElement[] els;
            LOG.error((Object)("Unsupported type " + c));
            for (StackTraceElement elem : els = new Exception().getStackTrace()) {
                LOG.error((Object)elem.getMethodName());
            }
            throw new UnsupportedOperationException("No code for unexpected " + c);
        }
        out.writeByte(code.byteValue());
    }

    public static void writeObject(DataOutput out, Object instance, Class declaredClass, Configuration conf) throws IOException {
        Object instanceObj = instance;
        Class<Writable> declClass = declaredClass;
        if (instanceObj == null) {
            instanceObj = new NullInstance(declClass, conf);
            declClass = Writable.class;
        }
        HbaseObjectWritable.writeClassCode(out, declClass);
        if (declClass.isArray()) {
            if (declClass.equals(byte[].class)) {
                Bytes.writeByteArray(out, (byte[])instanceObj);
            } else if (declClass.equals(Result[].class)) {
                Result.writeArray(out, (Result[])instanceObj);
            } else {
                int length = Array.getLength(instanceObj);
                out.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    HbaseObjectWritable.writeObject(out, Array.get(instanceObj, i), declClass.getComponentType(), conf);
                }
            }
        } else if (declClass == String.class) {
            Text.writeString((DataOutput)out, (String)((String)instanceObj));
        } else if (declClass.isPrimitive()) {
            if (declClass == Boolean.TYPE) {
                out.writeBoolean((Boolean)instanceObj);
            } else if (declClass == Character.TYPE) {
                out.writeChar(((Character)instanceObj).charValue());
            } else if (declClass == Byte.TYPE) {
                out.writeByte(((Byte)instanceObj).byteValue());
            } else if (declClass == Short.TYPE) {
                out.writeShort(((Short)instanceObj).shortValue());
            } else if (declClass == Integer.TYPE) {
                out.writeInt((Integer)instanceObj);
            } else if (declClass == Long.TYPE) {
                out.writeLong((Long)instanceObj);
            } else if (declClass == Float.TYPE) {
                out.writeFloat(((Float)instanceObj).floatValue());
            } else if (declClass == Double.TYPE) {
                out.writeDouble((Double)instanceObj);
            } else if (declClass != Void.TYPE) {
                throw new IllegalArgumentException("Not a primitive: " + declClass);
            }
        } else if (declClass.isEnum()) {
            Text.writeString((DataOutput)out, (String)((Enum)instanceObj).name());
        } else if (Writable.class.isAssignableFrom(declClass)) {
            Class<?> c = instanceObj.getClass();
            Byte code = CLASS_TO_CODE.get(c);
            if (code == null) {
                out.writeByte(0);
                Text.writeString((DataOutput)out, (String)c.getName());
            } else {
                HbaseObjectWritable.writeClassCode(out, c);
            }
            ((Writable)instanceObj).write(out);
        } else {
            throw new IOException("Can't write: " + instanceObj + " as " + declClass);
        }
    }

    public static Object readObject(DataInput in, Configuration conf) throws IOException {
        return HbaseObjectWritable.readObject(in, null, conf);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object readObject(DataInput in, HbaseObjectWritable objectWritable, Configuration conf) throws IOException {
        Writable instance;
        Class<?> declaredClass = CODE_TO_CLASS.get(in.readByte());
        if (declaredClass.isPrimitive()) {
            if (declaredClass == Boolean.TYPE) {
                instance = Boolean.valueOf(in.readBoolean());
            } else if (declaredClass == Character.TYPE) {
                instance = Character.valueOf(in.readChar());
            } else if (declaredClass == Byte.TYPE) {
                instance = Byte.valueOf(in.readByte());
            } else if (declaredClass == Short.TYPE) {
                instance = Short.valueOf(in.readShort());
            } else if (declaredClass == Integer.TYPE) {
                instance = Integer.valueOf(in.readInt());
            } else if (declaredClass == Long.TYPE) {
                instance = Long.valueOf(in.readLong());
            } else if (declaredClass == Float.TYPE) {
                instance = Float.valueOf(in.readFloat());
            } else if (declaredClass == Double.TYPE) {
                instance = Double.valueOf(in.readDouble());
            } else {
                if (declaredClass != Void.TYPE) throw new IllegalArgumentException("Not a primitive: " + declaredClass);
                instance = null;
            }
        } else if (declaredClass.isArray()) {
            if (declaredClass.equals(byte[].class)) {
                instance = (Writable)Bytes.readByteArray(in);
            } else if (declaredClass.equals(Result[].class)) {
                instance = Result.readArray(in);
            } else {
                int length = in.readInt();
                instance = Array.newInstance(declaredClass.getComponentType(), length);
                for (int i = 0; i < length; ++i) {
                    Array.set(instance, i, HbaseObjectWritable.readObject(in, conf));
                }
            }
        } else if (declaredClass == String.class) {
            instance = Text.readString((DataInput)in);
        } else if (declaredClass.isEnum()) {
            instance = Enum.valueOf(declaredClass, Text.readString((DataInput)in));
        } else {
            Class instanceClass = null;
            Byte b = in.readByte();
            if (b == 0) {
                String className = Text.readString((DataInput)in);
                try {
                    instanceClass = HbaseObjectWritable.getClassByName(conf, className);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Can't find class " + className);
                }
            } else {
                instanceClass = CODE_TO_CLASS.get(b);
            }
            Writable writable = WritableFactories.newInstance((Class)instanceClass, (Configuration)conf);
            writable.readFields(in);
            instance = writable;
            if (instanceClass == NullInstance.class) {
                declaredClass = ((NullInstance)instance).declaredClass;
                instance = null;
            }
        }
        if (objectWritable == null) return instance;
        objectWritable.declaredClass = declaredClass;
        objectWritable.instance = instance;
        return instance;
    }

    private static Class getClassByName(Configuration conf, String className) throws ClassNotFoundException {
        if (conf != null) {
            return conf.getClassByName(className);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = HbaseObjectWritable.class.getClassLoader();
        }
        return Class.forName(className, true, cl);
    }

    private static void addToMap(Class<?> clazz, byte code) {
        CLASS_TO_CODE.put(clazz, code);
        CODE_TO_CLASS.put(code, clazz);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    static {
        byte code;
        LOG = LogFactory.getLog(HbaseObjectWritable.class);
        CODE_TO_CLASS = new HashMap();
        CLASS_TO_CODE = new HashMap();
        byte by = code = 1;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Boolean.TYPE, by);
        byte by2 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Byte.TYPE, by2);
        byte by3 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Character.TYPE, by3);
        byte by4 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Short.TYPE, by4);
        byte by5 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Integer.TYPE, by5);
        byte by6 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Long.TYPE, by6);
        byte by7 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Float.TYPE, by7);
        byte by8 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Double.TYPE, by8);
        byte by9 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Void.TYPE, by9);
        byte by10 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(String.class, by10);
        byte by11 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(byte[].class, by11);
        byte by12 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(byte[][].class, by12);
        byte by13 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Text.class, by13);
        byte by14 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Writable.class, by14);
        byte by15 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Writable[].class, by15);
        byte by16 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HbaseMapWritable.class, by16);
        byte by17 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(NullInstance.class, by17);
        byte by18 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HColumnDescriptor.class, by18);
        byte by19 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HConstants.Modify.class, by19);
        byte by20 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HMsg.class, by20);
        byte by21 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HMsg[].class, by21);
        byte by22 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(RowFilterInterface.class, by22);
        byte by23 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(RowFilterSet.class, by23);
        byte by24 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HRegion.class, by24);
        byte by25 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HRegion[].class, by25);
        byte by26 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HRegionInfo.class, by26);
        byte by27 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HRegionInfo[].class, by27);
        byte by28 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HServerAddress.class, by28);
        byte by29 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HServerInfo.class, by29);
        byte by30 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(HTableDescriptor.class, by30);
        byte by31 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(MapWritable.class, by31);
        byte by32 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(ClusterStatus.class, by32);
        byte by33 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Delete.class, by33);
        byte by34 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Get.class, by34);
        byte by35 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(KeyValue.class, by35);
        byte by36 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(KeyValue[].class, by36);
        byte by37 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Put.class, by37);
        byte by38 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Put[].class, by38);
        byte by39 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Result.class, by39);
        byte by40 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Result[].class, by40);
        byte by41 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Scan.class, by41);
        byte by42 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(WhileMatchFilter.class, by42);
        byte by43 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(PrefixFilter.class, by43);
        byte by44 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(PageFilter.class, by44);
        byte by45 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(InclusiveStopFilter.class, by45);
        byte by46 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(ColumnCountGetFilter.class, by46);
        byte by47 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(SingleColumnValueFilter.class, by47);
        byte by48 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(BinaryComparator.class, by48);
        byte by49 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(CompareFilter.class, by49);
        byte by50 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(RowFilter.class, by50);
        byte by51 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(ValueFilter.class, by51);
        byte by52 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(QualifierFilter.class, by52);
        byte by53 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(SkipFilter.class, by53);
        byte by54 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(WritableByteArrayComparable.class, by54);
        byte by55 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(FirstKeyOnlyFilter.class, by55);
        byte by56 = code;
        code = (byte)(code + 1);
        HbaseObjectWritable.addToMap(Delete[].class, by56);
    }

    private static class NullInstance
    extends Configured
    implements Writable {
        Class<?> declaredClass;

        public NullInstance() {
            super(null);
        }

        public NullInstance(Class<?> declaredClass, Configuration conf) {
            super(conf);
            this.declaredClass = declaredClass;
        }

        public void readFields(DataInput in) throws IOException {
            this.declaredClass = CODE_TO_CLASS.get(in.readByte());
        }

        public void write(DataOutput out) throws IOException {
            HbaseObjectWritable.writeClassCode(out, this.declaredClass);
        }
    }
}

