/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.HBaseRPCStatistics;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.util.MetricsRegistry;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingRate;

public class HBaseRpcMetrics
implements Updater {
    private MetricsRecord metricsRecord;
    private static Log LOG = LogFactory.getLog(HBaseRpcMetrics.class);
    private final HBaseRPCStatistics rpcStatistics;
    public MetricsRegistry registry = new MetricsRegistry();
    public MetricsTimeVaryingRate rpcQueueTime = new MetricsTimeVaryingRate("RpcQueueTime", this.registry);
    public MetricsTimeVaryingRate rpcProcessingTime = new MetricsTimeVaryingRate("RpcProcessingTime", this.registry);

    public HBaseRpcMetrics(String hostName, String port) {
        MetricsContext context = MetricsUtil.getContext((String)"rpc");
        this.metricsRecord = MetricsUtil.createRecord((MetricsContext)context, (String)"metrics");
        this.metricsRecord.setTag("port", port);
        LOG.info((Object)("Initializing RPC Metrics with hostName=" + hostName + ", port=" + port));
        context.registerUpdater((Updater)this);
        this.initMethods();
        this.rpcStatistics = new HBaseRPCStatistics(this.registry, hostName, port);
    }

    private void initMethods() {
        for (String name : HBaseRPC.getMappedMethodNames()) {
            this.create(name);
        }
    }

    private MetricsTimeVaryingRate get(String key) {
        return (MetricsTimeVaryingRate)this.registry.get(key);
    }

    private MetricsTimeVaryingRate create(String key) {
        MetricsTimeVaryingRate newMetric = new MetricsTimeVaryingRate(key, this.registry);
        return newMetric;
    }

    public synchronized void inc(String name, int amt) {
        MetricsTimeVaryingRate m = this.get(name);
        if (m == null) {
            m = this.create(name);
        }
        m.inc((long)amt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdates(MetricsContext context) {
        this.rpcQueueTime.pushMetric(this.metricsRecord);
        this.rpcProcessingTime.pushMetric(this.metricsRecord);
        MetricsRegistry metricsRegistry = this.registry;
        synchronized (metricsRegistry) {
            for (String metricName : this.registry.getKeyList()) {
                MetricsTimeVaryingRate value = (MetricsTimeVaryingRate)this.registry.get(metricName);
                value.pushMetric(this.metricsRecord);
            }
        }
        this.metricsRecord.update();
    }

    public void shutdown() {
        if (this.rpcStatistics != null) {
            this.rpcStatistics.shutdown();
        }
    }
}

