/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.mapred.IdentityTableMap;
import org.apache.hadoop.hbase.mapred.IndexConfiguration;
import org.apache.hadoop.hbase.mapred.IndexOutputFormat;
import org.apache.hadoop.hbase.mapred.IndexTableReduce;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;

@Deprecated
public class BuildTableIndex {
    private static final String USAGE = "Usage: BuildTableIndex -m <numMapTasks> -r <numReduceTasks>\n  -indexConf <iconfFile> -indexDir <indexDir>\n  -table <tableName> -columns <columnName1> [<columnName2> ...]";

    private static void printUsage(String message) {
        System.err.println(message);
        System.err.println(USAGE);
        System.exit(-1);
    }

    public void run(String[] args) throws IOException {
        if (args.length < 6) {
            BuildTableIndex.printUsage("Too few arguments");
        }
        int numMapTasks = 1;
        int numReduceTasks = 1;
        String iconfFile = null;
        String indexDir = null;
        String tableName = null;
        StringBuffer columnNames = null;
        for (int i = 0; i < args.length - 1; ++i) {
            if ("-m".equals(args[i])) {
                numMapTasks = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-r".equals(args[i])) {
                numReduceTasks = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-indexConf".equals(args[i])) {
                iconfFile = args[++i];
                continue;
            }
            if ("-indexDir".equals(args[i])) {
                indexDir = args[++i];
                continue;
            }
            if ("-table".equals(args[i])) {
                tableName = args[++i];
                continue;
            }
            if ("-columns".equals(args[i])) {
                columnNames = new StringBuffer(args[++i]);
                while (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                    columnNames.append(" ");
                    columnNames.append(args[++i]);
                }
                continue;
            }
            BuildTableIndex.printUsage("Unsupported option " + args[i]);
        }
        if (indexDir == null || tableName == null || columnNames == null) {
            BuildTableIndex.printUsage("Index directory, table name and at least one column must be specified");
        }
        HBaseConfiguration conf = new HBaseConfiguration();
        if (iconfFile != null) {
            String content = this.readContent(iconfFile);
            IndexConfiguration iconf = new IndexConfiguration();
            iconf.addFromXML(content);
            conf.set("hbase.index.conf", content);
        }
        if (columnNames != null) {
            JobConf jobConf = this.createJob(conf, numMapTasks, numReduceTasks, indexDir, tableName, columnNames.toString());
            JobClient.runJob((JobConf)jobConf);
        }
    }

    public JobConf createJob(Configuration conf, int numMapTasks, int numReduceTasks, String indexDir, String tableName, String columnNames) {
        JobConf jobConf = new JobConf(conf, BuildTableIndex.class);
        jobConf.setJobName("build index for table " + tableName);
        jobConf.setNumMapTasks(numMapTasks);
        jobConf.setNumReduceTasks(numReduceTasks);
        IdentityTableMap.initJob(tableName, columnNames, IdentityTableMap.class, jobConf);
        jobConf.setReducerClass(IndexTableReduce.class);
        FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)new Path(indexDir));
        jobConf.setOutputFormat(IndexOutputFormat.class);
        return jobConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readContent(String fileName) throws IOException {
        int bytesRead;
        File file = new File(fileName);
        int length = (int)file.length();
        if (length == 0) {
            BuildTableIndex.printUsage("Index configuration file " + fileName + " does not exist");
        }
        byte[] bytes = new byte[length];
        FileInputStream fis = new FileInputStream(file);
        try {
            int read;
            for (bytesRead = 0; bytesRead < length && (read = fis.read(bytes, bytesRead, length - bytesRead)) > 0; bytesRead += read) {
            }
        }
        finally {
            fis.close();
        }
        return new String(bytes, 0, bytesRead, "UTF-8");
    }

    public static void main(String[] args) throws IOException {
        BuildTableIndex build = new BuildTableIndex();
        build.run(args);
    }
}

