/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.hbase.io.Cell;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.RowResult;
import org.apache.hadoop.hbase.mapred.TableMap;
import org.apache.hadoop.hbase.mapred.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

@Deprecated
public class GroupingTableMap
extends MapReduceBase
implements TableMap<ImmutableBytesWritable, RowResult> {
    public static final String GROUP_COLUMNS = "hbase.mapred.groupingtablemap.columns";
    protected byte[][] m_columns;

    public static void initJob(String table, String columns, String groupColumns, Class<? extends TableMap> mapper, JobConf job) {
        TableMapReduceUtil.initTableMapJob(table, columns, mapper, ImmutableBytesWritable.class, RowResult.class, job);
        job.set(GROUP_COLUMNS, groupColumns);
    }

    public void configure(JobConf job) {
        super.configure(job);
        String[] cols = job.get(GROUP_COLUMNS, "").split(" ");
        this.m_columns = new byte[cols.length][];
        for (int i = 0; i < cols.length; ++i) {
            this.m_columns[i] = Bytes.toBytes(cols[i]);
        }
    }

    public void map(ImmutableBytesWritable key, RowResult value, OutputCollector<ImmutableBytesWritable, RowResult> output, Reporter reporter) throws IOException {
        byte[][] keyVals = this.extractKeyValues(value);
        if (keyVals != null) {
            ImmutableBytesWritable tKey = this.createGroupKey(keyVals);
            output.collect((Object)tKey, (Object)value);
        }
    }

    protected byte[][] extractKeyValues(RowResult r) {
        byte[][] keyVals = null;
        ArrayList<byte[]> foundList = new ArrayList<byte[]>();
        int numCols = this.m_columns.length;
        if (numCols > 0) {
            block0: for (Map.Entry<byte[], Cell> e : r.entrySet()) {
                byte[] column = e.getKey();
                for (int i = 0; i < numCols; ++i) {
                    if (!Bytes.equals(column, this.m_columns[i])) continue;
                    foundList.add(e.getValue().getValue());
                    continue block0;
                }
            }
            if (foundList.size() == numCols) {
                keyVals = (byte[][])foundList.toArray((T[])new byte[numCols][]);
            }
        }
        return keyVals;
    }

    protected ImmutableBytesWritable createGroupKey(byte[][] vals) {
        if (vals == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < vals.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            try {
                sb.append(new String(vals[i], "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return new ImmutableBytesWritable(Bytes.toBytes(sb.toString()));
    }
}

