/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.io.BatchUpdate;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.HRegionPartitioner;
import org.apache.hadoop.hbase.mapred.TableInputFormat;
import org.apache.hadoop.hbase.mapred.TableMap;
import org.apache.hadoop.hbase.mapred.TableOutputFormat;
import org.apache.hadoop.hbase.mapred.TableReduce;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;

@Deprecated
public class TableMapReduceUtil {
    public static void initTableMapJob(String table, String columns, Class<? extends TableMap> mapper, Class<? extends WritableComparable> outputKeyClass, Class<? extends Writable> outputValueClass, JobConf job) {
        job.setInputFormat(TableInputFormat.class);
        job.setMapOutputValueClass(outputValueClass);
        job.setMapOutputKeyClass(outputKeyClass);
        job.setMapperClass(mapper);
        FileInputFormat.addInputPaths((JobConf)job, (String)table);
        job.set("hbase.mapred.tablecolumns", columns);
    }

    public static void initTableReduceJob(String table, Class<? extends TableReduce> reducer, JobConf job) throws IOException {
        TableMapReduceUtil.initTableReduceJob(table, reducer, job, null);
    }

    public static void initTableReduceJob(String table, Class<? extends TableReduce> reducer, JobConf job, Class partitioner) throws IOException {
        job.setOutputFormat(TableOutputFormat.class);
        job.setReducerClass(reducer);
        job.set("hbase.mapred.outputtable", table);
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(BatchUpdate.class);
        if (partitioner == HRegionPartitioner.class) {
            job.setPartitionerClass(HRegionPartitioner.class);
            HTable outputTable = new HTable(new HBaseConfiguration((Configuration)job), table);
            int regions = outputTable.getRegionsInfo().size();
            if (job.getNumReduceTasks() > regions) {
                job.setNumReduceTasks(outputTable.getRegionsInfo().size());
            }
        } else if (partitioner != null) {
            job.setPartitionerClass(partitioner);
        }
    }

    public static void limitNumReduceTasks(String table, JobConf job) throws IOException {
        HTable outputTable = new HTable(new HBaseConfiguration((Configuration)job), table);
        int regions = outputTable.getRegionsInfo().size();
        if (job.getNumReduceTasks() > regions) {
            job.setNumReduceTasks(regions);
        }
    }

    public static void limitNumMapTasks(String table, JobConf job) throws IOException {
        HTable outputTable = new HTable(new HBaseConfiguration((Configuration)job), table);
        int regions = outputTable.getRegionsInfo().size();
        if (job.getNumMapTasks() > regions) {
            job.setNumMapTasks(regions);
        }
    }

    public static void setNumReduceTasks(String table, JobConf job) throws IOException {
        HTable outputTable = new HTable(new HBaseConfiguration((Configuration)job), table);
        int regions = outputTable.getRegionsInfo().size();
        job.setNumReduceTasks(regions);
    }

    public static void setNumMapTasks(String table, JobConf job) throws IOException {
        HTable outputTable = new HTable(new HBaseConfiguration((Configuration)job), table);
        int regions = outputTable.getRegionsInfo().size();
        job.setNumMapTasks(regions);
    }

    public static void setScannerCaching(JobConf job, int batchSize) {
        job.setInt("hbase.client.scanner.caching", batchSize);
    }
}

