/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MultiRegionTable;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.Cell;
import org.apache.hadoop.hbase.mapred.IdentityTableMap;
import org.apache.hadoop.hbase.mapred.IndexConfiguration;
import org.apache.hadoop.hbase.mapred.IndexOutputFormat;
import org.apache.hadoop.hbase.mapred.IndexTableReduce;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.TermQuery;

public class TestTableIndex
extends MultiRegionTable {
    private static final Log LOG = LogFactory.getLog(TestTableIndex.class);
    static final String TABLE_NAME = "moretest";
    static final String INPUT_COLUMN = "contents:";
    static final byte[] TEXT_INPUT_COLUMN = Bytes.toBytes("contents:");
    static final String OUTPUT_COLUMN = "text:";
    static final byte[] TEXT_OUTPUT_COLUMN = Bytes.toBytes("text:");
    static final String ROWKEY_NAME = "key";
    static final String INDEX_DIR = "testindex";
    private static final byte[][] columns = new byte[][]{TEXT_INPUT_COLUMN, TEXT_OUTPUT_COLUMN};
    private JobConf jobConf = null;

    public TestTableIndex() {
        super(INPUT_COLUMN);
        this.desc = new HTableDescriptor(TABLE_NAME);
        this.desc.addFamily(new HColumnDescriptor(INPUT_COLUMN));
        this.desc.addFamily(new HColumnDescriptor(OUTPUT_COLUMN));
    }

    @Override
    public void tearDown() throws Exception {
        if (this.jobConf != null) {
            FileUtil.fullyDelete((File)new File(this.jobConf.get("hadoop.tmp.dir")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTableIndex() throws IOException {
        boolean printResults = false;
        if (printResults) {
            LOG.info((Object)"Print table contents before map/reduce");
        }
        this.scanTable(printResults);
        MiniMRCluster mrCluster = new MiniMRCluster(2, this.fs.getUri().toString(), 1);
        this.conf.set("hbase.index.conf", this.createIndexConfContent());
        try {
            this.jobConf = new JobConf((Configuration)this.conf, TestTableIndex.class);
            this.jobConf.setJobName("index column contents");
            this.jobConf.setNumMapTasks(2);
            this.jobConf.setNumReduceTasks(1);
            IdentityTableMap.initJob(TABLE_NAME, INPUT_COLUMN, IdentityTableMap.class, this.jobConf);
            this.jobConf.setReducerClass(IndexTableReduce.class);
            FileOutputFormat.setOutputPath((JobConf)this.jobConf, (Path)new Path(INDEX_DIR));
            this.jobConf.setOutputFormat(IndexOutputFormat.class);
            JobClient.runJob((JobConf)this.jobConf);
        }
        finally {
            mrCluster.shutdown();
        }
        if (printResults) {
            LOG.info((Object)"Print table contents after map/reduce");
        }
        this.scanTable(printResults);
        this.verify();
    }

    private String createIndexConfContent() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<configuration><column><property><name>hbase.column.name</name><value>contents:</value></property>");
        buffer.append("<property><name>hbase.column.store</name> <value>true</value></property>");
        buffer.append("<property><name>hbase.column.index</name><value>true</value></property>");
        buffer.append("<property><name>hbase.column.tokenize</name><value>false</value></property>");
        buffer.append("<property><name>hbase.column.boost</name><value>3</value></property>");
        buffer.append("<property><name>hbase.column.omit.norms</name><value>false</value></property></column>");
        buffer.append("<property><name>hbase.index.rowkey.name</name><value>key</value></property>");
        buffer.append("<property><name>hbase.index.max.buffered.docs</name><value>500</value></property>");
        buffer.append("<property><name>hbase.index.max.field.length</name><value>10000</value></property>");
        buffer.append("<property><name>hbase.index.merge.factor</name><value>10</value></property>");
        buffer.append("<property><name>hbase.index.use.compound.file</name><value>true</value></property>");
        buffer.append("<property><name>hbase.index.optimize</name><value>true</value></property></configuration>");
        IndexConfiguration c = new IndexConfiguration();
        c.addFromXML(buffer.toString());
        return c.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanTable(boolean printResults) throws IOException {
        HTable table = new HTable(this.conf, TABLE_NAME);
        Scan scan = new Scan();
        scan.addColumns(columns);
        ResultScanner scanner = table.getScanner(scan);
        try {
            for (Result r : scanner) {
                if (printResults) {
                    LOG.info((Object)("row: " + r.getRow()));
                }
                for (Map.Entry<byte[], Cell> e : r.getRowResult().entrySet()) {
                    if (!printResults) continue;
                    LOG.info((Object)(" column: " + e.getKey() + " value: " + new String(e.getValue().getValue(), "UTF-8")));
                }
            }
        }
        finally {
            scanner.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verify() throws IOException {
        for (HRegion r : this.cluster.getRegionThreads().get(0).getRegionServer().getOnlineRegions()) {
            HBaseTestCase.HRegionIncommon region = new HBaseTestCase.HRegionIncommon(r);
            region.flushcache();
        }
        Path localDir = new Path(this.getUnitTestdir(this.getName()), "index_" + Integer.toString(new Random().nextInt()));
        this.fs.copyToLocalFile(new Path(INDEX_DIR), localDir);
        LocalFileSystem localfs = FileSystem.getLocal((Configuration)this.conf);
        FileStatus[] indexDirs = localfs.listStatus(localDir);
        IndexSearcher searcher = null;
        ResultScanner scanner = null;
        try {
            if (indexDirs.length == 1) {
                searcher = new IndexSearcher(new File(indexDirs[0].getPath().toUri()).getAbsolutePath());
            } else if (indexDirs.length > 1) {
                Searchable[] searchers = new Searchable[indexDirs.length];
                for (int i = 0; i < indexDirs.length; ++i) {
                    searchers[i] = new IndexSearcher(new File(indexDirs[i].getPath().toUri()).getAbsolutePath());
                }
                searcher = new MultiSearcher(searchers);
            } else {
                throw new IOException("no index directory found");
            }
            HTable table = new HTable(this.conf, TABLE_NAME);
            Scan scan = new Scan();
            scan.addColumns(columns);
            scanner = table.getScanner(scan);
            IndexConfiguration indexConf = new IndexConfiguration();
            String content = this.conf.get("hbase.index.conf");
            if (content != null) {
                indexConf.addFromXML(content);
            }
            String rowkeyName = indexConf.getRowkeyName();
            int count = 0;
            for (Result r : scanner) {
                String value = Bytes.toString(r.getRow());
                Term term = new Term(rowkeyName, value);
                int hitCount = searcher.search((Query)new TermQuery(term)).length();
                TestTableIndex.assertEquals((String)("check row " + value), (int)1, (int)hitCount);
                ++count;
            }
            LOG.debug((Object)("Searcher.maxDoc: " + searcher.maxDoc()));
            LOG.debug((Object)("IndexReader.numDocs: " + searcher.getIndexReader().numDocs()));
            int maxDoc = searcher.getIndexReader().numDocs();
            TestTableIndex.assertEquals((String)"check number of rows", (int)maxDoc, (int)count);
        }
        finally {
            if (null != searcher) {
                searcher.close();
            }
            if (null != scanner) {
                scanner.close();
            }
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(TestTableIndex.class));
    }
}

