/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MultiRegionTable;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.BatchUpdate;
import org.apache.hadoop.hbase.io.Cell;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.RowResult;
import org.apache.hadoop.hbase.mapred.IdentityTableReduce;
import org.apache.hadoop.hbase.mapred.TableMap;
import org.apache.hadoop.hbase.mapred.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public class TestTableMapReduce
extends MultiRegionTable {
    private static final Log LOG = LogFactory.getLog((String)TestTableMapReduce.class.getName());
    static final String MULTI_REGION_TABLE_NAME = "mrtest";
    static final String INPUT_COLUMN = "contents:";
    static final String OUTPUT_COLUMN = "text:";
    private static final byte[][] columns = new byte[][]{Bytes.toBytes("contents:"), Bytes.toBytes("text:")};

    public TestTableMapReduce() {
        super(INPUT_COLUMN);
        this.desc = new HTableDescriptor(MULTI_REGION_TABLE_NAME);
        this.desc.addFamily(new HColumnDescriptor(INPUT_COLUMN));
        this.desc.addFamily(new HColumnDescriptor(OUTPUT_COLUMN));
    }

    public void testMultiRegionTable() throws IOException {
        this.runTestOnTable(new HTable(this.conf, MULTI_REGION_TABLE_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestOnTable(HTable table) throws IOException {
        MiniMRCluster mrCluster = new MiniMRCluster(2, this.fs.getUri().toString(), 1);
        JobConf jobConf = null;
        try {
            LOG.info((Object)"Before map/reduce startup");
            jobConf = new JobConf((Configuration)this.conf, TestTableMapReduce.class);
            jobConf.setJobName("process column contents");
            jobConf.setNumReduceTasks(1);
            TableMapReduceUtil.initTableMapJob(Bytes.toString(table.getTableName()), INPUT_COLUMN, ProcessContentsMapper.class, ImmutableBytesWritable.class, BatchUpdate.class, jobConf);
            TableMapReduceUtil.initTableReduceJob(Bytes.toString(table.getTableName()), IdentityTableReduce.class, jobConf);
            LOG.info((Object)("Started " + Bytes.toString(table.getTableName())));
            JobClient.runJob((JobConf)jobConf);
            LOG.info((Object)"After map/reduce completion");
            this.verify(Bytes.toString(table.getTableName()));
        }
        finally {
            mrCluster.shutdown();
            if (jobConf != null) {
                FileUtil.fullyDelete((File)new File(jobConf.get("hadoop.tmp.dir")));
            }
        }
    }

    private void verify(String tableName) throws IOException {
        HTable table = new HTable(this.conf, tableName);
        boolean verified = false;
        long pause = this.conf.getLong("hbase.client.pause", 5000L);
        int numRetries = this.conf.getInt("hbase.client.retries.number", 5);
        for (int i = 0; i < numRetries; ++i) {
            try {
                LOG.info((Object)("Verification attempt #" + i));
                this.verifyAttempt(table);
                verified = true;
                break;
            }
            catch (NullPointerException e) {
                LOG.debug((Object)("Verification attempt failed: " + e.getMessage()));
                try {
                    Thread.sleep(pause);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                continue;
            }
        }
        TestTableMapReduce.assertTrue((boolean)verified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAttempt(HTable table) throws IOException, NullPointerException {
        Scan scan = new Scan();
        scan.addColumns(columns);
        ResultScanner scanner = table.getScanner(scan);
        try {
            for (Result r : scanner) {
                if (LOG.isDebugEnabled() && r.size() > 2) {
                    throw new IOException("Too many results, expected 2 got " + r.size());
                }
                byte[] firstValue = null;
                byte[] secondValue = null;
                int count = 0;
                for (Map.Entry<byte[], Cell> e : r.getRowResult().entrySet()) {
                    if (count == 0) {
                        firstValue = e.getValue().getValue();
                    }
                    if (count == 1) {
                        secondValue = e.getValue().getValue();
                    }
                    if (++count != 2) continue;
                    break;
                }
                String first = "";
                if (firstValue == null) {
                    throw new NullPointerException(Bytes.toString(r.getRow()) + ": first value is null");
                }
                first = new String(firstValue, "UTF-8");
                String second = "";
                if (secondValue == null) {
                    throw new NullPointerException(Bytes.toString(r.getRow()) + ": second value is null");
                }
                byte[] secondReversed = new byte[secondValue.length];
                int i = 0;
                int j = secondValue.length - 1;
                while (j >= 0) {
                    secondReversed[i] = secondValue[j];
                    --j;
                    ++i;
                }
                second = new String(secondReversed, "UTF-8");
                if (first.compareTo(second) == 0) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("second key is not the reverse of first. row=" + r.getRow() + ", first value=" + first + ", second value=" + second));
                }
                TestTableMapReduce.fail();
            }
        }
        finally {
            scanner.close();
        }
    }

    public static class ProcessContentsMapper
    extends MapReduceBase
    implements TableMap<ImmutableBytesWritable, BatchUpdate> {
        public void map(ImmutableBytesWritable key, RowResult value, OutputCollector<ImmutableBytesWritable, BatchUpdate> output, Reporter reporter) throws IOException {
            if (value.size() != 1) {
                throw new IOException("There should only be one input column");
            }
            byte[][] keys = (byte[][])value.keySet().toArray((T[])new byte[value.size()][]);
            if (!Bytes.equals(keys[0], Bytes.toBytes(TestTableMapReduce.INPUT_COLUMN))) {
                throw new IOException("Wrong input column. Expected: 'contents:' but got: '" + Bytes.toString(keys[0]) + "'");
            }
            String originalValue = new String(value.get(keys[0]).getValue(), "UTF-8");
            StringBuilder newValue = new StringBuilder();
            for (int i = originalValue.length() - 1; i >= 0; --i) {
                newValue.append(originalValue.charAt(i));
            }
            BatchUpdate outval = new BatchUpdate(key.get());
            outval.put(TestTableMapReduce.OUTPUT_COLUMN, Bytes.toBytes(newValue.toString()));
            output.collect((Object)key, (Object)outval);
        }
    }
}

