/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.IndexConfiguration;
import org.apache.hadoop.hbase.mapreduce.LuceneDocumentWrapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class IndexTableReducer
extends Reducer<ImmutableBytesWritable, Result, ImmutableBytesWritable, LuceneDocumentWrapper>
implements Configurable {
    private static final Log LOG = LogFactory.getLog(IndexTableReducer.class);
    private IndexConfiguration indexConf;
    private Configuration conf = null;

    public void reduce(ImmutableBytesWritable key, Iterable<Result> values, Reducer.Context context) throws IOException, InterruptedException {
        Document doc = null;
        for (Result r : values) {
            if (doc == null) {
                doc = new Document();
                Field keyField = new Field(this.indexConf.getRowkeyName(), Bytes.toString(key.get(), key.getOffset(), key.getLength()), Field.Store.YES, Field.Index.UN_TOKENIZED);
                keyField.setOmitNorms(true);
                doc.add((Fieldable)keyField);
            }
            for (KeyValue kv : r.list()) {
                Field.Store store;
                String column = Bytes.toString(kv.getColumn());
                byte[] columnValue = kv.getValue();
                Field.Store store2 = store = this.indexConf.isStore(column) ? Field.Store.YES : Field.Store.NO;
                Field.Index index = this.indexConf.isIndex(column) ? (this.indexConf.isTokenize(column) ? Field.Index.TOKENIZED : Field.Index.UN_TOKENIZED) : Field.Index.NO;
                Field field = new Field(column, Bytes.toString(columnValue), store, index);
                field.setBoost(this.indexConf.getBoost(column));
                field.setOmitNorms(this.indexConf.isOmitNorms(column));
                doc.add((Fieldable)field);
            }
        }
        context.write((Object)key, (Object)new LuceneDocumentWrapper(doc));
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
        this.indexConf = new IndexConfiguration();
        String content = this.conf.get("hbase.index.conf");
        if (content != null) {
            this.indexConf.addFromXML(content);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Index conf: " + (Object)((Object)this.indexConf)));
        }
    }
}

