/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;

public class TestTimeRangeMapRed
extends HBaseClusterTestCase {
    private static final Log log = LogFactory.getLog(TestTimeRangeMapRed.class);
    private static final byte[] KEY = Bytes.toBytes("row1");
    private static final NavigableMap<Long, Boolean> TIMESTAMP = new TreeMap<Long, Boolean>();
    static final long MINSTAMP = 1245620005L;
    static final long MAXSTAMP = 1245620101L;
    static final byte[] TABLE_NAME;
    static final byte[] FAMILY_NAME;
    static final byte[] COLUMN_NAME;
    protected HTableDescriptor desc;
    protected HTable table;

    public TestTimeRangeMapRed() {
        System.setProperty("hadoop.log.dir", this.conf.get("hadoop.log.dir"));
        this.conf.set("mapred.output.dir", this.conf.get("hadoop.tmp.dir"));
        this.setOpenMetaTable(true);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.desc = new HTableDescriptor(TABLE_NAME);
        HColumnDescriptor col = new HColumnDescriptor(FAMILY_NAME);
        col.setMaxVersions(Integer.MAX_VALUE);
        this.desc.addFamily(col);
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        admin.createTable(this.desc);
        this.table = new HTable(this.conf, this.desc.getName());
    }

    public void testTimeRangeMapRed() throws IOException, InterruptedException, ClassNotFoundException {
        this.prepareTest();
        this.runTestOnTable();
        this.verify();
    }

    private void prepareTest() throws IOException {
        for (Map.Entry entry : TIMESTAMP.entrySet()) {
            Put put = new Put(KEY);
            put.add(FAMILY_NAME, COLUMN_NAME, (Long)entry.getKey(), Bytes.toBytes(false));
            this.table.put(put);
        }
        this.table.flushCommits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestOnTable() throws IOException, InterruptedException, ClassNotFoundException {
        MiniMRCluster mrCluster = new MiniMRCluster(2, this.fs.getUri().toString(), 1);
        Job job = null;
        try {
            job = new Job((Configuration)this.conf, "test123");
            job.setOutputFormatClass(NullOutputFormat.class);
            job.setNumReduceTasks(0);
            Scan scan = new Scan();
            scan.addColumn(FAMILY_NAME, COLUMN_NAME);
            scan.setTimeRange(1245620005L, 1245620101L);
            scan.setMaxVersions();
            TableMapReduceUtil.initTableMapperJob(Bytes.toString(TABLE_NAME), scan, ProcessTimeRangeMapper.class, Text.class, Text.class, job);
            job.waitForCompletion(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            mrCluster.shutdown();
            if (job != null) {
                FileUtil.fullyDelete((File)new File(job.getConfiguration().get("hadoop.tmp.dir")));
            }
        }
    }

    private void verify() throws IOException {
        Scan scan = new Scan();
        scan.addColumn(FAMILY_NAME, COLUMN_NAME);
        scan.setMaxVersions();
        ResultScanner scanner = this.table.getScanner(scan);
        for (Result r : scanner) {
            for (KeyValue kv : r.sorted()) {
                TestTimeRangeMapRed.assertEquals(TIMESTAMP.get(kv.getTimestamp()), (Object)Bytes.toBoolean(kv.getValue()));
                log.debug((Object)(Bytes.toString(r.getRow()) + "\t" + Bytes.toString(kv.getColumn()) + "\t" + kv.getTimestamp() + "\t" + Bytes.toBoolean(kv.getValue())));
            }
        }
        scanner.close();
    }

    static {
        TIMESTAMP.put(1245620000L, false);
        TIMESTAMP.put(1245620005L, true);
        TIMESTAMP.put(1245620010L, true);
        TIMESTAMP.put(1245620055L, true);
        TIMESTAMP.put(1245620100L, true);
        TIMESTAMP.put(1245620150L, false);
        TIMESTAMP.put(1245620250L, false);
        TABLE_NAME = Bytes.toBytes("table123");
        FAMILY_NAME = Bytes.toBytes("text");
        COLUMN_NAME = Bytes.toBytes("input");
    }

    private static class ProcessTimeRangeMapper
    extends TableMapper<ImmutableBytesWritable, MapWritable>
    implements Configurable {
        private Configuration conf = null;
        private HTable table = null;

        private ProcessTimeRangeMapper() {
        }

        public void map(ImmutableBytesWritable key, Result result, Mapper.Context context) throws IOException {
            ArrayList<Long> tsList = new ArrayList<Long>();
            for (KeyValue kv : result.sorted()) {
                tsList.add(kv.getTimestamp());
            }
            for (Long ts : tsList) {
                Put put = new Put(key.get());
                put.add(FAMILY_NAME, COLUMN_NAME, ts, Bytes.toBytes(true));
                this.table.put(put);
            }
            this.table.flushCommits();
        }

        public Configuration getConf() {
            return this.conf;
        }

        public void setConf(Configuration configuration) {
            this.conf = configuration;
            try {
                this.table = new HTable(new HBaseConfiguration(this.conf), TABLE_NAME);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

