/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.TableOperation;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;

abstract class ColumnOperation
extends TableOperation {
    private final Log LOG = LogFactory.getLog(this.getClass());

    protected ColumnOperation(HMaster master, byte[] tableName) throws IOException {
        super(master, tableName);
    }

    @Override
    protected void processScanItem(String serverName, HRegionInfo info) throws IOException {
        if (this.isEnabled(info)) {
            throw new TableNotDisabledException(this.tableName);
        }
    }

    protected void updateRegionInfo(HRegionInterface server, byte[] regionName, HRegionInfo i) throws IOException {
        Put put = new Put(i.getRegionName());
        put.add(CATALOG_FAMILY, REGIONINFO_QUALIFIER, Writables.getBytes((Writable)i));
        server.put(regionName, put);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("updated columns in row: " + i.getRegionNameAsString()));
        }
    }
}

