/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HMsg;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HServerLoad;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetaRegion;
import org.apache.hadoop.hbase.master.MetaScanner;
import org.apache.hadoop.hbase.master.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.master.RootScanner;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;

class RegionManager
implements HConstants {
    protected static final Log LOG = LogFactory.getLog(RegionManager.class);
    private AtomicReference<HServerAddress> rootRegionLocation = new AtomicReference<Object>(null);
    private volatile boolean safeMode = true;
    final Lock splitLogLock = new ReentrantLock();
    private final RootScanner rootScannerThread;
    final MetaScanner metaScannerThread;
    private final AtomicInteger numberOfMetaRegions = new AtomicInteger();
    private final NavigableMap<byte[], MetaRegion> onlineMetaRegions = new ConcurrentSkipListMap<byte[], MetaRegion>(Bytes.BYTES_COMPARATOR);
    private static final byte[] OVERLOADED = Bytes.toBytes("Overloaded");
    private static final byte[] META_REGION_PREFIX = Bytes.toBytes(".META.,");
    final SortedMap<String, RegionState> regionsInTransition = Collections.synchronizedSortedMap(new TreeMap());
    private final int maxAssignInOneGo;
    final HMaster master;
    private final LoadBalancer loadBalancer;
    private final SortedMap<byte[], Pair<HRegionInfo, HServerAddress>> regionsToSplit = Collections.synchronizedSortedMap(new TreeMap(Bytes.BYTES_COMPARATOR));
    private final SortedMap<byte[], Pair<HRegionInfo, HServerAddress>> regionsToCompact = Collections.synchronizedSortedMap(new TreeMap(Bytes.BYTES_COMPARATOR));
    private final SortedMap<byte[], Pair<HRegionInfo, HServerAddress>> regionsToMajorCompact = Collections.synchronizedSortedMap(new TreeMap(Bytes.BYTES_COMPARATOR));
    private final SortedMap<byte[], Pair<HRegionInfo, HServerAddress>> regionsToFlush = Collections.synchronizedSortedMap(new TreeMap(Bytes.BYTES_COMPARATOR));
    private final int zooKeeperNumRetries;
    private final int zooKeeperPause;

    RegionManager(HMaster master) {
        HBaseConfiguration conf = master.getConfiguration();
        this.master = master;
        this.maxAssignInOneGo = conf.getInt("hbase.regions.percheckin", 10);
        this.loadBalancer = new LoadBalancer(conf);
        this.rootScannerThread = new RootScanner(master);
        this.metaScannerThread = new MetaScanner(master);
        this.zooKeeperNumRetries = conf.getInt("zookeeper.retries", 5);
        this.zooKeeperPause = conf.getInt("zookeeper.pause", 2000);
        this.reassignRootRegion();
    }

    void start() {
        Threads.setDaemonThreadRunning(this.rootScannerThread, "RegionManager.rootScanner");
        Threads.setDaemonThreadRunning(this.metaScannerThread, "RegionManager.metaScanner");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsetRootRegion() {
        SortedMap<String, RegionState> sortedMap = this.regionsInTransition;
        synchronized (sortedMap) {
            this.rootRegionLocation.set(null);
            this.regionsInTransition.remove(HRegionInfo.ROOT_REGIONINFO.getRegionNameAsString());
            LOG.info((Object)"-ROOT- region unset (but not set to be reassigned)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reassignRootRegion() {
        this.unsetRootRegion();
        if (!this.master.shutdownRequested.get()) {
            SortedMap<String, RegionState> sortedMap = this.regionsInTransition;
            synchronized (sortedMap) {
                RegionState s = new RegionState(HRegionInfo.ROOT_REGIONINFO);
                s.setUnassigned();
                this.regionsInTransition.put(HRegionInfo.ROOT_REGIONINFO.getRegionNameAsString(), s);
                LOG.info((Object)"ROOT inserted into regionsInTransition");
            }
        }
    }

    void assignRegions(HServerInfo info, HRegionInfo[] mostLoadedRegions, ArrayList<HMsg> returnMsgs) {
        HServerLoad thisServersLoad = info.getLoad();
        boolean isSingleServer = this.master.serverManager.numServers() == 1;
        Set<RegionState> regionsToAssign = this.regionsAwaitingAssignment(info.getServerAddress(), isSingleServer);
        if (regionsToAssign.size() == 0) {
            if (!this.inSafeMode()) {
                this.loadBalancer.loadBalancing(info, mostLoadedRegions, returnMsgs);
            }
        } else if (isSingleServer) {
            this.assignRegionsToOneServer(regionsToAssign, info, returnMsgs);
        } else {
            this.assignRegionsToMultipleServers(thisServersLoad, regionsToAssign, info, returnMsgs);
        }
    }

    private void assignRegionsToMultipleServers(HServerLoad thisServersLoad, Set<RegionState> regionsToAssign, HServerInfo info, ArrayList<HMsg> returnMsgs) {
        boolean isMetaAssign = false;
        for (RegionState s : regionsToAssign) {
            if (!s.getRegionInfo().isMetaRegion()) continue;
            isMetaAssign = true;
        }
        int nRegionsToAssign = regionsToAssign.size();
        int nregions = this.regionsPerServer(nRegionsToAssign, thisServersLoad);
        LOG.debug((Object)("Assigning for " + info + ": total nregions to assign=" + nRegionsToAssign + ", nregions to reach balance=" + nregions + ", isMetaAssign=" + isMetaAssign));
        if (nRegionsToAssign <= nregions) {
            LOG.debug((Object)"Assigning one region only (playing it safe..)");
            this.assignRegions(regionsToAssign, 1, info, returnMsgs);
        } else if ((nRegionsToAssign -= nregions) > 0 || isMetaAssign) {
            HServerLoad heavierLoad = new HServerLoad();
            int nservers = this.computeNextHeaviestLoad(thisServersLoad, heavierLoad);
            HServerLoad load = new HServerLoad(thisServersLoad);
            for (nregions = 0; load.compareTo(heavierLoad) <= 0 && nregions < nRegionsToAssign; ++nregions) {
                load.setNumberOfRegions(load.getNumberOfRegions() + 1);
            }
            LOG.debug((Object)("Doing for " + info + " nregions: " + nregions + " and nRegionsToAssign: " + nRegionsToAssign));
            nregions = nregions < nRegionsToAssign ? (nservers > 0 ? (int)Math.ceil(1.0 * (double)nRegionsToAssign / (1.0 * (double)nservers)) : (int)Math.ceil(1.0 * (double)nRegionsToAssign / (1.0 * (double)this.master.serverManager.numServers()))) : nRegionsToAssign;
            this.assignRegions(regionsToAssign, nregions, info, returnMsgs);
        }
    }

    private void assignRegions(Set<RegionState> regionsToAssign, int nregions, HServerInfo info, ArrayList<HMsg> returnMsgs) {
        int count = nregions;
        if (count > this.maxAssignInOneGo) {
            count = this.maxAssignInOneGo;
        }
        for (RegionState s : regionsToAssign) {
            this.doRegionAssignment(s, info, returnMsgs);
            if (--count > 0) continue;
            break;
        }
    }

    private void assignRegionsToOneServer(Set<RegionState> regionsToAssign, HServerInfo info, ArrayList<HMsg> returnMsgs) {
        for (RegionState s : regionsToAssign) {
            this.doRegionAssignment(s, info, returnMsgs);
        }
    }

    private void doRegionAssignment(RegionState rs, HServerInfo sinfo, ArrayList<HMsg> returnMsgs) {
        String regionName = rs.getRegionInfo().getRegionNameAsString();
        LOG.info((Object)("Assigning region " + regionName + " to " + sinfo.getServerName()));
        rs.setPendingOpen(sinfo.getServerName());
        this.regionsInTransition.put(regionName, rs);
        returnMsgs.add(new HMsg(HMsg.Type.MSG_REGION_OPEN, rs.getRegionInfo()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int regionsPerServer(int numUnassignedRegions, HServerLoad thisServersLoad) {
        TreeMap<HServerLoad, Set<String>> lightServers = new TreeMap<HServerLoad, Set<String>>();
        SortedMap<HServerLoad, Set<String>> sortedMap = this.master.serverManager.loadToServers;
        synchronized (sortedMap) {
            lightServers.putAll(this.master.serverManager.loadToServers.headMap(thisServersLoad));
        }
        int nRegions = 0;
        for (Map.Entry e : lightServers.entrySet()) {
            HServerLoad lightLoad = new HServerLoad((HServerLoad)e.getKey());
            do {
                lightLoad.setNumberOfRegions(lightLoad.getNumberOfRegions() + 1);
            } while (lightLoad.compareTo(thisServersLoad) <= 0 && ++nRegions < numUnassignedRegions);
            if ((nRegions *= ((Set)e.getValue()).size()) < numUnassignedRegions) continue;
            break;
        }
        return nRegions;
    }

    private Set<RegionState> regionsAwaitingAssignment(HServerAddress addr, boolean isSingleServer) {
        boolean isMetaOrRoot;
        HashSet<RegionState> regionsToAssign = new HashSet<RegionState>();
        boolean isMetaServer = this.isMetaServer(addr);
        RegionState rootState = (RegionState)this.regionsInTransition.get(HRegionInfo.ROOT_REGIONINFO.getRegionNameAsString());
        if (rootState != null && rootState.isUnassigned()) {
            if (!isMetaServer || isSingleServer) {
                regionsToAssign.add(rootState);
            }
            return regionsToAssign;
        }
        boolean reassigningMetas = this.numberOfMetaRegions.get() != this.onlineMetaRegions.size();
        boolean bl = isMetaOrRoot = isMetaServer || this.isRootServer(addr);
        if (reassigningMetas && isMetaOrRoot && !isSingleServer) {
            return regionsToAssign;
        }
        for (RegionState s : this.regionsInTransition.values()) {
            HRegionInfo i = s.getRegionInfo();
            if (i == null || reassigningMetas && !i.isMetaRegion()) continue;
            if (!i.isMetaRegion() && !this.master.getServerManager().canAssignUserRegions()) {
                LOG.debug((Object)("user region " + i.getRegionNameAsString() + " is in transition but not enough servers yet"));
                continue;
            }
            if (!s.isUnassigned()) continue;
            regionsToAssign.add(s);
        }
        return regionsToAssign;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int computeNextHeaviestLoad(HServerLoad referenceLoad, HServerLoad heavierLoad) {
        TreeMap<HServerLoad, Set<String>> heavyServers = new TreeMap<HServerLoad, Set<String>>();
        SortedMap<HServerLoad, Set<String>> sortedMap = this.master.serverManager.loadToServers;
        synchronized (sortedMap) {
            heavyServers.putAll(this.master.serverManager.loadToServers.tailMap(referenceLoad));
        }
        int nservers = 0;
        for (Map.Entry e : heavyServers.entrySet()) {
            Set servers = (Set)e.getValue();
            nservers += servers.size();
            if (((HServerLoad)e.getKey()).compareTo(referenceLoad) == 0) {
                --nservers;
                continue;
            }
            heavierLoad.setNumberOfRequests(((HServerLoad)e.getKey()).getNumberOfRequests());
            heavierLoad.setNumberOfRegions(((HServerLoad)e.getKey()).getNumberOfRegions());
            break;
        }
        return nservers;
    }

    void unassignSomeRegions(HServerInfo info, int numRegionsToClose, HRegionInfo[] mostLoadedRegions, ArrayList<HMsg> returnMsgs) {
        LOG.debug((Object)("Choosing to reassign " + numRegionsToClose + " regions. mostLoadedRegions has " + mostLoadedRegions.length + " regions in it."));
        int regionIdx = 0;
        int regionsClosed = 0;
        int skipped = 0;
        while (regionsClosed < numRegionsToClose && regionIdx < mostLoadedRegions.length) {
            HRegionInfo currentRegion = mostLoadedRegions[regionIdx];
            ++regionIdx;
            if (currentRegion.isRootRegion() || currentRegion.isMetaTable()) continue;
            String regionName = currentRegion.getRegionNameAsString();
            if (this.regionIsInTransition(regionName)) {
                ++skipped;
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Going to close region " + regionName));
            }
            returnMsgs.add(new HMsg(HMsg.Type.MSG_REGION_CLOSE, currentRegion, OVERLOADED));
            this.setClosing(info.getServerName(), currentRegion, false);
            this.setPendingClose(regionName);
            ++regionsClosed;
        }
        LOG.info((Object)("Skipped " + skipped + " region(s) that are in transition states"));
    }

    public int countRegionsOnFS() throws IOException {
        int regions = 0;
        FileStatus[] tableDirs = this.master.fs.listStatus(this.master.rootdir, (PathFilter)new TableDirFilter());
        RegionDirFilter rdf = new RegionDirFilter();
        for (FileStatus tabledir : tableDirs) {
            if (!tabledir.isDir()) continue;
            FileStatus[] regionDirs = this.master.fs.listStatus(tabledir.getPath(), (PathFilter)rdf);
            regions += regionDirs.length;
        }
        return regions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<byte[], MetaRegion> getOnlineMetaRegions() {
        NavigableMap<byte[], MetaRegion> navigableMap = this.onlineMetaRegions;
        synchronized (navigableMap) {
            return Collections.unmodifiableMap(this.onlineMetaRegions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean metaRegionsInTransition() {
        NavigableMap<byte[], MetaRegion> navigableMap = this.onlineMetaRegions;
        synchronized (navigableMap) {
            for (MetaRegion metaRegion : this.onlineMetaRegions.values()) {
                String regionName = Bytes.toString(metaRegion.getRegionName());
                if (!this.regionIsInTransition(regionName)) continue;
                return true;
            }
        }
        return false;
    }

    public void stopScanners() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"telling root scanner to stop");
        }
        this.rootScannerThread.interruptIfAlive();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"telling meta scanner to stop");
        }
        this.metaScannerThread.interruptIfAlive();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"meta and root scanners notified");
        }
    }

    public void stop() {
        try {
            if (this.rootScannerThread.isAlive()) {
                this.rootScannerThread.join();
            }
        }
        catch (Exception iex) {
            LOG.warn((Object)"root scanner", (Throwable)iex);
        }
        try {
            if (this.metaScannerThread.isAlive()) {
                this.metaScannerThread.join();
            }
        }
        catch (Exception iex) {
            LOG.warn((Object)"meta scanner", (Throwable)iex);
        }
        this.master.getZooKeeperWrapper().clearRSDirectory();
        this.master.getZooKeeperWrapper().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areAllMetaRegionsOnline() {
        NavigableMap<byte[], MetaRegion> navigableMap = this.onlineMetaRegions;
        synchronized (navigableMap) {
            return this.rootRegionLocation.get() != null && this.numberOfMetaRegions.get() == this.onlineMetaRegions.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaRegion getFirstMetaRegionForRegion(HRegionInfo newRegion) {
        NavigableMap<byte[], MetaRegion> navigableMap = this.onlineMetaRegions;
        synchronized (navigableMap) {
            if (this.onlineMetaRegions.size() == 0) {
                return null;
            }
            if (this.onlineMetaRegions.size() == 1) {
                return (MetaRegion)this.onlineMetaRegions.get(this.onlineMetaRegions.firstKey());
            }
            if (this.onlineMetaRegions.containsKey(newRegion.getRegionName())) {
                return (MetaRegion)this.onlineMetaRegions.get(newRegion.getRegionName());
            }
            return (MetaRegion)this.onlineMetaRegions.get(this.onlineMetaRegions.headMap(newRegion.getRegionName()).lastKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MetaRegion> getMetaRegionsForTable(byte[] tableName) throws NotAllMetaRegionsOnlineException {
        byte[] firstMetaRegion = null;
        HashSet<MetaRegion> metaRegions = new HashSet<MetaRegion>();
        if (Bytes.equals(tableName, HConstants.META_TABLE_NAME)) {
            if (this.rootRegionLocation.get() == null) {
                throw new NotAllMetaRegionsOnlineException(Bytes.toString(HConstants.ROOT_TABLE_NAME));
            }
            metaRegions.add(new MetaRegion(this.rootRegionLocation.get(), HRegionInfo.ROOT_REGIONINFO));
        } else {
            if (!this.areAllMetaRegionsOnline()) {
                throw new NotAllMetaRegionsOnlineException();
            }
            NavigableMap<byte[], MetaRegion> navigableMap = this.onlineMetaRegions;
            synchronized (navigableMap) {
                firstMetaRegion = this.onlineMetaRegions.size() == 1 ? (byte[])this.onlineMetaRegions.firstKey() : (this.onlineMetaRegions.containsKey(tableName) ? tableName : this.onlineMetaRegions.headMap(tableName).lastKey());
                metaRegions.addAll(this.onlineMetaRegions.tailMap(firstMetaRegion).values());
            }
        }
        return metaRegions;
    }

    public MetaRegion getMetaRegionForRow(byte[] row) throws NotAllMetaRegionsOnlineException {
        if (!this.areAllMetaRegionsOnline()) {
            throw new NotAllMetaRegionsOnlineException();
        }
        int prefixlen = META_REGION_PREFIX.length;
        if (row.length > prefixlen && Bytes.compareTo(META_REGION_PREFIX, 0, prefixlen, row, 0, prefixlen) == 0) {
            return new MetaRegion(this.master.getRootRegionLocation(), HRegionInfo.ROOT_REGIONINFO);
        }
        return this.onlineMetaRegions.floorEntry(row).getValue();
    }

    public void createRegion(HRegionInfo newRegion, HRegionInterface server, byte[] metaRegionName) throws IOException {
        HRegion region = HRegion.createHRegion(newRegion, this.master.rootdir, this.master.getConfiguration());
        HRegionInfo info = region.getRegionInfo();
        byte[] regionName = region.getRegionName();
        Put put = new Put(regionName);
        byte[] infoBytes = Writables.getBytes((Writable)info);
        String infoString = new String(infoBytes);
        put.add(CATALOG_FAMILY, REGIONINFO_QUALIFIER, Writables.getBytes((Writable)info));
        server.put(metaRegionName, put);
        region.close();
        region.getLog().closeAndDelete();
        this.setUnassigned(info, true);
    }

    public void putMetaRegionOnline(MetaRegion metaRegion) {
        this.onlineMetaRegions.put(metaRegion.getStartKey(), metaRegion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MetaRegion> getListOfOnlineMetaRegions() {
        ArrayList<MetaRegion> regions;
        NavigableMap<byte[], MetaRegion> navigableMap = this.onlineMetaRegions;
        synchronized (navigableMap) {
            regions = new ArrayList<MetaRegion>(this.onlineMetaRegions.values());
        }
        return regions;
    }

    public int numOnlineMetaRegions() {
        return this.onlineMetaRegions.size();
    }

    public boolean isMetaRegionOnline(byte[] startKey) {
        return this.onlineMetaRegions.containsKey(startKey);
    }

    public MetaRegion offlineMetaRegion(byte[] startKey) {
        LOG.info((Object)"META region removed from onlineMetaRegions");
        return (MetaRegion)this.onlineMetaRegions.remove(startKey);
    }

    public boolean isRootServer(HServerAddress server) {
        return this.master.getRootRegionLocation() != null && server.equals(this.master.getRootRegionLocation());
    }

    public List<byte[]> listMetaRegionsForServer(HServerAddress server) {
        ArrayList<byte[]> metas = new ArrayList<byte[]>();
        for (MetaRegion region : this.onlineMetaRegions.values()) {
            if (!server.equals(region.getServer())) continue;
            metas.add(region.getStartKey());
        }
        return metas;
    }

    public boolean isMetaServer(HServerAddress server) {
        for (MetaRegion region : this.onlineMetaRegions.values()) {
            if (!server.equals(region.getServer())) continue;
            return true;
        }
        for (RegionState s : this.regionsInTransition.values()) {
            if (!s.getRegionInfo().isMetaRegion() || s.isUnassigned() || s.getServerName() == null || !s.getServerName().equals(server.toString())) continue;
            return true;
        }
        return false;
    }

    public boolean isRootServerCandidate(String server) {
        for (RegionState s : this.regionsInTransition.values()) {
            if (!s.getRegionInfo().isRootRegion() || s.isUnassigned() || s.getServerName() == null || !s.getServerName().equals(server)) continue;
            return true;
        }
        return false;
    }

    public HRegionInfo getMetaServerRegionInfo(String server) {
        for (RegionState s : this.regionsInTransition.values()) {
            if (!s.getRegionInfo().isMetaRegion() || s.isUnassigned() || s.getServerName() == null || !s.getServerName().equals(server)) continue;
            return s.getRegionInfo();
        }
        return null;
    }

    public synchronized boolean offlineMetaServer(HServerAddress server) {
        boolean hasMeta = false;
        if (this.master.getRootRegionLocation() != null && server.equals(this.master.getRootRegionLocation())) {
            LOG.info((Object)("Offlined ROOT server: " + server));
            this.reassignRootRegion();
            hasMeta = true;
        }
        for (MetaRegion region : this.onlineMetaRegions.values()) {
            if (!server.equals(region.getServer())) continue;
            LOG.info((Object)("Offlining META region: " + region));
            this.offlineMetaRegion(region.getStartKey());
            this.setUnassigned(region.getRegionInfo(), true);
            hasMeta = true;
        }
        return hasMeta;
    }

    public void removeRegion(HRegionInfo info) {
        this.regionsInTransition.remove(info.getRegionNameAsString());
    }

    public boolean regionIsInTransition(String regionName) {
        return this.regionsInTransition.containsKey(regionName);
    }

    public boolean regionIsOpening(String regionName) {
        RegionState state = (RegionState)this.regionsInTransition.get(regionName);
        if (state != null) {
            return state.isOpening();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnassigned(HRegionInfo info, boolean force) {
        SortedMap<String, RegionState> sortedMap = this.regionsInTransition;
        synchronized (sortedMap) {
            RegionState s = (RegionState)this.regionsInTransition.get(info.getRegionNameAsString());
            if (s == null) {
                s = new RegionState(info);
                this.regionsInTransition.put(info.getRegionNameAsString(), s);
            }
            if (force || !s.isPendingOpen() || !s.isOpen()) {
                s.setUnassigned();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnassigned(HRegionInfo info) {
        SortedMap<String, RegionState> sortedMap = this.regionsInTransition;
        synchronized (sortedMap) {
            RegionState s = (RegionState)this.regionsInTransition.get(info.getRegionNameAsString());
            if (s != null) {
                return s.isUnassigned();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPendingOpen(String regionName) {
        SortedMap<String, RegionState> sortedMap = this.regionsInTransition;
        synchronized (sortedMap) {
            RegionState s = (RegionState)this.regionsInTransition.get(regionName);
            if (s != null) {
                return s.isPendingOpen();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOpen(String regionName) {
        SortedMap<String, RegionState> sortedMap = this.regionsInTransition;
        synchronized (sortedMap) {
            RegionState s = (RegionState)this.regionsInTransition.get(regionName);
            if (s != null) {
                s.setOpen();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOfflined(String regionName) {
        SortedMap<String, RegionState> sortedMap = this.regionsInTransition;
        synchronized (sortedMap) {
            RegionState s = (RegionState)this.regionsInTransition.get(regionName);
            if (s != null) {
                return s.isOfflined();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosing(String serverName, HRegionInfo regionInfo, boolean setOffline) {
        SortedMap<String, RegionState> sortedMap = this.regionsInTransition;
        synchronized (sortedMap) {
            RegionState s = (RegionState)this.regionsInTransition.get(regionInfo.getRegionNameAsString());
            if (s == null) {
                s = new RegionState(regionInfo);
            }
            if (s.isPendingOpen()) {
                serverName = s.getServerName();
            }
            s.setClosing(serverName, setOffline);
            this.regionsInTransition.put(regionInfo.getRegionNameAsString(), s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<HRegionInfo> getMarkedToClose(String serverName) {
        HashSet<HRegionInfo> result = new HashSet<HRegionInfo>();
        SortedMap<String, RegionState> sortedMap = this.regionsInTransition;
        synchronized (sortedMap) {
            for (RegionState s : this.regionsInTransition.values()) {
                if (!s.isClosing() || s.isPendingClose() || s.isClosed() || s.getServerName().compareTo(serverName) != 0) continue;
                result.add(s.getRegionInfo());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPendingClose(String regionName) {
        SortedMap<String, RegionState> sortedMap = this.regionsInTransition;
        synchronized (sortedMap) {
            RegionState s = (RegionState)this.regionsInTransition.get(regionName);
            if (s != null) {
                s.setPendingClose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosed(String regionName) {
        SortedMap<String, RegionState> sortedMap = this.regionsInTransition;
        synchronized (sortedMap) {
            RegionState s = (RegionState)this.regionsInTransition.get(regionName);
            if (s != null) {
                s.setClosed();
            }
        }
    }

    public void addMetaRegionToScan(MetaRegion m) {
        this.metaScannerThread.addMetaRegionToScan(m);
    }

    public boolean isInitialRootScanComplete() {
        return this.rootScannerThread.isInitialScanComplete();
    }

    public boolean isInitialMetaScanComplete() {
        return this.metaScannerThread.isInitialScanComplete();
    }

    private boolean tellZooKeeperOutOfSafeMode() {
        for (int attempt = 0; attempt < this.zooKeeperNumRetries; ++attempt) {
            if (this.master.getZooKeeperWrapper().writeOutOfSafeMode()) {
                return true;
            }
            this.sleep(attempt);
        }
        LOG.error((Object)("Failed to tell ZooKeeper we're out of safe mode after " + this.zooKeeperNumRetries + " retries"));
        return false;
    }

    public boolean inSafeMode() {
        if (this.safeMode) {
            if (this.isInitialMetaScanComplete() && this.regionsInTransition.size() == 0 && this.tellZooKeeperOutOfSafeMode()) {
                this.master.connection.unsetRootRegionLocation();
                this.safeMode = false;
                LOG.info((Object)"exiting safe mode");
            } else {
                LOG.info((Object)"in safe mode");
            }
        }
        return this.safeMode;
    }

    public HServerAddress getRootRegionLocation() {
        return this.rootRegionLocation.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForRootRegionLocation() {
        AtomicReference<HServerAddress> atomicReference = this.rootRegionLocation;
        synchronized (atomicReference) {
            while (!this.master.closed.get() && this.rootRegionLocation.get() == null) {
                try {
                    this.rootRegionLocation.wait(this.master.threadWakeFrequency);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public int numMetaRegions() {
        return this.numberOfMetaRegions.get();
    }

    public void incrementNumMetaRegions() {
        this.numberOfMetaRegions.incrementAndGet();
    }

    private long getPauseTime(int tries) {
        int attempt = tries;
        if (attempt >= RETRY_BACKOFF.length) {
            attempt = RETRY_BACKOFF.length - 1;
        }
        return this.zooKeeperPause * RETRY_BACKOFF[attempt];
    }

    private void sleep(int attempt) {
        try {
            Thread.sleep(this.getPauseTime(attempt));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void writeRootRegionLocationToZooKeeper(HServerAddress address) {
        for (int attempt = 0; attempt < this.zooKeeperNumRetries; ++attempt) {
            if (this.master.getZooKeeperWrapper().writeRootRegionLocation(address)) {
                return;
            }
            this.sleep(attempt);
        }
        LOG.error((Object)("Failed to write root region location to ZooKeeper after " + this.zooKeeperNumRetries + " retries, shutting down"));
        this.master.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRootRegionLocation(HServerAddress address) {
        this.writeRootRegionLocationToZooKeeper(address);
        AtomicReference<HServerAddress> atomicReference = this.rootRegionLocation;
        synchronized (atomicReference) {
            this.rootRegionLocation.set(new HServerAddress(address));
            this.rootRegionLocation.notifyAll();
        }
    }

    public void setNumMetaRegions(int num) {
        this.numberOfMetaRegions.set(num);
    }

    public void startAction(byte[] regionName, HRegionInfo info, HServerAddress server, HConstants.Modify op) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding operation " + (Object)((Object)op) + " from tasklist"));
        }
        switch (op) {
            case TABLE_SPLIT: {
                this.startAction(regionName, info, server, this.regionsToSplit);
                break;
            }
            case TABLE_COMPACT: {
                this.startAction(regionName, info, server, this.regionsToCompact);
                break;
            }
            case TABLE_MAJOR_COMPACT: {
                this.startAction(regionName, info, server, this.regionsToMajorCompact);
                break;
            }
            case TABLE_FLUSH: {
                this.startAction(regionName, info, server, this.regionsToFlush);
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal table action " + (Object)((Object)op));
            }
        }
    }

    private void startAction(byte[] regionName, HRegionInfo info, HServerAddress server, SortedMap<byte[], Pair<HRegionInfo, HServerAddress>> map) {
        map.put(regionName, new Pair<HRegionInfo, HServerAddress>(info, server));
    }

    public void endAction(byte[] regionName, HConstants.Modify op) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing operation " + (Object)((Object)op) + " from tasklist"));
        }
        switch (op) {
            case TABLE_SPLIT: {
                this.regionsToSplit.remove(regionName);
                break;
            }
            case TABLE_COMPACT: {
                this.regionsToCompact.remove(regionName);
                break;
            }
            case TABLE_MAJOR_COMPACT: {
                this.regionsToMajorCompact.remove(regionName);
                break;
            }
            case TABLE_FLUSH: {
                this.regionsToFlush.remove(regionName);
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal table action " + (Object)((Object)op));
            }
        }
    }

    public void endActions(byte[] regionName) {
        this.regionsToSplit.remove(regionName);
        this.regionsToCompact.remove(regionName);
    }

    public void applyActions(HServerInfo serverInfo, ArrayList<HMsg> returnMsgs) {
        this.applyActions(serverInfo, returnMsgs, this.regionsToCompact, HMsg.Type.MSG_REGION_COMPACT);
        this.applyActions(serverInfo, returnMsgs, this.regionsToSplit, HMsg.Type.MSG_REGION_SPLIT);
        this.applyActions(serverInfo, returnMsgs, this.regionsToFlush, HMsg.Type.MSG_REGION_FLUSH);
        this.applyActions(serverInfo, returnMsgs, this.regionsToMajorCompact, HMsg.Type.MSG_REGION_MAJOR_COMPACT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyActions(HServerInfo serverInfo, ArrayList<HMsg> returnMsgs, SortedMap<byte[], Pair<HRegionInfo, HServerAddress>> map, HMsg.Type msg) {
        HServerAddress addr = serverInfo.getServerAddress();
        SortedMap<byte[], Pair<HRegionInfo, HServerAddress>> sortedMap = map;
        synchronized (sortedMap) {
            Iterator<Pair<HRegionInfo, HServerAddress>> i = map.values().iterator();
            while (i.hasNext()) {
                Pair<HRegionInfo, HServerAddress> pair = i.next();
                if (!addr.equals(pair.getSecond())) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Sending " + (Object)((Object)msg) + " " + (Object)((Object)pair.getFirst()) + " to " + addr));
                }
                returnMsgs.add(new HMsg(msg, pair.getFirst()));
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean clearFromInTransition(byte[] regionname) {
        boolean result = false;
        SortedMap<String, RegionState> sortedMap = this.regionsInTransition;
        synchronized (sortedMap) {
            if (this.regionsInTransition.isEmpty()) {
                return result;
            }
            for (Map.Entry<String, RegionState> e : this.regionsInTransition.entrySet()) {
                if (!Bytes.equals(regionname, e.getValue().getRegionName())) continue;
                this.regionsInTransition.remove(e.getKey());
                LOG.debug((Object)("Removed " + e.getKey() + ", " + e.getValue()));
                result = true;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NavigableMap<String, String> getRegionsInTransition() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        SortedMap<String, RegionState> sortedMap = this.regionsInTransition;
        synchronized (sortedMap) {
            if (this.regionsInTransition.isEmpty()) {
                return result;
            }
            for (Map.Entry<String, RegionState> e : this.regionsInTransition.entrySet()) {
                result.put(e.getKey(), e.getValue().toString());
            }
        }
        return result;
    }

    private static class RegionState
    implements Comparable<RegionState> {
        private final HRegionInfo regionInfo;
        private volatile boolean unassigned = false;
        private volatile boolean pendingOpen = false;
        private volatile boolean open = false;
        private volatile boolean closing = false;
        private volatile boolean pendingClose = false;
        private volatile boolean closed = false;
        private volatile boolean offlined = false;
        private volatile String serverName = null;

        RegionState(HRegionInfo info) {
            this.regionInfo = info;
        }

        synchronized HRegionInfo getRegionInfo() {
            return this.regionInfo;
        }

        synchronized byte[] getRegionName() {
            return this.regionInfo.getRegionName();
        }

        synchronized String getServerName() {
            return this.serverName;
        }

        synchronized boolean isOpening() {
            return this.unassigned || this.pendingOpen || this.open;
        }

        synchronized boolean isUnassigned() {
            return this.unassigned;
        }

        synchronized void setUnassigned() {
            this.unassigned = true;
            this.pendingOpen = false;
            this.open = false;
            this.closing = false;
            this.pendingClose = false;
            this.closed = false;
            this.offlined = false;
            this.serverName = null;
        }

        synchronized boolean isPendingOpen() {
            return this.pendingOpen;
        }

        synchronized void setPendingOpen(String serverName) {
            if (!this.unassigned) {
                LOG.warn((Object)("Cannot assign a region that is not currently unassigned. FIX!! State: " + this.toString()));
            }
            this.unassigned = false;
            this.pendingOpen = true;
            this.open = false;
            this.closing = false;
            this.pendingClose = false;
            this.closed = false;
            this.offlined = false;
            this.serverName = serverName;
        }

        synchronized boolean isOpen() {
            return this.open;
        }

        synchronized void setOpen() {
            if (!this.pendingOpen) {
                LOG.warn((Object)("Cannot set a region as open if it has not been pending. FIX!! State: " + this.toString()));
            }
            this.unassigned = false;
            this.pendingOpen = false;
            this.open = true;
            this.closing = false;
            this.pendingClose = false;
            this.closed = false;
            this.offlined = false;
        }

        synchronized boolean isClosing() {
            return this.closing;
        }

        synchronized void setClosing(String serverName, boolean setOffline) {
            this.unassigned = false;
            this.pendingOpen = false;
            this.open = false;
            this.closing = true;
            this.pendingClose = false;
            this.closed = false;
            this.offlined = setOffline;
            this.serverName = serverName;
        }

        synchronized boolean isPendingClose() {
            return this.pendingClose;
        }

        synchronized void setPendingClose() {
            if (!this.closing) {
                LOG.warn((Object)("Cannot set a region as pending close if it has not been closing.  FIX!! State: " + this.toString()));
            }
            this.unassigned = false;
            this.pendingOpen = false;
            this.open = false;
            this.closing = false;
            this.pendingClose = true;
            this.closed = false;
        }

        synchronized boolean isClosed() {
            return this.closed;
        }

        synchronized void setClosed() {
            if (!(this.pendingClose || this.pendingOpen || this.closing)) {
                throw new IllegalStateException("Cannot set a region to be closed if it was not already marked as pending close, pending open or closing. State: " + this.toString());
            }
            this.unassigned = false;
            this.pendingOpen = false;
            this.open = false;
            this.closing = false;
            this.pendingClose = false;
            this.closed = true;
        }

        synchronized boolean isOfflined() {
            return this.offlined;
        }

        public synchronized String toString() {
            return "name=" + Bytes.toString(this.getRegionName()) + ", unassigned=" + this.unassigned + ", pendingOpen=" + this.pendingOpen + ", open=" + this.open + ", closing=" + this.closing + ", pendingClose=" + this.pendingClose + ", closed=" + this.closed + ", offlined=" + this.offlined;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.compareTo((RegionState)o) == 0;
        }

        public int hashCode() {
            return Bytes.toString(this.getRegionName()).hashCode();
        }

        @Override
        public int compareTo(RegionState o) {
            if (o == null) {
                return 1;
            }
            return Bytes.compareTo(this.getRegionName(), o.getRegionName());
        }
    }

    private class LoadBalancer {
        private float slop;
        private final int maxRegToClose;

        LoadBalancer(HBaseConfiguration conf) {
            this.slop = conf.getFloat("hbase.regions.slop", 0.1f);
            if (this.slop <= 0.0f) {
                this.slop = 1.0f;
            }
            this.maxRegToClose = conf.getInt("hbase.regions.close.max", -1);
        }

        void loadBalancing(HServerInfo info, HRegionInfo[] mostLoadedRegions, ArrayList<HMsg> returnMsgs) {
            HServerLoad servLoad = info.getLoad();
            double avg = RegionManager.this.master.serverManager.getAverageLoad();
            if ((double)servLoad.getLoad() <= Math.ceil(avg) || avg <= 2.0) {
                return;
            }
            int numRegionsToClose = this.balanceFromOverloaded(servLoad, avg);
            if (numRegionsToClose <= 0) {
                numRegionsToClose = this.balanceToLowloaded(info.getServerName(), servLoad, avg);
            }
            if (this.maxRegToClose > 0) {
                numRegionsToClose = Math.min(numRegionsToClose, this.maxRegToClose);
            }
            if (numRegionsToClose > 0) {
                RegionManager.this.unassignSomeRegions(info, numRegionsToClose, mostLoadedRegions, returnMsgs);
            }
        }

        private int balanceFromOverloaded(HServerLoad srvLoad, double avgLoad) {
            int avgLoadPlusSlop = (int)Math.ceil(avgLoad * (double)(1.0f + this.slop));
            int numSrvRegs = srvLoad.getNumberOfRegions();
            if (numSrvRegs > avgLoadPlusSlop) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Server is overloaded: load=" + numSrvRegs + ", avg=" + avgLoad + ", slop=" + this.slop));
                }
                return numSrvRegs - (int)Math.ceil(avgLoad);
            }
            return 0;
        }

        private int balanceToLowloaded(String srvName, HServerLoad srvLoad, double avgLoad) {
            SortedMap<HServerLoad, Set<String>> loadToServers = RegionManager.this.master.serverManager.getLoadToServers();
            if (!((Set)loadToServers.get(loadToServers.lastKey())).contains(srvName)) {
                return 0;
            }
            int avgLoadMinusSlop = (int)Math.floor(avgLoad * (double)(1.0f - this.slop)) - 1;
            int lowestLoad = loadToServers.firstKey().getNumberOfRegions();
            if (lowestLoad >= avgLoadMinusSlop) {
                return 0;
            }
            int lowSrvCount = ((Set)loadToServers.get(loadToServers.firstKey())).size();
            int numRegionsToClose = 0;
            int numSrvRegs = srvLoad.getNumberOfRegions();
            int numMoveToLowLoaded = (avgLoadMinusSlop - lowestLoad) * lowSrvCount;
            numRegionsToClose = numSrvRegs - (int)Math.ceil(avgLoad);
            numRegionsToClose = Math.min(numRegionsToClose, numMoveToLowLoaded);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Server " + srvName + " will be unloaded for " + "balance. Server load: " + numSrvRegs + " avg: " + avgLoad + ", regions can be moved: " + numMoveToLowLoaded + ". Regions to close: " + numRegionsToClose));
            }
            return numRegionsToClose;
        }
    }

    static class RegionDirFilter
    implements PathFilter {
        RegionDirFilter() {
        }

        public boolean accept(Path path) {
            return !path.getName().equals("compaction.dir");
        }
    }

    static class TableDirFilter
    implements PathFilter {
        TableDirFilter() {
        }

        public boolean accept(Path path) {
            String pathname = path.getName();
            return !pathname.equals(".logs") && !pathname.equals("hbase.version");
        }
    }
}

