/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.migration.nineteen.io;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.migration.nineteen.HStoreKey;
import org.apache.hadoop.hbase.migration.nineteen.io.BloomFilterMapFile;
import org.apache.hadoop.hbase.migration.nineteen.io.Reference;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class HalfMapFileReader
extends BloomFilterMapFile.Reader {
    private static final Log LOG = LogFactory.getLog(HalfMapFileReader.class);
    private final boolean top;
    private final HStoreKey midkey;
    private boolean firstNextCall = true;

    public HalfMapFileReader(FileSystem fs, String dirName, Configuration conf, Reference.Range r, WritableComparable<HStoreKey> mk, HRegionInfo hri) throws IOException {
        this(fs, dirName, conf, r, mk, false, false, hri);
    }

    public HalfMapFileReader(FileSystem fs, String dirName, Configuration conf, Reference.Range r, WritableComparable<HStoreKey> mk, boolean filter, boolean blockCacheEnabled, HRegionInfo hri) throws IOException {
        super(fs, dirName, conf, filter, blockCacheEnabled, hri);
        this.midkey = new HStoreKey((HStoreKey)mk);
        this.midkey.setHRegionInfo(hri);
        this.top = Reference.isTopFileRegion(r);
    }

    private void checkKey(WritableComparable<HStoreKey> key) throws IOException {
        if (this.top) {
            if (key.compareTo((Object)this.midkey) < 0) {
                throw new IOException("Illegal Access: Key is less than midKey of backing mapfile");
            }
        } else if (key.compareTo((Object)this.midkey) >= 0) {
            throw new IOException("Illegal Access: Key is greater than or equal to midKey of backing mapfile");
        }
    }

    public synchronized void finalKey(WritableComparable key) throws IOException {
        if (this.top) {
            super.finalKey(key);
        } else {
            ImmutableBytesWritable value = new ImmutableBytesWritable();
            WritableComparable found = super.getClosest((WritableComparable)this.midkey, (Writable)value, true);
            Writables.copyWritable((Writable)found, (Writable)key);
        }
    }

    @Override
    public synchronized Writable get(WritableComparable key, Writable val) throws IOException {
        this.checkKey((WritableComparable<HStoreKey>)key);
        return super.get(key, val);
    }

    @Override
    public synchronized WritableComparable getClosest(WritableComparable key, Writable val) throws IOException {
        HStoreKey closest = null;
        if (this.top) {
            closest = key.compareTo((Object)this.midkey) < 0 ? this.midkey : super.getClosest(key, val);
            this.firstNextCall = false;
        } else if (key.compareTo((Object)this.midkey) < 0 && (closest = super.getClosest(key, val)) != null && closest.compareTo(this.midkey) >= 0) {
            closest = null;
        }
        return closest;
    }

    public synchronized WritableComparable midKey() throws IOException {
        return null;
    }

    public synchronized boolean next(WritableComparable key, Writable val) throws IOException {
        if (this.firstNextCall) {
            this.firstNextCall = false;
            if (this.top) {
                WritableComparable nearest = this.getClosest(this.midkey, val);
                if (nearest != null) {
                    Writables.copyWritable((Writable)nearest, (Writable)key);
                    return true;
                }
                return false;
            }
        }
        boolean result = super.next(key, val);
        int cmpresult = key.compareTo((Object)this.midkey);
        if (this.top && cmpresult < 0) {
            LOG.error((Object)"BUG BUG BUG. HalfMapFileReader wanted to return key out of range. DANGER");
            throw new IOException("BUG BUG BUG. HalfMapFileReader wanted to return key out of range. DANGER");
        }
        if (!this.top && cmpresult >= 0) {
            result = false;
        }
        return result;
    }

    public synchronized void reset() throws IOException {
        if (this.top) {
            this.firstNextCall = true;
            return;
        }
        super.reset();
    }

    public synchronized boolean seek(WritableComparable key) throws IOException {
        this.checkKey((WritableComparable<HStoreKey>)key);
        return super.seek(key);
    }
}

