/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.Writable;

public class TestGetClosestAtOrBefore
extends HBaseTestCase
implements HConstants {
    static final Log LOG = LogFactory.getLog(TestGetClosestAtOrBefore.class);
    private MiniDFSCluster miniHdfs;
    private static final byte[] T00 = Bytes.toBytes("000");
    private static final byte[] T10 = Bytes.toBytes("010");
    private static final byte[] T11 = Bytes.toBytes("011");
    private static final byte[] T12 = Bytes.toBytes("012");
    private static final byte[] T20 = Bytes.toBytes("020");
    private static final byte[] T30 = Bytes.toBytes("030");
    private static final byte[] T31 = Bytes.toBytes("031");
    private static final byte[] T35 = Bytes.toBytes("035");
    private static final byte[] T40 = Bytes.toBytes("040");

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.miniHdfs = new MiniDFSCluster((Configuration)this.conf, 1, true, null);
        this.conf.set("hbase.rootdir", this.miniHdfs.getFileSystem().getHomeDirectory().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUsingMetaAndBinary() throws IOException {
        FileSystem filesystem = FileSystem.get((Configuration)this.conf);
        Path rootdir = filesystem.makeQualified(new Path(this.conf.get("hbase.rootdir")));
        filesystem.mkdirs(rootdir);
        HRegionInfo.FIRST_META_REGIONINFO.getTableDesc().setMemStoreFlushSize(0x4000000L);
        HRegion mr = HRegion.createHRegion(HRegionInfo.FIRST_META_REGIONINFO, rootdir, this.conf);
        for (char c = 'A'; c < 'D'; c = (char)(c + '\u0001')) {
            HTableDescriptor htd = new HTableDescriptor("" + c);
            int last = 128;
            int interval = 2;
            for (int i = 0; i <= 128; i += 2) {
                HRegionInfo hri = new HRegionInfo(htd, i == 0 ? HConstants.EMPTY_BYTE_ARRAY : Bytes.toBytes((byte)i), i == 128 ? HConstants.EMPTY_BYTE_ARRAY : Bytes.toBytes((byte)i + 2));
                Put put = new Put(hri.getRegionName());
                put.add(CATALOG_FAMILY, REGIONINFO_QUALIFIER, Writables.getBytes((Writable)hri));
                mr.put(put, false);
            }
        }
        InternalScanner s = mr.getScanner(new Scan());
        try {
            ArrayList<KeyValue> keys = new ArrayList<KeyValue>();
            while (s.next(keys)) {
                LOG.info(keys);
                keys.clear();
            }
        }
        finally {
            s.close();
        }
        this.findRow(mr, 'C', 44, 44);
        this.findRow(mr, 'C', 45, 44);
        this.findRow(mr, 'C', 46, 46);
        this.findRow(mr, 'C', 43, 42);
        mr.flushcache();
        this.findRow(mr, 'C', 44, 44);
        this.findRow(mr, 'C', 45, 44);
        this.findRow(mr, 'C', 46, 46);
        this.findRow(mr, 'C', 43, 42);
        byte[] firstRowInC = HRegionInfo.createRegionName(Bytes.toBytes("C"), HConstants.EMPTY_BYTE_ARRAY, "00000000000000");
        Scan scan = new Scan(firstRowInC);
        s = mr.getScanner(scan);
        try {
            ArrayList<KeyValue> keys = new ArrayList<KeyValue>();
            while (s.next(keys)) {
                mr.delete(new Delete(((KeyValue)keys.get(0)).getRow()), null, false);
                keys.clear();
            }
        }
        finally {
            s.close();
        }
        this.findRow(mr, 'C', 44, -1);
        this.findRow(mr, 'C', 45, -1);
        this.findRow(mr, 'C', 46, -1);
        this.findRow(mr, 'C', 43, -1);
        mr.flushcache();
        this.findRow(mr, 'C', 44, -1);
        this.findRow(mr, 'C', 45, -1);
        this.findRow(mr, 'C', 46, -1);
        this.findRow(mr, 'C', 43, -1);
    }

    private byte[] findRow(HRegion mr, char table, int rowToFind, int answer) throws IOException {
        byte[] tableb = Bytes.toBytes("" + table);
        byte[] tofindBytes = Bytes.toBytes((short)rowToFind);
        byte[] metaKey = HRegionInfo.createRegionName(tableb, tofindBytes, "99999999999999");
        LOG.info((Object)("find=" + new String(metaKey)));
        Result r = mr.getClosestRowBefore(metaKey);
        if (answer == -1) {
            TestGetClosestAtOrBefore.assertNull((Object)r);
            return null;
        }
        TestGetClosestAtOrBefore.assertTrue((Bytes.compareTo(Bytes.toBytes((short)answer), this.extractRowFromMetaRow(r.getRow())) == 0 ? 1 : 0) != 0);
        return r.getRow();
    }

    private byte[] extractRowFromMetaRow(byte[] b) {
        int firstDelimiter = KeyValue.getDelimiter(b, 0, b.length, 44);
        int lastDelimiter = KeyValue.getDelimiterInReverse(b, 0, b.length, 44);
        int length = lastDelimiter - firstDelimiter - 1;
        byte[] row = new byte[length];
        System.arraycopy(b, firstDelimiter + 1, row, 0, length);
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetClosestRowBefore3() throws IOException {
        HRegion region = null;
        byte[] c0 = COLUMNS[0];
        byte[] c1 = COLUMNS[1];
        try {
            HTableDescriptor htd = this.createTableDescriptor(this.getName());
            region = this.createNewHRegion(htd, null, null);
            Put p = new Put(T00);
            p.add(c0, c0, T00);
            region.put(p);
            p = new Put(T10);
            p.add(c0, c0, T10);
            region.put(p);
            p = new Put(T20);
            p.add(c0, c0, T20);
            region.put(p);
            Result r = region.getClosestRowBefore(T20, c0);
            TestGetClosestAtOrBefore.assertTrue((boolean)Bytes.equals(T20, r.getRow()));
            Delete d = new Delete(T20);
            d.deleteColumn(c0, c0);
            region.delete(d, null, false);
            r = region.getClosestRowBefore(T20, c0);
            TestGetClosestAtOrBefore.assertTrue((boolean)Bytes.equals(T10, r.getRow()));
            p = new Put(T30);
            p.add(c0, c0, T30);
            region.put(p);
            r = region.getClosestRowBefore(T30, c0);
            TestGetClosestAtOrBefore.assertTrue((boolean)Bytes.equals(T30, r.getRow()));
            d = new Delete(T30);
            d.deleteColumn(c0, c0);
            region.delete(d, null, false);
            r = region.getClosestRowBefore(T30, c0);
            TestGetClosestAtOrBefore.assertTrue((boolean)Bytes.equals(T10, r.getRow()));
            r = region.getClosestRowBefore(T31, c0);
            TestGetClosestAtOrBefore.assertTrue((boolean)Bytes.equals(T10, r.getRow()));
            region.flushcache();
            r = region.getClosestRowBefore(T30, c0);
            TestGetClosestAtOrBefore.assertTrue((boolean)Bytes.equals(T10, r.getRow()));
            r = region.getClosestRowBefore(T31, c0);
            TestGetClosestAtOrBefore.assertTrue((boolean)Bytes.equals(T10, r.getRow()));
            p = new Put(T20);
            p.add(c1, c1, T20);
            region.put(p);
            r = region.getClosestRowBefore(T30, c0);
            TestGetClosestAtOrBefore.assertTrue((boolean)Bytes.equals(T10, r.getRow()));
            r = region.getClosestRowBefore(T31, c0);
            TestGetClosestAtOrBefore.assertTrue((boolean)Bytes.equals(T10, r.getRow()));
            region.flushcache();
            r = region.getClosestRowBefore(T30, c0);
            TestGetClosestAtOrBefore.assertTrue((boolean)Bytes.equals(T10, r.getRow()));
            r = region.getClosestRowBefore(T31, c0);
            TestGetClosestAtOrBefore.assertTrue((boolean)Bytes.equals(T10, r.getRow()));
            d = new Delete(T20);
            d.deleteColumn(c1, c1);
            region.delete(d, null, false);
            r = region.getClosestRowBefore(T30, c0);
            TestGetClosestAtOrBefore.assertTrue((boolean)Bytes.equals(T10, r.getRow()));
            r = region.getClosestRowBefore(T31, c0);
            TestGetClosestAtOrBefore.assertTrue((boolean)Bytes.equals(T10, r.getRow()));
            region.flushcache();
            r = region.getClosestRowBefore(T31, c0);
            TestGetClosestAtOrBefore.assertTrue((boolean)Bytes.equals(T10, r.getRow()));
            p = new Put(T11);
            p.add(c0, c0, T11);
            region.put(p);
            d = new Delete(T10);
            d.deleteColumn(c1, c1);
            r = region.getClosestRowBefore(T12, c0);
            TestGetClosestAtOrBefore.assertTrue((boolean)Bytes.equals(T11, r.getRow()));
        }
        finally {
            if (region != null) {
                try {
                    region.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                region.getLog().closeAndDelete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetClosestRowBefore2() throws IOException {
        HRegion region = null;
        byte[] c0 = COLUMNS[0];
        try {
            HTableDescriptor htd = this.createTableDescriptor(this.getName());
            region = this.createNewHRegion(htd, null, null);
            Put p = new Put(T10);
            p.add(c0, c0, T10);
            region.put(p);
            p = new Put(T30);
            p.add(c0, c0, T30);
            region.put(p);
            p = new Put(T40);
            p.add(c0, c0, T40);
            region.put(p);
            Result r = region.getClosestRowBefore(T35, c0);
            TestGetClosestAtOrBefore.assertTrue((boolean)Bytes.equals(T30, r.getRow()));
            region.flushcache();
            r = region.getClosestRowBefore(T35, c0);
            TestGetClosestAtOrBefore.assertTrue((boolean)Bytes.equals(T30, r.getRow()));
            p = new Put(T20);
            p.add(c0, c0, T20);
            region.put(p);
            r = region.getClosestRowBefore(T35, c0);
            TestGetClosestAtOrBefore.assertTrue((boolean)Bytes.equals(T30, r.getRow()));
            region.flushcache();
            r = region.getClosestRowBefore(T35, c0);
            TestGetClosestAtOrBefore.assertTrue((boolean)Bytes.equals(T30, r.getRow()));
        }
        finally {
            if (region != null) {
                try {
                    region.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                region.getLog().closeAndDelete();
            }
        }
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.miniHdfs != null) {
            this.miniHdfs.shutdown();
        }
        super.tearDown();
    }
}

