/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HStoreKey;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hdfs.MiniDFSCluster;

public class TestStoreFile
extends HBaseTestCase {
    static final Log LOG = LogFactory.getLog(TestStoreFile.class);
    private MiniDFSCluster cluster;

    @Override
    public void setUp() throws Exception {
        try {
            this.cluster = new MiniDFSCluster((Configuration)this.conf, 2, true, (String[])null);
            this.conf.set("hbase.rootdir", this.cluster.getFileSystem().getHomeDirectory().toString());
        }
        catch (IOException e) {
            TestStoreFile.shutdownDfs(this.cluster);
        }
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        TestStoreFile.shutdownDfs(this.cluster);
    }

    public void testBasicHalfMapFile() throws Exception {
        HFile.Writer writer = StoreFile.getWriter(this.fs, new Path(new Path(this.testDir, "regionname"), "familyname"), 2048, null, null);
        this.writeStoreFile(writer);
        this.checkHalfHFile(new StoreFile(this.fs, writer.getPath(), true, this.conf, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStoreFile(HFile.Writer writer) throws IOException {
        long now = System.currentTimeMillis();
        byte[] column = Bytes.toBytes(this.getName() + ':' + this.getName());
        try {
            for (int d = 97; d <= 122; d = (int)((char)(d + 1))) {
                for (int e = 97; e <= 122; e = (int)((char)(e + 1))) {
                    byte[] b = new byte[]{(byte)d, (byte)e};
                    writer.append(new KeyValue(b, column, now, b));
                }
            }
        }
        finally {
            writer.close();
        }
    }

    public void testReference() throws IOException {
        Path storedir = new Path(new Path(this.testDir, "regionname"), "familyname");
        Path dir = new Path(storedir, "1234567890");
        HFile.Writer writer = StoreFile.getWriter(this.fs, dir, 8192, null, null);
        this.writeStoreFile(writer);
        StoreFile hsf = new StoreFile(this.fs, writer.getPath(), true, this.conf, false);
        HFile.Reader reader = hsf.getReader();
        HStoreKey hsk = HStoreKey.create(reader.midkey());
        byte[] midkey = hsk.getRow();
        hsk = HStoreKey.create(reader.getLastKey());
        byte[] finalKey = hsk.getRow();
        Path refPath = StoreFile.split(this.fs, dir, hsf, reader.midkey(), Reference.Range.top);
        StoreFile refHsf = new StoreFile(this.fs, refPath, true, this.conf, false);
        HFileScanner s = refHsf.getReader().getScanner();
        boolean first = true;
        while (!s.isSeeked() && s.seekTo() || s.next()) {
            ByteBuffer bb = s.getKey();
            hsk = HStoreKey.create(bb.array(), bb.arrayOffset(), bb.limit());
            if (!first) continue;
            TestStoreFile.assertTrue((boolean)Bytes.equals(hsk.getRow(), midkey));
            first = false;
        }
        TestStoreFile.assertTrue((boolean)Bytes.equals(hsk.getRow(), finalKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHalfHFile(StoreFile f) throws IOException {
        byte[] midkey = f.getReader().midkey();
        Path topDir = Store.getStoreHomedir(this.testDir, 1, Bytes.toBytes(f.getPath().getParent().getName()));
        if (this.fs.exists(topDir)) {
            this.fs.delete(topDir, true);
        }
        Path topPath = StoreFile.split(this.fs, topDir, f, midkey, Reference.Range.top);
        Path bottomDir = Store.getStoreHomedir(this.testDir, 2, Bytes.toBytes(f.getPath().getParent().getName()));
        if (this.fs.exists(bottomDir)) {
            this.fs.delete(bottomDir, true);
        }
        Path bottomPath = StoreFile.split(this.fs, bottomDir, f, midkey, Reference.Range.bottom);
        HFile.Reader top = new StoreFile(this.fs, topPath, true, this.conf, false).getReader();
        HFile.Reader bottom = new StoreFile(this.fs, bottomPath, true, this.conf, false).getReader();
        ByteBuffer previous = null;
        LOG.info((Object)("Midkey: " + Bytes.toString(midkey)));
        byte[] midkeyBytes = new HStoreKey(midkey).getBytes();
        ByteBuffer bbMidkeyBytes = ByteBuffer.wrap(midkeyBytes);
        try {
            int i;
            String tmp;
            HStoreKey keyhsk;
            boolean first = true;
            ByteBuffer key = null;
            HFileScanner topScanner = top.getScanner();
            while (!topScanner.isSeeked() && topScanner.seekTo() || topScanner.isSeeked() && topScanner.next()) {
                key = topScanner.getKey();
                TestStoreFile.assertTrue((topScanner.getReader().getComparator().compare(key.array(), key.arrayOffset(), key.limit(), midkeyBytes, 0, midkeyBytes.length) >= 0 ? 1 : 0) != 0);
                if (!first) continue;
                first = false;
                LOG.info((Object)("First in top: " + Bytes.toString(Bytes.toBytes(key))));
            }
            LOG.info((Object)("Last in top: " + Bytes.toString(Bytes.toBytes(key))));
            first = true;
            HFileScanner bottomScanner = bottom.getScanner();
            while (!bottomScanner.isSeeked() && bottomScanner.seekTo() || bottomScanner.next()) {
                previous = bottomScanner.getKey();
                key = bottomScanner.getKey();
                if (first) {
                    first = false;
                    LOG.info((Object)("First in bottom: " + Bytes.toString(Bytes.toBytes(previous))));
                }
                TestStoreFile.assertTrue((key.compareTo(bbMidkeyBytes) < 0 ? 1 : 0) != 0);
            }
            if (previous != null) {
                LOG.info((Object)("Last in bottom: " + Bytes.toString(Bytes.toBytes(previous))));
            }
            this.fs.delete(topPath, false);
            this.fs.delete(bottomPath, false);
            byte[] badmidkey = Bytes.toBytes("  .");
            topPath = StoreFile.split(this.fs, topDir, f, badmidkey, Reference.Range.top);
            bottomPath = StoreFile.split(this.fs, bottomDir, f, badmidkey, Reference.Range.bottom);
            top = new StoreFile(this.fs, topPath, true, this.conf, false).getReader();
            bottom = new StoreFile(this.fs, bottomPath, true, this.conf, false).getReader();
            bottomScanner = bottom.getScanner();
            int count = 0;
            while (!bottomScanner.isSeeked() && bottomScanner.seekTo() || bottomScanner.next()) {
                ++count;
            }
            TestStoreFile.assertTrue((count == 0 ? 1 : 0) != 0);
            first = true;
            topScanner = top.getScanner();
            while (!topScanner.isSeeked() && topScanner.seekTo() || topScanner.next()) {
                key = topScanner.getKey();
                TestStoreFile.assertTrue((topScanner.getReader().getComparator().compare(key.array(), key.arrayOffset(), key.limit(), badmidkey, 0, badmidkey.length) >= 0 ? 1 : 0) != 0);
                if (!first) continue;
                first = false;
                first = false;
                keyhsk = HStoreKey.create(key);
                LOG.info((Object)("First top when key < bottom: " + keyhsk));
                tmp = Bytes.toString(keyhsk.getRow());
                for (i = 0; i < tmp.length(); ++i) {
                    TestStoreFile.assertTrue((tmp.charAt(i) == 'a' ? 1 : 0) != 0);
                }
            }
            keyhsk = HStoreKey.create(key);
            LOG.info((Object)("Last top when key < bottom: " + keyhsk));
            tmp = Bytes.toString(keyhsk.getRow());
            for (i = 0; i < tmp.length(); ++i) {
                TestStoreFile.assertTrue((tmp.charAt(i) == 'z' ? 1 : 0) != 0);
            }
            this.fs.delete(topPath, false);
            this.fs.delete(bottomPath, false);
            badmidkey = Bytes.toBytes("|||");
            topPath = StoreFile.split(this.fs, topDir, f, badmidkey, Reference.Range.top);
            bottomPath = StoreFile.split(this.fs, bottomDir, f, badmidkey, Reference.Range.bottom);
            top = new StoreFile(this.fs, topPath, true, this.conf, false).getReader();
            bottom = new StoreFile(this.fs, bottomPath, true, this.conf, false).getReader();
            first = true;
            bottomScanner = bottom.getScanner();
            while (!bottomScanner.isSeeked() && bottomScanner.seekTo() || bottomScanner.next()) {
                key = bottomScanner.getKey();
                if (!first) continue;
                first = false;
                keyhsk = HStoreKey.create(key);
                LOG.info((Object)("First bottom when key > top: " + keyhsk));
                tmp = Bytes.toString(keyhsk.getRow());
                for (i = 0; i < tmp.length(); ++i) {
                    TestStoreFile.assertTrue((tmp.charAt(i) == 'a' ? 1 : 0) != 0);
                }
            }
            keyhsk = HStoreKey.create(key);
            LOG.info((Object)("Last bottom when key > top: " + keyhsk));
            for (i = 0; i < tmp.length(); ++i) {
                TestStoreFile.assertTrue((Bytes.toString(keyhsk.getRow()).charAt(i) == 'z' ? 1 : 0) != 0);
            }
            count = 0;
            topScanner = top.getScanner();
            while (!topScanner.isSeeked() && topScanner.seekTo() || topScanner.isSeeked() && topScanner.next()) {
                ++count;
            }
            TestStoreFile.assertTrue((count == 0 ? 1 : 0) != 0);
        }
        finally {
            if (top != null) {
                top.close();
            }
            if (bottom != null) {
                bottom.close();
            }
            this.fs.delete(f.getPath(), true);
        }
    }
}

