/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.descriptors;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;
import org.apache.hadoop.hbase.rest.serializer.IRestSerializer;
import org.apache.hadoop.hbase.rest.serializer.ISerializable;
import org.apache.hadoop.hbase.util.Bytes;

public class TimestampsDescriptor
implements ISerializable {
    Map<Long, String> timestamps = new HashMap<Long, String>();

    public void add(long timestamp, byte[] tableName, byte[] rowName) {
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        sb.append(Bytes.toString(tableName));
        sb.append("/row/");
        sb.append(Bytes.toString(rowName));
        sb.append('/');
        sb.append(timestamp);
        this.timestamps.put(timestamp, sb.toString());
    }

    public Map<Long, String> getTimestamps() {
        return this.timestamps;
    }

    @Override
    public void restSerialize(IRestSerializer serializer) throws HBaseRestException {
        serializer.serializeTimestamps(this);
    }
}

