/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.serializer;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.io.Cell;
import org.apache.hadoop.hbase.io.RowResult;
import org.apache.hadoop.hbase.rest.DatabaseModel;
import org.apache.hadoop.hbase.rest.Status;
import org.apache.hadoop.hbase.rest.TableModel;
import org.apache.hadoop.hbase.rest.descriptors.RestCell;
import org.apache.hadoop.hbase.rest.descriptors.ScannerIdentifier;
import org.apache.hadoop.hbase.rest.descriptors.TimestampsDescriptor;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;
import org.apache.hadoop.hbase.rest.serializer.AbstractRestSerializer;
import org.apache.hadoop.hbase.rest.serializer.ISerializable;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.Bytes;

public class SimpleXMLSerializer
extends AbstractRestSerializer {
    private final AbstractPrinter printer;

    public SimpleXMLSerializer(HttpServletResponse response) throws HBaseRestException {
        super(response, false);
        this.printer = new SimplePrinter(response);
    }

    public SimpleXMLSerializer(HttpServletResponse response, boolean prettyPrint) throws HBaseRestException {
        super(response, prettyPrint);
        this.printer = prettyPrint ? new PrettyPrinter(response) : new SimplePrinter(response);
    }

    @Override
    public void writeOutput(Object o) throws HBaseRestException {
        this.response.setContentType("text/xml");
        this.response.setCharacterEncoding("UTF-8");
        if (o instanceof ISerializable) {
            ((ISerializable)o).restSerialize(this);
        } else if (o.getClass().isArray() && o.getClass().getComponentType() == RowResult.class) {
            this.serializeRowResultArray((RowResult[])o);
        } else if (o.getClass().isArray() && o.getClass().getComponentType() == Cell.class) {
            this.serializeCellArray((Cell[])o);
        } else {
            throw new HBaseRestException("Object does not conform to the ISerializable interface.  Unable to generate xml output.");
        }
    }

    @Override
    public void serializeDatabaseMetadata(DatabaseModel.DatabaseMetadata databaseMetadata) throws HBaseRestException {
        this.printer.print("<tables>");
        for (HTableDescriptor table : databaseMetadata.getTables()) {
            table.restSerialize(this);
        }
        this.printer.print("</tables>");
        this.printer.flush();
    }

    @Override
    public void serializeTableDescriptor(HTableDescriptor tableDescriptor) throws HBaseRestException {
        this.printer.print("<table>");
        this.printer.print("<name>");
        this.printer.print(tableDescriptor.getNameAsString());
        this.printer.print("</name>");
        this.printer.print("<columnfamilies>");
        for (HColumnDescriptor column : tableDescriptor.getColumnFamilies()) {
            column.restSerialize(this);
        }
        this.printer.print("</columnfamilies>");
        this.printer.print("</table>");
        this.printer.flush();
    }

    @Override
    public void serializeColumnDescriptor(HColumnDescriptor column) throws HBaseRestException {
        this.printer.print("<columnfamily>");
        this.printer.print("<name>");
        this.printer.print(Base64.encodeBytes(column.getName()));
        this.printer.print("</name>");
        this.printer.print("<compression>");
        this.printer.print(column.getCompression().toString());
        this.printer.print("</compression>");
        this.printer.print("<bloomfilter>");
        this.printer.print(column.getCompressionType().toString());
        this.printer.print("</bloomfilter>");
        this.printer.print("<max-versions>");
        this.printer.print(column.getMaxVersions());
        this.printer.print("</max-versions>");
        this.printer.print("</columnfamily>");
        this.printer.flush();
    }

    @Override
    public void serializeRegionData(TableModel.Regions regions) throws HBaseRestException {
        this.printer.print("<regions>");
        for (byte[] region : regions.getRegionKey()) {
            this.printer.print("<region>");
            this.printer.print(Bytes.toString(region));
            this.printer.print("</region>");
        }
        this.printer.print("</regions>");
        this.printer.flush();
    }

    @Override
    public void serializeStatusMessage(Status.StatusMessage message) throws HBaseRestException {
        this.printer.print("<status>");
        this.printer.print("<code>");
        this.printer.print(message.getStatusCode());
        this.printer.print("</code>");
        this.printer.print("<message>");
        this.printer.print(message.getMessage().toString());
        this.printer.print("</message>");
        this.printer.print("<error>");
        this.printer.print(message.getError());
        this.printer.print("</error>");
        this.printer.print("</status>");
        this.printer.flush();
    }

    @Override
    public void serializeScannerIdentifier(ScannerIdentifier scannerIdentifier) throws HBaseRestException {
        this.printer.print("<scanner>");
        this.printer.print("<id>");
        this.printer.print(scannerIdentifier.getId());
        this.printer.print("</id>");
        this.printer.print("</scanner>");
        this.printer.flush();
    }

    @Override
    public void serializeRowResult(RowResult rowResult) throws HBaseRestException {
        this.printer.print("<row>");
        this.printer.print("<name>");
        this.printer.print(Base64.encodeBytes(rowResult.getRow()));
        this.printer.print("</name>");
        this.printer.print("<columns>");
        for (RestCell cell : rowResult.getCells()) {
            this.printer.print("<column>");
            this.printer.print("<name>");
            this.printer.print(Base64.encodeBytes(cell.getName()));
            this.printer.print("</name>");
            this.printer.print("<timestamp>");
            this.printer.print(cell.getTimestamp());
            this.printer.print("</timestamp>");
            this.printer.print("<value>");
            this.printer.print(Base64.encodeBytes(cell.getValue()));
            this.printer.print("</value>");
            this.printer.print("</column>");
            this.printer.flush();
        }
        this.printer.print("</columns>");
        this.printer.print("</row>");
        this.printer.flush();
    }

    @Override
    public void serializeRowResultArray(RowResult[] rows) throws HBaseRestException {
        this.printer.print("<rows>");
        for (RowResult row : rows) {
            row.restSerialize(this);
        }
        this.printer.print("</rows>");
    }

    @Override
    public void serializeCell(Cell cell) throws HBaseRestException {
        this.printer.print("<cell>");
        this.printer.print("<value>");
        this.printer.print(Base64.encodeBytes(cell.getValue()));
        this.printer.print("</value>");
        this.printer.print("<timestamp>");
        this.printer.print(cell.getTimestamp());
        this.printer.print("</timestamp>");
        this.printer.print("</cell>");
    }

    @Override
    public void serializeCellArray(Cell[] cells) throws HBaseRestException {
        this.printer.print("<cells>");
        for (Cell cell : cells) {
            cell.restSerialize(this);
        }
        this.printer.print("</cells>");
    }

    @Override
    public void serializeTimestamps(TimestampsDescriptor timestampsDescriptor) throws HBaseRestException {
    }

    private class PrettyPrinter
    extends AbstractPrinter {
        private PrettyPrinter(HttpServletResponse response) throws HBaseRestException {
            super(response);
        }

        @Override
        public void print(String output) {
            this.writer.println(output);
        }

        @Override
        public void print(int output) {
            this.writer.println(output);
        }

        @Override
        public void print(long output) {
            this.writer.println(output);
        }

        @Override
        public void print(boolean output) {
            this.writer.println(output);
        }
    }

    private class SimplePrinter
    extends AbstractPrinter {
        private SimplePrinter(HttpServletResponse response) throws HBaseRestException {
            super(response);
        }

        @Override
        public void print(String output) {
            this.writer.print(output);
        }

        @Override
        public void print(int output) {
            this.writer.print(output);
        }

        @Override
        public void print(long output) {
            this.writer.print(output);
        }

        @Override
        public void print(boolean output) {
            this.writer.print(output);
        }
    }

    private abstract class AbstractPrinter
    implements IPrinter {
        protected final PrintWriter writer;

        private AbstractPrinter() {
            this.writer = null;
        }

        public AbstractPrinter(HttpServletResponse response) throws HBaseRestException {
            try {
                this.writer = response.getWriter();
            }
            catch (IOException e) {
                throw new HBaseRestException(e.getMessage(), e);
            }
        }

        @Override
        public void flush() {
            this.writer.flush();
        }
    }

    private static interface IPrinter {
        public void print(String var1);

        public void print(int var1);

        public void print(long var1);

        public void print(boolean var1);

        public void flush();
    }
}

