/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Migrate;

public class TestMigration
extends HBaseTestCase {
    private static final Log LOG = LogFactory.getLog(TestMigration.class);
    private static final int EXPECTED_COUNT = 3;

    public void testMigration() throws IOException, InterruptedException {
        Path rootdir = this.getUnitTestdir(this.getName());
        Path hbasedir = this.loadTestData(this.fs, rootdir);
        TestMigration.assertTrue((boolean)this.fs.exists(hbasedir));
        Migrate migrator = new Migrate(this.conf);
        Path qualified = this.fs.makeQualified(hbasedir);
        String uri = qualified.toString();
        this.conf.set("hbase.rootdir", uri);
        int result = migrator.run(new String[]{"upgrade"});
        TestMigration.assertEquals((int)0, (int)result);
        this.verify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path loadTestData(FileSystem dfs, Path rootDir) throws IOException {
        String hbasedir = "hbase-0.19-two-small-tables";
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("data/" + hbasedir + ".zip");
        ZipInputStream zip = new ZipInputStream(is);
        try {
            this.unzip(zip, dfs, rootDir);
        }
        finally {
            zip.close();
        }
        return new Path(rootDir, hbasedir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verify() throws IOException, InterruptedException {
        HConnectionManager.deleteConnectionInfo(this.conf, false);
        LOG.info((Object)"Start a cluster against migrated FS");
        int retries = 5;
        this.conf.setInt("hbase.client.retries.number", 5);
        MiniZooKeeperCluster zooKeeperCluster = new MiniZooKeeperCluster();
        int clientPort = zooKeeperCluster.startup(new File(this.testDir.toString()));
        this.conf.set("hbase.zookeeper.property.clientPort", Integer.toString(clientPort));
        MiniHBaseCluster cluster = new MiniHBaseCluster(this.conf, 1);
        try {
            HBaseAdmin hb = new HBaseAdmin(this.conf);
            TestMigration.assertTrue((boolean)hb.isMasterRunning());
            HTableDescriptor[] tables = hb.listTables();
            TestMigration.assertEquals((int)2, (int)tables.length);
            boolean foundTable = false;
            String tablenameStr = "a";
            byte[] tablename = Bytes.toBytes("a");
            for (int i = 0; i < tables.length; ++i) {
                byte[] tableName = tables[i].getName();
                if (!Bytes.equals(tablename, tables[i].getName())) continue;
                foundTable = true;
                break;
            }
            TestMigration.assertTrue((boolean)foundTable);
            LOG.info((Object)"a exists.  Now waiting till startcode changes before opening a scanner");
            this.waitOnStartCodeChange(5);
            HConnectionManager.deleteConnectionInfo(this.conf, false);
            HTable t = new HTable(this.conf, tablename);
            int count = 0;
            LOG.info((Object)"OPENING SCANNER");
            Scan scan = new Scan();
            ResultScanner s = t.getScanner(scan);
            try {
                Result r;
                Iterator i$ = s.iterator();
                while (i$.hasNext() && (r = (Result)i$.next()) != null && r.size() != 0) {
                    ++count;
                }
                TestMigration.assertEquals((int)3, (int)count);
            }
            finally {
                s.close();
            }
        }
        finally {
            HConnectionManager.deleteConnectionInfo(this.conf, false);
            cluster.shutdown();
            try {
                zooKeeperCluster.shutdown();
            }
            catch (IOException e) {
                LOG.warn((Object)"Shutting down ZooKeeper cluster", (Throwable)e);
            }
        }
    }

    private void waitOnStartCodeChange(int retries) throws IOException {
        HTable m = new HTable(this.conf, HConstants.META_TABLE_NAME);
        long oldStartCode = 1199736332062L;
        byte[] row = Bytes.toBytes("TestUpgrade,,1199736362468");
        long pause = this.conf.getLong("hbase.client.pause", 5000L);
        long startcode = -1L;
        boolean changed = false;
        for (int i = 0; i < retries; ++i) {
            Get get2 = new Get(row);
            get2.addColumn(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER);
            Result res = m.get(get2);
            KeyValue[] kvs = res.raw();
            if (kvs.length <= 0) {
                return;
            }
            byte[] value = kvs[0].getValue();
            startcode = Bytes.toLong(value);
            if (startcode != oldStartCode) {
                changed = true;
                break;
            }
            if (i + 1 == retries) continue;
            try {
                Thread.sleep(pause);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (!changed) {
            throw new IOException("Startcode didn't change after " + retries + " attempts");
        }
    }

    private void unzip(ZipInputStream zip, FileSystem dfs, Path rootDir) throws IOException {
        ZipEntry e = null;
        while ((e = zip.getNextEntry()) != null) {
            if (e.isDirectory()) {
                dfs.mkdirs(new Path(rootDir, e.getName()));
            } else {
                int len;
                FSDataOutputStream out = dfs.create(new Path(rootDir, e.getName()));
                byte[] buffer = new byte[4096];
                do {
                    if ((len = zip.read(buffer)) <= 0) continue;
                    out.write(buffer, 0, len);
                } while (len > 0);
                out.close();
            }
            zip.closeEntry();
        }
    }

    private void listPaths(FileSystem filesystem, Path dir, int rootdirlength) throws IOException {
        FileStatus[] stats = filesystem.listStatus(dir);
        if (stats == null || stats.length == 0) {
            return;
        }
        for (int i = 0; i < stats.length; ++i) {
            String path = stats[i].getPath().toString();
            if (stats[i].isDir()) {
                System.out.println("d " + path);
                this.listPaths(filesystem, stats[i].getPath(), rootdirlength);
                continue;
            }
            System.out.println("f " + path + " size=" + stats[i].getLen());
        }
    }
}

