/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import junit.framework.Assert;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.util.Pair;

public class TestPair
extends HBaseTestCase {
    public void testOf() {
        Pair<Integer, Double> p1 = Pair.of(1, 1.2);
        Assert.assertEquals((int)1, (int)p1.getFirst());
        Assert.assertEquals((Object)1.2, (Object)p1.getSecond());
        Pair<String, Integer> p2 = Pair.of("a", 1);
        Assert.assertEquals((String)"a", (String)p2.getFirst());
        Assert.assertEquals((int)1, (int)p2.getSecond());
        p2 = Pair.of(null, null);
        Assert.assertNull((Object)p2.getFirst());
        Assert.assertNull((Object)p2.getSecond());
    }

    public void testEquals() {
        Pair<Integer, Integer> item1a = Pair.of(1, 1);
        Pair<Integer, Integer> item1b = Pair.of(1, 1);
        Pair<Integer, Integer> item2 = Pair.of(1, 2);
        Pair<Integer, Integer> item3 = Pair.of(2, 1);
        Assert.assertTrue((boolean)item1a.equals(item1b));
        Assert.assertFalse((boolean)item1a.equals(item2));
        Assert.assertFalse((boolean)item1a.equals(item3));
        Pair<byte[], String[]> item4 = Pair.of(new byte[]{3, 27}, new String[]{"foo", "bar"});
        Pair<byte[], String[]> item5 = Pair.of(new byte[]{3, 27}, new String[]{"foo", "bar"});
        Assert.assertTrue((boolean)item4.equals(item5));
    }

    public void testEqualsNullFirst() {
        Pair<Integer, Integer> item1 = Pair.of(1, 1);
        Pair<Object, Integer> item2 = Pair.of(null, 2);
        Assert.assertFalse((boolean)item1.equals(item2));
        Assert.assertFalse((boolean)item2.equals(item1));
    }

    public void testEqualsNullSecond() {
        Pair<Integer, Integer> item1 = Pair.of(1, 1);
        Pair<Integer, Object> item2 = Pair.of(1, null);
        Assert.assertFalse((boolean)item1.equals(item2));
        Assert.assertFalse((boolean)item2.equals(item1));
    }

    public void testEqualsNullBoth() {
        Pair<Object, Object> item1 = Pair.of(null, null);
        Pair<Object, Object> item2 = Pair.of(null, null);
        Assert.assertTrue((boolean)item1.equals(item2));
        Assert.assertTrue((boolean)item2.equals(item1));
    }

    public void testHashCode() {
        HashSet<Pair<Integer, Integer>> testSet = new HashSet<Pair<Integer, Integer>>();
        Pair<Integer, Integer> item1a = Pair.of(1, 1);
        Pair<Integer, Integer> item1b = Pair.of(1, 1);
        Pair<Integer, Integer> item2 = Pair.of(1, 2);
        Pair<Integer, Integer> item3 = Pair.of(2, 1);
        testSet.add(item1a);
        Assert.assertTrue((boolean)testSet.contains(item1b));
        Assert.assertFalse((boolean)testSet.contains(item2));
        Assert.assertFalse((boolean)testSet.contains(item3));
    }

    public void testHashCodeWithPrimitiveArray() {
        Pair<byte[], byte[]> pair1 = Pair.of(new byte[]{1, 2, 3}, new byte[]{4, 5, 6});
        Pair<byte[], byte[]> pair2 = Pair.of(new byte[]{1, 2, 3}, new byte[]{4, 5, 6});
        Assert.assertEquals((int)pair1.hashCode(), (int)pair2.hashCode());
        Assert.assertFalse((pair1.hashCode() == Pair.of(1, 2).hashCode() ? 1 : 0) != 0);
    }

    public void testHashCodeWithObjectArray() {
        Pair<Object[], Object[]> pair1 = Pair.of(new Object[]{"one", "two", "three"}, new Object[]{"four", "five", "six"});
        Pair<Object[], Object[]> pair2 = Pair.of(new Object[]{"one", "two", "three"}, new Object[]{"four", "five", "six"});
        Assert.assertEquals((int)pair1.hashCode(), (int)pair2.hashCode());
        Assert.assertFalse((pair1.hashCode() == Pair.of(1, 2).hashCode() ? 1 : 0) != 0);
    }

    public void testSerializable() throws IOException, ClassNotFoundException {
        Pair<Integer, String> item1 = Pair.of(5, "bla");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(item1);
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bout.toByteArray()));
        Assert.assertEquals(item1, (Object)in.readObject());
    }
}

