/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.persistence.RowContainer;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.util.ReflectionUtils;

public abstract class CommonJoinOperator<T extends JoinDesc>
extends Operator<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Log LOG = LogFactory.getLog((String)CommonJoinOperator.class.getName());
    protected transient int numAliases;
    protected transient Map<Byte, List<ExprNodeEvaluator>> joinValues;
    protected transient Map<Byte, List<ObjectInspector>> joinValuesObjectInspectors;
    protected transient Map<Byte, List<ObjectInspector>> joinValuesStandardObjectInspectors;
    protected static transient Byte[] order;
    protected transient JoinCondDesc[] condn;
    protected transient boolean noOuterJoin;
    protected transient Object[] dummyObj;
    protected transient RowContainer<ArrayList<Object>>[] dummyObjVectors;
    protected transient int totalSz;
    private transient Map<Integer, Set<String>> posToAliasMap;
    transient LazyBinarySerDe[] spillTableSerDe;
    protected transient Map<Byte, TableDesc> spillTableDesc;
    HashMap<Byte, RowContainer<ArrayList<Object>>> storage;
    int joinEmitInterval = -1;
    int joinCacheSize = 0;
    int nextSz = 0;
    transient Byte lastAlias = null;
    transient boolean handleSkewJoin = false;
    Configuration hconf;
    transient boolean newGroupStarted = false;
    protected transient Byte alias;
    transient Object[] forwardCache;

    public CommonJoinOperator() {
    }

    public CommonJoinOperator(CommonJoinOperator<T> clone) {
        this.joinEmitInterval = clone.joinEmitInterval;
        this.joinCacheSize = clone.joinCacheSize;
        this.nextSz = clone.nextSz;
        this.childOperators = clone.childOperators;
        this.parentOperators = clone.parentOperators;
        this.counterNames = clone.counterNames;
        this.counterNameToEnum = clone.counterNameToEnum;
        this.done = clone.done;
        this.operatorId = clone.operatorId;
        this.storage = clone.storage;
        this.condn = clone.condn;
        this.setSchema(clone.getSchema());
        this.alias = clone.alias;
        this.beginTime = clone.beginTime;
        this.inputRows = clone.inputRows;
        this.childOperatorsArray = clone.childOperatorsArray;
        this.childOperatorsTag = clone.childOperatorsTag;
        this.colExprMap = clone.colExprMap;
        this.counters = clone.counters;
        this.dummyObj = clone.dummyObj;
        this.dummyObjVectors = clone.dummyObjVectors;
        this.forwardCache = clone.forwardCache;
        this.groupKeyObject = clone.groupKeyObject;
        this.handleSkewJoin = clone.handleSkewJoin;
        this.hconf = clone.hconf;
        this.id = clone.id;
        this.inputObjInspectors = clone.inputObjInspectors;
        this.inputRows = clone.inputRows;
        this.noOuterJoin = clone.noOuterJoin;
        this.numAliases = clone.numAliases;
        this.operatorId = clone.operatorId;
        this.posToAliasMap = clone.posToAliasMap;
        this.spillTableDesc = clone.spillTableDesc;
        this.statsMap = clone.statsMap;
    }

    protected int populateJoinKeyValue(Map<Byte, List<ExprNodeEvaluator>> outMap, Map<Byte, List<ExprNodeDesc>> inputMap) {
        int total = 0;
        for (Map.Entry<Byte, List<ExprNodeDesc>> e : inputMap.entrySet()) {
            Byte key = order[e.getKey()];
            List<ExprNodeDesc> expr = e.getValue();
            int sz = expr.size();
            total += sz;
            ArrayList<ExprNodeEvaluator> valueFields = new ArrayList<ExprNodeEvaluator>();
            for (int j = 0; j < sz; ++j) {
                valueFields.add(ExprNodeEvaluatorFactory.get(expr.get(j)));
            }
            outMap.put(key, valueFields);
        }
        return total;
    }

    protected static HashMap<Byte, List<ObjectInspector>> getObjectInspectorsFromEvaluators(Map<Byte, List<ExprNodeEvaluator>> exprEntries, ObjectInspector[] inputObjInspector) throws HiveException {
        HashMap<Byte, List<ObjectInspector>> result = new HashMap<Byte, List<ObjectInspector>>();
        for (Map.Entry<Byte, List<ExprNodeEvaluator>> exprEntry : exprEntries.entrySet()) {
            Byte alias = exprEntry.getKey();
            List<ExprNodeEvaluator> exprList = exprEntry.getValue();
            ArrayList<ObjectInspector> fieldOIList = new ArrayList<ObjectInspector>();
            for (int i = 0; i < exprList.size(); ++i) {
                fieldOIList.add(exprList.get(i).initialize(inputObjInspector[alias]));
            }
            result.put(alias, fieldOIList);
        }
        return result;
    }

    protected static HashMap<Byte, List<ObjectInspector>> getStandardObjectInspectors(Map<Byte, List<ObjectInspector>> aliasToObjectInspectors) {
        HashMap<Byte, List<ObjectInspector>> result = new HashMap<Byte, List<ObjectInspector>>();
        for (Map.Entry<Byte, List<ObjectInspector>> oiEntry : aliasToObjectInspectors.entrySet()) {
            Byte alias = oiEntry.getKey();
            List<ObjectInspector> oiList = oiEntry.getValue();
            ArrayList<ObjectInspector> fieldOIList = new ArrayList<ObjectInspector>(oiList.size());
            for (int i = 0; i < oiList.size(); ++i) {
                fieldOIList.add(ObjectInspectorUtils.getStandardObjectInspector(oiList.get(i), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE));
            }
            result.put(alias, fieldOIList);
        }
        return result;
    }

    protected static <T extends JoinDesc> ObjectInspector getJoinOutputObjectInspector(Byte[] order, Map<Byte, List<ObjectInspector>> aliasToObjectInspectors, T conf) {
        ArrayList<ObjectInspector> structFieldObjectInspectors = new ArrayList<ObjectInspector>();
        for (Byte alias : order) {
            List<ObjectInspector> oiList = aliasToObjectInspectors.get(alias);
            structFieldObjectInspectors.addAll(oiList);
        }
        StandardStructObjectInspector joinOutputObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(conf.getOutputColumnNames(), structFieldObjectInspectors);
        return joinOutputObjectInspector;
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        this.handleSkewJoin = ((JoinDesc)this.conf).getHandleSkewJoin();
        this.hconf = hconf;
        this.totalSz = 0;
        this.storage = new HashMap();
        this.numAliases = ((JoinDesc)this.conf).getExprs().size();
        this.joinValues = new HashMap<Byte, List<ExprNodeEvaluator>>();
        if (order == null) {
            order = ((JoinDesc)this.conf).getTagOrder();
        }
        this.condn = ((JoinDesc)this.conf).getConds();
        this.noOuterJoin = ((JoinDesc)this.conf).isNoOuterJoin();
        this.totalSz = this.populateJoinKeyValue(this.joinValues, ((JoinDesc)this.conf).getExprs());
        this.joinValuesObjectInspectors = CommonJoinOperator.getObjectInspectorsFromEvaluators(this.joinValues, this.inputObjInspectors);
        this.joinValuesStandardObjectInspectors = CommonJoinOperator.getStandardObjectInspectors(this.joinValuesObjectInspectors);
        this.dummyObj = new Object[this.numAliases];
        this.dummyObjVectors = new RowContainer[this.numAliases];
        this.joinEmitInterval = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEJOINEMITINTERVAL);
        this.joinCacheSize = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEJOINCACHESIZE);
        byte pos = 0;
        for (Byte alias : order) {
            int sz = ((JoinDesc)this.conf).getExprs().get(alias).size();
            ArrayList<Object> nr = new ArrayList<Object>(sz);
            for (int j = 0; j < sz; ++j) {
                nr.add(null);
            }
            this.dummyObj[pos] = nr;
            RowContainer values = this.getRowContainer(hconf, pos, alias, 1);
            values.add((ArrayList)this.dummyObj[pos]);
            this.dummyObjVectors[pos] = values;
            RowContainer rc = this.getRowContainer(hconf, pos, alias, this.joinCacheSize);
            this.storage.put(pos, rc);
            pos = (byte)(pos + 1);
        }
        this.forwardCache = new Object[this.totalSz];
        this.outputObjInspector = CommonJoinOperator.getJoinOutputObjectInspector(order, this.joinValuesStandardObjectInspectors, (JoinDesc)this.conf);
        LOG.info((Object)("JOIN " + ((StructObjectInspector)this.outputObjInspector).getTypeName() + " totalsz = " + this.totalSz));
    }

    RowContainer getRowContainer(Configuration hconf, byte pos, Byte alias, int containerSize) throws HiveException {
        TableDesc tblDesc = this.getSpillTableDesc(alias);
        SerDe serde = this.getSpillSerDe(alias);
        if (serde == null) {
            containerSize = 1;
        }
        RowContainer rc = new RowContainer(containerSize, hconf);
        StandardStructObjectInspector rcOI = null;
        if (tblDesc != null) {
            List<String> colNames = Utilities.getColumnNames(tblDesc.getProperties());
            rcOI = ObjectInspectorFactory.getStandardStructObjectInspector(colNames, this.joinValuesStandardObjectInspectors.get(pos));
        }
        rc.setSerDe(serde, rcOI);
        rc.setTableDesc(tblDesc);
        return rc;
    }

    private SerDe getSpillSerDe(byte alias) {
        TableDesc desc = this.getSpillTableDesc(alias);
        if (desc == null) {
            return null;
        }
        SerDe sd = (SerDe)ReflectionUtils.newInstance(desc.getDeserializerClass(), null);
        try {
            sd.initialize(null, desc.getProperties());
        }
        catch (SerDeException e) {
            e.printStackTrace();
            return null;
        }
        return sd;
    }

    public TableDesc getSpillTableDesc(Byte alias) {
        if (this.spillTableDesc == null || this.spillTableDesc.size() == 0) {
            this.initSpillTables();
        }
        return this.spillTableDesc.get(alias);
    }

    public Map<Byte, TableDesc> getSpillTableDesc() {
        if (this.spillTableDesc == null) {
            this.initSpillTables();
        }
        return this.spillTableDesc;
    }

    private void initSpillTables() {
        Map<Byte, List<ExprNodeDesc>> exprs = ((JoinDesc)this.conf).getExprs();
        this.spillTableDesc = new HashMap<Byte, TableDesc>(exprs.size());
        for (int tag = 0; tag < exprs.size(); ++tag) {
            List<ExprNodeDesc> valueCols = exprs.get((byte)tag);
            int columnSize = valueCols.size();
            StringBuilder colNames = new StringBuilder();
            StringBuilder colTypes = new StringBuilder();
            if (columnSize <= 0) continue;
            for (int k = 0; k < columnSize; ++k) {
                String newColName = tag + "_VALUE_" + k;
                colNames.append(newColName);
                colNames.append(',');
                colTypes.append(valueCols.get(k).getTypeString());
                colTypes.append(',');
            }
            colNames.setLength(colNames.length() - 1);
            colTypes.setLength(colTypes.length() - 1);
            TableDesc tblDesc = new TableDesc(LazyBinarySerDe.class, SequenceFileInputFormat.class, HiveSequenceFileOutputFormat.class, Utilities.makeProperties("serialization.format", "1", "columns", colNames.toString(), "columns.types", colTypes.toString()));
            this.spillTableDesc.put((byte)tag, tblDesc);
        }
    }

    @Override
    public void startGroup() throws HiveException {
        LOG.trace((Object)"Join: Starting new group");
        this.newGroupStarted = true;
        for (RowContainer<ArrayList<Object>> alw : this.storage.values()) {
            alw.clear();
        }
    }

    protected int getNextSize(int sz) {
        if (sz >= 100000) {
            return sz + 100000;
        }
        return 2 * sz;
    }

    protected static ArrayList<Object> computeValues(Object row, List<ExprNodeEvaluator> valueFields, List<ObjectInspector> valueFieldsOI) throws HiveException {
        ArrayList<Object> nr = new ArrayList<Object>(valueFields.size());
        for (int i = 0; i < valueFields.size(); ++i) {
            nr.add(ObjectInspectorUtils.copyToStandardObject(valueFields.get(i).evaluate(row), valueFieldsOI.get(i), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE));
        }
        return nr;
    }

    private void createForwardJoinObject(IntermediateObject intObj, boolean[] nullsArr) throws HiveException {
        int p = 0;
        for (int i = 0; i < this.numAliases; ++i) {
            Byte alias = order[i];
            int sz = this.joinValues.get(alias).size();
            if (nullsArr[i]) {
                for (int j = 0; j < sz; ++j) {
                    this.forwardCache[p++] = null;
                }
                continue;
            }
            ArrayList<Object> obj = intObj.getObjs()[i];
            for (int j = 0; j < sz; ++j) {
                this.forwardCache[p++] = obj.get(j);
            }
        }
        this.forward(this.forwardCache, this.outputObjInspector);
    }

    private void copyOldArray(boolean[] src, boolean[] dest) {
        for (int i = 0; i < src.length; ++i) {
            dest[i] = src[i];
        }
    }

    private ArrayList<boolean[]> joinObjectsInnerJoin(ArrayList<boolean[]> resNulls, ArrayList<boolean[]> inputNulls, ArrayList<Object> newObj, IntermediateObject intObj, int left, boolean newObjNull) {
        if (newObjNull) {
            return resNulls;
        }
        for (boolean[] oldNulls : inputNulls) {
            boolean oldObjNull = oldNulls[left];
            if (oldObjNull) continue;
            boolean[] newNulls = new boolean[intObj.getCurSize()];
            this.copyOldArray(oldNulls, newNulls);
            newNulls[oldNulls.length] = false;
            resNulls.add(newNulls);
        }
        return resNulls;
    }

    private ArrayList<boolean[]> joinObjectsLeftSemiJoin(ArrayList<boolean[]> resNulls, ArrayList<boolean[]> inputNulls, ArrayList<Object> newObj, IntermediateObject intObj, int left, boolean newObjNull) {
        if (newObjNull) {
            return resNulls;
        }
        for (boolean[] oldNulls : inputNulls) {
            boolean oldObjNull = oldNulls[left];
            if (oldObjNull) continue;
            boolean[] newNulls = new boolean[intObj.getCurSize()];
            this.copyOldArray(oldNulls, newNulls);
            newNulls[oldNulls.length] = false;
            resNulls.add(newNulls);
        }
        return resNulls;
    }

    private ArrayList<boolean[]> joinObjectsLeftOuterJoin(ArrayList<boolean[]> resNulls, ArrayList<boolean[]> inputNulls, ArrayList<Object> newObj, IntermediateObject intObj, int left, boolean newObjNull) {
        for (boolean[] oldNulls : inputNulls) {
            boolean oldObjNull = oldNulls[left];
            boolean[] newNulls = new boolean[intObj.getCurSize()];
            this.copyOldArray(oldNulls, newNulls);
            newNulls[oldNulls.length] = oldObjNull ? true : newObjNull;
            resNulls.add(newNulls);
        }
        return resNulls;
    }

    private ArrayList<boolean[]> joinObjectsRightOuterJoin(ArrayList<boolean[]> resNulls, ArrayList<boolean[]> inputNulls, ArrayList<Object> newObj, IntermediateObject intObj, int left, boolean newObjNull, boolean firstRow) {
        if (newObjNull) {
            return resNulls;
        }
        if (inputNulls.isEmpty() && firstRow) {
            boolean[] newNulls = new boolean[intObj.getCurSize()];
            for (int i = 0; i < intObj.getCurSize() - 1; ++i) {
                newNulls[i] = true;
            }
            newNulls[intObj.getCurSize() - 1] = newObjNull;
            resNulls.add(newNulls);
            return resNulls;
        }
        boolean allOldObjsNull = firstRow;
        for (boolean[] oldNulls : inputNulls) {
            if (oldNulls[left]) continue;
            allOldObjsNull = false;
            break;
        }
        for (boolean[] oldNulls : inputNulls) {
            boolean[] newNulls;
            boolean oldObjNull = oldNulls[left];
            if (!oldObjNull) {
                newNulls = new boolean[intObj.getCurSize()];
                this.copyOldArray(oldNulls, newNulls);
                newNulls[oldNulls.length] = newObjNull;
                resNulls.add(newNulls);
                continue;
            }
            if (!allOldObjsNull) continue;
            newNulls = new boolean[intObj.getCurSize()];
            for (int i = 0; i < intObj.getCurSize() - 1; ++i) {
                newNulls[i] = true;
            }
            newNulls[oldNulls.length] = newObjNull;
            resNulls.add(newNulls);
            return resNulls;
        }
        return resNulls;
    }

    private ArrayList<boolean[]> joinObjectsFullOuterJoin(ArrayList<boolean[]> resNulls, ArrayList<boolean[]> inputNulls, ArrayList<Object> newObj, IntermediateObject intObj, int left, boolean newObjNull, boolean firstRow) {
        if (newObjNull) {
            for (boolean[] oldNulls : inputNulls) {
                boolean[] newNulls = new boolean[intObj.getCurSize()];
                this.copyOldArray(oldNulls, newNulls);
                newNulls[oldNulls.length] = newObjNull;
                resNulls.add(newNulls);
            }
            return resNulls;
        }
        if (inputNulls.isEmpty() && firstRow) {
            boolean[] newNulls = new boolean[intObj.getCurSize()];
            for (int i = 0; i < intObj.getCurSize() - 1; ++i) {
                newNulls[i] = true;
            }
            newNulls[intObj.getCurSize() - 1] = newObjNull;
            resNulls.add(newNulls);
            return resNulls;
        }
        boolean allOldObjsNull = firstRow;
        for (boolean[] oldNulls : inputNulls) {
            if (oldNulls[left]) continue;
            allOldObjsNull = false;
            break;
        }
        boolean rhsPreserved = false;
        for (boolean[] oldNulls : inputNulls) {
            boolean[] newNulls;
            boolean oldObjNull = oldNulls[left];
            if (!oldObjNull) {
                newNulls = new boolean[intObj.getCurSize()];
                this.copyOldArray(oldNulls, newNulls);
                newNulls[oldNulls.length] = newObjNull;
                resNulls.add(newNulls);
                continue;
            }
            if (!oldObjNull) continue;
            newNulls = new boolean[intObj.getCurSize()];
            this.copyOldArray(oldNulls, newNulls);
            newNulls[oldNulls.length] = true;
            resNulls.add(newNulls);
            if (!allOldObjsNull || rhsPreserved) continue;
            newNulls = new boolean[intObj.getCurSize()];
            for (int i = 0; i < oldNulls.length; ++i) {
                newNulls[i] = true;
            }
            newNulls[oldNulls.length] = false;
            resNulls.add(newNulls);
            rhsPreserved = true;
        }
        return resNulls;
    }

    private ArrayList<boolean[]> joinObjects(ArrayList<boolean[]> inputNulls, ArrayList<Object> newObj, IntermediateObject intObj, int joinPos, boolean firstRow) {
        boolean newObjNull;
        ArrayList<boolean[]> resNulls = new ArrayList<boolean[]>();
        boolean bl = newObjNull = newObj == this.dummyObj[joinPos];
        if (joinPos == 0) {
            if (newObjNull) {
                return null;
            }
            boolean[] nulls = new boolean[]{newObjNull};
            resNulls.add(nulls);
            return resNulls;
        }
        int left = this.condn[joinPos - 1].getLeft();
        int type = this.condn[joinPos - 1].getType();
        if ((type == 2 || type == 3) && !newObjNull && inputNulls == null && firstRow) {
            boolean[] newNulls = new boolean[intObj.getCurSize()];
            for (int i = 0; i < newNulls.length - 1; ++i) {
                newNulls[i] = true;
            }
            newNulls[newNulls.length - 1] = false;
            resNulls.add(newNulls);
            return resNulls;
        }
        if (inputNulls == null) {
            return null;
        }
        if (type == 0) {
            return this.joinObjectsInnerJoin(resNulls, inputNulls, newObj, intObj, left, newObjNull);
        }
        if (type == 1) {
            return this.joinObjectsLeftOuterJoin(resNulls, inputNulls, newObj, intObj, left, newObjNull);
        }
        if (type == 2) {
            return this.joinObjectsRightOuterJoin(resNulls, inputNulls, newObj, intObj, left, newObjNull, firstRow);
        }
        if (type == 5) {
            return this.joinObjectsLeftSemiJoin(resNulls, inputNulls, newObj, intObj, left, newObjNull);
        }
        assert (type == 3);
        return this.joinObjectsFullOuterJoin(resNulls, inputNulls, newObj, intObj, left, newObjNull, firstRow);
    }

    private void genObject(ArrayList<boolean[]> inputNulls, int aliasNum, IntermediateObject intObj, boolean firstRow) throws HiveException {
        boolean childFirstRow = firstRow;
        boolean skipping = false;
        if (aliasNum < this.numAliases) {
            RowContainer<ArrayList<Object>> aliasRes = this.storage.get(order[aliasNum]);
            ArrayList<Object> newObj = aliasRes.first();
            while (newObj != null) {
                if (aliasNum > 0 && this.condn[aliasNum - 1].getType() == 5 && newObj != this.dummyObj[aliasNum]) {
                    skipping = true;
                }
                intObj.pushObj(newObj);
                ArrayList<boolean[]> newNulls = this.joinObjects(inputNulls, newObj, intObj, aliasNum, childFirstRow);
                this.genObject(newNulls, aliasNum + 1, intObj, firstRow);
                intObj.popObj();
                firstRow = false;
                if (!skipping) {
                    newObj = aliasRes.next();
                    continue;
                }
                break;
            }
        } else {
            if (inputNulls == null) {
                return;
            }
            for (boolean[] nullsVec : inputNulls) {
                this.createForwardJoinObject(intObj, nullsVec);
            }
        }
    }

    @Override
    public void endGroup() throws HiveException {
        LOG.trace((Object)("Join Op: endGroup called: numValues=" + this.numAliases));
        this.checkAndGenObject();
    }

    private void genUniqueJoinObject(int aliasNum, IntermediateObject intObj) throws HiveException {
        if (aliasNum == this.numAliases) {
            int p = 0;
            for (int i = 0; i < this.numAliases; ++i) {
                int sz = this.joinValues.get(order[i]).size();
                ArrayList<Object> obj = intObj.getObjs()[i];
                for (int j = 0; j < sz; ++j) {
                    this.forwardCache[p++] = obj.get(j);
                }
            }
            this.forward(this.forwardCache, this.outputObjInspector);
            return;
        }
        RowContainer<ArrayList<Object>> alias = this.storage.get(order[aliasNum]);
        ArrayList<Object> row = alias.first();
        while (row != null) {
            intObj.pushObj(row);
            this.genUniqueJoinObject(aliasNum + 1, intObj);
            intObj.popObj();
            row = alias.next();
        }
    }

    protected void checkAndGenObject() throws HiveException {
        if (this.condn[0].getType() == 4) {
            new IntermediateObject(new ArrayList[this.numAliases], 0);
            boolean preserve = false;
            boolean hasNulls = false;
            for (int i = 0; i < this.numAliases; ++i) {
                Byte alias = order[i];
                RowContainer<ArrayList<Object>> alw = this.storage.get(alias);
                if (alw.size() == 0) {
                    alw.add((ArrayList)this.dummyObj[i]);
                    hasNulls = true;
                    continue;
                }
                if (!this.condn[i].getPreserved()) continue;
                preserve = true;
            }
            if (hasNulls && !preserve) {
                return;
            }
            LOG.trace((Object)"calling genUniqueJoinObject");
            this.genUniqueJoinObject(0, new IntermediateObject(new ArrayList[this.numAliases], 0));
            LOG.trace((Object)"called genUniqueJoinObject");
        } else {
            for (int i = 0; i < this.numAliases; ++i) {
                Byte alias = order[i];
                RowContainer<ArrayList<Object>> alw = this.storage.get(alias);
                if (alw.size() != 0) continue;
                if (this.noOuterJoin) {
                    LOG.trace((Object)("No data for alias=" + i));
                    return;
                }
                alw.add((ArrayList)this.dummyObj[i]);
            }
            LOG.trace((Object)"calling genObject");
            this.genObject(null, 0, new IntermediateObject(new ArrayList[this.numAliases], 0), true);
            LOG.trace((Object)"called genObject");
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        LOG.trace((Object)"Join Op close");
        for (RowContainer<ArrayList<Object>> alw : this.storage.values()) {
            if (alw == null) continue;
            alw.clear();
        }
        this.storage.clear();
    }

    @Override
    public String getName() {
        return "JOIN";
    }

    public Map<Integer, Set<String>> getPosToAliasMap() {
        return this.posToAliasMap;
    }

    public void setPosToAliasMap(Map<Integer, Set<String>> posToAliasMap) {
        this.posToAliasMap = posToAliasMap;
    }

    public static class IntermediateObject {
        ArrayList<Object>[] objs;
        int curSize;

        public IntermediateObject(ArrayList<Object>[] objs, int curSize) {
            this.objs = objs;
            this.curSize = curSize;
        }

        public ArrayList<Object>[] getObjs() {
            return this.objs;
        }

        public int getCurSize() {
            return this.curSize;
        }

        public void pushObj(ArrayList<Object> newObj) {
            this.objs[this.curSize++] = newObj;
        }

        public void popObj() {
            --this.curSize;
        }

        public Object topObj() {
            return this.objs[this.curSize - 1];
        }
    }
}

