/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.ExecMapper;
import org.apache.hadoop.hive.ql.exec.ExecReducer;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.JobCloseFeedBack;
import org.apache.hadoop.hive.ql.exec.JobTrackerURLResolver;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskHandle;
import org.apache.hadoop.hive.ql.exec.Throttle;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.errors.ErrorAndSolution;
import org.apache.hadoop.hive.ql.exec.errors.TaskLogProcessor;
import org.apache.hadoop.hive.ql.history.HiveHistory;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.varia.NullAppender;

public class ExecDriver
extends Task<MapredWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient JobConf job;
    protected transient int mapProgress = 0;
    protected transient int reduceProgress = 0;
    protected transient boolean success = false;
    public static Random randGen = new Random();
    public static Map<String, String> runningJobKillURIs = Collections.synchronizedMap(new HashMap());

    public ExecDriver() {
    }

    public static String getResourceFiles(Configuration conf, SessionState.ResourceType t) {
        Set<String> files;
        SessionState ss = SessionState.get();
        Set<String> set = files = ss == null ? null : ss.list_resource(t, null);
        if (files != null) {
            ArrayList<String> realFiles = new ArrayList<String>(files.size());
            for (String one : files) {
                try {
                    realFiles.add(Utilities.realFile(one, conf));
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot validate file " + one + "due to exception: " + e.getMessage(), e);
                }
            }
            return StringUtils.join(realFiles, ",");
        }
        return "";
    }

    private void initializeFiles(String prop, String files) {
        if (files != null && files.length() > 0) {
            this.job.set(prop, files);
            ShimLoader.getHadoopShims().setTmpFiles(prop, files);
        }
    }

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan, DriverContext driverContext) {
        String addedArchives;
        String addedJars;
        super.initialize(conf, queryPlan, driverContext);
        this.job = new JobConf((Configuration)conf, ExecDriver.class);
        String addedFiles = ExecDriver.getResourceFiles((Configuration)this.job, SessionState.ResourceType.FILE);
        if (StringUtils.isNotBlank(addedFiles)) {
            HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.HIVEADDEDFILES, addedFiles);
        }
        if (StringUtils.isNotBlank(addedJars = ExecDriver.getResourceFiles((Configuration)this.job, SessionState.ResourceType.JAR))) {
            HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.HIVEADDEDJARS, addedJars);
        }
        if (StringUtils.isNotBlank(addedArchives = ExecDriver.getResourceFiles((Configuration)this.job, SessionState.ResourceType.ARCHIVE))) {
            HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.HIVEADDEDARCHIVES, addedArchives);
        }
    }

    public ExecDriver(MapredWork plan, JobConf job, boolean isSilent) throws HiveException {
        this.setWork(plan);
        this.job = job;
        this.LOG = LogFactory.getLog((String)this.getClass().getName());
        this.console = new SessionState.LogHelper(this.LOG, isSilent);
    }

    public void jobInfo(RunningJob rj) {
        if (this.job.get("mapred.job.tracker", "local").equals("local")) {
            this.console.printInfo("Job running in-process (local Hadoop)");
        } else {
            String hp = this.job.get("mapred.job.tracker");
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().setTaskProperty(SessionState.get().getQueryId(), this.getId(), HiveHistory.Keys.TASK_HADOOP_ID, rj.getJobID());
            }
            this.console.printInfo(ExecDriver.getJobStartMsg(rj.getJobID()) + ", Tracking URL = " + rj.getTrackingURL());
            this.console.printInfo("Kill Command = " + HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HADOOPBIN) + " job  -Dmapred.job.tracker=" + hp + " -kill " + rj.getJobID());
        }
    }

    protected boolean checkFatalErrors(TaskHandle t, StringBuilder errMsg) {
        ExecDriverTaskHandle th = (ExecDriverTaskHandle)t;
        RunningJob rj = th.getRunningJob();
        try {
            Counters ctrs = th.getCounters();
            for (Operator<? extends Serializable> op : ((MapredWork)this.work).getAliasToWork().values()) {
                if (!op.checkFatalErrors(ctrs, errMsg)) continue;
                return true;
            }
            return ((MapredWork)this.work).getReducer() != null && ((MapredWork)this.work).getReducer().checkFatalErrors(ctrs, errMsg);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void progress(TaskHandle taskHandle) throws IOException {
        ExecDriverTaskHandle th = (ExecDriverTaskHandle)taskHandle;
        JobClient jc = th.getJobClient();
        RunningJob rj = th.getRunningJob();
        String lastReport = "";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        long reportTime = System.currentTimeMillis();
        long maxReportInterval = 60000L;
        boolean fatal = false;
        StringBuilder errMsg = new StringBuilder();
        long pullInterval = HiveConf.getLongVar((Configuration)this.job, HiveConf.ConfVars.HIVECOUNTERSPULLINTERVAL);
        boolean initializing = true;
        while (!rj.isComplete()) {
            try {
                Thread.sleep(pullInterval);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (initializing && ShimLoader.getHadoopShims().isJobPreparing(rj)) continue;
            initializing = false;
            th.setRunningJob(jc.getJob(rj.getJobID()));
            if (fatal) continue;
            fatal = this.checkFatalErrors(th, errMsg);
            if (fatal) {
                this.success = false;
                this.console.printError("[Fatal Error] " + errMsg.toString() + ". Killing the job.");
                rj.killJob();
                continue;
            }
            errMsg.setLength(0);
            this.updateCounters(th);
            String report = " " + this.getId() + " map = " + this.mapProgress + "%,  reduce = " + this.reduceProgress + "%";
            if (report.equals(lastReport) && System.currentTimeMillis() < reportTime + maxReportInterval) continue;
            String output = dateFormat.format(Calendar.getInstance().getTime()) + report;
            SessionState ss = SessionState.get();
            if (ss != null) {
                ss.getHiveHistory().setTaskCounters(SessionState.get().getQueryId(), this.getId(), rj);
                ss.getHiveHistory().setTaskProperty(SessionState.get().getQueryId(), this.getId(), HiveHistory.Keys.TASK_HADOOP_PROGRESS, output);
                ss.getHiveHistory().progressTask(SessionState.get().getQueryId(), this);
                ss.getHiveHistory().logPlanProgress(this.queryPlan);
            }
            this.console.printInfo(output);
            lastReport = report;
            reportTime = System.currentTimeMillis();
        }
        if (!fatal && (fatal = this.checkFatalErrors(th, errMsg))) {
            this.console.printError("[Fatal Error] " + errMsg.toString());
            this.success = false;
        } else {
            this.success = rj.isSuccessful();
        }
        this.setDone();
        th.setRunningJob(jc.getJob(rj.getJobID()));
        this.updateCounters(th);
        SessionState ss = SessionState.get();
        if (ss != null) {
            ss.getHiveHistory().logPlanProgress(this.queryPlan);
        }
    }

    public int estimateNumberOfReducers(HiveConf hive, JobConf job, MapredWork work) throws IOException {
        if (hive == null) {
            hive = new HiveConf();
        }
        long bytesPerReducer = hive.getLongVar(HiveConf.ConfVars.BYTESPERREDUCER);
        int maxReducers = hive.getIntVar(HiveConf.ConfVars.MAXREDUCERS);
        long totalInputFileSize = this.getTotalInputFileSize(job, work);
        this.LOG.info((Object)("BytesPerReducer=" + bytesPerReducer + " maxReducers=" + maxReducers + " totalInputFileSize=" + totalInputFileSize));
        int reducers = (int)((totalInputFileSize + bytesPerReducer - 1L) / bytesPerReducer);
        reducers = Math.max(1, reducers);
        reducers = Math.min(maxReducers, reducers);
        return reducers;
    }

    protected void setNumberOfReducers() throws IOException {
        Integer numReducersFromWork = ((MapredWork)this.work).getNumReduceTasks();
        if (((MapredWork)this.work).getReducer() == null) {
            this.console.printInfo("Number of reduce tasks is set to 0 since there's no reduce operator");
            ((MapredWork)this.work).setNumReduceTasks(0);
        } else {
            if (numReducersFromWork >= 0) {
                this.console.printInfo("Number of reduce tasks determined at compile time: " + ((MapredWork)this.work).getNumReduceTasks());
            } else if (this.job.getNumReduceTasks() > 0) {
                int reducers = this.job.getNumReduceTasks();
                ((MapredWork)this.work).setNumReduceTasks(reducers);
                this.console.printInfo("Number of reduce tasks not specified. Defaulting to jobconf value of: " + reducers);
            } else {
                int reducers = this.estimateNumberOfReducers(this.conf, this.job, (MapredWork)this.work);
                ((MapredWork)this.work).setNumReduceTasks(reducers);
                this.console.printInfo("Number of reduce tasks not specified. Estimated from input data size: " + reducers);
            }
            this.console.printInfo("In order to change the average load for a reducer (in bytes):");
            this.console.printInfo("  set " + HiveConf.ConfVars.BYTESPERREDUCER.varname + "=<number>");
            this.console.printInfo("In order to limit the maximum number of reducers:");
            this.console.printInfo("  set " + HiveConf.ConfVars.MAXREDUCERS.varname + "=<number>");
            this.console.printInfo("In order to set a constant number of reducers:");
            this.console.printInfo("  set " + (Object)((Object)HiveConf.ConfVars.HADOOPNUMREDUCERS) + "=<number>");
        }
    }

    public long getTotalInputFileSize(JobConf job, MapredWork work) throws IOException {
        long r = 0L;
        for (String path : work.getPathToAliases().keySet()) {
            try {
                Path p = new Path(path);
                FileSystem fs = p.getFileSystem((Configuration)job);
                ContentSummary cs = fs.getContentSummary(p);
                r += cs.getLength();
            }
            catch (IOException e) {
                this.LOG.info((Object)("Cannot get size of " + path + ". Safely ignored."));
            }
        }
        return r;
    }

    @Override
    public void updateCounters(TaskHandle t) throws IOException {
        ExecDriverTaskHandle th = (ExecDriverTaskHandle)t;
        RunningJob rj = th.getRunningJob();
        this.mapProgress = Math.round(rj.mapProgress() * 100.0f);
        this.reduceProgress = Math.round(rj.reduceProgress() * 100.0f);
        this.taskCounters.put("CNTR_NAME_" + this.getId() + "_MAP_PROGRESS", Long.valueOf(this.mapProgress));
        this.taskCounters.put("CNTR_NAME_" + this.getId() + "_REDUCE_PROGRESS", Long.valueOf(this.reduceProgress));
        Counters ctrs = th.getCounters();
        for (Operator<? extends Serializable> op : ((MapredWork)this.work).getAliasToWork().values()) {
            op.updateCounters(ctrs);
        }
        if (((MapredWork)this.work).getReducer() != null) {
            ((MapredWork)this.work).getReducer().updateCounters(ctrs);
        }
    }

    public boolean mapStarted() {
        return this.mapProgress > 0;
    }

    public boolean reduceStarted() {
        return this.reduceProgress > 0;
    }

    public boolean mapDone() {
        return this.mapProgress == 100;
    }

    public boolean reduceDone() {
        return this.reduceProgress == 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(DriverContext driverContext) {
        int returnVal;
        block45: {
            String addedArchives;
            String addedFiles;
            this.success = true;
            try {
                this.setNumberOfReducers();
            }
            catch (IOException e) {
                String statusMesg = "IOException while accessing HDFS to estimate the number of reducers: " + e.getMessage();
                this.console.printError(statusMesg, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                return 1;
            }
            String invalidReason = ((MapredWork)this.work).isInvalid();
            if (invalidReason != null) {
                throw new RuntimeException("Plan invalid, Reason: " + invalidReason);
            }
            String hiveScratchDir = driverContext.getCtx() != null && driverContext.getCtx().getQueryPath() != null ? driverContext.getCtx().getQueryPath().toString() : HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.SCRATCHDIR);
            String emptyScratchDirStr = null;
            Path emptyScratchDir = null;
            for (int numTries = 3; numTries > 0; --numTries) {
                emptyScratchDirStr = hiveScratchDir + File.separator + Utilities.randGen.nextInt();
                emptyScratchDir = new Path(emptyScratchDirStr);
                try {
                    FileSystem fs = emptyScratchDir.getFileSystem((Configuration)this.job);
                    fs.mkdirs(emptyScratchDir);
                    break;
                }
                catch (Exception e) {
                    if (numTries > 0) {
                        continue;
                    }
                    throw new RuntimeException("Failed to make dir " + emptyScratchDir.toString() + " : " + e.getMessage());
                }
            }
            ShimLoader.getHadoopShims().setNullOutputFormat(this.job);
            this.job.setMapperClass(ExecMapper.class);
            this.job.setMapOutputKeyClass(HiveKey.class);
            this.job.setMapOutputValueClass(BytesWritable.class);
            try {
                this.job.setPartitionerClass(Class.forName(HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HIVEPARTITIONER)));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.getMessage());
            }
            if (((MapredWork)this.work).getNumMapTasks() != null) {
                this.job.setNumMapTasks(((MapredWork)this.work).getNumMapTasks().intValue());
            }
            if (((MapredWork)this.work).getMinSplitSize() != null) {
                HiveConf.setIntVar((Configuration)this.job, HiveConf.ConfVars.MAPREDMINSPLITSIZE, ((MapredWork)this.work).getMinSplitSize());
            }
            this.job.setNumReduceTasks(((MapredWork)this.work).getNumReduceTasks().intValue());
            this.job.setReducerClass(ExecReducer.class);
            if (((MapredWork)this.work).getInputformat() != null) {
                HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.HIVEINPUTFORMAT, ((MapredWork)this.work).getInputformat());
            }
            boolean useSpeculativeExecReducers = HiveConf.getBoolVar((Configuration)this.job, HiveConf.ConfVars.HIVESPECULATIVEEXECREDUCERS);
            HiveConf.setBoolVar((Configuration)this.job, HiveConf.ConfVars.HADOOPSPECULATIVEEXECREDUCERS, useSpeculativeExecReducers);
            String inpFormat = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HIVEINPUTFORMAT);
            if (inpFormat == null || !StringUtils.isNotBlank(inpFormat)) {
                inpFormat = ShimLoader.getHadoopShims().getInputFormatClassName();
            }
            this.LOG.info((Object)("Using " + inpFormat));
            try {
                this.job.setInputFormat(Class.forName(inpFormat));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.getMessage());
            }
            this.job.setOutputKeyClass(Text.class);
            this.job.setOutputValueClass(Text.class);
            String auxJars = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HIVEAUXJARS);
            String addedJars = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HIVEADDEDJARS);
            if (StringUtils.isNotBlank(auxJars) || StringUtils.isNotBlank(addedJars)) {
                String allJars = StringUtils.isNotBlank(auxJars) ? (StringUtils.isNotBlank(addedJars) ? addedJars + "," + auxJars : auxJars) : addedJars;
                this.LOG.info((Object)("adding libjars: " + allJars));
                this.initializeFiles("tmpjars", allJars);
            }
            if (StringUtils.isNotBlank(addedFiles = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HIVEADDEDFILES))) {
                this.initializeFiles("tmpfiles", addedFiles);
            }
            if (StringUtils.isNotBlank(addedArchives = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HIVEADDEDARCHIVES))) {
                this.initializeFiles("tmparchives", addedArchives);
            }
            returnVal = 0;
            RunningJob rj = null;
            RunningJob orig_rj = null;
            boolean noName = StringUtils.isEmpty(HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HADOOPJOBNAME));
            if (noName) {
                HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.HADOOPJOBNAME, "JOB" + randGen.nextInt());
            }
            try {
                this.addInputPaths(this.job, (MapredWork)this.work, emptyScratchDirStr);
                Utilities.setMapRedWork((Configuration)this.job, (MapredWork)this.work, hiveScratchDir);
                String pwd = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.METASTOREPWD);
                if (pwd != null) {
                    HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.METASTOREPWD, "HIVE");
                }
                JobClient jc = new JobClient(this.job);
                Throttle.checkJobTracker(this.job, this.LOG);
                orig_rj = rj = jc.submitJob(this.job);
                if (pwd != null) {
                    HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.METASTOREPWD, pwd);
                }
                runningJobKillURIs.put(rj.getJobID(), rj.getTrackingURL() + "&action=kill");
                ExecDriverTaskHandle th = new ExecDriverTaskHandle(jc, rj);
                this.jobInfo(rj);
                this.progress(th);
                if (rj == null) {
                    rj = orig_rj;
                    this.success = false;
                }
                String statusMesg = ExecDriver.getJobEndMsg(rj.getJobID());
                if (!this.success) {
                    statusMesg = statusMesg + " with errors";
                    returnVal = 2;
                    this.console.printError(statusMesg);
                    if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.SHOW_JOB_FAIL_DEBUG_INFO)) {
                        this.showJobFailDebugInfo(this.job, rj);
                    }
                } else {
                    this.console.printInfo(statusMesg);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                String mesg = " with exception '" + Utilities.getNameMessage(e) + "'";
                mesg = rj != null ? "Ended Job = " + rj.getJobID() + mesg : "Job Submission failed" + mesg;
                this.console.printError(mesg, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                this.success = false;
                returnVal = 1;
            }
            finally {
                Utilities.clearMapRedWork((Configuration)this.job);
                try {
                    emptyScratchDir.getFileSystem((Configuration)this.job).delete(emptyScratchDir, true);
                    if (returnVal != 0 && rj != null) {
                        rj.killJob();
                    }
                    runningJobKillURIs.remove(rj.getJobID());
                }
                catch (Exception e) {}
            }
            ArrayList<String> dpPaths = new ArrayList<String>();
            try {
                if (rj != null) {
                    JobCloseFeedBack feedBack = new JobCloseFeedBack();
                    if (((MapredWork)this.work).getAliasToWork() != null) {
                        for (Operator<? extends Serializable> op : ((MapredWork)this.work).getAliasToWork().values()) {
                            op.jobClose((Configuration)this.job, this.success, feedBack);
                            ArrayList<Object> dirs = feedBack.get(JobCloseFeedBack.FeedBackType.DYNAMIC_PARTITIONS);
                            if (dirs == null) continue;
                            for (Object o : dirs) {
                                if (!(o instanceof String)) continue;
                                dpPaths.add((String)o);
                            }
                        }
                    }
                    if (((MapredWork)this.work).getReducer() != null) {
                        ((MapredWork)this.work).getReducer().jobClose((Configuration)this.job, this.success, feedBack);
                    }
                }
            }
            catch (Exception e) {
                if (!this.success) break block45;
                this.success = false;
                returnVal = 3;
                String mesg = "Job Commit failed with exception '" + Utilities.getNameMessage(e) + "'";
                this.console.printError(mesg, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            }
        }
        return returnVal;
    }

    public static String getJobStartMsg(String jobId) {
        return "Starting Job = " + jobId;
    }

    public static String getJobEndMsg(String jobId) {
        return "Ended Job = " + jobId;
    }

    private String getTaskAttemptLogUrl(String taskTrackerHttpAddress, String taskAttemptId) {
        return taskTrackerHttpAddress + "/tasklog?taskid=" + taskAttemptId + "&all=true";
    }

    private void showJobFailDebugInfo(JobConf conf, RunningJob rj) throws IOException {
        TaskCompletionEvent[] taskCompletions;
        HashMap<String, Integer> failures = new HashMap<String, Integer>();
        HashSet<String> successes = new HashSet<String>();
        HashMap<String, TaskInfo> taskIdToInfo = new HashMap<String, TaskInfo>();
        int startIndex = 0;
        while ((taskCompletions = rj.getTaskCompletionEvents(startIndex)) != null && taskCompletions.length != 0) {
            boolean more = true;
            for (TaskCompletionEvent t : taskCompletions) {
                String[] taskJobIds = ShimLoader.getHadoopShims().getTaskJobIDs(t);
                if (taskJobIds == null) {
                    this.console.printError("Task attempt info is unavailable in this Hadoop version");
                    more = false;
                    break;
                }
                String taskId = taskJobIds[0];
                String jobId = taskJobIds[1];
                TaskInfo ti = (TaskInfo)taskIdToInfo.get(taskId);
                if (ti == null) {
                    ti = new TaskInfo(jobId);
                    taskIdToInfo.put(taskId, ti);
                }
                assert (ti.getJobId() == jobId);
                ti.getLogUrls().add(this.getTaskAttemptLogUrl(t.getTaskTrackerHttp(), t.getTaskId()));
                if (t.getTaskStatus() != TaskCompletionEvent.Status.SUCCEEDED) {
                    Integer failAttempts = (Integer)failures.get(taskId);
                    if (failAttempts == null) {
                        failAttempts = 0;
                    }
                    failAttempts = failAttempts + 1;
                    failures.put(taskId, failAttempts);
                    continue;
                }
                successes.add(taskId);
            }
            if (!more) break;
            startIndex += taskCompletions.length;
        }
        for (String task : successes) {
            failures.remove(task);
        }
        if (failures.keySet().size() == 0) {
            return;
        }
        int maxFailures = 0;
        for (Integer failCount : failures.values()) {
            if (maxFailures >= failCount) continue;
            maxFailures = failCount;
        }
        String jtUrl = JobTrackerURLResolver.getURL(conf);
        for (String task : failures.keySet()) {
            if ((Integer)failures.get(task) != maxFailures) continue;
            TaskInfo ti = (TaskInfo)taskIdToInfo.get(task);
            String jobId = ti.getJobId();
            String taskUrl = jtUrl + "/taskdetails.jsp?jobid=" + jobId + "&tipid=" + task.toString();
            TaskLogProcessor tlp = new TaskLogProcessor(conf);
            for (String logUrl : ti.getLogUrls()) {
                tlp.addTaskAttemptLogUrl(logUrl);
            }
            List<ErrorAndSolution> errors = tlp.getErrors();
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            sb.append("Task with the most failures(" + maxFailures + "): \n");
            sb.append("-----\n");
            sb.append("Task ID:\n  " + task + "\n\n");
            sb.append("URL:\n  " + taskUrl + "\n");
            for (ErrorAndSolution e : errors) {
                sb.append("\n");
                sb.append("Possible error:\n  " + e.getError() + "\n\n");
                sb.append("Solution:\n  " + e.getSolution() + "\n");
            }
            sb.append("-----\n");
            this.console.printError(sb.toString());
            break;
        }
    }

    private static void printUsage() {
        System.err.println("ExecDriver -plan <plan-file> [-jobconf k1=v1 [-jobconf k2=v2] ...] [-files <file1>[,<file2>] ...]");
        System.exit(1);
    }

    private static void setupChildLog4j(Configuration conf) {
        URL hive_l4j = ExecDriver.class.getClassLoader().getResource("hive-exec-log4j.properties");
        if (hive_l4j == null) {
            hive_l4j = ExecDriver.class.getClassLoader().getResource("hive-log4j.properties");
        }
        if (hive_l4j != null) {
            System.setProperty(HiveConf.ConfVars.HIVEQUERYID.toString(), HiveConf.getVar(conf, HiveConf.ConfVars.HIVEQUERYID));
            LogManager.resetConfiguration();
            PropertyConfigurator.configure((URL)hive_l4j);
        }
    }

    public static void main(String[] args) throws IOException, HiveException {
        FileInputStream pathData;
        String planFileName = null;
        ArrayList<String> jobConfArgs = new ArrayList<String>();
        boolean noLog = false;
        String files = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-plan")) {
                    planFileName = args[++i];
                    continue;
                }
                if (args[i].equals("-jobconf")) {
                    jobConfArgs.add(args[++i]);
                    continue;
                }
                if (args[i].equals("-nolog")) {
                    noLog = true;
                    continue;
                }
                if (!args[i].equals("-files")) continue;
                files = args[++i];
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("Missing argument to option");
            ExecDriver.printUsage();
        }
        JobConf conf = new JobConf(ExecDriver.class);
        StringBuilder sb = new StringBuilder("JobConf:\n");
        for (String one : jobConfArgs) {
            int eqIndex = one.indexOf(61);
            if (eqIndex == -1) continue;
            try {
                String key = one.substring(0, eqIndex);
                String value = URLDecoder.decode(one.substring(eqIndex + 1), "UTF-8");
                conf.set(key, value);
                sb.append(key).append("=").append(value).append("\n");
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("Unexpected error " + e.getMessage() + " while encoding " + one.substring(eqIndex + 1));
                System.exit(3);
            }
        }
        if (files != null) {
            conf.set("tmpfiles", files);
        }
        boolean isSilent = HiveConf.getBoolVar((Configuration)conf, HiveConf.ConfVars.HIVESESSIONSILENT);
        if (noLog) {
            BasicConfigurator.resetConfiguration();
            BasicConfigurator.configure((Appender)new NullAppender());
        } else {
            ExecDriver.setupChildLog4j((Configuration)conf);
        }
        Log LOG = LogFactory.getLog((String)ExecDriver.class.getName());
        SessionState.LogHelper console = new SessionState.LogHelper(LOG, isSilent);
        if (planFileName == null) {
            console.printError("Must specify Plan File Name");
            ExecDriver.printUsage();
        }
        console.printInfo("plan = " + planFileName);
        LOG.info((Object)sb.toString());
        URI pathURI = new Path(planFileName).toUri();
        if (StringUtils.isEmpty(pathURI.getScheme())) {
            pathData = new FileInputStream(planFileName);
        } else {
            FileSystem fs = FileSystem.get((Configuration)conf);
            pathData = fs.open(new Path(planFileName));
        }
        String auxJars = HiveConf.getVar((Configuration)conf, HiveConf.ConfVars.HIVEAUXJARS);
        String addedJars = HiveConf.getVar((Configuration)conf, HiveConf.ConfVars.HIVEADDEDJARS);
        try {
            ClassLoader loader = conf.getClassLoader();
            if (StringUtils.isNotBlank(auxJars)) {
                loader = Utilities.addToClassPath(loader, StringUtils.split(auxJars, ","));
            }
            if (StringUtils.isNotBlank(addedJars)) {
                loader = Utilities.addToClassPath(loader, StringUtils.split(addedJars, ","));
            }
            conf.setClassLoader(loader);
            Thread.currentThread().setContextClassLoader(loader);
        }
        catch (Exception e) {
            throw new HiveException(e.getMessage(), e);
        }
        MapredWork plan = Utilities.deserializeMapRedWork(pathData, (Configuration)conf);
        ExecDriver ed = new ExecDriver(plan, conf, isSilent);
        int ret = ed.execute(new DriverContext());
        if (ret != 0) {
            System.exit(2);
        }
    }

    public static String generateCmdLine(HiveConf hconf) {
        try {
            StringBuilder sb = new StringBuilder();
            Properties deltaP = hconf.getChangedProperties();
            boolean hadoopLocalMode = hconf.getVar(HiveConf.ConfVars.HADOOPJT).equals("local");
            String hadoopSysDir = "mapred.system.dir";
            String hadoopWorkDir = "mapred.local.dir";
            for (Object one : deltaP.keySet()) {
                String oneProp = (String)one;
                if (hadoopLocalMode && (oneProp.equals(hadoopSysDir) || oneProp.equals(hadoopWorkDir))) continue;
                String oneValue = deltaP.getProperty(oneProp);
                sb.append("-jobconf ");
                sb.append(oneProp);
                sb.append("=");
                sb.append(URLEncoder.encode(oneValue, "UTF-8"));
                sb.append(" ");
            }
            if (hadoopLocalMode) {
                sb.append("-jobconf ");
                sb.append(hadoopSysDir);
                sb.append("=");
                sb.append(URLEncoder.encode(hconf.get(hadoopSysDir) + "/" + Utilities.randGen.nextInt(), "UTF-8"));
                sb.append(" ");
                sb.append("-jobconf ");
                sb.append(hadoopWorkDir);
                sb.append("=");
                sb.append(URLEncoder.encode(hconf.get(hadoopWorkDir) + "/" + Utilities.randGen.nextInt(), "UTF-8"));
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isMapRedTask() {
        return true;
    }

    @Override
    public boolean hasReduce() {
        MapredWork w = (MapredWork)this.getWork();
        return w.getReducer() != null;
    }

    private boolean isEmptyPath(JobConf job, String path) throws Exception {
        FileStatus[] fStats;
        Path dirPath = new Path(path);
        FileSystem inpFs = dirPath.getFileSystem((Configuration)job);
        return !inpFs.exists(dirPath) || (fStats = inpFs.listStatus(dirPath)).length <= 0;
    }

    private int addInputPath(String path, JobConf job, MapredWork work, String hiveScratchDir, int numEmptyPaths, boolean isEmptyPath, String alias) throws Exception {
        assert (path == null || isEmptyPath);
        Class<? extends HiveOutputFormat> outFileFormat = null;
        boolean nonNative = true;
        if (isEmptyPath) {
            PartitionDesc partDesc = work.getPathToPartitionInfo().get(path);
            outFileFormat = partDesc.getOutputFileFormatClass();
            nonNative = partDesc.getTableDesc().isNonNative();
        } else {
            TableDesc tableDesc = work.getAliasToPartnInfo().get(alias).getTableDesc();
            outFileFormat = tableDesc.getOutputFileFormatClass();
            nonNative = tableDesc.isNonNative();
        }
        if (nonNative) {
            FileInputFormat.addInputPaths((JobConf)job, (String)path);
            this.LOG.info((Object)("Add a non-native table " + path));
            return numEmptyPaths;
        }
        String newDir = hiveScratchDir + File.separator + ++numEmptyPaths;
        Path newPath = new Path(newDir);
        FileSystem fs = newPath.getFileSystem((Configuration)job);
        fs.mkdirs(newPath);
        String newFile = newDir + File.separator + "emptyFile";
        Path newFilePath = new Path(newFile);
        this.LOG.info((Object)("Changed input file to " + newPath.toString()));
        LinkedHashMap<String, ArrayList<String>> pathToAliases = work.getPathToAliases();
        if (isEmptyPath) {
            assert (path != null);
            pathToAliases.put(newPath.toUri().toString(), pathToAliases.get(path));
            pathToAliases.remove(path);
        } else {
            assert (path == null);
            ArrayList<String> newList = new ArrayList<String>();
            newList.add(alias);
            pathToAliases.put(newPath.toUri().toString(), newList);
        }
        work.setPathToAliases(pathToAliases);
        LinkedHashMap<String, PartitionDesc> pathToPartitionInfo = work.getPathToPartitionInfo();
        if (isEmptyPath) {
            pathToPartitionInfo.put(newPath.toUri().toString(), pathToPartitionInfo.get(path));
            pathToPartitionInfo.remove(path);
        } else {
            PartitionDesc pDesc = work.getAliasToPartnInfo().get(alias).clone();
            pathToPartitionInfo.put(newPath.toUri().toString(), pDesc);
        }
        work.setPathToPartitionInfo(pathToPartitionInfo);
        String onefile = newPath.toString();
        FileSinkOperator.RecordWriter recWriter = outFileFormat.newInstance().getHiveRecordWriter(job, newFilePath, Text.class, false, new Properties(), null);
        recWriter.close(false);
        FileInputFormat.addInputPaths((JobConf)job, (String)onefile);
        return numEmptyPaths;
    }

    private void addInputPaths(JobConf job, MapredWork work, String hiveScratchDir) throws Exception {
        int numEmptyPaths = 0;
        ArrayList<String> pathsProcessed = new ArrayList<String>();
        for (String oneAlias : work.getAliasToWork().keySet()) {
            this.LOG.info((Object)("Processing alias " + oneAlias));
            ArrayList<String> emptyPaths = new ArrayList<String>();
            String path = null;
            for (String onefile : work.getPathToAliases().keySet()) {
                List aliases = work.getPathToAliases().get(onefile);
                if (!aliases.contains(oneAlias) || pathsProcessed.contains(path = onefile)) continue;
                pathsProcessed.add(path);
                this.LOG.info((Object)("Adding input file " + path));
                if (!this.isEmptyPath(job, path)) {
                    FileInputFormat.addInputPaths((JobConf)job, (String)path);
                    continue;
                }
                emptyPaths.add(path);
            }
            for (String emptyPath : emptyPaths) {
                numEmptyPaths = this.addInputPath(emptyPath, job, work, hiveScratchDir, numEmptyPaths, true, oneAlias);
            }
            if (path != null) continue;
            numEmptyPaths = this.addInputPath(null, job, work, hiveScratchDir, numEmptyPaths, false, oneAlias);
        }
    }

    @Override
    public StageType getType() {
        return StageType.MAPRED;
    }

    @Override
    public String getName() {
        return "EXEC";
    }

    static {
        if (new Configuration().getBoolean("webinterface.private.actions", false)) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Map<String, String> map = runningJobKillURIs;
                    synchronized (map) {
                        for (String uri : runningJobKillURIs.values()) {
                            try {
                                System.err.println("killing job with: " + uri);
                                HttpURLConnection conn = (HttpURLConnection)new URL(uri).openConnection();
                                conn.setRequestMethod("POST");
                                int retCode = conn.getResponseCode();
                                if (retCode == 200) continue;
                                System.err.println("Got an error trying to kill job with URI: " + uri + " = " + retCode);
                            }
                            catch (Exception e) {
                                System.err.println("trying to kill job, caught: " + e);
                            }
                        }
                    }
                }
            });
        }
    }

    private static class TaskInfo {
        String jobId;
        HashSet<String> logUrls;

        public TaskInfo(String jobId) {
            this.jobId = jobId;
            this.logUrls = new HashSet();
        }

        public void addLogUrl(String logUrl) {
            this.logUrls.add(logUrl);
        }

        public HashSet<String> getLogUrls() {
            return this.logUrls;
        }

        public String getJobId() {
            return this.jobId;
        }
    }

    public static class ExecDriverTaskHandle
    extends TaskHandle {
        JobClient jc;
        RunningJob rj;

        JobClient getJobClient() {
            return this.jc;
        }

        RunningJob getRunningJob() {
            return this.rj;
        }

        public ExecDriverTaskHandle(JobClient jc, RunningJob rj) {
            this.jc = jc;
            this.rj = rj;
        }

        public void setRunningJob(RunningJob job) {
            this.rj = job;
        }

        @Override
        public Counters getCounters() throws IOException {
            return this.rj.getCounters();
        }
    }
}

