/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.Text;

public class GroupByOperator
extends Operator<GroupByDesc>
implements Serializable {
    private static final Log LOG = LogFactory.getLog((String)GroupByOperator.class.getName());
    private static final long serialVersionUID = 1L;
    private static final int NUMROWSESTIMATESIZE = 1000;
    protected transient ExprNodeEvaluator[] keyFields;
    protected transient ObjectInspector[] keyObjectInspectors;
    protected transient Object[] keyObjects;
    protected transient ExprNodeEvaluator[][] aggregationParameterFields;
    protected transient ObjectInspector[][] aggregationParameterObjectInspectors;
    protected transient ObjectInspector[][] aggregationParameterStandardObjectInspectors;
    protected transient Object[][] aggregationParameterObjects;
    protected transient boolean[] aggregationIsDistinct;
    transient GenericUDAFEvaluator[] aggregationEvaluators;
    protected transient ArrayList<ObjectInspector> objectInspectors;
    transient ArrayList<String> fieldNames;
    protected transient ArrayList<Object> currentKeys;
    protected transient ArrayList<Object> newKeys;
    protected transient GenericUDAFEvaluator.AggregationBuffer[] aggregations;
    protected transient Object[][] aggregationsParametersLastInvoke;
    protected transient HashMap<KeyWrapper, GenericUDAFEvaluator.AggregationBuffer[]> hashAggregations;
    protected transient HashSet<ArrayList<Object>> keysCurrentGroup;
    transient boolean bucketGroup;
    transient boolean firstRow;
    transient long totalMemory;
    transient boolean hashAggr;
    transient boolean groupKeyIsNotReduceKey;
    transient boolean firstRowInGroup;
    transient long numRowsInput;
    transient long numRowsHashTbl;
    transient int groupbyMapAggrInterval;
    transient long numRowsCompareHashAggr;
    transient float minReductionHashAggr;
    protected transient ObjectInspector[] currentKeyObjectInspectors;
    transient StructObjectInspector newKeyObjectInspector;
    transient StructObjectInspector currentKeyObjectInspector;
    transient List<Integer> keyPositionsSize;
    transient List<varLenFields> aggrPositions;
    transient int fixedRowSize;
    transient long maxHashTblMemory;
    transient int totalVariableSize;
    transient int numEntriesVarSize;
    transient int numEntriesHashTable;
    private static final int javaObjectOverHead = 64;
    private static final int javaHashEntryOverHead = 64;
    private static final int javaSizePrimitiveType = 16;
    private static final int javaSizeUnknownType = 256;
    KeyWrapper keyProber = new KeyWrapper();
    transient Object[] forwardCache;

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        int i;
        int i2;
        this.totalMemory = Runtime.getRuntime().totalMemory();
        this.numRowsInput = 0L;
        this.numRowsHashTbl = 0L;
        assert (this.inputObjInspectors.length == 1);
        ObjectInspector rowInspector = this.inputObjInspectors[0];
        this.keyFields = new ExprNodeEvaluator[((GroupByDesc)this.conf).getKeys().size()];
        this.keyObjectInspectors = new ObjectInspector[((GroupByDesc)this.conf).getKeys().size()];
        this.currentKeyObjectInspectors = new ObjectInspector[((GroupByDesc)this.conf).getKeys().size()];
        this.keyObjects = new Object[((GroupByDesc)this.conf).getKeys().size()];
        for (i2 = 0; i2 < this.keyFields.length; ++i2) {
            this.keyFields[i2] = ExprNodeEvaluatorFactory.get(((GroupByDesc)this.conf).getKeys().get(i2));
            this.keyObjectInspectors[i2] = this.keyFields[i2].initialize(rowInspector);
            this.currentKeyObjectInspectors[i2] = ObjectInspectorUtils.getStandardObjectInspector(this.keyObjectInspectors[i2], ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            this.keyObjects[i2] = null;
        }
        this.newKeys = new ArrayList(this.keyFields.length);
        this.aggregationParameterFields = new ExprNodeEvaluator[((GroupByDesc)this.conf).getAggregators().size()][];
        this.aggregationParameterObjectInspectors = new ObjectInspector[((GroupByDesc)this.conf).getAggregators().size()][];
        this.aggregationParameterStandardObjectInspectors = new ObjectInspector[((GroupByDesc)this.conf).getAggregators().size()][];
        this.aggregationParameterObjects = new Object[((GroupByDesc)this.conf).getAggregators().size()][];
        for (i2 = 0; i2 < this.aggregationParameterFields.length; ++i2) {
            ArrayList<ExprNodeDesc> parameters = ((GroupByDesc)this.conf).getAggregators().get(i2).getParameters();
            this.aggregationParameterFields[i2] = new ExprNodeEvaluator[parameters.size()];
            this.aggregationParameterObjectInspectors[i2] = new ObjectInspector[parameters.size()];
            this.aggregationParameterStandardObjectInspectors[i2] = new ObjectInspector[parameters.size()];
            this.aggregationParameterObjects[i2] = new Object[parameters.size()];
            for (int j = 0; j < parameters.size(); ++j) {
                this.aggregationParameterFields[i2][j] = ExprNodeEvaluatorFactory.get(parameters.get(j));
                this.aggregationParameterObjectInspectors[i2][j] = this.aggregationParameterFields[i2][j].initialize(rowInspector);
                this.aggregationParameterStandardObjectInspectors[i2][j] = ObjectInspectorUtils.getStandardObjectInspector(this.aggregationParameterObjectInspectors[i2][j], ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                this.aggregationParameterObjects[i2][j] = null;
            }
        }
        this.aggregationIsDistinct = new boolean[((GroupByDesc)this.conf).getAggregators().size()];
        for (i2 = 0; i2 < this.aggregationIsDistinct.length; ++i2) {
            this.aggregationIsDistinct[i2] = ((GroupByDesc)this.conf).getAggregators().get(i2).getDistinct();
        }
        this.aggregationEvaluators = new GenericUDAFEvaluator[((GroupByDesc)this.conf).getAggregators().size()];
        for (i2 = 0; i2 < this.aggregationEvaluators.length; ++i2) {
            AggregationDesc agg = ((GroupByDesc)this.conf).getAggregators().get(i2);
            this.aggregationEvaluators[i2] = agg.getGenericUDAFEvaluator();
        }
        int totalFields = this.keyFields.length + this.aggregationEvaluators.length;
        this.objectInspectors = new ArrayList(totalFields);
        for (ExprNodeEvaluator keyField : this.keyFields) {
            this.objectInspectors.add(null);
        }
        for (i = 0; i < this.aggregationEvaluators.length; ++i) {
            ObjectInspector roi = this.aggregationEvaluators[i].init(((GroupByDesc)this.conf).getAggregators().get(i).getMode(), this.aggregationParameterObjectInspectors[i]);
            this.objectInspectors.add(roi);
        }
        this.bucketGroup = ((GroupByDesc)this.conf).getBucketGroup();
        this.aggregationsParametersLastInvoke = new Object[((GroupByDesc)this.conf).getAggregators().size()][];
        if (((GroupByDesc)this.conf).getMode() != GroupByDesc.Mode.HASH || this.bucketGroup) {
            this.aggregations = this.newAggregations();
            this.hashAggr = false;
        } else {
            this.hashAggregations = new HashMap();
            this.aggregations = this.newAggregations();
            this.hashAggr = true;
            this.keyPositionsSize = new ArrayList<Integer>();
            this.aggrPositions = new ArrayList<varLenFields>();
            this.groupbyMapAggrInterval = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEGROUPBYMAPINTERVAL);
            this.numRowsCompareHashAggr = this.groupbyMapAggrInterval;
            this.minReductionHashAggr = HiveConf.getFloatVar(hconf, HiveConf.ConfVars.HIVEMAPAGGRHASHMINREDUCTION);
            this.groupKeyIsNotReduceKey = ((GroupByDesc)this.conf).getGroupKeyNotReductionKey();
            if (this.groupKeyIsNotReduceKey) {
                this.keysCurrentGroup = new HashSet();
            }
        }
        this.fieldNames = ((GroupByDesc)this.conf).getOutputColumnNames();
        for (i = 0; i < this.keyFields.length; ++i) {
            this.objectInspectors.set(i, this.currentKeyObjectInspectors[i]);
        }
        ArrayList<String> keyNames = new ArrayList<String>(this.keyFields.length);
        for (int i3 = 0; i3 < this.keyFields.length; ++i3) {
            keyNames.add(this.fieldNames.get(i3));
        }
        this.newKeyObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(keyNames, Arrays.asList(this.keyObjectInspectors));
        this.currentKeyObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(keyNames, Arrays.asList(this.currentKeyObjectInspectors));
        this.outputObjInspector = ObjectInspectorFactory.getStandardStructObjectInspector(this.fieldNames, this.objectInspectors);
        this.firstRow = true;
        if (this.hashAggr) {
            this.computeMaxEntriesHashAggr(hconf);
        }
        this.initializeChildren(hconf);
    }

    private void computeMaxEntriesHashAggr(Configuration hconf) throws HiveException {
        this.maxHashTblMemory = (long)(HiveConf.getFloatVar(hconf, HiveConf.ConfVars.HIVEMAPAGGRHASHMEMORY) * (float)Runtime.getRuntime().maxMemory());
        this.estimateRowSize();
    }

    private int getSize(int pos, PrimitiveObjectInspector.PrimitiveCategory category) {
        switch (category) {
            case VOID: 
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return 16;
            }
            case STRING: {
                this.keyPositionsSize.add(new Integer(pos));
                return 64;
            }
        }
        return 256;
    }

    private int getSize(int pos, Class<?> c, Field f) {
        if (c.isPrimitive() || c.isInstance(new Boolean(true)) || c.isInstance(new Byte(0)) || c.isInstance(new Short(0)) || c.isInstance(new Integer(0)) || c.isInstance(new Long(0L)) || c.isInstance(new Float(0.0f)) || c.isInstance(new Double(0.0))) {
            return 16;
        }
        if (c.isInstance(new String())) {
            int idx = 0;
            varLenFields v = null;
            for (idx = 0; idx < this.aggrPositions.size() && (v = this.aggrPositions.get(idx)).getAggrPos() != pos; ++idx) {
            }
            if (idx == this.aggrPositions.size()) {
                v = new varLenFields(pos, new ArrayList<Field>());
                this.aggrPositions.add(v);
            }
            v.getFields().add(f);
            return 64;
        }
        return 256;
    }

    private int getSize(int pos, TypeInfo typeInfo) {
        if (typeInfo instanceof PrimitiveTypeInfo) {
            return this.getSize(pos, ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory());
        }
        return 256;
    }

    private void estimateRowSize() throws HiveException {
        this.fixedRowSize = 64;
        ArrayList<ExprNodeDesc> keys = ((GroupByDesc)this.conf).getKeys();
        for (int pos = 0; pos < keys.size(); ++pos) {
            this.fixedRowSize += this.getSize(pos, keys.get(pos).getTypeInfo());
        }
        for (int i = 0; i < this.aggregationEvaluators.length; ++i) {
            Field[] fArr;
            this.fixedRowSize += 64;
            Class<?> agg = this.aggregationEvaluators[i].getNewAggregationBuffer().getClass();
            for (Field f : fArr = ObjectInspectorUtils.getDeclaredNonStaticFields(agg)) {
                this.fixedRowSize += this.getSize(i, f.getType(), f);
            }
        }
    }

    protected GenericUDAFEvaluator.AggregationBuffer[] newAggregations() throws HiveException {
        GenericUDAFEvaluator.AggregationBuffer[] aggs = new GenericUDAFEvaluator.AggregationBuffer[this.aggregationEvaluators.length];
        for (int i = 0; i < this.aggregationEvaluators.length; ++i) {
            aggs[i] = this.aggregationEvaluators[i].getNewAggregationBuffer();
        }
        return aggs;
    }

    protected void resetAggregations(GenericUDAFEvaluator.AggregationBuffer[] aggs) throws HiveException {
        for (int i = 0; i < aggs.length; ++i) {
            this.aggregationEvaluators[i].reset(aggs[i]);
        }
    }

    protected void updateAggregations(GenericUDAFEvaluator.AggregationBuffer[] aggs, Object row, ObjectInspector rowInspector, boolean hashAggr, boolean newEntryForHashAggr, Object[][] lastInvoke) throws HiveException {
        for (int ai = 0; ai < aggs.length; ++ai) {
            int pi;
            Object[] o = new Object[this.aggregationParameterFields[ai].length];
            for (pi = 0; pi < this.aggregationParameterFields[ai].length; ++pi) {
                o[pi] = this.aggregationParameterFields[ai][pi].evaluate(row);
            }
            if (this.aggregationIsDistinct[ai]) {
                if (hashAggr) {
                    if (!newEntryForHashAggr) continue;
                    this.aggregationEvaluators[ai].aggregate(aggs[ai], o);
                    continue;
                }
                if (lastInvoke[ai] == null) {
                    lastInvoke[ai] = new Object[o.length];
                }
                if (ObjectInspectorUtils.compare(o, this.aggregationParameterObjectInspectors[ai], lastInvoke[ai], this.aggregationParameterStandardObjectInspectors[ai]) == 0) continue;
                this.aggregationEvaluators[ai].aggregate(aggs[ai], o);
                for (pi = 0; pi < o.length; ++pi) {
                    lastInvoke[ai][pi] = ObjectInspectorUtils.copyToStandardObject(o[pi], this.aggregationParameterObjectInspectors[ai][pi], ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                }
                continue;
            }
            this.aggregationEvaluators[ai].aggregate(aggs[ai], o);
        }
    }

    @Override
    public void startGroup() throws HiveException {
        this.firstRowInGroup = true;
    }

    @Override
    public void endGroup() throws HiveException {
        if (this.groupKeyIsNotReduceKey) {
            this.keysCurrentGroup.clear();
        }
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        this.firstRow = false;
        ObjectInspector rowInspector = this.inputObjInspectors[tag];
        if (this.hashAggr && !this.groupKeyIsNotReduceKey) {
            ++this.numRowsInput;
            if (this.numRowsInput == this.numRowsCompareHashAggr) {
                this.numRowsCompareHashAggr += (long)this.groupbyMapAggrInterval;
                if ((float)this.numRowsHashTbl > (float)this.numRowsInput * this.minReductionHashAggr) {
                    LOG.warn((Object)("Disable Hash Aggr: #hash table = " + this.numRowsHashTbl + " #total = " + this.numRowsInput + " reduction = " + 1.0 * (double)(this.numRowsHashTbl / this.numRowsInput) + " minReduction = " + this.minReductionHashAggr));
                    this.flush(true);
                    this.hashAggr = false;
                } else {
                    LOG.trace((Object)("Hash Aggr Enabled: #hash table = " + this.numRowsHashTbl + " #total = " + this.numRowsInput + " reduction = " + 1.0 * (double)(this.numRowsHashTbl / this.numRowsInput) + " minReduction = " + this.minReductionHashAggr));
                }
            }
        }
        try {
            this.newKeys.clear();
            for (int i = 0; i < this.keyFields.length; ++i) {
                if (this.keyObjectInspectors[i] == null) {
                    this.keyObjectInspectors[i] = this.keyFields[i].initialize(rowInspector);
                }
                this.keyObjects[i] = this.keyFields[i].evaluate(row);
                this.newKeys.add(this.keyObjects[i]);
            }
            if (this.hashAggr) {
                this.processHashAggr(row, rowInspector, this.newKeys);
            } else {
                this.processAggr(row, rowInspector, this.newKeys);
            }
            this.firstRowInGroup = false;
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private static ArrayList<Object> deepCopyElements(Object[] keys, ObjectInspector[] keyObjectInspectors, ObjectInspectorUtils.ObjectInspectorCopyOption copyOption) {
        ArrayList<Object> result = new ArrayList<Object>(keys.length);
        GroupByOperator.deepCopyElements(keys, keyObjectInspectors, result, copyOption);
        return result;
    }

    private static void deepCopyElements(Object[] keys, ObjectInspector[] keyObjectInspectors, ArrayList<Object> result, ObjectInspectorUtils.ObjectInspectorCopyOption copyOption) {
        result.clear();
        for (int i = 0; i < keys.length; ++i) {
            result.add(ObjectInspectorUtils.copyToStandardObject(keys[i], keyObjectInspectors[i], copyOption));
        }
    }

    private void processHashAggr(Object row, ObjectInspector rowInspector, ArrayList<Object> newKeys) throws HiveException {
        GenericUDAFEvaluator.AggregationBuffer[] aggs = null;
        boolean newEntryForHashAggr = false;
        this.keyProber.hashcode = newKeys.hashCode();
        this.keyProber.keys = newKeys;
        aggs = this.hashAggregations.get(this.keyProber);
        ArrayList<Object> newDefaultKeys = null;
        if (aggs == null) {
            newDefaultKeys = GroupByOperator.deepCopyElements(this.keyObjects, this.keyObjectInspectors, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            KeyWrapper newKeyProber = new KeyWrapper(this.keyProber.hashcode, newDefaultKeys, true);
            aggs = this.newAggregations();
            this.hashAggregations.put(newKeyProber, aggs);
            newEntryForHashAggr = true;
            ++this.numRowsHashTbl;
        }
        if (this.groupKeyIsNotReduceKey) {
            if (newDefaultKeys == null) {
                newDefaultKeys = GroupByOperator.deepCopyElements(this.keyObjects, this.keyObjectInspectors, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            }
            newEntryForHashAggr = this.keysCurrentGroup.add(newDefaultKeys);
        }
        this.updateAggregations(aggs, row, rowInspector, true, newEntryForHashAggr, null);
        if ((!this.groupKeyIsNotReduceKey || this.firstRowInGroup) && this.shouldBeFlushed(newKeys)) {
            this.flush(false);
        }
    }

    private void processAggr(Object row, ObjectInspector rowInspector, ArrayList<Object> newKeys) throws HiveException {
        boolean keysAreEqual;
        GenericUDAFEvaluator.AggregationBuffer[] aggs = null;
        Object[][] lastInvoke = null;
        boolean bl = keysAreEqual = ObjectInspectorUtils.compare(newKeys, this.newKeyObjectInspector, this.currentKeys, this.currentKeyObjectInspector) == 0;
        if (this.currentKeys != null && !keysAreEqual) {
            this.forward(this.currentKeys, this.aggregations);
        }
        if (this.currentKeys == null || !keysAreEqual) {
            if (this.currentKeys == null) {
                this.currentKeys = new ArrayList(this.keyFields.length);
            }
            GroupByOperator.deepCopyElements(this.keyObjects, this.keyObjectInspectors, this.currentKeys, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            this.resetAggregations(this.aggregations);
            for (int i = 0; i < this.aggregationsParametersLastInvoke.length; ++i) {
                this.aggregationsParametersLastInvoke[i] = null;
            }
        }
        aggs = this.aggregations;
        lastInvoke = this.aggregationsParametersLastInvoke;
        this.updateAggregations(aggs, row, rowInspector, false, false, lastInvoke);
    }

    private boolean shouldBeFlushed(ArrayList<Object> newKeys) {
        int numEntries = this.hashAggregations.size();
        if (this.numEntriesHashTable == 0 || numEntries % 1000 == 0) {
            for (Integer pos : this.keyPositionsSize) {
                Object key = newKeys.get(pos);
                if (key == null) continue;
                if (key instanceof String) {
                    this.totalVariableSize += ((String)key).length();
                    continue;
                }
                if (!(key instanceof Text)) continue;
                this.totalVariableSize += ((Text)key).getLength();
            }
            GenericUDAFEvaluator.AggregationBuffer[] aggs = null;
            if (this.aggrPositions.size() > 0) {
                aggs = this.hashAggregations.get(newKeys);
            }
            for (varLenFields v : this.aggrPositions) {
                int aggrPos = v.getAggrPos();
                List<Field> fieldsVarLen = v.getFields();
                GenericUDAFEvaluator.AggregationBuffer agg = aggs[aggrPos];
                try {
                    for (Field f : fieldsVarLen) {
                        this.totalVariableSize += ((String)f.get(agg)).length();
                    }
                }
                catch (IllegalAccessException e) {
                    assert (false);
                }
            }
            ++this.numEntriesVarSize;
            this.numEntriesHashTable = (int)(this.maxHashTblMemory / (long)(this.fixedRowSize + this.totalVariableSize / this.numEntriesVarSize));
            LOG.trace((Object)("Hash Aggr: #hash table = " + numEntries + " #max in hash table = " + this.numEntriesHashTable));
        }
        return numEntries >= this.numEntriesHashTable;
    }

    private void flush(boolean complete) throws HiveException {
        if (complete) {
            for (Map.Entry<KeyWrapper, GenericUDAFEvaluator.AggregationBuffer[]> m : this.hashAggregations.entrySet()) {
                this.forward(m.getKey().keys, m.getValue());
            }
            this.hashAggregations.clear();
            this.hashAggregations = null;
            LOG.warn((Object)"Hash Table completed flushed");
            return;
        }
        int oldSize = this.hashAggregations.size();
        LOG.warn((Object)("Hash Tbl flush: #hash table = " + oldSize));
        Iterator<Map.Entry<KeyWrapper, GenericUDAFEvaluator.AggregationBuffer[]>> iter = this.hashAggregations.entrySet().iterator();
        int numDel = 0;
        while (iter.hasNext()) {
            Map.Entry<KeyWrapper, GenericUDAFEvaluator.AggregationBuffer[]> m = iter.next();
            this.forward(m.getKey().keys, m.getValue());
            iter.remove();
            if (++numDel * 10 < oldSize) continue;
            LOG.warn((Object)("Hash Table flushed: new size = " + this.hashAggregations.size()));
            return;
        }
    }

    protected void forward(ArrayList<Object> keys, GenericUDAFEvaluator.AggregationBuffer[] aggs) throws HiveException {
        int i;
        int totalFields = keys.size() + aggs.length;
        if (this.forwardCache == null) {
            this.forwardCache = new Object[totalFields];
        }
        for (i = 0; i < keys.size(); ++i) {
            this.forwardCache[i] = keys.get(i);
        }
        for (i = 0; i < aggs.length; ++i) {
            this.forwardCache[keys.size() + i] = this.aggregationEvaluators[i].evaluate(aggs[i]);
        }
        this.forward(this.forwardCache, this.outputObjInspector);
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (!abort) {
            try {
                if (this.firstRow && this.keyFields.length == 0) {
                    this.firstRow = false;
                    for (int ai = 0; ai < this.aggregations.length; ++ai) {
                        Object[] o = new Object[this.aggregationParameterFields[ai].length];
                        for (int pi = 0; pi < this.aggregationParameterFields[ai].length; ++pi) {
                            o[pi] = null;
                        }
                        this.aggregationEvaluators[ai].aggregate(this.aggregations[ai], o);
                    }
                    this.forward(new ArrayList<Object>(0), this.aggregations);
                } else if (this.hashAggregations != null) {
                    LOG.warn((Object)("Begin Hash Table flush at close: size = " + this.hashAggregations.size()));
                    Iterator<Map.Entry<KeyWrapper, GenericUDAFEvaluator.AggregationBuffer[]>> iter = this.hashAggregations.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<KeyWrapper, GenericUDAFEvaluator.AggregationBuffer[]> m = iter.next();
                        this.forward(m.getKey().keys, m.getValue());
                        iter.remove();
                    }
                    this.hashAggregations.clear();
                } else if (this.aggregations != null) {
                    if (this.currentKeys != null) {
                        this.forward(this.currentKeys, this.aggregations);
                    }
                    this.currentKeys = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new HiveException(e);
            }
        }
    }

    public List<String> genColLists(HashMap<Operator<? extends Serializable>, OpParseContext> opParseCtx) {
        List<String> colLists = new ArrayList<String>();
        ArrayList<ExprNodeDesc> keys = ((GroupByDesc)this.conf).getKeys();
        for (ExprNodeDesc key : keys) {
            colLists = Utilities.mergeUniqElems(colLists, key.getCols());
        }
        ArrayList<AggregationDesc> aggrs = ((GroupByDesc)this.conf).getAggregators();
        for (AggregationDesc aggr : aggrs) {
            ArrayList<ExprNodeDesc> params = aggr.getParameters();
            for (ExprNodeDesc param : params) {
                colLists = Utilities.mergeUniqElems(colLists, param.getCols());
            }
        }
        return colLists;
    }

    @Override
    public String getName() {
        return new String("GBY");
    }

    @Override
    public OperatorType getType() {
        return OperatorType.GROUPBY;
    }

    class KeyWrapper {
        int hashcode;
        ArrayList<Object> keys;
        boolean copy = false;

        KeyWrapper() {
        }

        public KeyWrapper(int hashcode, ArrayList<Object> copiedKeys) {
            this(hashcode, copiedKeys, false);
        }

        public KeyWrapper(int hashcode, ArrayList<Object> copiedKeys, boolean inHashMap) {
            this.hashcode = hashcode;
            this.keys = copiedKeys;
            this.copy = inHashMap;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object obj) {
            ArrayList<Object> copied_in_hashmap = ((KeyWrapper)obj).keys;
            if (!this.copy) {
                return ObjectInspectorUtils.compare(copied_in_hashmap, GroupByOperator.this.currentKeyObjectInspector, this.keys, GroupByOperator.this.newKeyObjectInspector) == 0;
            }
            return ObjectInspectorUtils.compare(copied_in_hashmap, GroupByOperator.this.currentKeyObjectInspector, this.keys, GroupByOperator.this.currentKeyObjectInspector) == 0;
        }
    }

    class varLenFields {
        int aggrPos;
        List<Field> fields;

        varLenFields(int aggrPos, List<Field> fields) {
            this.aggrPos = aggrPos;
            this.fields = fields;
        }

        int getAggrPos() {
            return this.aggrPos;
        }

        List<Field> getFields() {
            return this.fields;
        }
    }
}

