/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.ExecDriver;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskExecutionException;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.ShimLoader;

public class MapRedTask
extends Task<MapredWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String HADOOP_MEM_KEY = "HADOOP_HEAPSIZE";
    static final String HADOOP_OPTS_KEY = "HADOOP_OPTS";
    static final String[] HIVE_SYS_PROP = new String[]{"build.dir", "build.dir.hive"};

    @Override
    public int execute(DriverContext driverContext) {
        try {
            String hadoopExec = this.conf.getVar(HiveConf.ConfVars.HADOOPBIN);
            String hiveJar = this.conf.getJar();
            String addedJars = ExecDriver.getResourceFiles(this.conf, SessionState.ResourceType.JAR);
            this.conf.setVar(HiveConf.ConfVars.HIVEADDEDJARS, addedJars);
            String auxJars = this.conf.getAuxJars();
            String libJarsOption = StringUtils.isEmpty(addedJars) ? (StringUtils.isEmpty(auxJars) ? " " : " -libjars " + auxJars + " ") : (StringUtils.isEmpty(auxJars) ? " -libjars " + addedJars + " " : " -libjars " + addedJars + "," + auxJars + " ");
            String hiveConfArgs = ExecDriver.generateCmdLine(this.conf);
            String hiveScratchDir = driverContext.getCtx() != null && driverContext.getCtx().getQueryPath() != null ? driverContext.getCtx().getQueryPath().toString() : this.conf.getVar(HiveConf.ConfVars.SCRATCHDIR);
            File scratchDir = new File(hiveScratchDir);
            if (!scratchDir.exists()) {
                this.LOG.info((Object)("Local scratch directory " + scratchDir.getPath() + " not found. Attempting to create."));
                if (!scratchDir.mkdirs() && !scratchDir.exists()) {
                    throw new TaskExecutionException("Cannot create scratch directory \"" + scratchDir.getPath() + "\". " + "To configure a different directory, " + "set the configuration " + "\"hive.exec.scratchdir\" " + "in the session, or permanently by modifying the " + "appropriate hive configuration file such as hive-site.xml.");
                }
            }
            MapredWork plan = (MapredWork)this.getWork();
            File planFile = File.createTempFile("plan", ".xml", scratchDir);
            this.LOG.info((Object)("Generating plan file " + planFile.toString()));
            FileOutputStream out = new FileOutputStream(planFile);
            Utilities.serializeMapRedWork(plan, out);
            String isSilent = "true".equalsIgnoreCase(System.getProperty("test.silent")) ? "-nolog" : "";
            String jarCmd = ShimLoader.getHadoopShims().usesJobShell() ? libJarsOption + hiveJar + " " + ExecDriver.class.getName() : hiveJar + " " + ExecDriver.class.getName() + libJarsOption;
            String cmdLine = hadoopExec + " jar " + jarCmd + " -plan " + planFile.toString() + " " + isSilent + " " + hiveConfArgs;
            String files = ExecDriver.getResourceFiles(this.conf, SessionState.ResourceType.FILE);
            if (!files.isEmpty()) {
                cmdLine = cmdLine + " -files " + files;
            }
            this.LOG.info((Object)("Executing: " + cmdLine));
            Process executor = null;
            StringBuilder sb = new StringBuilder();
            Properties p = System.getProperties();
            for (String element : HIVE_SYS_PROP) {
                if (!p.containsKey(element)) continue;
                sb.append(" -D" + element + "=" + p.getProperty(element));
            }
            String hadoopOpts = sb.toString();
            HashMap<String, String> variables = new HashMap<String, String>(System.getenv());
            int hadoopMem = this.conf.getIntVar(HiveConf.ConfVars.HIVEHADOOPMAXMEM);
            if (hadoopMem == 0) {
                variables.remove(HADOOP_MEM_KEY);
            } else {
                variables.put(HADOOP_MEM_KEY, String.valueOf(hadoopMem));
            }
            if (variables.containsKey(HADOOP_OPTS_KEY)) {
                variables.put(HADOOP_OPTS_KEY, (String)variables.get(HADOOP_OPTS_KEY) + hadoopOpts);
            } else {
                variables.put(HADOOP_OPTS_KEY, hadoopOpts);
            }
            String[] env = new String[variables.size()];
            int pos = 0;
            for (Map.Entry entry : variables.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                env[pos++] = name + "=" + value;
            }
            executor = Runtime.getRuntime().exec(cmdLine, env);
            Utilities.StreamPrinter outPrinter = new Utilities.StreamPrinter(executor.getInputStream(), null, SessionState.getConsole().getChildOutStream());
            Utilities.StreamPrinter errPrinter = new Utilities.StreamPrinter(executor.getErrorStream(), null, SessionState.getConsole().getChildErrStream());
            outPrinter.start();
            errPrinter.start();
            int exitVal = executor.waitFor();
            if (exitVal != 0) {
                this.LOG.error((Object)("Execution failed with exit status: " + exitVal));
            } else {
                this.LOG.info((Object)"Execution completed successfully");
            }
            return exitVal;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.LOG.error((Object)("Exception: " + e.getMessage()));
            return 1;
        }
    }

    @Override
    public boolean isMapRedTask() {
        return true;
    }

    @Override
    public boolean hasReduce() {
        MapredWork w = (MapredWork)this.getWork();
        return w.getReducer() != null;
    }

    @Override
    public StageType getType() {
        return StageType.MAPREDLOCAL;
    }

    @Override
    public String getName() {
        return "MAPRED";
    }
}

