/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;

public class MoveTask
extends Task<MoveWork>
implements Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public int execute(DriverContext driverContext) {
        try {
            LoadTableDesc tbd;
            LoadFileDesc lfd = ((MoveWork)this.work).getLoadFileWork();
            if (lfd != null) {
                String mesg_detail;
                String mesg;
                Path targetPath = new Path(lfd.getTargetDir());
                Path sourcePath = new Path(lfd.getSourceDir());
                FileSystem fs = sourcePath.getFileSystem((Configuration)this.conf);
                if (lfd.getIsDfsDir()) {
                    mesg = "Moving data to: " + lfd.getTargetDir();
                    mesg_detail = " from " + lfd.getSourceDir();
                    this.console.printInfo(mesg, mesg_detail);
                    fs.delete(targetPath, true);
                    if (fs.exists(sourcePath)) {
                        if (!fs.rename(sourcePath, targetPath)) {
                            throw new HiveException("Unable to rename: " + sourcePath + " to: " + targetPath);
                        }
                    } else if (!fs.mkdirs(targetPath)) {
                        throw new HiveException("Unable to make directory: " + targetPath);
                    }
                } else {
                    mesg = "Copying data to local directory " + lfd.getTargetDir();
                    mesg_detail = " from " + lfd.getSourceDir();
                    this.console.printInfo(mesg, mesg_detail);
                    LocalFileSystem dstFs = FileSystem.getLocal((Configuration)this.conf);
                    if (dstFs.delete(targetPath, true) || !dstFs.exists(targetPath)) {
                        this.console.printInfo(mesg, mesg_detail);
                        if (fs.exists(sourcePath)) {
                            fs.copyToLocalFile(sourcePath, targetPath);
                        } else if (!dstFs.mkdirs(targetPath)) {
                            throw new HiveException("Unable to make local directory: " + targetPath);
                        }
                    } else {
                        throw new AccessControlException("Unable to delete the existing destination directory: " + targetPath);
                    }
                }
            }
            if ((tbd = ((MoveWork)this.work).getLoadTableWork()) != null) {
                StringBuilder mesg = new StringBuilder("Loading data to table ").append(tbd.getTable().getTableName());
                if (tbd.getPartitionSpec().size() > 0) {
                    mesg.append(" partition (");
                    Map<String, String> partSpec = tbd.getPartitionSpec();
                    for (String key : partSpec.keySet()) {
                        mesg.append(key).append('=').append(partSpec.get(key)).append(", ");
                    }
                    mesg.setLength(mesg.length() - 2);
                    mesg.append(')');
                }
                String mesg_detail = " from " + tbd.getSourceDir();
                this.console.printInfo(mesg.toString(), mesg_detail);
                Table table = this.db.getTable(this.db.getCurrentDatabase(), tbd.getTable().getTableName());
                if (((MoveWork)this.work).getCheckFileFormat()) {
                    boolean flag;
                    ArrayList<FileStatus> files;
                    FileSystem fs;
                    try {
                        fs = FileSystem.get((URI)table.getDataLocation(), (Configuration)this.conf);
                        FileStatus[] dirs = fs.globStatus(new Path(tbd.getSourceDir()));
                        files = new ArrayList<FileStatus>();
                        for (int i = 0; dirs != null && i < dirs.length; ++i) {
                            files.addAll(Arrays.asList(fs.listStatus(dirs[i].getPath())));
                            if (files.size() <= 0) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (IOException e) {
                        throw new HiveException("addFiles: filesystem error in check phase", e);
                    }
                    if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVECHECKFILEFORMAT) && !(flag = HiveFileFormatUtils.checkInputFormat(fs, this.conf, tbd.getTable().getInputFileFormatClass(), files))) {
                        throw new HiveException("Wrong file format. Please check the file's format.");
                    }
                }
                LineageInfo.DataContainer dc = null;
                if (tbd.getPartitionSpec().size() == 0) {
                    dc = new LineageInfo.DataContainer(table.getTTable());
                    this.db.loadTable(new Path(tbd.getSourceDir()), tbd.getTable().getTableName(), tbd.getReplace(), new Path(tbd.getTmpDir()));
                    if (((MoveWork)this.work).getOutputs() != null) {
                        ((MoveWork)this.work).getOutputs().add(new WriteEntity(table));
                    }
                } else {
                    this.LOG.info((Object)("Partition is: " + tbd.getPartitionSpec().toString()));
                    DynamicPartitionCtx dpCtx = tbd.getDPCtx();
                    if (dpCtx != null && dpCtx.getNumDPCols() > 0) {
                        ArrayList<LinkedHashMap<String, String>> dp = this.db.loadDynamicPartitions(new Path(tbd.getSourceDir()), tbd.getTable().getTableName(), tbd.getPartitionSpec(), tbd.getReplace(), new Path(tbd.getTmpDir()), dpCtx.getNumDPCols());
                        for (LinkedHashMap<String, String> partSpec : dp) {
                            Partition partn = this.db.getPartition(table, partSpec, false);
                            WriteEntity enty = new WriteEntity(partn);
                            if (((MoveWork)this.work).getOutputs() != null) {
                                ((MoveWork)this.work).getOutputs().add(enty);
                            }
                            if (this.queryPlan.getOutputs() == null) {
                                this.queryPlan.setOutputs(new HashSet<WriteEntity>());
                            }
                            this.queryPlan.getOutputs().add(enty);
                            dc = new LineageInfo.DataContainer(table.getTTable(), partn.getTPartition());
                            if (SessionState.get() != null) {
                                SessionState.get().getLineageState().setLineage(tbd.getSourceDir(), dc, table.getCols());
                            }
                            this.console.printInfo("\tLoading partition " + partSpec);
                        }
                        dc = null;
                    } else {
                        this.db.loadPartition(new Path(tbd.getSourceDir()), tbd.getTable().getTableName(), tbd.getPartitionSpec(), tbd.getReplace(), new Path(tbd.getTmpDir()));
                        Partition partn = this.db.getPartition(table, tbd.getPartitionSpec(), false);
                        dc = new LineageInfo.DataContainer(table.getTTable(), partn.getTPartition());
                        if (((MoveWork)this.work).getOutputs() != null) {
                            ((MoveWork)this.work).getOutputs().add(new WriteEntity(partn));
                        }
                    }
                }
                if (SessionState.get() != null && dc != null) {
                    SessionState.get().getLineageState().setLineage(tbd.getSourceDir(), dc, table.getCols());
                }
            }
            return 0;
        }
        catch (Exception e) {
            this.console.printError("Failed with exception " + e.getMessage(), "\n" + StringUtils.stringifyException((Throwable)e));
            return 1;
        }
    }

    public boolean isLocal() {
        LoadTableDesc tbd = ((MoveWork)this.work).getLoadTableWork();
        if (tbd != null) {
            return false;
        }
        LoadFileDesc lfd = ((MoveWork)this.work).getLoadFileWork();
        if (lfd != null) {
            return !lfd.getIsDfsDir();
        }
        return false;
    }

    @Override
    public StageType getType() {
        return StageType.MOVE;
    }

    @Override
    public String getName() {
        return "MOVE";
    }
}

