/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.BucketMatcher;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.persistence.RowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.ReflectionUtils;

public class SMBMapJoinOperator
extends AbstractMapJoinOperator<SMBJoinDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)SMBMapJoinOperator.class.getName());
    private MapredLocalWork localWork = null;
    private Map<String, FetchOperator> fetchOperators;
    transient Map<Byte, ArrayList<Object>> keyWritables;
    transient Map<Byte, ArrayList<Object>> nextKeyWritables;
    HashMap<Byte, RowContainer<ArrayList<Object>>> nextGroupStorage;
    HashMap<Byte, RowContainer<ArrayList<Object>>> candidateStorage;
    transient HashMap<Byte, String> tagToAlias;
    private transient HashMap<Byte, Boolean> fetchOpDone = new HashMap();
    private transient HashMap<Byte, Boolean> foundNextKeyGroup = new HashMap();
    transient boolean firstFetchHappened = false;
    transient boolean localWorkInited = false;
    transient boolean closeCalled = false;

    public SMBMapJoinOperator() {
    }

    public SMBMapJoinOperator(AbstractMapJoinOperator<? extends MapJoinDesc> mapJoinOp) {
        super(mapJoinOp);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.firstRow = true;
        this.closeCalled = false;
        this.firstFetchHappened = false;
        this.nextGroupStorage = new HashMap();
        this.candidateStorage = new HashMap();
        int bucketSize = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEMAPJOINBUCKETCACHESIZE);
        byte storePos = 0;
        for (Byte alias : order) {
            RowContainer rc = this.getRowContainer(hconf, storePos, alias, bucketSize);
            this.nextGroupStorage.put(storePos, rc);
            RowContainer candidateRC = this.getRowContainer(hconf, storePos, alias, bucketSize);
            this.candidateStorage.put(alias, candidateRC);
            storePos = (byte)(storePos + 1);
        }
        this.tagToAlias = ((SMBJoinDesc)this.conf).getTagToAlias();
        this.keyWritables = new HashMap<Byte, ArrayList<Object>>();
        this.nextKeyWritables = new HashMap<Byte, ArrayList<Object>>();
        for (Byte alias : order) {
            if (alias != (byte)this.posBigTable) {
                this.fetchOpDone.put(alias, Boolean.FALSE);
            }
            this.foundNextKeyGroup.put(alias, Boolean.FALSE);
        }
    }

    @Override
    public void initializeLocalWork(Configuration hconf) throws HiveException {
        this.initializeMapredLocalWork((MapJoinDesc)this.getConf(), hconf, ((SMBJoinDesc)this.getConf()).getLocalWork(), LOG);
        super.initializeLocalWork(hconf);
    }

    public void initializeMapredLocalWork(MapJoinDesc conf, Configuration hconf, MapredLocalWork localWork, Log l4j) throws HiveException {
        if (localWork == null || this.localWorkInited) {
            return;
        }
        this.localWorkInited = true;
        this.localWork = localWork;
        this.fetchOperators = new HashMap<String, FetchOperator>();
        for (Map.Entry<String, FetchWork> entry : localWork.getAliasToFetchWork().entrySet()) {
            this.fetchOperators.put(entry.getKey(), new FetchOperator(entry.getValue(), new JobConf(hconf)));
            if (l4j == null) continue;
            l4j.info((Object)("fetchoperator for " + entry.getKey() + " created"));
        }
        for (Map.Entry<String, Serializable> entry : this.fetchOperators.entrySet()) {
            Operator<? extends Serializable> forwardOp = localWork.getAliasToWork().get(entry.getKey());
            forwardOp.setExecContext(this.getExecContext());
            forwardOp.initialize((Configuration)this.getExecContext().getJc(), new ObjectInspector[]{((FetchOperator)entry.getValue()).getOutputObjectInspector()});
            l4j.info((Object)("fetchoperator for " + entry.getKey() + " initialized"));
        }
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        if (tag == this.posBigTable && this.getExecContext().inputFileChanged()) {
            if (this.firstFetchHappened) {
                this.joinFinalLeftData();
            }
            for (Map.Entry<String, FetchOperator> entry : this.fetchOperators.entrySet()) {
                String alias = entry.getKey();
                FetchOperator fetchOp = entry.getValue();
                fetchOp.clearFetchContext();
                this.setUpFetchOpContext(fetchOp, alias);
            }
            this.firstFetchHappened = false;
        }
        if (!this.firstFetchHappened) {
            this.firstFetchHappened = true;
            for (Byte t : order) {
                if (t == (byte)this.posBigTable) continue;
                this.fetchNextGroup(t);
            }
        }
        byte alias = (byte)tag;
        ArrayList<Object> key = SMBMapJoinOperator.computeValues(row, (List)this.joinKeys.get(alias), (List)this.joinKeysObjectInspectors.get(alias));
        ArrayList<Object> value = SMBMapJoinOperator.computeValues(row, (List)this.joinValues.get(alias), (List)this.joinValuesObjectInspectors.get(alias));
        boolean nextKeyGroup = this.processKey(alias, key);
        if (nextKeyGroup) {
            this.nextGroupStorage.get(alias).add(value);
            this.foundNextKeyGroup.put((byte)tag, Boolean.TRUE);
            if (tag != this.posBigTable) {
                return;
            }
        }
        this.reportProgress();
        if (nextKeyGroup) {
            assert (tag == (byte)this.posBigTable);
            List<Byte> smallestPos = null;
            while ((smallestPos = this.joinOneGroup()) != null && smallestPos.size() > 0 && !smallestPos.contains((byte)this.posBigTable)) {
            }
            return;
        }
        assert (!nextKeyGroup);
        this.candidateStorage.get((byte)tag).add(value);
    }

    private void joinFinalLeftData() throws HiveException {
        List<Byte> ret;
        RowContainer<ArrayList<Object>> bigTblRowContainer = this.candidateStorage.get((byte)this.posBigTable);
        boolean allFetchOpDone = this.allFetchOpDone();
        while (bigTblRowContainer != null && bigTblRowContainer.size() > 0 && !allFetchOpDone) {
            this.joinOneGroup();
            bigTblRowContainer = this.candidateStorage.get((byte)this.posBigTable);
            allFetchOpDone = this.allFetchOpDone();
        }
        while (!allFetchOpDone && (ret = this.joinOneGroup()) != null && ret.size() != 0) {
            this.reportProgress();
            allFetchOpDone = this.allFetchOpDone();
        }
        boolean dataInCache = true;
        block2: while (dataInCache) {
            int i$;
            Byte[] arr$ = order;
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                byte t = arr$[i$];
                if (!this.foundNextKeyGroup.get(t).booleanValue() || this.nextKeyWritables.get(t) == null) continue;
                this.promoteNextGroupToCandidate(t);
            }
            this.joinOneGroup();
            dataInCache = false;
            arr$ = order;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                byte r = arr$[i$];
                if (this.candidateStorage.get(r).size() <= 0) continue;
                dataInCache = true;
                continue block2;
            }
        }
    }

    private boolean allFetchOpDone() {
        boolean allFetchOpDone = true;
        for (Byte tag : order) {
            if (tag == (byte)this.posBigTable) continue;
            allFetchOpDone = allFetchOpDone && this.fetchOpDone.get(tag) != false;
        }
        return allFetchOpDone;
    }

    private List<Byte> joinOneGroup() throws HiveException {
        int smallestPos = -1;
        smallestPos = this.findMostSmallKey();
        List<Byte> listOfNeedFetchNext = null;
        if (smallestPos >= 0 && (listOfNeedFetchNext = this.joinObject(smallestPos)).size() > 0) {
            for (Byte b : listOfNeedFetchNext) {
                this.fetchNextGroup(b);
            }
        }
        return listOfNeedFetchNext;
    }

    private List<Byte> joinObject(int smallestPos) throws HiveException {
        ArrayList<Byte> needFetchList = new ArrayList<Byte>();
        ArrayList<Object> smallKey = this.keyWritables.get((byte)smallestPos);
        needFetchList.add((byte)smallestPos);
        this.storage.put((byte)smallestPos, this.candidateStorage.get((byte)smallestPos));
        for (Byte i : order) {
            if ((byte)smallestPos == i) continue;
            ArrayList<Object> key = this.keyWritables.get(i);
            if (key == null) {
                this.putDummyOrEmpty(i);
                continue;
            }
            int cmp = this.compareKeys(key, smallKey);
            if (cmp == 0) {
                this.storage.put(Byte.valueOf(i), this.candidateStorage.get((byte)i));
                needFetchList.add(i);
                continue;
            }
            this.putDummyOrEmpty(i);
        }
        this.checkAndGenObject();
        for (Byte pos : needFetchList) {
            this.candidateStorage.get(pos).clear();
            this.keyWritables.remove(pos);
        }
        return needFetchList;
    }

    private void fetchNextGroup(Byte t) throws HiveException {
        if (this.foundNextKeyGroup.get(t).booleanValue()) {
            if (this.nextKeyWritables.get(t) != null) {
                this.promoteNextGroupToCandidate(t);
            } else {
                this.keyWritables.remove(t);
                this.candidateStorage.remove(t);
                this.nextGroupStorage.remove(t);
            }
            this.foundNextKeyGroup.put(t, Boolean.FALSE);
        }
        if (t == (byte)this.posBigTable) {
            return;
        }
        while (!this.foundNextKeyGroup.get(t).booleanValue() && !this.fetchOpDone.get(t).booleanValue()) {
            this.fetchOneRow(t);
        }
        if (!this.foundNextKeyGroup.get(t).booleanValue() && this.fetchOpDone.get(t).booleanValue()) {
            this.nextKeyWritables.remove(t);
        }
    }

    private void promoteNextGroupToCandidate(Byte t) throws HiveException {
        this.keyWritables.put(t, this.nextKeyWritables.get(t));
        this.nextKeyWritables.remove(t);
        RowContainer<ArrayList<Object>> oldRowContainer = this.candidateStorage.get(t);
        oldRowContainer.clear();
        this.candidateStorage.put(t, this.nextGroupStorage.get(t));
        this.nextGroupStorage.put(t, oldRowContainer);
    }

    private int compareKeys(ArrayList<Object> k1, ArrayList<Object> k2) {
        int ret = 0;
        for (int i = 0; i < k1.size() && i < k1.size(); ++i) {
            WritableComparable key_1 = (WritableComparable)k1.get(i);
            WritableComparable key_2 = (WritableComparable)k2.get(i);
            ret = WritableComparator.get(key_1.getClass()).compare(key_1, key_2);
            if (ret == 0) continue;
            return ret;
        }
        return k1.size() - k2.size();
    }

    private void putDummyOrEmpty(Byte i) {
        if (this.noOuterJoin) {
            this.storage.put(i, this.emptyList);
        } else {
            this.storage.put(i, this.dummyObjVectors[i.intValue()]);
        }
    }

    private int findMostSmallKey() {
        int index = -1;
        ArrayList<Object> mostSmallOne = null;
        Byte[] arr$ = order;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            byte i = arr$[i$];
            ArrayList<Object> key = this.keyWritables.get(i);
            if (key == null) continue;
            if (mostSmallOne == null) {
                mostSmallOne = key;
                index = i;
                continue;
            }
            int cmp = this.compareKeys(key, mostSmallOne);
            if (cmp >= 0) continue;
            mostSmallOne = key;
            index = i;
        }
        return index;
    }

    private boolean processKey(byte alias, ArrayList<Object> key) throws HiveException {
        ArrayList<Object> keyWritable = this.keyWritables.get(alias);
        if (keyWritable == null) {
            this.keyWritables.put(alias, key);
            return false;
        }
        int cmp = this.compareKeys(key, keyWritable);
        if (cmp != 0) {
            this.nextKeyWritables.put(alias, key);
            return true;
        }
        return false;
    }

    private void setUpFetchOpContext(FetchOperator fetchOp, String alias) {
        String currentInputFile = this.getExecContext().getCurrentInputFile();
        MapredLocalWork.BucketMapJoinContext bucketMatcherCxt = this.localWork.getBucketMapjoinContext();
        Class<? extends BucketMatcher> bucketMatcherCls = bucketMatcherCxt.getBucketMatcherClass();
        BucketMatcher bucketMatcher = (BucketMatcher)ReflectionUtils.newInstance(bucketMatcherCls, null);
        this.getExecContext().setFileId(bucketMatcherCxt.getBucketFileNameMapping().get(currentInputFile));
        LOG.info((Object)("set task id: " + this.getExecContext().getFileId()));
        bucketMatcher.setAliasBucketFileNameMapping(bucketMatcherCxt.getAliasBucketFileNameMapping());
        List<Path> aliasFiles = bucketMatcher.getAliasBucketFiles(currentInputFile, bucketMatcherCxt.getMapJoinBigTableAlias(), alias);
        Iterator<Path> iter = aliasFiles.iterator();
        fetchOp.setupContext(iter, null);
    }

    private void fetchOneRow(byte tag) {
        if (this.fetchOperators != null) {
            String tble = this.tagToAlias.get(tag);
            FetchOperator fetchOp = this.fetchOperators.get(tble);
            Operator<? extends Serializable> forwardOp = this.localWork.getAliasToWork().get(tble);
            try {
                InspectableObject row = fetchOp.getNextRow();
                if (row == null) {
                    this.fetchOpDone.put(tag, Boolean.TRUE);
                    return;
                }
                forwardOp.process(row.o, 0);
                if (forwardOp.getDone()) {
                    this.fetchOpDone.put(tag, Boolean.TRUE);
                }
            }
            catch (Throwable e) {
                if (e instanceof OutOfMemoryError) {
                    throw (OutOfMemoryError)e;
                }
                throw new RuntimeException("Map local work failed", e);
            }
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (this.closeCalled) {
            return;
        }
        this.closeCalled = true;
        if (this.getExecContext() != null && this.getExecContext().inputFileChanged() || !this.firstFetchHappened) {
            for (Map.Entry<String, FetchOperator> entry : this.fetchOperators.entrySet()) {
                String alias = entry.getKey();
                FetchOperator fetchOp = entry.getValue();
                fetchOp.clearFetchContext();
                this.setUpFetchOpContext(fetchOp, alias);
            }
            this.firstFetchHappened = true;
            for (Byte t : order) {
                if (t == (byte)this.posBigTable) continue;
                this.fetchNextGroup(t);
            }
        }
        this.joinFinalLeftData();
        for (Byte alias : order) {
            if (alias != (byte)this.posBigTable) {
                this.fetchOpDone.put(alias, Boolean.FALSE);
            }
            this.foundNextKeyGroup.put(alias, Boolean.FALSE);
        }
        this.localWorkInited = false;
        super.closeOp(abort);
        if (this.fetchOperators != null) {
            for (Map.Entry<String, FetchOperator> entry : this.fetchOperators.entrySet()) {
                Operator<? extends Serializable> forwardOp = this.localWork.getAliasToWork().get(entry.getKey());
                forwardOp.close(abort);
            }
        }
    }

    @Override
    protected boolean allInitializedParentsAreClosed() {
        return true;
    }

    @Override
    public String getName() {
        return "MAPJOIN";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.MAPJOIN;
    }
}

