/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewJoinOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.UDTFOperator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.ColumnPrunerProcCtx;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;

public final class ColumnPrunerProcFactory {
    protected static final Log LOG = LogFactory.getLog((String)ColumnPrunerProcFactory.class.getName());

    private ColumnPrunerProcFactory() {
    }

    public static ColumnPrunerFilterProc getFilterProc() {
        return new ColumnPrunerFilterProc();
    }

    public static ColumnPrunerGroupByProc getGroupByProc() {
        return new ColumnPrunerGroupByProc();
    }

    public static ColumnPrunerDefaultProc getDefaultProc() {
        return new ColumnPrunerDefaultProc();
    }

    public static ColumnPrunerTableScanProc getTableScanProc() {
        return new ColumnPrunerTableScanProc();
    }

    public static ColumnPrunerReduceSinkProc getReduceSinkProc() {
        return new ColumnPrunerReduceSinkProc();
    }

    private static boolean[] getPruneReduceSinkOpRetainFlags(List<String> retainedParentOpOutputCols, ReduceSinkOperator reduce) {
        ReduceSinkDesc reduceConf = (ReduceSinkDesc)reduce.getConf();
        ArrayList<ExprNodeDesc> originalValueEval = reduceConf.getValueCols();
        boolean[] flags = new boolean[originalValueEval.size()];
        block0: for (int i = 0; i < originalValueEval.size(); ++i) {
            flags[i] = false;
            List<String> current = originalValueEval.get(i).getCols();
            if (current == null || current.size() == 0) {
                flags[i] = true;
                continue;
            }
            for (int j = 0; j < current.size(); ++j) {
                if (!retainedParentOpOutputCols.contains(current.get(j))) continue;
                flags[i] = true;
                continue block0;
            }
        }
        return flags;
    }

    private static void pruneReduceSinkOperator(boolean[] retainFlags, ReduceSinkOperator reduce, ColumnPrunerProcCtx cppCtx) throws SemanticException {
        int i;
        ReduceSinkDesc reduceConf = (ReduceSinkDesc)reduce.getConf();
        Map<String, ExprNodeDesc> oldMap = reduce.getColumnExprMap();
        HashMap<String, ExprNodeDesc> newMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<ColumnInfo> sig = new ArrayList<ColumnInfo>();
        RowResolver oldRR = cppCtx.getOpToParseCtxMap().get(reduce).getRR();
        RowResolver newRR = new RowResolver();
        ArrayList<String> originalValueOutputColNames = reduceConf.getOutputValueColumnNames();
        ArrayList<ExprNodeDesc> originalValueEval = reduceConf.getValueCols();
        ArrayList<String> newOutputColNames = new ArrayList<String>();
        ArrayList<ExprNodeDesc> newValueEval = new ArrayList<ExprNodeDesc>();
        for (int i2 = 0; i2 < retainFlags.length; ++i2) {
            if (!retainFlags[i2]) continue;
            newValueEval.add(originalValueEval.get(i2));
            String outputCol = originalValueOutputColNames.get(i2);
            newOutputColNames.add(outputCol);
            String[] nm = oldRR.reverseLookup(outputCol);
            if (nm == null) {
                outputCol = Utilities.ReduceField.VALUE.toString() + "." + outputCol;
                nm = oldRR.reverseLookup(outputCol);
            }
            newMap.put(outputCol, oldMap.get(outputCol));
            ColumnInfo colInfo = oldRR.get(nm[0], nm[1]);
            newRR.put(nm[0], nm[1], colInfo);
            sig.add(colInfo);
        }
        ArrayList<ExprNodeDesc> keyCols = reduceConf.getKeyCols();
        List<String> keys = new ArrayList<String>();
        RowResolver parResover = cppCtx.getOpToParseCtxMap().get(reduce.getParentOperators().get(0)).getRR();
        for (i = 0; i < keyCols.size(); ++i) {
            keys = Utilities.mergeUniqElems(keys, keyCols.get(i).getCols());
        }
        for (i = 0; i < keys.size(); ++i) {
            String outputCol = (String)keys.get(i);
            String[] nm = parResover.reverseLookup(outputCol);
            ColumnInfo colInfo = oldRR.get(nm[0], nm[1]);
            if (colInfo == null) continue;
            newRR.put(nm[0], nm[1], colInfo);
        }
        cppCtx.getOpToParseCtxMap().get(reduce).setRR(newRR);
        reduce.setColumnExprMap(newMap);
        reduce.getSchema().setSignature(sig);
        reduceConf.setOutputValueColumnNames(newOutputColNames);
        reduceConf.setValueCols(newValueEval);
        TableDesc newValueTable = PlanUtils.getReduceValueTableDesc(PlanUtils.getFieldSchemasFromColumnList(reduceConf.getValueCols(), newOutputColNames, 0, ""));
        reduceConf.setValueSerializeInfo(newValueTable);
    }

    public static ColumnPrunerSelectProc getSelectProc() {
        return new ColumnPrunerSelectProc();
    }

    public static ColumnPrunerLateralViewJoinProc getLateralViewJoinProc() {
        return new ColumnPrunerLateralViewJoinProc();
    }

    public static ColumnPrunerJoinProc getJoinProc() {
        return new ColumnPrunerJoinProc();
    }

    private static void pruneOperator(NodeProcessorCtx ctx, Operator<? extends Serializable> op, List<String> cols) throws SemanticException {
        RowSchema inputSchema = op.getSchema();
        if (inputSchema != null) {
            ArrayList<ColumnInfo> rs = new ArrayList<ColumnInfo>();
            ArrayList<ColumnInfo> inputCols = inputSchema.getSignature();
            for (ColumnInfo i : inputCols) {
                if (!cols.contains(i.getInternalName())) continue;
                rs.add(i);
            }
            op.getSchema().setSignature(rs);
        }
    }

    private static void pruneJoinOperator(NodeProcessorCtx ctx, CommonJoinOperator op, JoinDesc conf, Map<String, ExprNodeDesc> columnExprMap, Map<Byte, List<Integer>> retainMap, boolean mapJoin) throws SemanticException {
        String internalName;
        ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
        HashMap<Byte, List<String>> prunedColLists = new HashMap<Byte, List<String>>();
        List<Operator<Serializable>> childOperators = op.getChildOperators();
        for (Operator<Serializable> child : childOperators) {
            if (!(child instanceof FileSinkOperator)) continue;
            return;
        }
        List<String> childColLists = cppCtx.genColLists(op);
        RowResolver joinRR = cppCtx.getOpToParseCtxMap().get(op).getRR();
        RowResolver newJoinRR = new RowResolver();
        ArrayList<String> outputCols = new ArrayList<String>();
        ArrayList<ColumnInfo> rs = new ArrayList<ColumnInfo>();
        HashMap<String, ExprNodeDesc> newColExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < conf.getOutputColumnNames().size(); ++i) {
            internalName = conf.getOutputColumnNames().get(i);
            ExprNodeDesc desc = columnExprMap.get(internalName);
            Byte tag = conf.getReversedExprs().get(internalName);
            if (!childColLists.contains(internalName)) {
                int index = conf.getExprs().get(tag).indexOf(desc);
                if (index < 0) continue;
                conf.getExprs().get(tag).remove(desc);
                if (retainMap == null) continue;
                retainMap.get(tag).remove(index);
                continue;
            }
            List<String> prunedRSList = (ArrayList<String>)prunedColLists.get(tag);
            if (prunedRSList == null) {
                prunedRSList = new ArrayList<String>();
                prunedColLists.put(tag, prunedRSList);
            }
            prunedRSList = Utilities.mergeUniqElems(prunedRSList, desc.getCols());
            outputCols.add(internalName);
            newColExprMap.put(internalName, desc);
        }
        if (mapJoin) {
            ArrayList<TableDesc> valueTableDescs = new ArrayList<TableDesc>();
            for (int pos = 0; pos < op.getParentOperators().size(); ++pos) {
                List<ExprNodeDesc> valueCols = conf.getExprs().get(new Byte((byte)pos));
                StringBuilder keyOrder = new StringBuilder();
                for (int i = 0; i < valueCols.size(); ++i) {
                    keyOrder.append("+");
                }
                TableDesc valueTableDesc = PlanUtils.getMapJoinValueTableDesc(PlanUtils.getFieldSchemasFromColumnList(valueCols, "mapjoinvalue"));
                valueTableDescs.add(valueTableDesc);
            }
            ((MapJoinDesc)conf).setValueTblDescs(valueTableDescs);
            Set<Map.Entry<Byte, List<ExprNodeDesc>>> exprs = ((MapJoinDesc)conf).getKeys().entrySet();
            for (Map.Entry<Byte, List<ExprNodeDesc>> entry : exprs) {
                List<ExprNodeDesc> lists = entry.getValue();
                for (int j = 0; j < lists.size(); ++j) {
                    ExprNodeDesc desc = lists.get(j);
                    Byte tag = entry.getKey();
                    List<String> cols = (List<String>)prunedColLists.get(tag);
                    cols = Utilities.mergeUniqElems(cols, desc.getCols());
                    prunedColLists.put(tag, cols);
                }
            }
        }
        for (Operator<Serializable> child : childOperators) {
            if (!(child instanceof ReduceSinkOperator)) continue;
            boolean[] flags = ColumnPrunerProcFactory.getPruneReduceSinkOpRetainFlags(childColLists, (ReduceSinkOperator)child);
            ColumnPrunerProcFactory.pruneReduceSinkOperator(flags, (ReduceSinkOperator)child, cppCtx);
        }
        for (int i = 0; i < outputCols.size(); ++i) {
            internalName = (String)outputCols.get(i);
            String[] nm = joinRR.reverseLookup(internalName);
            ColumnInfo col = joinRR.get(nm[0], nm[1]);
            newJoinRR.put(nm[0], nm[1], col);
            rs.add(col);
        }
        op.setColumnExprMap(newColExprMap);
        conf.setOutputColumnNames(outputCols);
        op.getSchema().setSignature(rs);
        cppCtx.getOpToParseCtxMap().get(op).setRR(newJoinRR);
        cppCtx.getJoinPrunedColLists().put(op, prunedColLists);
    }

    public static ColumnPrunerMapJoinProc getMapJoinProc() {
        return new ColumnPrunerMapJoinProc();
    }

    public static class ColumnPrunerMapJoinProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            MapJoinOperator op = (MapJoinOperator)nd;
            ColumnPrunerProcFactory.pruneJoinOperator(ctx, op, (JoinDesc)op.getConf(), op.getColumnExprMap(), ((MapJoinDesc)op.getConf()).getRetainList(), true);
            return null;
        }
    }

    public static class ColumnPrunerJoinProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            JoinOperator op = (JoinOperator)nd;
            ColumnPrunerProcFactory.pruneJoinOperator(ctx, op, (JoinDesc)op.getConf(), op.getColumnExprMap(), null, false);
            return null;
        }
    }

    public static class ColumnPrunerSelectProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            SelectOperator op = (SelectOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            ArrayList<String> cols = new ArrayList();
            if (op.getChildOperators() != null) {
                for (Operator<Serializable> child : op.getChildOperators()) {
                    if (!(child instanceof FileSinkOperator) && !(child instanceof ScriptOperator) && !(child instanceof UDTFOperator) && !(child instanceof LimitOperator) && !(child instanceof UnionOperator)) continue;
                    cppCtx.getPrunedColLists().put(op, cppCtx.getColsFromSelectExpr(op));
                    return null;
                }
            }
            cols = cppCtx.genColLists(op);
            SelectDesc conf = (SelectDesc)op.getConf();
            cppCtx.getPrunedColLists().put(op, cppCtx.getSelectColsFromChildren(op, cols));
            if (conf.isSelStarNoCompute()) {
                return null;
            }
            ArrayList<ExprNodeDesc> originalColList = ((SelectDesc)op.getConf()).getColList();
            ArrayList<String> columns = new ArrayList<String>();
            for (ExprNodeDesc expr : originalColList) {
                Utilities.mergeUniqElems(columns, expr.getCols());
            }
            ArrayList<String> originalOutputColumnNames = conf.getOutputColumnNames();
            if (cols.size() < originalOutputColumnNames.size()) {
                ArrayList<ExprNodeDesc> newColList = new ArrayList<ExprNodeDesc>();
                ArrayList<String> newOutputColumnNames = new ArrayList<String>();
                ArrayList<ColumnInfo> rs_oldsignature = op.getSchema().getSignature();
                ArrayList<ColumnInfo> rs_newsignature = new ArrayList<ColumnInfo>();
                RowResolver old_rr = cppCtx.getOpToParseCtxMap().get(op).getRR();
                RowResolver new_rr = new RowResolver();
                for (String col : cols) {
                    int index = originalOutputColumnNames.indexOf(col);
                    newOutputColumnNames.add(col);
                    newColList.add((ExprNodeDesc)originalColList.get(index));
                    rs_newsignature.add(rs_oldsignature.get(index));
                    String[] tabcol = old_rr.reverseLookup(col);
                    ColumnInfo columnInfo = old_rr.get(tabcol[0], tabcol[1]);
                    new_rr.put(tabcol[0], tabcol[1], columnInfo);
                }
                cppCtx.getOpToParseCtxMap().get(op).setRR(new_rr);
                op.getSchema().setSignature(rs_newsignature);
                conf.setColList(newColList);
                conf.setOutputColumnNames(newOutputColumnNames);
                this.handleChildren(op, cols, cppCtx);
            }
            return null;
        }

        private void handleChildren(SelectOperator op, List<String> retainedSelOutputCols, ColumnPrunerProcCtx cppCtx) throws SemanticException {
            for (Operator<Serializable> child : op.getChildOperators()) {
                if (child instanceof ReduceSinkOperator) {
                    boolean[] flags = ColumnPrunerProcFactory.getPruneReduceSinkOpRetainFlags(retainedSelOutputCols, (ReduceSinkOperator)child);
                    ColumnPrunerProcFactory.pruneReduceSinkOperator(flags, (ReduceSinkOperator)child, cppCtx);
                    continue;
                }
                if (!(child instanceof FilterOperator)) continue;
                for (Operator<Serializable> filterChild : child.getChildOperators()) {
                    if (!(filterChild instanceof ReduceSinkOperator)) continue;
                    boolean[] flags = ColumnPrunerProcFactory.getPruneReduceSinkOpRetainFlags(retainedSelOutputCols, (ReduceSinkOperator)filterChild);
                    ColumnPrunerProcFactory.pruneReduceSinkOperator(flags, (ReduceSinkOperator)filterChild, cppCtx);
                }
            }
        }
    }

    public static class ColumnPrunerLateralViewJoinProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            LateralViewJoinOperator op = (LateralViewJoinOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            List<Object> cols = new ArrayList();
            cols = cppCtx.genColLists(op);
            Map<String, ExprNodeDesc> colExprMap = op.getColumnExprMap();
            ArrayList<String> colsAfterReplacement = new ArrayList<String>();
            for (String string : cols) {
                if (colExprMap.containsKey(string)) {
                    ExprNodeDesc expr = colExprMap.get(string);
                    colsAfterReplacement.addAll(expr.getCols());
                    continue;
                }
                colsAfterReplacement.add(string);
            }
            cppCtx.getPrunedColLists().put(op, colsAfterReplacement);
            return null;
        }
    }

    public static class ColumnPrunerReduceSinkProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            ReduceSinkOperator op = (ReduceSinkOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            HashMap<Operator<? extends Serializable>, OpParseContext> opToParseCtxMap = cppCtx.getOpToParseCtxMap();
            RowResolver redSinkRR = opToParseCtxMap.get(op).getRR();
            ReduceSinkDesc conf = (ReduceSinkDesc)op.getConf();
            List<Operator<Serializable>> childOperators = op.getChildOperators();
            List<Operator<Serializable>> parentOperators = op.getParentOperators();
            List<String> colLists = new ArrayList<String>();
            ArrayList<ExprNodeDesc> keys = conf.getKeyCols();
            for (ExprNodeDesc key : keys) {
                colLists = Utilities.mergeUniqElems(colLists, key.getCols());
            }
            if (childOperators.size() == 1 && childOperators.get(0) instanceof JoinOperator) {
                assert (parentOperators.size() == 1);
                Operator<Serializable> par = parentOperators.get(0);
                JoinOperator childJoin = (JoinOperator)childOperators.get(0);
                RowResolver parRR = opToParseCtxMap.get(par).getRR();
                List<String> childJoinCols = cppCtx.getJoinPrunedColLists().get(childJoin).get((byte)conf.getTag());
                boolean[] flags = new boolean[conf.getValueCols().size()];
                for (int i = 0; i < flags.length; ++i) {
                    flags[i] = false;
                }
                if (childJoinCols != null && childJoinCols.size() > 0) {
                    Map<String, ExprNodeDesc> exprMap = op.getColumnExprMap();
                    for (String childCol : childJoinCols) {
                        ColumnInfo cInfo;
                        ExprNodeDesc desc = exprMap.get(childCol);
                        int index = conf.getValueCols().indexOf(desc);
                        flags[index] = true;
                        String[] nm = redSinkRR.reverseLookup(childCol);
                        if (nm == null || colLists.contains((cInfo = parRR.get(nm[0], nm[1])).getInternalName())) continue;
                        colLists.add(cInfo.getInternalName());
                    }
                }
                Collections.sort(colLists);
                ColumnPrunerProcFactory.pruneReduceSinkOperator(flags, op, cppCtx);
            } else {
                ArrayList<ExprNodeDesc> vals = conf.getValueCols();
                for (ExprNodeDesc val : vals) {
                    colLists = Utilities.mergeUniqElems(colLists, val.getCols());
                }
            }
            cppCtx.getPrunedColLists().put(op, colLists);
            return null;
        }
    }

    public static class ColumnPrunerTableScanProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            TableScanOperator scanOp = (TableScanOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            List<String> cols = cppCtx.genColLists((Operator)nd);
            cppCtx.getPrunedColLists().put((Operator)nd, cols);
            ArrayList<Integer> needed_columns = new ArrayList<Integer>();
            RowResolver inputRR = cppCtx.getOpToParseCtxMap().get(scanOp).getRR();
            for (int i = 0; i < cols.size(); ++i) {
                int position = inputRR.getPosition(cols.get(i));
                if (position < 0) continue;
                needed_columns.add(position);
            }
            scanOp.setNeededColumnIDs(needed_columns);
            return null;
        }
    }

    public static class ColumnPrunerDefaultProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            cppCtx.getPrunedColLists().put((Operator)nd, cppCtx.genColLists((Operator)nd));
            return null;
        }
    }

    public static class ColumnPrunerGroupByProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            GroupByOperator op = (GroupByOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            List<String> colLists = new ArrayList<String>();
            GroupByDesc conf = (GroupByDesc)op.getConf();
            ArrayList<ExprNodeDesc> keys = conf.getKeys();
            for (ExprNodeDesc key : keys) {
                colLists = Utilities.mergeUniqElems(colLists, key.getCols());
            }
            ArrayList<AggregationDesc> aggrs = conf.getAggregators();
            for (AggregationDesc aggr : aggrs) {
                ArrayList<ExprNodeDesc> params = aggr.getParameters();
                for (ExprNodeDesc param : params) {
                    colLists = Utilities.mergeUniqElems(colLists, param.getCols());
                }
            }
            cppCtx.getPrunedColLists().put(op, colLists);
            return null;
        }
    }

    public static class ColumnPrunerFilterProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            FilterOperator op = (FilterOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            ExprNodeDesc condn = ((FilterDesc)op.getConf()).getPredicate();
            List<String> cl = condn.getCols();
            cppCtx.getPrunedColLists().put(op, Utilities.mergeUniqElems(cppCtx.genColLists(op), cl));
            ColumnPrunerProcFactory.pruneOperator(cppCtx, op, cppCtx.getPrunedColLists().get(op));
            return null;
        }
    }
}

