/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ExtractOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.ForwardOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;

public class ReduceSinkDeDuplication
implements Transform {
    protected ParseContext pGraphContext;

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        this.pGraphContext = pctx;
        ReduceSinkDeduplicateProcCtx cppCtx = new ReduceSinkDeduplicateProcCtx(this.pGraphContext);
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", "RS%.*RS%"), ReduceSinkDeduplicateProcFactory.getReducerReducerProc());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(ReduceSinkDeduplicateProcFactory.getDefaultProc(), opRules, cppCtx);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(this.pGraphContext.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return this.pGraphContext;
    }

    static class ReduceSinkDeduplicateProcFactory {
        ReduceSinkDeduplicateProcFactory() {
        }

        public static NodeProcessor getReducerReducerProc() {
            return new ReducerReducerProc();
        }

        public static NodeProcessor getDefaultProc() {
            return new DefaultProc();
        }

        static class ReducerReducerProc
        implements NodeProcessor {
            ReducerReducerProc() {
            }

            @Override
            public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
                ReduceSinkDeduplicateProcCtx ctx = (ReduceSinkDeduplicateProcCtx)procCtx;
                ReduceSinkOperator childReduceSink = (ReduceSinkOperator)nd;
                if (ctx.contains(childReduceSink)) {
                    return null;
                }
                ParseContext pGraphContext = ctx.getPctx();
                HashMap<String, String> childColumnMapping = this.getPartitionAndKeyColumnMapping(childReduceSink);
                ReduceSinkOperator parentRS = null;
                parentRS = this.findSingleParentReduceSink(childReduceSink, pGraphContext);
                if (parentRS == null) {
                    ctx.addRejectedReduceSinkOperator(childReduceSink);
                    return null;
                }
                HashMap<String, String> parentColumnMapping = this.getPartitionAndKeyColumnMapping(parentRS);
                Operator stopBacktrackFlagOp = null;
                if (parentRS.getParentOperators() == null || parentRS.getParentOperators().size() == 0) {
                    stopBacktrackFlagOp = parentRS;
                } else {
                    if (parentRS.getParentOperators().size() != 1) {
                        return null;
                    }
                    stopBacktrackFlagOp = parentRS.getParentOperators().get(0);
                }
                boolean succeed = this.backTrackColumnNames(childColumnMapping, childReduceSink, stopBacktrackFlagOp, pGraphContext);
                if (!succeed) {
                    return null;
                }
                succeed = this.backTrackColumnNames(parentColumnMapping, parentRS, stopBacktrackFlagOp, pGraphContext);
                if (!succeed) {
                    return null;
                }
                boolean same = this.compareReduceSink(childReduceSink, parentRS, childColumnMapping, parentColumnMapping);
                if (!same) {
                    return null;
                }
                this.replaceReduceSinkWithSelectOperator(childReduceSink, pGraphContext);
                return null;
            }

            private void replaceReduceSinkWithSelectOperator(ReduceSinkOperator childReduceSink, ParseContext pGraphContext) throws SemanticException {
                List<Operator<Serializable>> parentOp = childReduceSink.getParentOperators();
                List<Operator<? extends Serializable>> childOp = childReduceSink.getChildOperators();
                Operator oldParent = childReduceSink;
                if (childOp != null && childOp.size() == 1 && childOp.get(0) instanceof ExtractOperator) {
                    oldParent = childOp.get(0);
                    childOp = childOp.get(0).getChildOperators();
                }
                Operator<Serializable> input = parentOp.get(0);
                input.getChildOperators().clear();
                RowResolver inputRR = pGraphContext.getOpParseCtx().get(input).getRR();
                ArrayList<ExprNodeDesc> exprs = new ArrayList<ExprNodeDesc>();
                ArrayList<String> outputs = new ArrayList<String>();
                ArrayList<String> outputCols = ((ReduceSinkDesc)childReduceSink.getConf()).getOutputValueColumnNames();
                RowResolver outputRS = new RowResolver();
                HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
                for (int i = 0; i < outputCols.size(); ++i) {
                    String internalName = (String)outputCols.get(i);
                    String[] nm = inputRR.reverseLookup(internalName);
                    ColumnInfo valueInfo = inputRR.get(nm[0], nm[1]);
                    ExprNodeDesc colDesc = ((ReduceSinkDesc)childReduceSink.getConf()).getValueCols().get(i);
                    exprs.add(colDesc);
                    outputs.add(internalName);
                    outputRS.put(nm[0], nm[1], new ColumnInfo(internalName, valueInfo.getType(), nm[0], valueInfo.getIsPartitionCol()));
                    colExprMap.put(internalName, colDesc);
                }
                SelectDesc select = new SelectDesc(exprs, outputs, false);
                SelectOperator sel = (SelectOperator)this.putOpInsertMap(OperatorFactory.getAndMakeChild(select, new RowSchema(inputRR.getColumnInfos()), input), inputRR, pGraphContext);
                sel.setColumnExprMap(colExprMap);
                sel.setChildOperators(childOp);
                for (Operator<? extends Serializable> ch : childOp) {
                    ch.replaceParent(oldParent, sel);
                }
            }

            private Operator<? extends Serializable> putOpInsertMap(Operator<? extends Serializable> op, RowResolver rr, ParseContext pGraphContext) {
                OpParseContext ctx = new OpParseContext(rr);
                pGraphContext.getOpParseCtx().put(op, ctx);
                return op;
            }

            private boolean compareReduceSink(ReduceSinkOperator childReduceSink, ReduceSinkOperator parentRS, HashMap<String, String> childColumnMapping, HashMap<String, String> parentColumnMapping) {
                ArrayList<ExprNodeDesc> parentReduceKeyCols;
                ArrayList<ExprNodeDesc> parentPartitionCols;
                ArrayList<ExprNodeDesc> childPartitionCols = ((ReduceSinkDesc)childReduceSink.getConf()).getPartitionCols();
                boolean ret = this.compareExprNodes(childColumnMapping, parentColumnMapping, childPartitionCols, parentPartitionCols = ((ReduceSinkDesc)parentRS.getConf()).getPartitionCols());
                if (!ret) {
                    return false;
                }
                ArrayList<ExprNodeDesc> childReduceKeyCols = ((ReduceSinkDesc)childReduceSink.getConf()).getKeyCols();
                ret = this.compareExprNodes(childColumnMapping, parentColumnMapping, childReduceKeyCols, parentReduceKeyCols = ((ReduceSinkDesc)parentRS.getConf()).getKeyCols());
                if (!ret) {
                    return false;
                }
                String childRSOrder = ((ReduceSinkDesc)childReduceSink.getConf()).getOrder();
                String parentRSOrder = ((ReduceSinkDesc)parentRS.getConf()).getOrder();
                boolean moveChildRSOrderToParent = false;
                if (childRSOrder != null && !childRSOrder.trim().equals("")) {
                    if (parentRSOrder == null || !childRSOrder.trim().equals(parentRSOrder.trim())) {
                        return false;
                    }
                } else if (parentRSOrder == null || parentRSOrder.trim().equals("")) {
                    moveChildRSOrderToParent = true;
                }
                int childNumReducers = ((ReduceSinkDesc)childReduceSink.getConf()).getNumReducers();
                int parentNumReducers = ((ReduceSinkDesc)parentRS.getConf()).getNumReducers();
                boolean moveChildReducerNumToParent = false;
                if (childNumReducers != parentNumReducers && childNumReducers != -1) {
                    if (parentNumReducers == -1) {
                        moveChildReducerNumToParent = true;
                    } else {
                        return false;
                    }
                }
                if (moveChildRSOrderToParent) {
                    ((ReduceSinkDesc)parentRS.getConf()).setOrder(childRSOrder);
                }
                if (moveChildReducerNumToParent) {
                    ((ReduceSinkDesc)parentRS.getConf()).setNumReducers(childNumReducers);
                }
                return true;
            }

            private boolean compareExprNodes(HashMap<String, String> childColumnMapping, HashMap<String, String> parentColumnMapping, ArrayList<ExprNodeDesc> childColExprs, ArrayList<ExprNodeDesc> parentColExprs) {
                boolean parentEmpty;
                boolean childEmpty = childColExprs == null || childColExprs.size() == 0;
                boolean bl = parentEmpty = parentColExprs == null || parentColExprs.size() == 0;
                if (childEmpty) {
                    return true;
                }
                if (parentEmpty) {
                    return false;
                }
                if (childColExprs.size() != parentColExprs.size()) {
                    return false;
                }
                for (int i = 0; i < childColExprs.size(); ++i) {
                    ExprNodeDesc childExpr = childColExprs.get(i);
                    ExprNodeDesc parentExpr = parentColExprs.get(i);
                    if (childExpr instanceof ExprNodeColumnDesc && parentExpr instanceof ExprNodeColumnDesc) {
                        String parentCol;
                        String childCol = childColumnMapping.get(((ExprNodeColumnDesc)childExpr).getColumn());
                        if (childCol.equals(parentCol = parentColumnMapping.get(((ExprNodeColumnDesc)childExpr).getColumn()))) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }

            private boolean backTrackColumnNames(HashMap<String, String> columnMapping, ReduceSinkOperator reduceSink, Operator<? extends Serializable> stopBacktrackFlagOp, ParseContext pGraphContext) {
                Operator startOperator = reduceSink;
                while (startOperator != null && startOperator != stopBacktrackFlagOp) {
                    Map<String, ExprNodeDesc> colExprMap = (startOperator = startOperator.getParentOperators().get(0)).getColumnExprMap();
                    if (colExprMap == null || colExprMap.size() == 0) continue;
                    for (String key : columnMapping.keySet()) {
                        String oldCol = columnMapping.get(key);
                        ExprNodeDesc exprNode = colExprMap.get(oldCol);
                        if (exprNode instanceof ExprNodeColumnDesc) {
                            String col = ((ExprNodeColumnDesc)exprNode).getColumn();
                            columnMapping.put(key, col);
                            continue;
                        }
                        return false;
                    }
                }
                return true;
            }

            private HashMap<String, String> getPartitionAndKeyColumnMapping(ReduceSinkOperator reduceSink) {
                List<String> cols;
                HashMap<String, String> columnMapping = new HashMap<String, String>();
                ReduceSinkDesc reduceSinkDesc = (ReduceSinkDesc)reduceSink.getConf();
                ArrayList<ExprNodeDesc> partitionCols = reduceSinkDesc.getPartitionCols();
                ArrayList<ExprNodeDesc> reduceKeyCols = reduceSinkDesc.getKeyCols();
                if (partitionCols != null) {
                    for (ExprNodeDesc desc : partitionCols) {
                        cols = desc.getCols();
                        for (String col : cols) {
                            columnMapping.put(col, col);
                        }
                    }
                }
                if (reduceKeyCols != null) {
                    for (ExprNodeDesc desc : reduceKeyCols) {
                        cols = desc.getCols();
                        for (String col : cols) {
                            columnMapping.put(col, col);
                        }
                    }
                }
                return columnMapping;
            }

            private ReduceSinkOperator findSingleParentReduceSink(ReduceSinkOperator childReduceSink, ParseContext pGraphContext) {
                Operator start = childReduceSink;
                while (start != null) {
                    if (start.getParentOperators() == null || start.getParentOperators().size() != 1) {
                        return null;
                    }
                    boolean allowed = false;
                    if (start instanceof SelectOperator || start instanceof FilterOperator || start instanceof ExtractOperator || start instanceof ForwardOperator || start instanceof ScriptOperator || start instanceof ReduceSinkOperator) {
                        allowed = true;
                    }
                    if (!allowed) {
                        return null;
                    }
                    if (start instanceof ScriptOperator && !HiveConf.getBoolVar(pGraphContext.getConf(), HiveConf.ConfVars.HIVESCRIPTOPERATORTRUST)) {
                        return null;
                    }
                    if (!((start = start.getParentOperators().get(0)) instanceof ReduceSinkOperator)) continue;
                    return start;
                }
                return null;
            }
        }

        static class DefaultProc
        implements NodeProcessor {
            DefaultProc() {
            }

            @Override
            public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
                return null;
            }
        }
    }

    class ReduceSinkDeduplicateProcCtx
    implements NodeProcessorCtx {
        ParseContext pctx;
        List<ReduceSinkOperator> rejectedRSList = new ArrayList<ReduceSinkOperator>();

        public ReduceSinkDeduplicateProcCtx(ParseContext pctx) {
            this.pctx = pctx;
        }

        public boolean contains(ReduceSinkOperator rsOp) {
            return this.rejectedRSList.contains(rsOp);
        }

        public void addRejectedReduceSinkOperator(ReduceSinkOperator rsOp) {
            if (!this.rejectedRSList.contains(rsOp)) {
                this.rejectedRSList.add(rsOp);
            }
        }

        public ParseContext getPctx() {
            return this.pctx;
        }

        public void setPctx(ParseContext pctx) {
            this.pctx = pctx;
        }
    }
}

