/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableSimpleDesc;
import org.apache.hadoop.hive.ql.plan.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DescFunctionDesc;
import org.apache.hadoop.hive.ql.plan.DescTableDesc;
import org.apache.hadoop.hive.ql.plan.DropDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.MsckDesc;
import org.apache.hadoop.hive.ql.plan.ShowDatabasesDesc;
import org.apache.hadoop.hive.ql.plan.ShowFunctionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowPartitionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowTableStatusDesc;
import org.apache.hadoop.hive.ql.plan.ShowTablesDesc;
import org.apache.hadoop.hive.ql.plan.SwitchDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.TextInputFormat;

public class DDLSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.parse.DDLSemanticAnalyzer");
    public static final Map<Integer, String> TokenToTypeName = new HashMap<Integer, String>();
    public static final Set<String> reservedPartitionValues = new HashSet<String>();

    public static String getTypeName(int token) throws SemanticException {
        if (token == 73 || token == 74 || token == 75) {
            throw new SemanticException(ErrorMsg.UNSUPPORTED_TYPE.getMsg());
        }
        return TokenToTypeName.get(token);
    }

    public DDLSemanticAnalyzer(HiveConf conf) throws SemanticException {
        super(conf);
        reservedPartitionValues.add(HiveConf.getVar(conf, HiveConf.ConfVars.DEFAULTPARTITIONNAME));
        reservedPartitionValues.add(HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_ORIGINAL));
        reservedPartitionValues.add(HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_ARCHIVED));
        reservedPartitionValues.add(HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_EXTRACTED));
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        if (ast.getToken().getType() == 108) {
            this.analyzeDropTable(ast, false);
        } else if (ast.getToken().getType() == 83) {
            this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
            this.analyzeDescribeTable(ast);
        } else if (ast.getToken().getType() == 100) {
            this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
            this.analyzeShowDatabases(ast);
        } else if (ast.getToken().getType() == 101) {
            this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
            this.analyzeShowTables(ast);
        } else if (ast.getToken().getType() == 104) {
            this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
            this.analyzeShowTableStatus(ast);
        } else if (ast.getToken().getType() == 102) {
            this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
            this.analyzeShowFunctions(ast);
        } else if (ast.getToken().getType() == 84) {
            this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
            this.analyzeDescFunction(ast);
        } else if (ast.getToken().getType() == 99) {
            this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
            this.analyzeMetastoreCheck(ast);
        } else if (ast.getToken().getType() == 136) {
            this.analyzeDropTable(ast, true);
        } else if (ast.getToken().getType() == 137) {
            this.analyzeAlterTableProps(ast, true);
        } else if (ast.getToken().getType() == 85) {
            this.analyzeAlterTableRename(ast);
        } else if (ast.getToken().getType() == 91) {
            this.analyzeAlterTableTouch(ast);
        } else if (ast.getToken().getType() == 92) {
            this.analyzeAlterTableArchive(ast, false);
        } else if (ast.getToken().getType() == 93) {
            this.analyzeAlterTableArchive(ast, true);
        } else if (ast.getToken().getType() == 86) {
            this.analyzeAlterTableModifyCols(ast, AlterTableDesc.AlterTableTypes.ADDCOLS);
        } else if (ast.getToken().getType() == 88) {
            this.analyzeAlterTableModifyCols(ast, AlterTableDesc.AlterTableTypes.REPLACECOLS);
        } else if (ast.getToken().getType() == 87) {
            this.analyzeAlterTableRenameCol(ast);
        } else if (ast.getToken().getType() == 89) {
            this.analyzeAlterTableAddParts(ast);
        } else if (ast.getToken().getType() == 90) {
            this.analyzeAlterTableDropParts(ast);
        } else if (ast.getToken().getType() == 97) {
            this.analyzeAlterTableProps(ast, false);
        } else if (ast.getToken().getType() == 94) {
            this.analyzeAlterTableSerdeProps(ast);
        } else if (ast.getToken().getType() == 95) {
            this.analyzeAlterTableSerde(ast);
        } else if (ast.getToken().getType() == 96) {
            this.analyzeAlterTableFileFormat(ast);
        } else if (ast.getToken().getType() == 124) {
            this.analyzeAlterTableClusterSort(ast);
        } else if (ast.getToken().getType() == 103) {
            this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
            this.analyzeShowPartitions(ast);
        } else if (ast.getToken().getType() == 80) {
            this.analyzeCreateDatabase(ast);
        } else if (ast.getToken().getType() == 106) {
            this.analyzeDropDatabase(ast);
        } else if (ast.getToken().getType() == 105) {
            this.analyzeSwitchDatabase(ast);
        } else {
            throw new SemanticException("Unsupported command.");
        }
    }

    private void analyzeCreateDatabase(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        boolean ifNotExists = false;
        String dbComment = null;
        block4: for (int i = 1; i < ast.getChildCount(); ++i) {
            ASTNode childNode = (ASTNode)ast.getChild(i);
            switch (childNode.getToken().getType()) {
                case 145: {
                    ifNotExists = true;
                    continue block4;
                }
                case 107: {
                    dbComment = DDLSemanticAnalyzer.unescapeSQLString(childNode.getChild(0).getText());
                    continue block4;
                }
                default: {
                    throw new SemanticException("Unrecognized token in CREATE DATABASE statement");
                }
            }
        }
        CreateDatabaseDesc createDatabaseDesc = new CreateDatabaseDesc();
        createDatabaseDesc.setName(dbName);
        createDatabaseDesc.setComment(dbComment);
        createDatabaseDesc.setIfNotExists(ifNotExists);
        createDatabaseDesc.setLocationUri(null);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), createDatabaseDesc), this.conf, new Task[0]));
    }

    private void analyzeDropDatabase(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        boolean ifExists = false;
        if (null != ast.getFirstChildWithType(146)) {
            ifExists = true;
        }
        DropDatabaseDesc dropDatabaseDesc = new DropDatabaseDesc(dbName, ifExists);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropDatabaseDesc), this.conf, new Task[0]));
    }

    private void analyzeSwitchDatabase(ASTNode ast) {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        SwitchDatabaseDesc switchDatabaseDesc = new SwitchDatabaseDesc(dbName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), switchDatabaseDesc), this.conf, new Task[0]));
    }

    private void analyzeDropTable(ASTNode ast, boolean expectView) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        DropTableDesc dropTblDesc = new DropTableDesc(tableName, expectView);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableProps(ASTNode ast, boolean expectView) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(1).getChild(0));
        AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ADDPROPS, expectView);
        alterTblDesc.setProps(mapProp);
        alterTblDesc.setOldName(tableName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableSerdeProps(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(1).getChild(0));
        AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ADDSERDEPROPS);
        alterTblDesc.setProps(mapProp);
        alterTblDesc.setOldName(tableName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableSerde(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String serdeName = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(1).getText());
        AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ADDSERDE);
        if (ast.getChildCount() > 2) {
            HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(2).getChild(0));
            alterTblDesc.setProps(mapProp);
        }
        alterTblDesc.setOldName(tableName);
        alterTblDesc.setSerdeName(serdeName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableFileFormat(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String inputFormat = null;
        String outputFormat = null;
        String storageHandler = null;
        String serde = null;
        ASTNode child = (ASTNode)ast.getChild(1);
        switch (child.getToken().getType()) {
            case 122: {
                inputFormat = DDLSemanticAnalyzer.unescapeSQLString(((ASTNode)child.getChild(0)).getToken().getText());
                outputFormat = DDLSemanticAnalyzer.unescapeSQLString(((ASTNode)child.getChild(1)).getToken().getText());
                try {
                    Class.forName(inputFormat);
                    Class.forName(outputFormat);
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new SemanticException(e);
                }
            }
            case 123: {
                storageHandler = DDLSemanticAnalyzer.unescapeSQLString(((ASTNode)child.getChild(1)).getToken().getText());
                try {
                    Class.forName(storageHandler);
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new SemanticException(e);
                }
            }
            case 119: {
                inputFormat = SEQUENCEFILE_INPUT;
                outputFormat = SEQUENCEFILE_OUTPUT;
                break;
            }
            case 120: {
                inputFormat = TEXTFILE_INPUT;
                outputFormat = TEXTFILE_OUTPUT;
                break;
            }
            case 121: {
                inputFormat = RCFILE_INPUT;
                outputFormat = RCFILE_OUTPUT;
                serde = COLUMNAR_SERDE;
            }
        }
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, inputFormat, outputFormat, serde, storageHandler);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableClusterSort(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        ASTNode buckets = (ASTNode)ast.getChild(1);
        List<String> bucketCols = this.getColumnNames((ASTNode)buckets.getChild(0));
        ArrayList<Order> sortCols = new ArrayList();
        int numBuckets = -1;
        if (buckets.getChildCount() == 2) {
            numBuckets = Integer.valueOf(buckets.getChild(1).getText());
        } else {
            sortCols = this.getColumnNamesOrder((ASTNode)buckets.getChild(1));
            numBuckets = Integer.valueOf(buckets.getChild(2).getText());
        }
        if (numBuckets <= 0) {
            throw new SemanticException(ErrorMsg.INVALID_BUCKET_NUMBER.getMsg());
        }
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, numBuckets, bucketCols, sortCols);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    static HashMap<String, String> getProps(ASTNode prop) {
        HashMap<String, String> mapProp = new HashMap<String, String>();
        DDLSemanticAnalyzer.readProps(prop, mapProp);
        return mapProp;
    }

    private String getFullyQualifiedName(ASTNode ast) {
        if (ast.getChildCount() == 0) {
            return ast.getText();
        }
        return this.getFullyQualifiedName((ASTNode)ast.getChild(0)) + "." + this.getFullyQualifiedName((ASTNode)ast.getChild(1));
    }

    private FetchTask createFetchTask(String schema) {
        Properties prop = new Properties();
        prop.setProperty("serialization.format", "9");
        prop.setProperty("serialization.null.format", " ");
        String[] colTypes = schema.split("#");
        prop.setProperty("columns", colTypes[0]);
        prop.setProperty("columns.types", colTypes[1]);
        FetchWork fetch = new FetchWork(this.ctx.getResFile().toString(), new TableDesc(LazySimpleSerDe.class, TextInputFormat.class, IgnoreKeyTextOutputFormat.class, prop), -1);
        fetch.setSerializationNullFormat(" ");
        return (FetchTask)TaskFactory.get(fetch, this.conf, new Task[0]);
    }

    private void analyzeDescribeTable(ASTNode ast) throws SemanticException {
        ASTNode tableTypeExpr = (ASTNode)ast.getChild(0);
        String tableName = this.getFullyQualifiedName((ASTNode)tableTypeExpr.getChild(0));
        HashMap<String, String> partSpec = null;
        if (tableTypeExpr.getChildCount() == 2) {
            ASTNode partspec = (ASTNode)tableTypeExpr.getChild(1);
            partSpec = this.getPartSpec(partspec);
        }
        boolean isExt = ast.getChildCount() > 1;
        DescTableDesc descTblDesc = new DescTableDesc(this.ctx.getResFile(), tableName, partSpec, isExt);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), descTblDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(descTblDesc.getSchema()));
        LOG.info((Object)"analyzeDescribeTable done");
    }

    private HashMap<String, String> getPartSpec(ASTNode partspec) throws SemanticException {
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        for (int i = 0; i < partspec.getChildCount(); ++i) {
            ASTNode partspec_val = (ASTNode)partspec.getChild(i);
            String val = DDLSemanticAnalyzer.stripQuotes(partspec_val.getChild(1).getText());
            partSpec.put(partspec_val.getChild(0).getText().toLowerCase(), val);
        }
        return partSpec;
    }

    private void analyzeShowPartitions(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        assert (partSpecs.size() <= 1);
        Map<String, String> partSpec = null;
        if (partSpecs.size() > 0) {
            partSpec = partSpecs.get(0);
        }
        ShowPartitionsDesc showPartsDesc = new ShowPartitionsDesc(tableName, this.ctx.getResFile(), partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showPartsDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showPartsDesc.getSchema()));
    }

    private void analyzeShowDatabases(ASTNode ast) throws SemanticException {
        ShowDatabasesDesc showDatabasesDesc;
        if (ast.getChildCount() == 1) {
            String databasePattern = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
            showDatabasesDesc = new ShowDatabasesDesc(this.ctx.getResFile(), databasePattern);
        } else {
            showDatabasesDesc = new ShowDatabasesDesc(this.ctx.getResFile());
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showDatabasesDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showDatabasesDesc.getSchema()));
    }

    private void analyzeShowTables(ASTNode ast) throws SemanticException {
        ShowTablesDesc showTblsDesc;
        if (ast.getChildCount() == 1) {
            String tableNames = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
            showTblsDesc = new ShowTablesDesc(this.ctx.getResFile(), tableNames);
        } else {
            showTblsDesc = new ShowTablesDesc(this.ctx.getResFile());
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showTblsDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showTblsDesc.getSchema()));
    }

    private void analyzeShowTableStatus(ASTNode ast) throws SemanticException {
        String tableNames = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String dbName = this.db.getCurrentDatabase();
        int children = ast.getChildCount();
        HashMap<String, String> partSpec = null;
        if (children >= 2) {
            if (children > 3) {
                throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg());
            }
            for (int i = 1; i < children; ++i) {
                ASTNode child = (ASTNode)ast.getChild(i);
                if (child.getToken().getType() == 175) {
                    dbName = DDLSemanticAnalyzer.unescapeIdentifier(child.getText());
                    continue;
                }
                if (child.getToken().getType() == 11) {
                    partSpec = this.getPartSpec(child);
                    continue;
                }
                throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg());
            }
        }
        ShowTableStatusDesc showTblStatusDesc = new ShowTableStatusDesc(this.ctx.getResFile().toString(), dbName, tableNames, partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showTblStatusDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showTblStatusDesc.getSchema()));
    }

    private void analyzeShowFunctions(ASTNode ast) throws SemanticException {
        ShowFunctionsDesc showFuncsDesc;
        if (ast.getChildCount() == 1) {
            String funcNames = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            showFuncsDesc = new ShowFunctionsDesc(this.ctx.getResFile(), funcNames);
        } else {
            showFuncsDesc = new ShowFunctionsDesc(this.ctx.getResFile());
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showFuncsDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showFuncsDesc.getSchema()));
    }

    private void analyzeDescFunction(ASTNode ast) throws SemanticException {
        boolean isExtended;
        String funcName;
        if (ast.getChildCount() == 1) {
            funcName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = false;
        } else if (ast.getChildCount() == 2) {
            funcName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = true;
        } else {
            throw new SemanticException("Unexpected Tokens at DESCRIBE FUNCTION");
        }
        DescFunctionDesc descFuncDesc = new DescFunctionDesc(this.ctx.getResFile(), funcName, isExtended);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), descFuncDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(descFuncDesc.getSchema()));
    }

    private void analyzeAlterTableRename(ASTNode ast) throws SemanticException {
        AlterTableDesc alterTblDesc = new AlterTableDesc(DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText()), DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText()));
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableRenameCol(ASTNode ast) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String newComment = null;
        String newType = null;
        newType = DDLSemanticAnalyzer.getTypeStringFromAST((ASTNode)ast.getChild(3));
        boolean first = false;
        String flagCol = null;
        ASTNode positionNode = null;
        if (ast.getChildCount() == 6) {
            newComment = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(4).getText());
            positionNode = (ASTNode)ast.getChild(5);
        } else if (ast.getChildCount() == 5) {
            if (ast.getChild(4).getType() == 165) {
                newComment = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(4).getText());
            } else {
                positionNode = (ASTNode)ast.getChild(4);
            }
        }
        if (positionNode != null) {
            if (positionNode.getChildCount() == 0) {
                first = true;
            } else {
                flagCol = DDLSemanticAnalyzer.unescapeIdentifier(positionNode.getChild(0).getText());
            }
        }
        AlterTableDesc alterTblDesc = new AlterTableDesc(tblName, DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText()), DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(2).getText()), newType, newComment, first, flagCol);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableModifyCols(ASTNode ast, AlterTableDesc.AlterTableTypes alterType) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        List<FieldSchema> newCols = this.getColumns((ASTNode)ast.getChild(1));
        AlterTableDesc alterTblDesc = new AlterTableDesc(tblName, newCols, alterType);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableDropParts(ASTNode ast) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        DropTableDesc dropTblDesc = new DropTableDesc(tblName, partSpecs);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableAddParts(CommonTree ast) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        Iterator<Map<String, String>> partIter = partSpecs.iterator();
        String currentLocation = null;
        Map<String, String> currentPart = null;
        boolean ifNotExists = false;
        int numCh = ast.getChildCount();
        block5: for (int num = 1; num < numCh; ++num) {
            CommonTree child = (CommonTree)ast.getChild(num);
            switch (child.getToken().getType()) {
                case 145: {
                    ifNotExists = true;
                    continue block5;
                }
                case 11: {
                    if (currentPart != null) {
                        this.validatePartitionValues(currentPart);
                        AddPartitionDesc addPartitionDesc = new AddPartitionDesc(this.db.getCurrentDatabase(), tblName, currentPart, currentLocation, ifNotExists);
                        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), addPartitionDesc), this.conf, new Task[0]));
                    }
                    currentLocation = null;
                    currentPart = partIter.next();
                    continue block5;
                }
                case 127: {
                    currentLocation = DDLSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block5;
                }
                default: {
                    throw new SemanticException("Unknown child: " + child);
                }
            }
        }
        if (currentPart != null) {
            this.validatePartitionValues(currentPart);
            AddPartitionDesc addPartitionDesc = new AddPartitionDesc(this.db.getCurrentDatabase(), tblName, currentPart, currentLocation, ifNotExists);
            this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), addPartitionDesc), this.conf, new Task[0]));
        }
    }

    private void analyzeAlterTableTouch(CommonTree ast) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        if (partSpecs.size() == 0) {
            AlterTableSimpleDesc touchDesc = new AlterTableSimpleDesc(this.db.getCurrentDatabase(), tblName, null, AlterTableDesc.AlterTableTypes.TOUCH);
            this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), touchDesc), this.conf, new Task[0]));
        } else {
            for (Map<String, String> partSpec : partSpecs) {
                AlterTableSimpleDesc touchDesc = new AlterTableSimpleDesc(this.db.getCurrentDatabase(), tblName, partSpec, AlterTableDesc.AlterTableTypes.TOUCH);
                this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), touchDesc), this.conf, new Task[0]));
            }
        }
    }

    private void analyzeAlterTableArchive(CommonTree ast, boolean isUnArchive) throws SemanticException {
        if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVEARCHIVEENABLED)) {
            throw new SemanticException(ErrorMsg.ARCHIVE_METHODS_DISABLED.getMsg());
        }
        String tblName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        if (partSpecs.size() > 1) {
            throw new SemanticException(isUnArchive ? ErrorMsg.UNARCHIVE_ON_MULI_PARTS.getMsg() : ErrorMsg.ARCHIVE_ON_MULI_PARTS.getMsg());
        }
        if (partSpecs.size() == 0) {
            throw new SemanticException(ErrorMsg.ARCHIVE_ON_TABLE.getMsg());
        }
        Map<String, String> partSpec = partSpecs.get(0);
        AlterTableSimpleDesc archiveDesc = new AlterTableSimpleDesc(this.db.getCurrentDatabase(), tblName, partSpec, isUnArchive ? AlterTableDesc.AlterTableTypes.UNARCHIVE : AlterTableDesc.AlterTableTypes.ARCHIVE);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), archiveDesc), this.conf, new Task[0]));
    }

    private void analyzeMetastoreCheck(CommonTree ast) throws SemanticException {
        String tableName = null;
        boolean repair = false;
        if (ast.getChildCount() > 0) {
            boolean bl = repair = ast.getChild(0).getType() == 227;
            if (!repair) {
                tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
            } else if (ast.getChildCount() > 1) {
                tableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
            }
        }
        List<Map<String, String>> specs = this.getPartitionSpecs(ast);
        MsckDesc checkDesc = new MsckDesc(tableName, specs, this.ctx.getResFile(), repair);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), checkDesc), this.conf, new Task[0]));
    }

    private List<Map<String, String>> getPartitionSpecs(CommonTree ast) throws SemanticException {
        ArrayList<Map<String, String>> partSpecs = new ArrayList<Map<String, String>>();
        int childIndex = 0;
        for (childIndex = 1; childIndex < ast.getChildCount(); ++childIndex) {
            Tree partspec = ast.getChild(childIndex);
            if (partspec.getType() != 11) continue;
            LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
            for (int i = 0; i < partspec.getChildCount(); ++i) {
                CommonTree partspec_val = (CommonTree)partspec.getChild(i);
                String val = DDLSemanticAnalyzer.stripQuotes(partspec_val.getChild(1).getText());
                partSpec.put(partspec_val.getChild(0).getText().toLowerCase(), val);
            }
            partSpecs.add(partSpec);
        }
        return partSpecs;
    }

    private void validatePartitionValues(Map<String, String> partSpec) throws SemanticException {
        for (Map.Entry<String, String> e : partSpec.entrySet()) {
            for (String s : reservedPartitionValues) {
                if (!e.getValue().contains(s)) continue;
                throw new SemanticException(ErrorMsg.RESERVED_PART_VAL.getMsg("(User value: " + e.getValue() + " Reserved substring: " + s + ")"));
            }
        }
    }

    static {
        TokenToTypeName.put(70, "boolean");
        TokenToTypeName.put(66, "tinyint");
        TokenToTypeName.put(67, "smallint");
        TokenToTypeName.put(68, "int");
        TokenToTypeName.put(69, "bigint");
        TokenToTypeName.put(71, "float");
        TokenToTypeName.put(72, "double");
        TokenToTypeName.put(76, "string");
        TokenToTypeName.put(73, "date");
        TokenToTypeName.put(74, "datetime");
        TokenToTypeName.put(75, "timestamp");
    }
}

