/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.plan.api.Adjacency;
import org.apache.hadoop.hive.ql.plan.api.NodeType;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class Graph
implements TBase<Graph, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("Graph");
    private static final TField NODE_TYPE_FIELD_DESC = new TField("nodeType", 8, 1);
    private static final TField ROOTS_FIELD_DESC = new TField("roots", 15, 2);
    private static final TField ADJACENCY_LIST_FIELD_DESC = new TField("adjacencyList", 15, 3);
    private NodeType nodeType;
    private List<String> roots;
    private List<Adjacency> adjacencyList;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public Graph() {
    }

    public Graph(NodeType nodeType, List<String> roots, List<Adjacency> adjacencyList) {
        this();
        this.nodeType = nodeType;
        this.roots = roots;
        this.adjacencyList = adjacencyList;
    }

    public Graph(Graph other) {
        if (other.isSetNodeType()) {
            this.nodeType = other.nodeType;
        }
        if (other.isSetRoots()) {
            ArrayList<String> __this__roots = new ArrayList<String>();
            for (String string : other.roots) {
                __this__roots.add(string);
            }
            this.roots = __this__roots;
        }
        if (other.isSetAdjacencyList()) {
            ArrayList<Adjacency> __this__adjacencyList = new ArrayList<Adjacency>();
            for (Adjacency adjacency : other.adjacencyList) {
                __this__adjacencyList.add(new Adjacency(adjacency));
            }
            this.adjacencyList = __this__adjacencyList;
        }
    }

    public Graph deepCopy() {
        return new Graph(this);
    }

    @Override
    public void clear() {
        this.nodeType = null;
        this.roots = null;
        this.adjacencyList = null;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public void unsetNodeType() {
        this.nodeType = null;
    }

    public boolean isSetNodeType() {
        return this.nodeType != null;
    }

    public void setNodeTypeIsSet(boolean value) {
        if (!value) {
            this.nodeType = null;
        }
    }

    public int getRootsSize() {
        return this.roots == null ? 0 : this.roots.size();
    }

    public Iterator<String> getRootsIterator() {
        return this.roots == null ? null : this.roots.iterator();
    }

    public void addToRoots(String elem) {
        if (this.roots == null) {
            this.roots = new ArrayList<String>();
        }
        this.roots.add(elem);
    }

    public List<String> getRoots() {
        return this.roots;
    }

    public void setRoots(List<String> roots) {
        this.roots = roots;
    }

    public void unsetRoots() {
        this.roots = null;
    }

    public boolean isSetRoots() {
        return this.roots != null;
    }

    public void setRootsIsSet(boolean value) {
        if (!value) {
            this.roots = null;
        }
    }

    public int getAdjacencyListSize() {
        return this.adjacencyList == null ? 0 : this.adjacencyList.size();
    }

    public Iterator<Adjacency> getAdjacencyListIterator() {
        return this.adjacencyList == null ? null : this.adjacencyList.iterator();
    }

    public void addToAdjacencyList(Adjacency elem) {
        if (this.adjacencyList == null) {
            this.adjacencyList = new ArrayList<Adjacency>();
        }
        this.adjacencyList.add(elem);
    }

    public List<Adjacency> getAdjacencyList() {
        return this.adjacencyList;
    }

    public void setAdjacencyList(List<Adjacency> adjacencyList) {
        this.adjacencyList = adjacencyList;
    }

    public void unsetAdjacencyList() {
        this.adjacencyList = null;
    }

    public boolean isSetAdjacencyList() {
        return this.adjacencyList != null;
    }

    public void setAdjacencyListIsSet(boolean value) {
        if (!value) {
            this.adjacencyList = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case NODE_TYPE: {
                if (value == null) {
                    this.unsetNodeType();
                    break;
                }
                this.setNodeType((NodeType)value);
                break;
            }
            case ROOTS: {
                if (value == null) {
                    this.unsetRoots();
                    break;
                }
                this.setRoots((List)value);
                break;
            }
            case ADJACENCY_LIST: {
                if (value == null) {
                    this.unsetAdjacencyList();
                    break;
                }
                this.setAdjacencyList((List)value);
            }
        }
    }

    @Override
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case NODE_TYPE: {
                return this.getNodeType();
            }
            case ROOTS: {
                return this.getRoots();
            }
            case ADJACENCY_LIST: {
                return this.getAdjacencyList();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case NODE_TYPE: {
                return this.isSetNodeType();
            }
            case ROOTS: {
                return this.isSetRoots();
            }
            case ADJACENCY_LIST: {
                return this.isSetAdjacencyList();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Graph) {
            return this.equals((Graph)that);
        }
        return false;
    }

    public boolean equals(Graph that) {
        if (that == null) {
            return false;
        }
        boolean this_present_nodeType = this.isSetNodeType();
        boolean that_present_nodeType = that.isSetNodeType();
        if (this_present_nodeType || that_present_nodeType) {
            if (!this_present_nodeType || !that_present_nodeType) {
                return false;
            }
            if (!this.nodeType.equals(that.nodeType)) {
                return false;
            }
        }
        boolean this_present_roots = this.isSetRoots();
        boolean that_present_roots = that.isSetRoots();
        if (this_present_roots || that_present_roots) {
            if (!this_present_roots || !that_present_roots) {
                return false;
            }
            if (!((Object)this.roots).equals(that.roots)) {
                return false;
            }
        }
        boolean this_present_adjacencyList = this.isSetAdjacencyList();
        boolean that_present_adjacencyList = that.isSetAdjacencyList();
        if (this_present_adjacencyList || that_present_adjacencyList) {
            if (!this_present_adjacencyList || !that_present_adjacencyList) {
                return false;
            }
            if (!((Object)this.adjacencyList).equals(that.adjacencyList)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public int compareTo(Graph other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        Graph typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetNodeType()).compareTo(typedOther.isSetNodeType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNodeType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.nodeType), (Comparable)((Object)typedOther.nodeType))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRoots()).compareTo(typedOther.isSetRoots());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRoots() && (lastComparison = TBaseHelper.compareTo(this.roots, typedOther.roots)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetAdjacencyList()).compareTo(typedOther.isSetAdjacencyList());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAdjacencyList() && (lastComparison = TBaseHelper.compareTo(this.adjacencyList, typedOther.adjacencyList)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 8) {
                        this.nodeType = NodeType.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 2: {
                    if (field.type == 15) {
                        TList _list4 = iprot.readListBegin();
                        this.roots = new ArrayList<String>(_list4.size);
                        for (int _i5 = 0; _i5 < _list4.size; ++_i5) {
                            String _elem6 = iprot.readString();
                            this.roots.add(_elem6);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                case 3: {
                    if (field.type == 15) {
                        TList _list7 = iprot.readListBegin();
                        this.adjacencyList = new ArrayList<Adjacency>(_list7.size);
                        for (int _i8 = 0; _i8 < _list7.size; ++_i8) {
                            Adjacency _elem9 = new Adjacency();
                            _elem9.read(iprot);
                            this.adjacencyList.add(_elem9);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.nodeType != null) {
            oprot.writeFieldBegin(NODE_TYPE_FIELD_DESC);
            oprot.writeI32(this.nodeType.getValue());
            oprot.writeFieldEnd();
        }
        if (this.roots != null) {
            oprot.writeFieldBegin(ROOTS_FIELD_DESC);
            oprot.writeListBegin(new TList(11, this.roots.size()));
            for (String _iter10 : this.roots) {
                oprot.writeString(_iter10);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.adjacencyList != null) {
            oprot.writeFieldBegin(ADJACENCY_LIST_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.adjacencyList.size()));
            for (Adjacency _iter11 : this.adjacencyList) {
                _iter11.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Graph(");
        boolean first = true;
        sb.append("nodeType:");
        if (this.nodeType == null) {
            sb.append("null");
        } else {
            sb.append(this.nodeType);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("roots:");
        if (this.roots == null) {
            sb.append("null");
        } else {
            sb.append(this.roots);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("adjacencyList:");
        if (this.adjacencyList == null) {
            sb.append("null");
        } else {
            sb.append(this.adjacencyList);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.NODE_TYPE, new FieldMetaData("nodeType", 3, new EnumMetaData(16, NodeType.class)));
        tmpMap.put(_Fields.ROOTS, new FieldMetaData("roots", 3, new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.ADJACENCY_LIST, new FieldMetaData("adjacencyList", 3, new ListMetaData(15, new StructMetaData(12, Adjacency.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(Graph.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        NODE_TYPE(1, "nodeType"),
        ROOTS(2, "roots"),
        ADJACENCY_LIST(3, "adjacencyList");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return NODE_TYPE;
                }
                case 2: {
                    return ROOTS;
                }
                case 3: {
                    return ADJACENCY_LIST;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

