/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jline.ArgumentCompletor;
import jline.Completor;
import jline.ConsoleReader;
import jline.History;
import jline.SimpleCompletor;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.cli.OptionsProcessor;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.ShimLoader;

public class CliDriver {
    public static final String prompt = "hive";
    public static final String prompt2 = "    ";
    private final SessionState.LogHelper console;
    private final Configuration conf;

    public CliDriver() {
        SessionState ss = SessionState.get();
        this.conf = ss != null ? ss.getConf() : new Configuration();
        Log LOG = LogFactory.getLog((String)"CliDriver");
        this.console = new SessionState.LogHelper(LOG);
    }

    public int processCmd(String cmd) {
        SessionState ss = SessionState.get();
        String cmd_trimmed = cmd.trim();
        String[] tokens = cmd_trimmed.split("\\s+");
        String cmd_1 = cmd_trimmed.substring(tokens[0].length()).trim();
        int ret = 0;
        if (cmd_trimmed.toLowerCase().equals("quit") || cmd_trimmed.toLowerCase().equals("exit")) {
            System.exit(0);
        } else if (cmd_trimmed.startsWith("!")) {
            String shell_cmd = cmd_trimmed.substring(1);
            try {
                Process executor = Runtime.getRuntime().exec(shell_cmd);
                Utilities.StreamPrinter outPrinter = new Utilities.StreamPrinter(executor.getInputStream(), null, SessionState.getConsole().getChildOutStream());
                Utilities.StreamPrinter errPrinter = new Utilities.StreamPrinter(executor.getErrorStream(), null, SessionState.getConsole().getChildErrStream());
                outPrinter.start();
                errPrinter.start();
                ret = executor.waitFor();
                if (ret != 0) {
                    this.console.printError("Command failed with exit code = " + ret);
                }
            }
            catch (Exception e) {
                this.console.printError("Exception raised from Shell command " + e.getLocalizedMessage(), org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                ret = 1;
            }
        } else if (tokens[0].toLowerCase().equals("list")) {
            SessionState.ResourceType t;
            if (tokens.length < 2 || (t = SessionState.find_resource_type((String)tokens[1])) == null) {
                this.console.printError("Usage: list [" + StringUtils.join((Object[])SessionState.ResourceType.values(), (String)"|") + "] [<value> [<value>]*]");
                ret = 1;
            } else {
                Set s;
                List<String> filter = null;
                if (tokens.length >= 3) {
                    System.arraycopy(tokens, 2, tokens, 0, tokens.length - 2);
                    filter = Arrays.asList(tokens);
                }
                if ((s = ss.list_resource(t, filter)) != null && !s.isEmpty()) {
                    ss.out.println(StringUtils.join((Collection)s, (String)"\n"));
                }
            }
        } else {
            CommandProcessor proc = CommandProcessorFactory.get((String)tokens[0]);
            if (proc != null) {
                if (proc instanceof Driver) {
                    long end;
                    Driver qp = (Driver)proc;
                    PrintStream out = ss.out;
                    long start = System.currentTimeMillis();
                    ret = qp.run(cmd).getResponseCode();
                    if (ret != 0) {
                        qp.close();
                        return ret;
                    }
                    ArrayList res = new ArrayList();
                    try {
                        while (qp.getResults(res)) {
                            for (String r : res) {
                                out.println(r);
                            }
                            res.clear();
                            if (!out.checkError()) continue;
                            break;
                        }
                    }
                    catch (IOException e) {
                        this.console.printError("Failed with exception " + e.getClass().getName() + ":" + e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                        ret = 1;
                    }
                    int cret = qp.close();
                    if (ret == 0) {
                        ret = cret;
                    }
                    if ((end = System.currentTimeMillis()) > start) {
                        double timeTaken = (double)(end - start) / 1000.0;
                        this.console.printInfo("Time taken: " + timeTaken + " seconds", null);
                    }
                } else {
                    ret = proc.run(cmd_1).getResponseCode();
                }
            }
        }
        return ret;
    }

    public int processLine(String line) {
        int lastRet = 0;
        int ret = 0;
        String command = "";
        for (String oneCmd : line.split(";")) {
            if (StringUtils.endsWith((String)oneCmd, (String)"\\")) {
                command = command + StringUtils.chop((String)oneCmd) + ";";
                continue;
            }
            if (StringUtils.isBlank((String)(command = command + oneCmd))) continue;
            ret = this.processCmd(command);
            command = "";
            lastRet = ret;
            boolean ignoreErrors = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.CLIIGNOREERRORS);
            if (ret == 0 || ignoreErrors) continue;
            return ret;
        }
        return lastRet;
    }

    public int processReader(BufferedReader r) throws IOException {
        String line;
        StringBuilder qsb = new StringBuilder();
        while ((line = r.readLine()) != null) {
            qsb.append(line + "\n");
        }
        return this.processLine(qsb.toString());
    }

    public static void main(String[] args) throws Exception {
        String line;
        OptionsProcessor oproc = new OptionsProcessor();
        if (!oproc.process_stage1(args)) {
            System.exit(1);
        }
        SessionState.initHiveLog4j();
        CliSessionState ss = new CliSessionState(new HiveConf(SessionState.class));
        ss.in = System.in;
        try {
            ss.out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            ss.err = new PrintStream((OutputStream)System.err, true, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.exit(3);
        }
        if (!oproc.process_stage2(ss)) {
            System.exit(2);
        }
        HiveConf conf = ss.getConf();
        for (Map.Entry<Object, Object> item : ss.cmdProperties.entrySet()) {
            conf.set((String)item.getKey(), (String)item.getValue());
        }
        if (!ShimLoader.getHadoopShims().usesJobShell()) {
            ClassLoader loader = conf.getClassLoader();
            String auxJars = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEAUXJARS);
            if (StringUtils.isNotBlank((String)auxJars)) {
                loader = Utilities.addToClassPath((ClassLoader)loader, (String[])StringUtils.split((String)auxJars, (String)","));
            }
            conf.setClassLoader(loader);
            Thread.currentThread().setContextClassLoader(loader);
        }
        SessionState.start((SessionState)ss);
        CliDriver cli = new CliDriver();
        if (ss.execString != null) {
            System.exit(cli.processLine(ss.execString));
        }
        try {
            if (ss.fileName != null) {
                System.exit(cli.processReader(new BufferedReader(new FileReader(ss.fileName))));
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not open input file for reading. (" + e.getMessage() + ")");
            System.exit(3);
        }
        ConsoleReader reader = new ConsoleReader();
        reader.setBellEnabled(false);
        LinkedList<SimpleCompletor> completors = new LinkedList<SimpleCompletor>();
        completors.add(new SimpleCompletor(new String[]{"set", "from", "create", "load", "describe", "quit", "exit"}));
        reader.addCompletor((Completor)new ArgumentCompletor(completors));
        String HISTORYFILE = ".hivehistory";
        String historyFile = System.getProperty("user.home") + File.separator + ".hivehistory";
        reader.setHistory(new History(new File(historyFile)));
        int ret = 0;
        String prefix = "";
        String curPrompt = prompt;
        while ((line = reader.readLine(curPrompt + "> ")) != null) {
            if (!prefix.equals("")) {
                prefix = prefix + '\n';
            }
            if (line.trim().endsWith(";") && !line.trim().endsWith("\\;")) {
                line = prefix + line;
                ret = cli.processLine(line);
                prefix = "";
                curPrompt = prompt;
                continue;
            }
            prefix = prefix + line;
            curPrompt = prompt2;
        }
        System.exit(ret);
    }
}

