/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.plan.tableDesc;

public class GenMRProcContext
implements NodeProcessorCtx {
    private HiveConf conf;
    private HashMap<Operator<? extends Serializable>, Task<? extends Serializable>> opTaskMap;
    private HashMap<UnionOperator, GenMRUnionCtx> unionTaskMap;
    private HashMap<MapJoinOperator, GenMRMapJoinCtx> mapJoinTaskMap;
    private List<Operator<? extends Serializable>> seenOps;
    private List<FileSinkOperator> seenFileSinkOps;
    private ParseContext parseCtx;
    private List<Task<? extends Serializable>> mvTask;
    private List<Task<? extends Serializable>> rootTasks;
    private LinkedHashMap<Operator<? extends Serializable>, GenMapRedCtx> mapCurrCtx;
    private Task<? extends Serializable> currTask;
    private Operator<? extends Serializable> currTopOp;
    private UnionOperator currUnionOp;
    private MapJoinOperator currMapJoinOp;
    private String currAliasId;
    private List<Operator<? extends Serializable>> rootOps;
    private Set<ReadEntity> inputs;
    private Set<WriteEntity> outputs;

    public GenMRProcContext() {
    }

    public GenMRProcContext(HiveConf conf, HashMap<Operator<? extends Serializable>, Task<? extends Serializable>> opTaskMap, List<Operator<? extends Serializable>> seenOps, ParseContext parseCtx, List<Task<? extends Serializable>> mvTask, List<Task<? extends Serializable>> rootTasks, LinkedHashMap<Operator<? extends Serializable>, GenMapRedCtx> mapCurrCtx, Set<ReadEntity> inputs, Set<WriteEntity> outputs) {
        this.conf = conf;
        this.opTaskMap = opTaskMap;
        this.seenOps = seenOps;
        this.mvTask = mvTask;
        this.parseCtx = parseCtx;
        this.rootTasks = rootTasks;
        this.mapCurrCtx = mapCurrCtx;
        this.inputs = inputs;
        this.outputs = outputs;
        this.currTask = null;
        this.currTopOp = null;
        this.currUnionOp = null;
        this.currMapJoinOp = null;
        this.currAliasId = null;
        this.rootOps = new ArrayList<Operator<? extends Serializable>>();
        this.rootOps.addAll(parseCtx.getTopOps().values());
        this.unionTaskMap = new HashMap();
        this.mapJoinTaskMap = new HashMap();
    }

    public HashMap<Operator<? extends Serializable>, Task<? extends Serializable>> getOpTaskMap() {
        return this.opTaskMap;
    }

    public void setOpTaskMap(HashMap<Operator<? extends Serializable>, Task<? extends Serializable>> opTaskMap) {
        this.opTaskMap = opTaskMap;
    }

    public List<Operator<? extends Serializable>> getSeenOps() {
        return this.seenOps;
    }

    public List<FileSinkOperator> getSeenFileSinkOps() {
        return this.seenFileSinkOps;
    }

    public void setSeenOps(List<Operator<? extends Serializable>> seenOps) {
        this.seenOps = seenOps;
    }

    public void setSeenFileSinkOps(List<FileSinkOperator> seenFileSinkOps) {
        this.seenFileSinkOps = seenFileSinkOps;
    }

    public List<Operator<? extends Serializable>> getRootOps() {
        return this.rootOps;
    }

    public void setRootOps(List<Operator<? extends Serializable>> rootOps) {
        this.rootOps = rootOps;
    }

    public ParseContext getParseCtx() {
        return this.parseCtx;
    }

    public void setParseCtx(ParseContext parseCtx) {
        this.parseCtx = parseCtx;
    }

    public List<Task<? extends Serializable>> getMvTask() {
        return this.mvTask;
    }

    public void setMvTask(List<Task<? extends Serializable>> mvTask) {
        this.mvTask = mvTask;
    }

    public List<Task<? extends Serializable>> getRootTasks() {
        return this.rootTasks;
    }

    public void setRootTasks(List<Task<? extends Serializable>> rootTasks) {
        this.rootTasks = rootTasks;
    }

    public LinkedHashMap<Operator<? extends Serializable>, GenMapRedCtx> getMapCurrCtx() {
        return this.mapCurrCtx;
    }

    public void setMapCurrCtx(LinkedHashMap<Operator<? extends Serializable>, GenMapRedCtx> mapCurrCtx) {
        this.mapCurrCtx = mapCurrCtx;
    }

    public Task<? extends Serializable> getCurrTask() {
        return this.currTask;
    }

    public void setCurrTask(Task<? extends Serializable> currTask) {
        this.currTask = currTask;
    }

    public Operator<? extends Serializable> getCurrTopOp() {
        return this.currTopOp;
    }

    public void setCurrTopOp(Operator<? extends Serializable> currTopOp) {
        this.currTopOp = currTopOp;
    }

    public UnionOperator getCurrUnionOp() {
        return this.currUnionOp;
    }

    public void setCurrUnionOp(UnionOperator currUnionOp) {
        this.currUnionOp = currUnionOp;
    }

    public MapJoinOperator getCurrMapJoinOp() {
        return this.currMapJoinOp;
    }

    public void setCurrMapJoinOp(MapJoinOperator currMapJoinOp) {
        this.currMapJoinOp = currMapJoinOp;
    }

    public String getCurrAliasId() {
        return this.currAliasId;
    }

    public void setCurrAliasId(String currAliasId) {
        this.currAliasId = currAliasId;
    }

    public GenMRUnionCtx getUnionTask(UnionOperator op) {
        return this.unionTaskMap.get(op);
    }

    public void setUnionTask(UnionOperator op, GenMRUnionCtx uTask) {
        this.unionTaskMap.put(op, uTask);
    }

    public GenMRMapJoinCtx getMapJoinCtx(MapJoinOperator op) {
        return this.mapJoinTaskMap.get(op);
    }

    public void setMapJoinCtx(MapJoinOperator op, GenMRMapJoinCtx mjCtx) {
        this.mapJoinTaskMap.put(op, mjCtx);
    }

    public Set<ReadEntity> getInputs() {
        return this.inputs;
    }

    public Set<WriteEntity> getOutputs() {
        return this.outputs;
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public void setConf(HiveConf conf) {
        this.conf = conf;
    }

    public static class GenMRMapJoinCtx {
        String taskTmpDir;
        tableDesc tt_desc;
        Operator<? extends Serializable> rootMapJoinOp;
        MapJoinOperator oldMapJoin;

        public GenMRMapJoinCtx() {
            this.taskTmpDir = null;
            this.tt_desc = null;
            this.rootMapJoinOp = null;
            this.oldMapJoin = null;
        }

        public GenMRMapJoinCtx(String taskTmpDir, tableDesc tt_desc, Operator<? extends Serializable> rootMapJoinOp, MapJoinOperator oldMapJoin) {
            this.taskTmpDir = taskTmpDir;
            this.tt_desc = tt_desc;
            this.rootMapJoinOp = rootMapJoinOp;
            this.oldMapJoin = oldMapJoin;
        }

        public void setTaskTmpDir(String taskTmpDir) {
            this.taskTmpDir = taskTmpDir;
        }

        public String getTaskTmpDir() {
            return this.taskTmpDir;
        }

        public void setTTDesc(tableDesc tt_desc) {
            this.tt_desc = tt_desc;
        }

        public tableDesc getTTDesc() {
            return this.tt_desc;
        }

        public Operator<? extends Serializable> getRootMapJoinOp() {
            return this.rootMapJoinOp;
        }

        public void setRootMapJoinOp(Operator<? extends Serializable> rootMapJoinOp) {
            this.rootMapJoinOp = rootMapJoinOp;
        }

        public MapJoinOperator getOldMapJoin() {
            return this.oldMapJoin;
        }

        public void setOldMapJoin(MapJoinOperator oldMapJoin) {
            this.oldMapJoin = oldMapJoin;
        }
    }

    public static class GenMRUnionCtx {
        Task<? extends Serializable> uTask = null;
        List<String> taskTmpDir = new ArrayList<String>();
        List<tableDesc> tt_desc = new ArrayList<tableDesc>();

        public Task<? extends Serializable> getUTask() {
            return this.uTask;
        }

        public void setUTask(Task<? extends Serializable> uTask) {
            this.uTask = uTask;
        }

        public void addTaskTmpDir(String taskTmpDir) {
            this.taskTmpDir.add(taskTmpDir);
        }

        public List<String> getTaskTmpDir() {
            return this.taskTmpDir;
        }

        public void addTTDesc(tableDesc tt_desc) {
            this.tt_desc.add(tt_desc);
        }

        public List<tableDesc> getTTDesc() {
            return this.tt_desc;
        }
    }

    public static class GenMapRedCtx {
        Task<? extends Serializable> currTask;
        Operator<? extends Serializable> currTopOp;
        String currAliasId;

        public GenMapRedCtx() {
        }

        public GenMapRedCtx(Task<? extends Serializable> currTask, Operator<? extends Serializable> currTopOp, String currAliasId) {
            this.currTask = currTask;
            this.currTopOp = currTopOp;
            this.currAliasId = currAliasId;
        }

        public Task<? extends Serializable> getCurrTask() {
            return this.currTask;
        }

        public Operator<? extends Serializable> getCurrTopOp() {
            return this.currTopOp;
        }

        public String getCurrAliasId() {
            return this.currAliasId;
        }
    }
}

