/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util.jdbm.recman;

import org.apache.hadoop.hive.ql.util.jdbm.recman.BlockIo;

class RecordHeader {
    private static final short O_CURRENTSIZE = 0;
    private static final short O_AVAILABLESIZE = 4;
    static final int SIZE = 8;
    private BlockIo block;
    private short pos;

    RecordHeader(BlockIo block, short pos) {
        this.block = block;
        this.pos = pos;
        if (pos > 8184) {
            throw new Error("Offset too large for record header (" + block.getBlockId() + ":" + pos + ")");
        }
    }

    int getCurrentSize() {
        return this.block.readInt(this.pos + 0);
    }

    void setCurrentSize(int value) {
        this.block.writeInt(this.pos + 0, value);
    }

    int getAvailableSize() {
        return this.block.readInt(this.pos + 4);
    }

    void setAvailableSize(int value) {
        this.block.writeInt(this.pos + 4, value);
    }

    public String toString() {
        return "RH(" + this.block.getBlockId() + ":" + this.pos + ", avl=" + this.getAvailableSize() + ", cur=" + this.getCurrentSize() + ")";
    }
}

