/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filesystem;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class URIUtil {
    public static boolean equals(URI one, URI two) {
        try {
            return EFS.getStore(one).equals(EFS.getStore(two));
        }
        catch (CoreException coreException) {
            return one.equals(two);
        }
    }

    private static String escapeColons(String string) {
        if (string.indexOf(58) == -1) {
            return string;
        }
        int length = string.length();
        StringBuffer result = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            char c = string.charAt(i);
            if (c == ':') {
                result.append("%3A");
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static IPath toPath(URI uri) {
        Assert.isNotNull(uri);
        if ("file".equals(uri.getScheme())) {
            return new Path(uri.getSchemeSpecificPart());
        }
        return null;
    }

    public static URI toURI(IPath path) {
        if (path == null) {
            return null;
        }
        if (path.isAbsolute()) {
            return URIUtil.toURI(path.toFile().getAbsolutePath());
        }
        try {
            return new URI(URIUtil.escapeColons(path.toString()));
        }
        catch (URISyntaxException uRISyntaxException) {
            return URIUtil.toURI(path.toFile().getAbsolutePath());
        }
    }

    public static URI toURI(String pathString) {
        if (File.separatorChar != '/') {
            pathString = pathString.replace(File.separatorChar, '/');
        }
        int length = pathString.length();
        StringBuffer pathBuf = new StringBuffer(length + 1);
        if (length > 0 && pathString.charAt(0) != '/') {
            pathBuf.append('/');
        }
        if (pathString.startsWith("//")) {
            pathBuf.append('/').append('/');
        }
        pathBuf.append(pathString);
        try {
            return new URI("file", null, pathBuf.toString(), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(pathString).toURI();
        }
    }

    private URIUtil() {
    }
}

