/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.util.Imports;
import org.datanucleus.util.Localiser;

public class Parser {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ObjectManagerFactoryImpl.class.getClassLoader());
    protected final String input;
    protected final Imports imports;
    protected final CharacterIterator ci;

    public Parser(String input, Imports imports) {
        this.input = input;
        this.imports = imports;
        this.ci = new StringCharacterIterator(input);
    }

    public String getInput() {
        return this.input;
    }

    public int getIndex() {
        return this.ci.getIndex();
    }

    public int skipWS() {
        int startIdx = this.ci.getIndex();
        char c = this.ci.current();
        while (Character.isWhitespace(c) || c == '\t' || c == '\f' || c == '\n' || c == '\r' || c == '\t' || c == '\f' || c == ' ' || c == '\t' || c == '\n' || c == '\f' || c == '\r' || c == ' ') {
            c = this.ci.next();
        }
        return startIdx;
    }

    public boolean parseEOS() {
        this.skipWS();
        return this.ci.current() == '\uffff';
    }

    public boolean parseChar(char c) {
        this.skipWS();
        if (this.ci.current() == c) {
            this.ci.next();
            return true;
        }
        return false;
    }

    public boolean parseChar(char c, char unlessFollowedBy) {
        int savedIdx = this.skipWS();
        if (this.ci.current() == c && this.ci.next() != unlessFollowedBy) {
            return true;
        }
        this.ci.setIndex(savedIdx);
        return false;
    }

    public boolean parseString(String s) {
        int savedIdx = this.skipWS();
        int len = s.length();
        char c = this.ci.current();
        for (int i = 0; i < len; ++i) {
            if (c != s.charAt(i)) {
                this.ci.setIndex(savedIdx);
                return false;
            }
            c = this.ci.next();
        }
        return true;
    }

    public boolean parseStringIgnoreCase(String s) {
        String lowerCasedString = s.toLowerCase();
        int savedIdx = this.skipWS();
        int len = lowerCasedString.length();
        char c = this.ci.current();
        for (int i = 0; i < len; ++i) {
            if (Character.toLowerCase(c) != lowerCasedString.charAt(i)) {
                this.ci.setIndex(savedIdx);
                return false;
            }
            c = this.ci.next();
        }
        return true;
    }

    public boolean peekStringIgnoreCase(String s) {
        String lowerCasedString = s.toLowerCase();
        int savedIdx = this.skipWS();
        int len = lowerCasedString.length();
        char c = this.ci.current();
        for (int i = 0; i < len; ++i) {
            if (Character.toLowerCase(c) != lowerCasedString.charAt(i)) {
                this.ci.setIndex(savedIdx);
                return false;
            }
            c = this.ci.next();
        }
        this.ci.setIndex(savedIdx);
        return true;
    }

    public String parseIdentifier() {
        this.skipWS();
        char c = this.ci.current();
        if (!Character.isJavaIdentifierStart(c) && c != ':') {
            return null;
        }
        StringBuffer id = new StringBuffer();
        id.append(c);
        while (Character.isJavaIdentifierPart(c = this.ci.next())) {
            id.append(c);
        }
        return id.toString();
    }

    public String parseMethod() {
        int savedIdx = this.ci.getIndex();
        String id = this.parseIdentifier();
        if (id == null) {
            this.ci.setIndex(savedIdx);
            return null;
        }
        this.skipWS();
        if (!this.parseChar('(')) {
            this.ci.setIndex(savedIdx);
            return null;
        }
        this.ci.setIndex(this.ci.getIndex() - 1);
        return id;
    }

    public String parseName() {
        int savedIdx = this.skipWS();
        String id = this.parseIdentifier();
        if (id == null) {
            return null;
        }
        StringBuffer qn = new StringBuffer(id);
        while (this.parseChar('.')) {
            id = this.parseIdentifier();
            if (id == null) {
                this.ci.setIndex(savedIdx);
                return null;
            }
            qn.append('.').append(id);
        }
        return qn.toString();
    }

    public Class parseCast(ClassLoaderResolver clr, ClassLoader primary) {
        String typeName;
        int savedIdx = this.skipWS();
        if (!this.parseChar('(') || (typeName = this.parseName()) == null || !this.parseChar(')')) {
            this.ci.setIndex(savedIdx);
            return null;
        }
        try {
            return this.imports.resolveClassDeclaration(typeName, clr, primary);
        }
        catch (ClassNotResolvedException e) {
            this.ci.setIndex(savedIdx);
            throw new NucleusUserException(LOCALISER.msg("021053", (Object)typeName));
        }
    }

    private static final boolean isDecDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static final boolean isOctDigit(char c) {
        return c >= '0' && c <= '7';
    }

    private static final boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public BigInteger parseIntegerLiteral() {
        int radix;
        int savedIdx = this.skipWS();
        StringBuffer digits = new StringBuffer();
        char c = this.ci.current();
        if (c == '0') {
            c = this.ci.next();
            if (c == 'x' || c == 'X') {
                radix = 16;
                c = this.ci.next();
                while (Parser.isHexDigit(c)) {
                    digits.append(c);
                    c = this.ci.next();
                }
            } else if (Parser.isOctDigit(c)) {
                radix = 8;
                do {
                    digits.append(c);
                } while (Parser.isOctDigit(c = this.ci.next()));
            } else {
                radix = 10;
                digits.append('0');
            }
        } else {
            radix = 10;
            while (Parser.isDecDigit(c)) {
                digits.append(c);
                c = this.ci.next();
            }
        }
        if (digits.length() == 0) {
            this.ci.setIndex(savedIdx);
            return null;
        }
        if (c == 'l' || c == 'L') {
            this.ci.next();
        }
        return new BigInteger(digits.toString(), radix);
    }

    public BigDecimal parseFloatingPointLiteral() {
        int savedIdx = this.skipWS();
        StringBuffer val = new StringBuffer();
        boolean dotSeen = false;
        boolean expSeen = false;
        boolean sfxSeen = false;
        char c = this.ci.current();
        while (Parser.isDecDigit(c)) {
            val.append(c);
            c = this.ci.next();
        }
        if (c == '.') {
            dotSeen = true;
            val.append(c);
            c = this.ci.next();
            while (Parser.isDecDigit(c)) {
                val.append(c);
                c = this.ci.next();
            }
        }
        if (val.length() < (dotSeen ? 2 : 1)) {
            this.ci.setIndex(savedIdx);
            return null;
        }
        if (c == 'e' || c == 'E') {
            expSeen = true;
            val.append(c);
            c = this.ci.next();
            if (c != '+' && c != '-' && !Parser.isDecDigit(c)) {
                this.ci.setIndex(savedIdx);
                return null;
            }
            do {
                val.append(c);
            } while (Parser.isDecDigit(c = this.ci.next()));
        }
        if (c == 'f' || c == 'F' || c == 'd' || c == 'D') {
            sfxSeen = true;
            this.ci.next();
        }
        if (!(dotSeen || expSeen || sfxSeen)) {
            this.ci.setIndex(savedIdx);
            return null;
        }
        return new BigDecimal(val.toString());
    }

    public Boolean parseBooleanLiteral() {
        int savedIdx = this.skipWS();
        String id = this.parseIdentifier();
        if (id == null) {
            return null;
        }
        if (id.equals("true")) {
            return Boolean.TRUE;
        }
        if (id.equals("false")) {
            return Boolean.FALSE;
        }
        this.ci.setIndex(savedIdx);
        return null;
    }

    public boolean nextIsSingleQuote() {
        this.skipWS();
        return this.ci.current() == '\'';
    }

    public boolean nextIsDot() {
        return this.ci.current() == '.';
    }

    public Character parseCharacterLiteral() {
        this.skipWS();
        if (this.ci.current() != '\'') {
            return null;
        }
        char c = this.ci.next();
        if (c == '\uffff') {
            throw new NucleusUserException("Invalid character literal: " + this.input);
        }
        if (c == '\\') {
            c = this.parseEscapedCharacter();
        }
        if (this.ci.next() != '\'') {
            throw new NucleusUserException("Invalid character literal: " + this.input);
        }
        this.ci.next();
        return new Character(c);
    }

    public String parseStringLiteral() {
        char c;
        this.skipWS();
        char quote = this.ci.current();
        if (quote != '\"' && quote != '\'') {
            return null;
        }
        StringBuffer lit = new StringBuffer();
        while ((c = this.ci.next()) != quote) {
            if (c == '\uffff') {
                throw new NucleusUserException("Invalid string literal: " + this.input);
            }
            if (c == '\\') {
                c = this.parseEscapedCharacter();
            }
            lit.append(c);
        }
        this.ci.next();
        return lit.toString();
    }

    protected char parseEscapedCharacter() {
        char c = this.ci.next();
        if (Parser.isOctDigit(c)) {
            int i = c - 48;
            c = this.ci.next();
            if (Parser.isOctDigit(c)) {
                i = i * 8 + (c - 48);
                c = this.ci.next();
                if (Parser.isOctDigit(c)) {
                    i = i * 8 + (c - 48);
                } else {
                    this.ci.previous();
                }
            } else {
                this.ci.previous();
            }
            if (i > 255) {
                throw new NucleusUserException("Invalid character escape: '\\" + Integer.toOctalString(i) + "'");
            }
            return (char)i;
        }
        switch (c) {
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
            case '\\': {
                return '\\';
            }
        }
        throw new NucleusUserException("Invalid character escape: '\\" + c + "'");
    }

    public boolean parseNullLiteral() {
        int savedIdx = this.skipWS();
        String id = this.parseIdentifier();
        if (id == null) {
            return false;
        }
        if (id.equals("null")) {
            return true;
        }
        this.ci.setIndex(savedIdx);
        return false;
    }

    public String remaining() {
        StringBuffer sb = new StringBuffer();
        char c = this.ci.current();
        while (c != '\uffff') {
            sb.append(c);
            c = this.ci.next();
        }
        return sb.toString();
    }

    public String toString() {
        return this.input;
    }
}

