/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class FileUtils {
    public static Path makeQualified(Path path, Configuration conf) throws IOException {
        if (!path.isAbsolute()) {
            return path.makeQualified(FileSystem.get((Configuration)conf));
        }
        URI fsUri = FileSystem.getDefaultUri((Configuration)conf);
        URI pathUri = path.toUri();
        String scheme = pathUri.getScheme();
        String authority = pathUri.getAuthority();
        if (scheme != null && (authority != null || fsUri.getAuthority() == null)) {
            return path;
        }
        if (scheme == null) {
            scheme = fsUri.getScheme();
        }
        if (authority == null && (authority = fsUri.getAuthority()) == null) {
            authority = "";
        }
        return new Path(scheme + ":" + "//" + authority + pathUri.getPath());
    }
}

