/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExecDriver;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.mapredWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.ShimLoader;

public class MapRedTask
extends Task<mapredWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String hadoopMemKey = "HADOOP_HEAPSIZE";
    static final String hadoopOptsKey = "HADOOP_OPTS";
    static final String[] HIVE_SYS_PROP = new String[]{"build.dir", "build.dir.hive"};

    @Override
    public int execute() {
        try {
            String hadoopExec = this.conf.getVar(HiveConf.ConfVars.HADOOPBIN);
            String hiveJar = this.conf.getJar();
            String addedJars = ExecDriver.getResourceFiles(this.conf, SessionState.ResourceType.JAR);
            this.conf.setVar(HiveConf.ConfVars.HIVEADDEDJARS, addedJars);
            String auxJars = this.conf.getAuxJars();
            String libJarsOption = StringUtils.isEmpty(addedJars) ? (StringUtils.isEmpty(auxJars) ? " " : " -libjars " + auxJars + " ") : (StringUtils.isEmpty(auxJars) ? " -libjars " + addedJars + " " : " -libjars " + addedJars + "," + auxJars + " ");
            String hiveConfArgs = ExecDriver.generateCmdLine(this.conf);
            File scratchDir = new File(this.conf.getVar(HiveConf.ConfVars.SCRATCHDIR));
            mapredWork plan = (mapredWork)this.getWork();
            File planFile = File.createTempFile("plan", ".xml", scratchDir);
            this.LOG.info((Object)("Generating plan file " + planFile.toString()));
            FileOutputStream out = new FileOutputStream(planFile);
            Utilities.serializeMapRedWork(plan, out);
            String isSilent = "true".equalsIgnoreCase(System.getProperty("test.silent")) ? "-silent" : "";
            String jarCmd = ShimLoader.getHadoopShims().usesJobShell() ? libJarsOption + hiveJar + " " + ExecDriver.class.getName() : hiveJar + " " + ExecDriver.class.getName() + libJarsOption;
            String cmdLine = hadoopExec + " jar " + jarCmd + " -plan " + planFile.toString() + " " + isSilent + " " + hiveConfArgs;
            String files = ExecDriver.getResourceFiles(this.conf, SessionState.ResourceType.FILE);
            if (!files.isEmpty()) {
                cmdLine = cmdLine + " -files " + files;
            }
            this.LOG.info((Object)("Executing: " + cmdLine));
            Process executor = null;
            StringBuilder sb = new StringBuilder();
            Properties p = System.getProperties();
            for (int k = 0; k < HIVE_SYS_PROP.length; ++k) {
                if (!p.containsKey(HIVE_SYS_PROP[k])) continue;
                sb.append(" -D" + HIVE_SYS_PROP[k] + "=" + p.getProperty(HIVE_SYS_PROP[k]));
            }
            String hadoopOpts = sb.toString();
            HashMap<String, String> variables = new HashMap<String, String>(System.getenv());
            int hadoopMem = this.conf.getIntVar(HiveConf.ConfVars.HIVEHADOOPMAXMEM);
            if (hadoopMem == 0) {
                variables.remove(hadoopMemKey);
            } else {
                variables.put(hadoopMemKey, String.valueOf(hadoopMem));
            }
            if (variables.containsKey(hadoopOptsKey)) {
                variables.put(hadoopOptsKey, (String)variables.get(hadoopOptsKey) + hadoopOpts);
            } else {
                variables.put(hadoopOptsKey, hadoopOpts);
            }
            String[] env = new String[variables.size()];
            int pos = 0;
            for (Map.Entry entry : variables.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                env[pos++] = name + "=" + value;
            }
            executor = Runtime.getRuntime().exec(cmdLine, env);
            Utilities.StreamPrinter outPrinter = new Utilities.StreamPrinter(executor.getInputStream(), null, SessionState.getConsole().getChildOutStream());
            Utilities.StreamPrinter errPrinter = new Utilities.StreamPrinter(executor.getErrorStream(), null, SessionState.getConsole().getChildErrStream());
            outPrinter.start();
            errPrinter.start();
            int exitVal = executor.waitFor();
            if (exitVal != 0) {
                this.LOG.error((Object)("Execution failed with exit status: " + exitVal));
            } else {
                this.LOG.info((Object)"Execution completed successfully");
            }
            return exitVal;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.LOG.error((Object)("Exception: " + e.getMessage()));
            return 1;
        }
    }

    @Override
    public boolean isMapRedTask() {
        return true;
    }

    @Override
    public boolean hasReduce() {
        mapredWork w = (mapredWork)this.getWork();
        return w.getReducer() != null;
    }

    @Override
    public int getType() {
        return 7;
    }
}

