/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class GenMRRedSink2
implements NodeProcessor {
    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx opProcCtx, Object ... nodeOutputs) throws SemanticException {
        ReduceSinkOperator op = (ReduceSinkOperator)nd;
        GenMRProcContext ctx = (GenMRProcContext)opProcCtx;
        LinkedHashMap<Operator<? extends Serializable>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = ctx.getMapCurrCtx();
        GenMRProcContext.GenMapRedCtx mapredCtx = (GenMRProcContext.GenMapRedCtx)mapCurrCtx.get(op.getParentOperators().get(0));
        Task currTask = mapredCtx.getCurrTask();
        Operator<? extends Serializable> currTopOp = mapredCtx.getCurrTopOp();
        String currAliasId = mapredCtx.getCurrAliasId();
        Operator<Serializable> reducer = op.getChildOperators().get(0);
        HashMap<Operator<? extends Serializable>, Task<? extends Serializable>> opTaskMap = ctx.getOpTaskMap();
        Task opMapTask = (Task)opTaskMap.get(reducer);
        ctx.setCurrTopOp(currTopOp);
        ctx.setCurrAliasId(currAliasId);
        ctx.setCurrTask(currTask);
        if (opMapTask == null) {
            GenMapRedUtils.splitPlan(op, ctx);
        } else {
            GenMapRedUtils.joinPlan(op, currTask, opMapTask, ctx, -1, true, false, false);
            currTask = opMapTask;
            ctx.setCurrTask(currTask);
        }
        mapCurrCtx.put(op, new GenMRProcContext.GenMapRedCtx(ctx.getCurrTask(), ctx.getCurrTopOp(), ctx.getCurrAliasId()));
        return null;
    }
}

